/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.lex.data.AtomLocant;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.StructureToken;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

public class OximeStr
extends StructureToken {
    OximeStr(String name, String struc) {
        super(name, struc);
    }

    @Override
    public boolean is(String name) {
        return name == "oxime";
    }

    @Override
    protected void connectToParent(Str parent) {
        for (MolAtom connectionPoint : parent.getConnectionPoints(this)) {
            MolAtom oxo = this.getNeighbourOxo(connectionPoint);
            Molecule oxime = this.getCompleteStructure();
            MolAtom oximeN = this.getLocantMap().get("oximeN");
            oxime.removeAtom(this.getLocantMap().get("oximeC"));
            Molecule parentM = parent.getParentMol();
            OximeStr.fuseCleared(parentM, oxime);
            parent.mergeAtoms(oxo, oximeN);
        }
    }

    @Override
    protected MolAtom[] getConnectionPointInParent(Str parent) {
        List<MolAtom> C = this.getAllCO(parent.getParentMol());
        if (C == null) {
            return null;
        }
        if (C.size() == this.multiplicity) {
            return C.toArray(new MolAtom[C.size()]);
        }
        if (this.multiplicity == 1 && OximeStr.allEquivalent(parent.getParentMol(), C)) {
            if (this.name.equals("monoxime") || this.name.equals("monooxime")) {
                return new MolAtom[]{C.get(0)};
            }
            if (C.size() == 2) {
                return C.toArray(new MolAtom[2]);
            }
        }
        return null;
    }

    private List<MolAtom> getAllCO(Molecule m) {
        ArrayList<MolAtom> res = new ArrayList<MolAtom>();
        for (MolAtom a : m.getAtomArray()) {
            if (a.getAtno() != 6) continue;
            int b = a.getBondCount();
            while (--b >= 0) {
                MolAtom o;
                MolBond bond = a.getBond(b);
                if (bond.getType() != 2 || (o = bond.getOtherAtom(a)).getAtno() != 8) continue;
                res.add(a);
            }
        }
        if (res.isEmpty()) {
            return null;
        }
        return res;
    }

    @Override
    public boolean hasLocant(Locant l, boolean strictGreek) {
        return l.equals(AtomLocant.O);
    }
}

