/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.SimpleLocant;

public class RingNumber
extends Locant {
    private int first = -1;
    private int second = -1;

    public RingNumber(int value) {
        this(value, -1, -1);
    }

    public RingNumber(int value, int first) {
        this(value, first, -1);
    }

    public RingNumber(int value, int first, int second) {
        this.value = value;
        this.first = first;
        this.second = second;
    }

    public int getFirst() {
        return Math.max(this.first, 0);
    }

    public void setFirst(int first) {
        this.first = first;
    }

    public boolean hasFirst() {
        return this.first > 0;
    }

    public int getSecond() {
        return Math.max(this.second, 0);
    }

    public void setSecond(int second) {
        this.second = second;
    }

    public boolean hasSecond() {
        return this.second > 0;
    }

    public String toString() {
        String val = new SimpleLocant(this.value).toString();
        if (this.first > -1) {
            val = val + "^(" + Integer.toString(this.first);
            if (this.second > -1) {
                val = val + "," + Integer.toString(this.second);
            }
            val = val + ")";
        }
        return val;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof RingNumber)) {
            return false;
        }
        RingNumber oo = (RingNumber)o;
        return this.first == oo.first && this.second == oo.second && super.equals(o);
    }
}

