/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.UtilLegacy;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.struc.MolAtom;

public class SimpleLocant
extends Locant {
    public char greekLetter = '\u0000';
    private boolean isOrthoMetaPara = false;

    public SimpleLocant(int value) {
        this.value = value;
    }

    public SimpleLocant(int value, char greekLetter) {
        this.value = value;
        this.greekLetter = greekLetter;
    }

    public SimpleLocant(int value, int parent) {
        this.value = value;
        this.primes = parent;
    }

    public SimpleLocant(int value, boolean isOrthoMetaPara) {
        this.value = value;
        this.isOrthoMetaPara = isOrthoMetaPara;
    }

    @Override
    public boolean isSimpleNumber() {
        return this.greekLetter == '\u0000' && !this.isOrthoMetaPara && this.value < 1000;
    }

    @Override
    public boolean isOne() {
        return this.getValue() == 1;
    }

    @Override
    public boolean isOrthoMetaPara() {
        return this.isOrthoMetaPara;
    }

    @Override
    public boolean isGreekLetter() {
        return UtilLegacy.isGreekLetter(this.value);
    }

    public char getAsGreekLetter() {
        switch (this.value) {
            case 0x7FFFFFFC: {
                return 'a';
            }
            case 0x7FFFFFFD: {
                return 'b';
            }
        }
        return '\u0000';
    }

    @Override
    public boolean isNumGreekLocant() {
        return this.greekLetter != '\u0000';
    }

    @Override
    protected int getSortOrder() {
        if (this.value < 100) {
            return this.value * 100;
        }
        return this.value;
    }

    @Override
    public MolAtom getAtom(Str s) {
        MolAtom res = s.getLocantMap().get(this.toString(false));
        if (res == null && s.isCyclic() && this.isOrthoMetaPara) {
            res = s.getLocantMap().get(this.toString(true));
        }
        return res;
    }

    @Override
    public String getBasicLocantString() {
        return this.toString(true);
    }

    private String toString(boolean basic) {
        int value = this.value;
        if (value == 0x7FFFFFFC) {
            return "alpha";
        }
        if (value == 0x7FFFFFFD) {
            return "beta";
        }
        if (value == 0x7FFFFFFE) {
            return "gamma";
        }
        if (value == Integer.MAX_VALUE) {
            return "omega";
        }
        char asc = '.';
        if (value > 100) {
            asc = (char)(value % 100 + 96);
            value /= 100;
        }
        String val = Integer.toString(value);
        if (!basic && this.isOrthoMetaPara) {
            switch (this.value) {
                case 2: {
                    val = "o";
                    break;
                }
                case 3: {
                    val = "m";
                    break;
                }
                case 4: {
                    val = "p";
                    break;
                }
                default: {
                    throw new RuntimeException("Wrong OMP: " + this.value);
                }
            }
        }
        if (asc != '.') {
            val = val + asc;
        }
        for (int i = 0; i < this.primes; ++i) {
            val = val + "'";
        }
        return val;
    }

    public String toString() {
        String val = this.toString(false);
        if (this.greekLetter != '\u0000') {
            val = val + " greek(" + this.greekLetter + ")";
        }
        return val;
    }
}

