/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.struc.MolAtom;

public class SpecialLocant
extends Locant {
    public static final SpecialLocant loc1 = new SpecialLocant("loc1");
    public static final SpecialLocant loc2 = new SpecialLocant("loc2");
    public static final SpecialLocant end1 = new SpecialLocant("end1");
    public static final SpecialLocant end2 = new SpecialLocant("end2");
    public static final SpecialLocant sym = new SpecialLocant("sym");
    public static final SpecialLocant asym = new SpecialLocant("asym");
    public static final SpecialLocant vicinal = new SpecialLocant("v");
    public static final SpecialLocant n = new SpecialLocant("n"){

        @Override
        public MolAtom getAtom(Str str) {
            return Locant.N.getAtom(str);
        }
    };
    private String name;

    private SpecialLocant(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public MolAtom getAtom(Str str) {
        MolAtom res = super.getAtom(str);
        if (res != null) {
            return res;
        }
        if (this == loc1) {
            return str.getLocantMap().get("loc1A");
        }
        if (this == loc2) {
            return str.getLocantMap().get("loc2A");
        }
        return null;
    }

    @Override
    public boolean equals(Object that) {
        return this == that;
    }
}

