/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.calculations.clean.Cleaner;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.util.TextUtils;
import chemaxon.naming.n2s.Ambiguity;
import chemaxon.naming.n2s.Util;
import chemaxon.naming.n2s.UtilLegacy;
import chemaxon.naming.n2s.lex.data.AtomLocant;
import chemaxon.naming.n2s.lex.data.BondNumber;
import chemaxon.naming.n2s.lex.data.Dearomatizer;
import chemaxon.naming.n2s.lex.data.Hydro;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.MarkushStr;
import chemaxon.naming.n2s.lex.data.NonStdValenceLocant;
import chemaxon.naming.n2s.lex.data.Part;
import chemaxon.naming.n2s.lex.data.SimpleLocant;
import chemaxon.naming.n2s.lex.data.SpecialLocant;
import chemaxon.naming.n2s.lex.data.StereoNumber;
import chemaxon.naming.n2s.lex.data.Token;
import chemaxon.naming.n2s.parse.HeteroAtomStr;
import chemaxon.naming.n2s.parse.Modifier;
import chemaxon.naming.n2s.parse.Radical;
import chemaxon.naming.n2s.parse.SaltEnding;
import chemaxon.naming.n2s.parse.Suffix;
import chemaxon.naming.n2s.util.MoleculeDoctor;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.DataSgroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Str
extends Token {
    private Modifier.Set<Str> modifiers = new Modifier.Set();
    public List<Str> substituents = null;
    public LocantList locantInParent = null;
    private LocantList numGreekLocants;
    public ArrayList<Suffix> suffixes = null;
    public Radical radical = null;
    public LocantList stereos;
    public LocantList locantsBefore = new LocantList();
    public boolean spaceSeparated = false;
    public boolean mustBeEster = false;
    public boolean explicitSingle = false;
    public boolean isRoot = false;
    public int multiplicity = 1;
    private static final String STEREO_CANDIDATE = "stereo_candidate";
    private static final String STEREO_DELAYED = "stereo_delayed";
    private Molecule _mol;
    private boolean generating = false;
    private boolean generated = false;
    private int numParentAtoms;
    private int numParentBonds;
    private boolean dangling;
    public static final int NO_BOND = -1;
    static final String MERGE_WITH_O = "mergeWithO";
    public static final String MERGE_WITH_N = "mergeWithN";
    private HashMap<String, MolAtom> _locantMap;
    String Nprimes = "";
    Str parent;
    public LocantList nonStdValence = new LocantList();
    private static final MolAtom ambiguous = new MolAtom(0);

    public void add(Modifier<Str> mod) {
        this.modifiers.add(mod);
    }

    public boolean hasSubstituents() {
        return this.substituents != null;
    }

    public Str() {
    }

    public Str(String name) {
        super(name);
    }

    public void addSubstituent(Str substituent) {
        this.addSubstituent(null, substituent);
    }

    public void addSubstituent(Locant locant, Str substituent) {
        this.addSubstituent(locant, substituent, false);
    }

    public void addSubstituent(Locant locant, Str substituent, boolean prepend) {
        if (this.substituents == null) {
            this.substituents = new ArrayList<Str>();
        } else if ((this.is("oxy") || this.is("sulfan") && this.hasSuffixName("yl") || this.is("thio")) && this.substituents.size() == 1 && this.hasStandardValence()) {
            this.substituents.get(0).addSubstituent(locant, substituent);
            return;
        }
        if (locant != null) {
            substituent.locantInParent = LocantList.simpleList(locant);
        }
        if (prepend) {
            this.substituents.add(0, substituent);
        } else {
            this.substituents.add(substituent);
        }
        substituent.parent = this;
    }

    public void removeSubstituent(Str substituent) {
        this.substituents.remove(substituent);
    }

    public void removeSubstituent(int index) {
        this.substituents.remove(index);
    }

    public int substituentCount() {
        if (this.substituents == null) {
            return 0;
        }
        return this.substituents.size();
    }

    boolean hasLocant() {
        return this.locantInParent != null;
    }

    public void setLocantInParent(Locant l) {
        this.locantInParent = l == null ? null : LocantList.simpleList(l);
    }

    public boolean isCyclic() {
        return false;
    }

    public boolean isMonoAtomic() {
        return false;
    }

    public boolean isMarkush() {
        return false;
    }

    public boolean isAcid() {
        if (this.name.endsWith("ate") || this.name.endsWith("ite")) {
            return true;
        }
        if (this.name.endsWith(" acid") || this.name.endsWith("ic ")) {
            return true;
        }
        if (this.suffixes != null) {
            for (Suffix s : this.suffixes) {
                if (s.getType() != 4 && !s.getName().endsWith(" acid")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAlcohol() {
        return this.getSuffix("ol") != null;
    }

    public boolean isAmine() {
        return this.is("amine") || this.getSuffix("amine") != null;
    }

    public boolean isYlene() {
        if (this.getName().endsWith("ylene")) {
            return true;
        }
        return this.hasSuffixName("ylene");
    }

    public boolean isSalt() {
        Suffix s;
        return this.suffixes != null && this.suffixes.size() == 1 && ((s = this.suffixes.get(0)).is("salt") || s.is("ide"));
    }

    public boolean isSaltIde() {
        Suffix ide = this.getSuffix("ide");
        if (ide == null) {
            return false;
        }
        return !(ide instanceof SaltEnding);
    }

    public boolean isEsterParent() {
        return this.isAcid();
    }

    public boolean isChain() {
        return false;
    }

    public boolean needsLocant() {
        return this.isCyclic() && (this.hasSuffixName("yl") || this.substituents != null || this.suffixes != null);
    }

    public boolean firstAtomSubstituable() {
        return false;
    }

    public boolean nameEndsWith(String string) {
        return this.name != null && this.name.endsWith(string);
    }

    public int suffixCount() {
        if (this.suffixes == null) {
            return 0;
        }
        return this.suffixes.size();
    }

    public Suffix getSuffix(int index) {
        return this.suffixes.get(index);
    }

    public void addSuffix(Suffix suffix) {
        Suffix s;
        if (this.suffixes == null) {
            this.suffixes = new ArrayList();
        }
        if (suffix.is("hydrazide")) {
            Iterator<Suffix> it = this.suffixes.iterator();
            while (it.hasNext()) {
                Suffix s2 = it.next();
                if (s2.getMultiplicity() != suffix.getMultiplicity() || !s2.is("ic acid") && !s2.is("oic acid") && !s2.is("carboxylic acid") && !s2.is("ic ") && !s2.is("oic ") && !s2.is("carboxylic ")) continue;
                suffix.setLocant(s2.getLocant());
                it.remove();
            }
        }
        if (suffix.is("on") && !suffix.hasLocant() && !this.suffixes.isEmpty() && (s = this.suffixes.get(this.suffixes.size() - 1)).is("ol") && !s.hasLocant()) {
            throw new RuntimeException("olone");
        }
        if (suffix instanceof Radical) {
            this.radical = (Radical)suffix;
        }
        this.suffixes.add(suffix);
    }

    public void addSuffixes(List<Suffix> suffixes) {
        if (suffixes == null) {
            return;
        }
        for (Suffix s : suffixes) {
            this.addSuffix(s);
        }
    }

    public boolean removeSuffixName(String name) {
        Suffix s = this.getSuffix(name);
        if (s == null) {
            return false;
        }
        this.suffixes.remove(s);
        return true;
    }

    public void removeSuffix(Suffix toRemove) {
        this.suffixes.remove(toRemove);
        if (this.radical == toRemove) {
            this.radical = null;
        }
    }

    public boolean remove(Suffix toRemove) {
        for (Suffix s : this.suffixes) {
            if (s != toRemove) continue;
            this.suffixes.remove(s);
            for (MolAtom a : toRemove.getGeneratedAtoms()) {
                if (a.containsPropertyKey("merged")) continue;
                this.getMol().removeAtom(a);
            }
            return true;
        }
        return false;
    }

    public Suffix getSuffix(String name) {
        if (this.suffixes == null) {
            return null;
        }
        for (Suffix s : this.suffixes) {
            if (!UtilLegacy.isName(s.getName(), name)) continue;
            return s;
        }
        return null;
    }

    public boolean hasExplicitRadical() {
        if (this.getParentMol().getAtom(0).getRadical() > 0) {
            return true;
        }
        if (this.getName().endsWith("yl") && !this.is("biphenyl") && this.suffixCount() == 0) {
            return true;
        }
        return this.radical != null;
    }

    public Str getSubstituent(String name) {
        if (this.substituents == null) {
            return null;
        }
        for (Str s : this.substituents) {
            if (!UtilLegacy.isName(s.getName(), name)) continue;
            return s;
        }
        return null;
    }

    public boolean hasSuffixName(String name) {
        if (name == "yl" && this.getName().endsWith("yl")) {
            return true;
        }
        return this.getSuffix(name) != null;
    }

    public void addHydro(Hydro hydro) {
        this.modifiers.add(hydro);
    }

    public void addHydros(LocantList ll, Hydro hydro) {
        hydro.setLocants(ll);
        this.addHydro(hydro);
    }

    public void addStereo(LocantList stereos) {
        if (this.stereos == null) {
            this.stereos = stereos;
        } else {
            this.stereos.tryAddLocant(stereos);
        }
    }

    public boolean tryAddLocantsBefore(LocantList locants, boolean cautious) {
        if (this.addNumGreekLocants(locants)) {
            return true;
        }
        if (this.useLocantsForSuffixes(locants, cautious)) {
            return true;
        }
        if (this.hasDefaultLocants()) {
            this.locantsBefore = locants;
            return true;
        }
        return false;
    }

    boolean isCis() {
        return this.stereos != null && this.stereos.hasCis();
    }

    boolean isTrans() {
        return this.stereos != null && this.stereos.hasTrans();
    }

    private List<StereoNumber> getBondStereos() {
        if (this.stereos == null) {
            return null;
        }
        ArrayList<StereoNumber> res = new ArrayList<StereoNumber>();
        for (Locant s : this.stereos.getLocantsList()) {
            StereoNumber sn;
            if (!(s instanceof StereoNumber) || !(sn = (StereoNumber)s).isBondStereo() || sn.isEmpty()) continue;
            res.add(sn);
        }
        return res;
    }

    private boolean addNumGreekLocants(LocantList locants) {
        if (!locants.isAllNumGreek()) {
            return false;
        }
        this.numGreekLocants = locants;
        return true;
    }

    protected boolean useLocantsForSuffixes(LocantList locants, boolean cautious) {
        if (this.suffixes == null) {
            return false;
        }
        for (Suffix s : this.suffixes) {
            if (s.getName().startsWith("an")) continue;
            if (s.is("ide")) {
                return false;
            }
            if (cautious && s.getName().startsWith("yl")) {
                return false;
            }
            if (s.hasLocant()) continue;
            LocantList ll = locants.expandOMP(s.getMultiplicity());
            if (s.getMultiplicity() != ll.size()) continue;
            if (!this.hasLocants(ll)) {
                return false;
            }
            s.setLocant(ll, this);
            return true;
        }
        return false;
    }

    public boolean addLocantsBefore(LocantList locants) {
        return this.addLocantsBefore(locants, true);
    }

    private boolean addLocantsBefore(LocantList locants, boolean allowRecursion) {
        if (this.is("androst")) {
            return true;
        }
        if (this.tryAddLocantsBefore(locants, false)) {
            return true;
        }
        if (this.substituents != null && this.substituents.size() == 1 && allowRecursion && this.substituents.get(0).addLocantsBefore(locants, true)) {
            return true;
        }
        if (this.locantInParent != null) {
            return false;
        }
        this.locantInParent = locants;
        return true;
    }

    public void setLocantBefore(Locant l) {
        this.locantsBefore.tryAddLocant(l);
    }

    public LocantList getLocantsBefore() {
        if (this.locantsBefore != null && this.locantsBefore.hasLocant()) {
            return this.locantsBefore;
        }
        return this.locantInParent;
    }

    @Override
    public String getValue() {
        return "";
    }

    public boolean acceptsAne() {
        return this.isCyclic();
    }

    public boolean hasLocants(LocantList locants) {
        if (locants == null || locants == Locant.Pers) {
            return true;
        }
        for (Locant l : locants.getLocantsList()) {
            if (this.hasLocant(l)) continue;
            return false;
        }
        return true;
    }

    public boolean hasDefaultLocants() {
        return false;
    }

    boolean hasStandardValence() {
        if (this.suffixes == null) {
            return true;
        }
        for (Suffix s : this.suffixes) {
            LocantList l = s.getLocant();
            if (!l.hasLocant() || !(l.getLocant(0) instanceof NonStdValenceLocant)) continue;
            return false;
        }
        return true;
    }

    public boolean isSpaceSeparated() {
        return this.spaceSeparated;
    }

    public void setSpaceSeparated(boolean value) {
        this.spaceSeparated = value;
    }

    public boolean isExplicitSingle() {
        return this.explicitSingle;
    }

    public void setExplicitSingle(boolean explicitSingle) {
        this.explicitSingle = explicitSingle;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public static MolAtom getRadical(Molecule m) {
        return (MolAtom)m.properties().getObject("radicalAtom");
    }

    @Override
    public Str clone() {
        Str res = (Str)super.clone();
        this._mol = null;
        this._locantMap = null;
        if (this.substituents != null) {
            res.substituents = new ArrayList<Str>(this.substituents.size());
            for (Str str : this.substituents) {
                res.substituents.add(str.cloneMe());
            }
        }
        if (this.suffixes != null) {
            res.suffixes = new ArrayList(this.suffixes.size());
            for (Suffix suffix : this.suffixes) {
                res.suffixes.add(suffix.clone());
            }
        }
        this.modifiers = this.modifiers.clone();
        return res;
    }

    public abstract Str cloneMe();

    public Str cloneMe(boolean alwaysDeep) {
        return this.cloneMe();
    }

    public Molecule getCompleteStructure() {
        if (this._mol != null && Util.getProperty(this._mol, "getCompleteStructure") != null) {
            this._mol = null;
            this._locantMap = null;
            this.generated = false;
            this.generating = false;
        }
        this.checkState(this.getMol());
        this.setRadical();
        this.checkState(this._mol);
        this._mol.setProperty("getCompleteStructure", "called");
        return this._mol;
    }

    private void checkState(Molecule mol) {
        assert (this.doCheckState(mol));
    }

    private boolean doCheckState(Molecule mol) {
        try {
            return true;
        }
        catch (MoleculeDoctor.MoleculeInternalStateException e) {
            throw new RuntimeException("Molecule graph inconsistant for " + this, e);
        }
    }

    public Molecule getCompleteStructureClear() {
        Molecule dearomatized;
        Molecule res = this.getCompleteStructure();
        this.handleAlphaBeta();
        res = this.handleDelayedActions(res);
        if (this.locantInParent != null && this.locantInParent.hasLocant()) {
            throw new RuntimeException("locantInParent in toplevel structure: " + this.locantInParent.toString() + " - " + this);
        }
        if (this.locantsBefore != null && this.locantsBefore.hasLocant()) {
            throw new RuntimeException("locantsBefore in toplevel structure: " + this.locantsBefore.toString() + " - " + this);
        }
        int i = res.getAtomCount();
        while (--i >= 0) {
            int chirality = res.getChirality(i);
            if (chirality == 0 || chirality == 3) continue;
            res.setAbsStereo(true);
            break;
        }
        if ((dearomatized = Dearomatizer.removePartialAromatization(res)) == null) {
            throw new RuntimeException("Partially aromatic: " + res.toFormat("cxsmiles"));
        }
        res = dearomatized;
        Str.clearAll(res);
        if (res.getDim() > 0) {
            Cleaner.clean(res, res.getDim(), null);
        }
        this.checkState(res);
        return res;
    }

    private Molecule handleDelayedActions(Molecule m) {
        boolean hadSuccess = false;
        boolean hadFailure = false;
        for (Sgroup sg : m.getSgroupArray()) {
            int chirality;
            MolAtom a;
            if (!(sg instanceof DataSgroup)) continue;
            DataSgroup data = (DataSgroup)sg;
            String key = data.getFieldName();
            if (key.equals(STEREO_DELAYED)) {
                a = data.getAtom(0);
                boolean success = StereoNumber.setChirality(m, a, chirality = Integer.parseInt(data.getData()));
                if (!success && this.uppercaseStereo(chirality) != -1) {
                    success = StereoNumber.setChirality(m, a, this.uppercaseStereo(chirality));
                }
                if (success) {
                    m.ungroupSgroup(data);
                }
                hadSuccess |= success;
                hadFailure |= !success;
                continue;
            }
            if (!key.equals(STEREO_CANDIDATE)) continue;
            a = data.getAtom(0);
            if (StereoNumber.setChirality(m, a, chirality = Integer.parseInt(data.getData()))) {
                m.ungroupSgroup(data);
                continue;
            }
            hadFailure = true;
        }
        if (hadSuccess && hadFailure) {
            return this.handleDelayedActions(m);
        }
        if (hadFailure && !Ambiguity.stereochemistry.allow()) {
            throw new RuntimeException("Ambiguous stereodescriptor");
        }
        return m;
    }

    private int uppercaseStereo(int chirality) {
        if (chirality == 32) {
            return 8;
        }
        if (chirality == 64) {
            return 16;
        }
        return -1;
    }

    public static void clearNumbering(Molecule res) {
        Str.clearNumbering(res, false);
    }

    static void clearNumbering(Molecule res, boolean full) {
        int i = res.getAtomCount();
        while (--i >= 0) {
            MolAtom a = res.getAtom(i);
            if (!MarkushStr.isMarkush(a.getAliasstr())) {
                boolean defHydro = !full && a.getAliasstr() != null && a.getAliasstr().contains("defHydro");
                a.setAliasstr(defHydro ? "defHydro" : null);
            }
            if (full) {
                a.setExtraLabel(null);
            }
            if (!full || a.propertyCount() <= 0) continue;
            Object notes = a.getProperty("TEXTNOTES");
            a.clearProperties();
            if (notes == null) continue;
            a.putProperty("TEXTNOTES", notes);
        }
    }

    static void clearAll(Molecule res) {
        Str.clearNumbering(res, true);
        for (MolBond molBond : res.getBondArray()) {
            molBond.setFlags(molBond.getFlags() & 0xFFFFFDFF);
        }
        for (Serializable serializable : res.getSgroupArray()) {
            if (!(serializable instanceof DataSgroup)) continue;
            res.ungroupSgroup((Sgroup)serializable);
        }
    }

    private boolean handleAlphaBeta() {
        if (this.numGreekLocants == null) {
            return false;
        }
        for (Locant l : this.numGreekLocants.getLocantsList()) {
            if (this.handleAlphaBeta((SimpleLocant)l)) continue;
            return false;
        }
        return true;
    }

    private boolean handleAlphaBeta(SimpleLocant l) {
        if (l.greekLetter == 'a') {
            return true;
        }
        if (l.greekLetter == 'b') {
            MolAtom atom = this.getAtom(new SimpleLocant(l.getValue()));
            int a = this.getMol().indexOf(atom);
            int chirality = this.getMol().getChirality(a);
            if (chirality == 8) {
                this.getMol().setChirality(a, 16);
            } else if (chirality == 8) {
                this.getMol().setChirality(a, 16);
            }
            return true;
        }
        return false;
    }

    public void addSimpleBond(Molecule m, MolAtom connectionPoint, MolAtom radical, int bondType) {
        this.prepareToConnection(connectionPoint);
        this.prepareToConnection(radical);
        bondType = this.addUpDown(m, connectionPoint, bondType);
        m.add(new MolBond(connectionPoint, radical, bondType));
    }

    private int addUpDown(Molecule m, MolAtom sourceAtom, int bondType) {
        if (bondType != 1) {
            return bondType;
        }
        if (!this.isCis() && !this.isTrans()) {
            return 1;
        }
        if (!Util.isRingAtom(sourceAtom)) {
            return 1;
        }
        int stereo = this.getCurrentStereoLigand(m);
        int numLigands = this.getConnectionCount();
        if (stereo != 0 && numLigands == 1) {
            numLigands = 2;
        }
        if (numLigands != 2) {
            return 1;
        }
        if (stereo == 0) {
            stereo = 528;
        }
        if (this.isTrans()) {
            stereo = Str.invertUpDown(stereo);
        }
        return 1 | stereo;
    }

    private static int invertUpDown(int stereo) {
        if ((stereo & 0x10) != 0) {
            return 0x20 | stereo & 0x200;
        }
        return 0x10 | stereo & 0x200;
    }

    private int getCurrentStereoLigand(Molecule m) {
        if (m.getDim() == 0) {
            Cleaner.clean(m, 2, null);
        }
        int i = m.getBondCount();
        while (--i >= 0) {
            MolBond b = m.getBond(i);
            int stereo = b.getFlags() & 0x30;
            if (stereo == 0) continue;
            if (b.getAtom1().getStereoGroupType() == 2 || b.getAtom2().getStereoGroupType() == 2) {
                stereo |= 0x200;
            }
            return stereo;
        }
        return 0;
    }

    public static void fuseCleared(Molecule m, Molecule addition) {
        Str.clearNumbering(addition);
        if (m.getDim() == 0 && addition.getDim() > 0) {
            Cleaner.clean(m, addition.getDim(), null);
        } else if (addition.getDim() == 0 && m.getDim() > 0) {
            Cleaner.clean(addition, m.getDim(), null);
        }
        m.fuse(addition);
    }

    @Override
    public void display(String prefix, StringBuilder res) {
        List<Hydro> hydros;
        res.append(prefix);
        if (this.spaceSeparated) {
            res.append("' '");
        }
        if (this.locantInParent != null) {
            res.append(this.locantInParent).append('-');
        }
        res.append(this);
        if (this.suffixes != null) {
            for (Suffix s : this.suffixes) {
                res.append(' ').append(s);
            }
        }
        String subPrefix = prefix + "  ";
        if (this.stereos != null) {
            res.append('\n').append(subPrefix).append(this.stereos);
        }
        if ((hydros = this.getHydros()) != null) {
            res.append('\n').append(subPrefix).append(hydros);
        }
        if (this.substituents != null) {
            for (Str sub : this.substituents) {
                res.append('\n');
                if (sub == null) {
                    res.append(subPrefix + "[null]");
                    continue;
                }
                sub.display(subPrefix, res);
            }
        }
    }

    public MolAtom getEsterificationPoint() {
        MolAtom a = this.getLocantMap().get("defEster");
        if (a != null) {
            return a;
        }
        a = this.getLocantMap().get("ester");
        if (a != null) {
            return a;
        }
        return null;
    }

    public MolAtom[] getParentEsterificationPoints() {
        ArrayList<MolAtom> res = new ArrayList<MolAtom>();
        for (MolAtom a : this.getParentMol().getAtomArray()) {
            if (!Str.hasKeyword(a, "ester")) continue;
            res.add(a);
        }
        return res.toArray(new MolAtom[res.size()]);
    }

    public MolAtom[] getAllEsterificationPoints() {
        MolAtom[] r = this.getParentEsterificationPoints();
        if (r.length > 0) {
            return r;
        }
        ArrayList<MolAtom> res = new ArrayList<MolAtom>();
        for (MolAtom a : this.getMol().getAtomArray()) {
            if (!Str.hasKeyword(a, "ester")) continue;
            res.add(a);
        }
        return res.toArray(new MolAtom[res.size()]);
    }

    public MolAtom[] getAllChalcogens(int atno) {
        MolAtom[] r = this.getAllEsterificationPoints();
        if (r.length > 0) {
            return r;
        }
        ArrayList<MolAtom> res = new ArrayList<MolAtom>();
        for (MolAtom a : this.getMol().getAtomArray()) {
            if (!this.isOH(a, atno)) continue;
            res.add(a);
        }
        return res.toArray(new MolAtom[res.size()]);
    }

    public void removeEsterificationPoint(MolAtom a) {
        this.replaceKeyword(a, "ester", "ESTERIFIED");
        this.replaceKeyword(a, "defEster", "ESTERIFIED");
    }

    public int getAtomCountIfKnown() {
        if (this._mol == null) {
            return 0;
        }
        return this._mol.getAtomCount();
    }

    int getNumParentAtoms() {
        return this.numParentAtoms;
    }

    public boolean isDangling() {
        return this.dangling;
    }

    protected Molecule getMol() {
        this.getParentMol();
        this.checkState(this._mol);
        if (!this.generating) {
            this.generating = true;
            this.generate();
            this.generated = true;
        }
        this.checkState(this._mol);
        return this._mol;
    }

    public Molecule getMolPublic() {
        return this.getMol();
    }

    protected void setMol(Molecule mol) {
        this._mol = mol;
    }

    public Molecule getParentMol() {
        return this.getParentMol(false);
    }

    public Molecule getParentMol(boolean recreate) {
        if (this._mol != null && !recreate) {
            return this._mol;
        }
        if (recreate) {
            this._locantMap = null;
        }
        this._mol = this.createParentMolecule();
        this.numParentAtoms = this._mol.getAtomCount();
        this.numParentBonds = this._mol.getBondCount();
        return this._mol;
    }

    public abstract Molecule createParentMolecule();

    public Iterable<MolAtom> parentAtoms() {
        return Arrays.asList(this.getParentMol().getAtomArray()).subList(0, this.numParentAtoms);
    }

    public Iterable<MolBond> parentBonds() {
        return Arrays.asList(this.getParentMol().getBondArray()).subList(0, this.numParentBonds);
    }

    public void generate() {
        Iterator<Cloneable> it;
        this.checkState(this.getMol());
        this.modifiers.applyAll(this);
        this.handleRemainingHydro();
        this.checkState(this._mol);
        if (this.suffixes != null) {
            it = this.suffixes.iterator();
            while (it.hasNext()) {
                Suffix suffix = it.next();
                if (!suffix.connect(this)) continue;
                it.remove();
            }
        }
        this.checkState(this._mol);
        if (this.substituents != null) {
            this.addDefaultConnectionPointPair(this.substituents);
            for (Str s : this.substituents) {
                s.connectToParent(this);
            }
            this.addDefaultConnectionPoints(this.substituents, false);
            boolean stillDangling = false;
            for (Str s : this.substituents) {
                if (!s.dangling) continue;
                if (!Ambiguity.missingLocant.allow()) {
                    throw new RuntimeException("Could not connect to " + this);
                }
                stillDangling = true;
            }
            if (stillDangling) {
                this.addDefaultConnectionPoints(this.substituents, true);
                for (Str s : this.substituents) {
                    if (!s.dangling) continue;
                    throw new RuntimeException("Could not connect to " + this);
                }
            }
        }
        this.checkState(this._mol);
        if (this.stereos != null) {
            for (Locant stereoLocant : this.stereos.getLocantsList()) {
                StereoNumber stereo = (StereoNumber)stereoLocant;
                if (stereo.isBondStereo()) {
                    MolBond bond = this.getBond(stereo);
                    if (bond == null) continue;
                    bond.setFlags(stereo.getStereoFlag(), 1008);
                    continue;
                }
                if (stereo.getStereoData() == 1 || stereo.getStereoData() == 2) {
                    if (Ambiguity.stereochemistry.allow()) continue;
                    throw new RuntimeException("Unsupported endo/exo stereo-descriptor");
                }
                if (stereo.isDLconfiguration()) {
                    this.changeStereo(this._mol, stereo.getStereoData());
                    continue;
                }
                MolAtom a = this.getAtom(stereo);
                if (a == ambiguous) {
                    if (Ambiguity.stereochemistry.allow()) continue;
                    throw new RuntimeException("Ambiguous chiral stereo-descriptor");
                }
                if (a == null) {
                    for (MolAtom candidate : this.parentAtoms()) {
                        this.attachData(this.getParentMol(), candidate, STEREO_CANDIDATE, stereo.getChirality());
                    }
                    continue;
                }
                this.attachData(this.getParentMol(), a, STEREO_DELAYED, stereo.getChirality());
            }
        }
        if (this.locantInParent != null) {
            it = this.locantInParent.getLocantsList().iterator();
            while (it.hasNext()) {
                Locant l = (Locant)it.next();
                if (!l.applyToParent(this)) continue;
                it.remove();
            }
        }
    }

    private void changeStereo(Molecule mol, int configuration) {
        int defaultStereo = this.getDefaultStereo();
        boolean hasChiral = false;
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            int chirality = mol.getChirality(i);
            if ((chirality & 0x18) == 0) continue;
            hasChiral = true;
            if (configuration == 5) {
                mol.getAtom(i).setStereoGroupType(3);
                mol.getAtom(i).setStereoGroupNumber(1);
                continue;
            }
            if (configuration == defaultStereo) continue;
            mol.setChirality(i, Chem.reverseChirality(chirality));
        }
        if (!hasChiral) {
            throw new RuntimeException("D/L modifier on non-chiral structure");
        }
    }

    private void addDefaultConnectionPoints(List<Str> substituents, boolean allowAmbiguous) {
        ArrayList<Str> noLocs = new ArrayList<Str>();
        String subName = null;
        for (Str s : substituents) {
            if (!s.dangling || s.hasLocant() || s.isSpaceSeparated()) continue;
            if (subName == null) {
                subName = s.getName();
            } else if (!subName.equals(s.getName())) {
                return;
            }
            noLocs.add(s);
        }
        if (noLocs.isEmpty()) {
            return;
        }
        MolAtom[] possibleRoots = this.getPossibleRoots();
        if (allowAmbiguous || possibleRoots.length == noLocs.size()) {
            int n = 0;
            for (Str s : noLocs) {
                this.connect(s, possibleRoots[n++]);
                substituents.remove(s);
            }
        }
    }

    private MolAtom[] getPossibleRoots() {
        ArrayList<MolAtom> res = new ArrayList<MolAtom>();
        for (MolAtom a : this.parentAtoms()) {
            a.valenceCheck();
            if (a.getAtno() == 8 && !this.is("peroxide") && !this.is("borate")) continue;
            int i = Util.getImplicitHcount(a);
            while (--i >= 0) {
                res.add(a);
            }
        }
        return res.toArray(new MolAtom[res.size()]);
    }

    private MolAtom[] getPerLocations() {
        ArrayList<MolAtom> res = new ArrayList<MolAtom>();
        for (MolAtom a : this.getAllAtoms()) {
            a.valenceCheck();
            if (a.getAtno() != 6) continue;
            int i = Util.getImplicitHcount(a);
            while (--i >= 0) {
                res.add(a);
            }
        }
        for (Hydro h : this.modifiers.getAll(Hydro.class)) {
            for (MolAtom a : this.getAtoms(h.getLocants())) {
                res.remove(a);
            }
        }
        if (res.size() < 2) {
            throw new RuntimeException("per without at least two locations");
        }
        return res.toArray(new MolAtom[res.size()]);
    }

    private MolAtom[] getAllAtoms() {
        return this.getMol().getAtomArray();
    }

    protected void connectToParent(Str parent) {
        parent.connect(this);
    }

    private void addDefaultConnectionPointPair(List<Str> substituents) {
        if (this.hasConnectableSuffixes()) {
            return;
        }
        Str noLoc1 = null;
        Str noLoc2 = null;
        for (Str s : substituents) {
            if (s.hasLocant() || s.isSpaceSeparated()) continue;
            if (noLoc1 == null) {
                noLoc1 = s;
                continue;
            }
            if (noLoc2 == null) {
                noLoc2 = s;
                continue;
            }
            return;
        }
        if (noLoc2 == null || !this.hasLoc12()) {
            return;
        }
        noLoc1.setLocantInParent(SpecialLocant.loc1);
        noLoc2.setLocantInParent(SpecialLocant.loc2);
    }

    private boolean hasLoc12() {
        MolAtom a1 = this.getLocantMap().get("loc1");
        MolAtom a2 = this.getLocantMap().get("loc2");
        if (a1 == null || a2 == null) {
            a1 = this.getLocantMap().get("loc1A");
            a2 = this.getLocantMap().get("loc2A");
            if (a2 == null || !Ambiguity.defaultLocant.allow()) {
                return false;
            }
        }
        return true;
    }

    private boolean hasConnectableSuffixes() {
        if (this.suffixes == null) {
            return false;
        }
        for (Suffix s : this.suffixes) {
            if (s.getType() == 3) continue;
            return true;
        }
        return false;
    }

    private void handleRemainingHydro() {
        int noLocant = 0;
        Hydro noLocantHydro = null;
        for (Hydro hydro : this.modifiers.getUnapplied(Hydro.class)) {
            assert (hydro.getLocants() == null);
            if (noLocantHydro == null) {
                noLocantHydro = hydro;
            } else if (hydro.getType() != noLocantHydro.getType()) {
                throw new RuntimeException("Dissimilar hydrogenation without locants");
            }
            ++noLocant;
        }
        if (noLocant > 0) {
            if (noLocantHydro.getType() == 1) {
                throw new RuntimeException("dehydro without locant");
            }
            int done = 0;
            for (MolAtom a : this.parentAtoms()) {
                if (!this.hydrogenize(a, 1) || Util.getImplicitHcount(a) <= 0) continue;
                ++done;
            }
            if (done > noLocant) {
                throw new RuntimeException("Partial hydrogenation without locants");
            }
            if (done == 0) {
                throw new RuntimeException("Unknown hydrogenation without locants");
            }
        }
    }

    private int hydrogenize(MolBond b) {
        MolAtom a1 = b.getAtom1();
        MolAtom a2 = b.getAtom2();
        if (a1.getBondCount() == 1 || a2.getBondCount() == 1) {
            return 0;
        }
        if (b.getType() == 2) {
            b.setType(1);
            int res = 0;
            if (Util.getImplicitHcount(a1) > 0) {
                ++res;
            }
            if (Util.getImplicitHcount(a2) > 0) {
                ++res;
            }
            return res;
        }
        if (b.getType() == 4) {
            b.setType(1);
            int res = 0;
            if (Util.getImplicitHcount(a1) > 0) {
                ++res;
            }
            if (Util.getImplicitHcount(a2) > 0) {
                ++res;
            }
            return res / 2;
        }
        return 0;
    }

    public boolean connect(Suffix suffix) {
        if (suffix.is("en") || suffix.is("ene")) {
            this.setBond(suffix, 2);
            return false;
        }
        if (suffix.is("ylene") && this.parent == null) {
            Suffix amine = this.getSuffix("amine");
            if (amine == null || amine.getMultiplicity() != 2) {
                this.setBond(suffix, 2);
            }
            return true;
        }
        if (suffix.is("yn") || suffix.is("yne")) {
            this.setBond(suffix, 3);
            return false;
        }
        if (suffix.nothingToGenerate()) {
            return false;
        }
        MolAtom[] connectionPoints = this.getConnectionPoints(suffix);
        if (connectionPoints == null) {
            return false;
        }
        if (suffix.is("ium") || suffix.is("onium")) {
            for (MolAtom a : connectionPoints) {
                a.setCharge(a.getCharge() + 1);
            }
            return false;
        }
        if (suffix.is("ion")) {
            int charge;
            if (suffix.getValue().equals("+")) {
                charge = 1;
            } else if (suffix.getValue().equals("-")) {
                charge = -1;
            } else {
                return false;
            }
            for (MolAtom a : connectionPoints) {
                a.setCharge(a.getCharge() + charge);
            }
            return false;
        }
        Molecule m = this.getParentMol();
        for (MolAtom connectionPoint : connectionPoints) {
            if (suffix.is("hydrazide") && this.hasKetone(connectionPoint)) {
                MolAtom n1 = new MolAtom(7);
                MolAtom n2 = new MolAtom(7);
                m.add(n1);
                m.add(n2);
                m.add(new MolBond(n1, n2));
                m.add(new MolBond(connectionPoint, n1));
                continue;
            }
            Molecule sM = suffix.getCompleteStructure();
            MolAtom radical = suffix.getRadicalAtom();
            int bondType = suffix.getRadical(this);
            this.addDefaultLocantsFrom(sM, true);
            this.getParentMol().fuse(sM);
            this.addBond(connectionPoint, radical, bondType, suffix);
            if (!suffix.is("oyl")) continue;
            if (bondType == 0) {
                this.setRadical(radical, 1);
                continue;
            }
            this.setRadical(connectionPoint, 1);
        }
        return false;
    }

    public MolAtom[] getConnectionPoints(Suffix suffix) {
        LocantList locant = suffix.getLocant();
        MolAtom[] connectionPoints = null;
        if (locant.hasLocant()) {
            connectionPoints = this.getConnectionPoint(locant, suffix.isSpaceSeparated(), false);
        } else if (this.locantInParent != null && !this.isSubstituent() && this.hasLocants(this.locantInParent) && this.locantInParent.size() == suffix.getMultiplicity()) {
            connectionPoints = this.getConnectionPoint(this.locantInParent, suffix.isSpaceSeparated(), false);
            this.locantInParent = null;
        } else if (!locant.hasLocant() && suffix.getMultiplicity() == 2 && !suffix.isSeparateFragment()) {
            MolAtom loc2;
            MolAtom loc1 = this.getLocantMap().get("loc1");
            if (loc1 != null) {
                loc2 = this.getLocantMap().get("loc2");
                connectionPoints = new MolAtom[]{loc1, loc2};
            } else {
                loc1 = this.getLocantMap().get("loc1A");
                loc2 = this.getLocantMap().get("loc2A");
                if (loc1 != null && loc2 != null && Ambiguity.defaultLocant.allow()) {
                    connectionPoints = new MolAtom[]{loc1, loc2};
                }
            }
        }
        if (connectionPoints == null) {
            if (suffix.isSeparateFragment()) {
                int i = suffix.getMultiplicity();
                while (--i >= 0) {
                    this.getParentMol().fuse(suffix.getCompleteStructure());
                }
                return null;
            }
            MolAtom radical = Str.getRadical(this.getParentMol());
            if (radical != null && suffix.getMultiplicity() == 1) {
                connectionPoints = new MolAtom[]{radical};
            } else {
                connectionPoints = new MolAtom[suffix.getMultiplicity()];
                int i = connectionPoints.length;
                while (--i >= 0) {
                    connectionPoints[i] = this.getDefaultSuffixPoint(suffix);
                }
            }
        }
        return connectionPoints;
    }

    private boolean hasKetone(MolAtom connectionPoint) {
        for (int b = 0; b < connectionPoint.getBondCount(); ++b) {
            MolBond bond = connectionPoint.getBond(b);
            if (bond.getType() != 2 || bond.getOtherAtom(connectionPoint).getAtno() != 8) continue;
            return true;
        }
        return false;
    }

    private MolAtom getDefaultSuffixPoint(Suffix s) {
        MolAtom res;
        if (s.is("on") && this.isChain() && this.numParentAtoms >= 3) {
            return this.getLocantMap().get("2");
        }
        if (s.is("ium") && (res = this.getGoodPlaceForCharge()) != null) {
            return res;
        }
        return this.getDefaultSuffixPoint();
    }

    private MolAtom getGoodPlaceForCharge() {
        MolAtom candidate = null;
        for (MolAtom a : this.parentAtoms()) {
            if (!Util.isAtom(a, 7)) continue;
            if (candidate == null) {
                candidate = a;
                continue;
            }
            return null;
        }
        return candidate;
    }

    private MolAtom getDefaultSuffixPoint() {
        MolAtom res = this.getLocantMap().get("defSuf");
        if (res != null) {
            return res;
        }
        res = this.getLocantMap().get("def");
        if (res != null) {
            return res;
        }
        return this.getAtom((Locant)null);
    }

    protected boolean isSubstituent() {
        if (this.suffixes != null) {
            for (Suffix s : this.suffixes) {
                if (!s.isSubstituentEnding()) continue;
                return true;
            }
        }
        return false;
    }

    protected void setDefaultBondLocants(LocantList l, int multiplicity) {
    }

    private void setBond(Suffix suffix, int type) {
        Locant where;
        MolBond b;
        LocantList locants = suffix.getLocant();
        if (!locants.hasLocant()) {
            this.setDefaultBondLocants(locants, suffix.getMultiplicity());
        }
        if (!locants.hasLocant()) {
            this.setDefaultBondLocants(locants, suffix.getMultiplicity(), this.getBondStereos());
        }
        if (locants.hasLocant()) {
            for (Locant l : locants.getLocantsList()) {
                MolBond b2 = this.getBond(l);
                b2.setType(type);
            }
            return;
        }
        if (this.getParentMol().getBondCount() == 1) {
            this.getParentMol().getBond(0).setType(type);
            return;
        }
        if (suffix.getMultiplicity() == 1 && (b = this.getBond(where = this.is("but") || this.hasSuffixName("al") ? Locant.Two : Locant.One)) != null) {
            b.setType(type);
            return;
        }
        throw new RuntimeException("Do not know where to place bond");
    }

    private void setDefaultBondLocants(LocantList locants, int multiplicity, List<StereoNumber> bondStereos) {
        if (bondStereos == null || bondStereos.size() != multiplicity) {
            return;
        }
        for (StereoNumber s : bondStereos) {
            locants.tryAddLocant(s.getBasicLocant());
        }
    }

    private MolBond getBond(StereoNumber locant) {
        if (locant.empty) {
            MolBond res = null;
            Molecule m = this.getMol();
            for (MolBond bond : m.getBondArray()) {
                if (!m.canBeCT(bond)) continue;
                if (res == null) {
                    res = bond;
                    continue;
                }
                if (Ambiguity.stereochemistry.allow()) continue;
                throw new RuntimeException("Ambiguous stereo bond");
            }
            return res;
        }
        return this.getBond(locant.getBasicLocant());
    }

    private MolBond getBond(Locant locant) {
        if (locant instanceof BondNumber) {
            BondNumber b = (BondNumber)locant;
            SimpleLocant first = b.getFirstLocant();
            SimpleLocant second = b.getSecondLocant();
            if (second == null) {
                return this.getBond(first);
            }
            return this.getAtom(first).getBondTo(this.getAtom(second));
        }
        if (!(locant instanceof SimpleLocant)) {
            throw new RuntimeException("Invalid bond locant: " + locant);
        }
        SimpleLocant l = (SimpleLocant)locant;
        Locant next = locant.clone();
        next.setValue(l.getValue() + 1);
        MolAtom a1 = this.getAtom(l);
        MolAtom a2 = this.getAtom(next);
        MolBond res = a1.getBondTo(a2);
        return res;
    }

    public void connect(Str part) {
        if (part.isSeparate()) {
            Molecule m = part.getCompleteStructure();
            Str.fuseCleared(this.getParentMol(), m);
            return;
        }
        if (this.is("carbonate") && part.is("vinyl")) {
            MolAtom[] OHs = this.getParentEsterificationPoints();
            Molecule m = part.getCompleteStructure();
            Str.fuseCleared(this.getParentMol(), m);
            this.addBond(OHs[0], m.getAtom(0), 1, part);
            this.addBond(OHs[1], m.getAtom(1), 1, part);
            this.removeEsterificationPoint(OHs[0]);
            this.removeEsterificationPoint(OHs[1]);
            return;
        }
        if (this.is("glycol") && !part.hasExplicitRadical()) {
            throw new RuntimeException("Unsupported glycol");
        }
        MolAtom[] connectionPoints = this.getConnectionPoints(part);
        if (connectionPoints == null) {
            part.dangling = true;
            return;
        }
        if (connectionPoints.length == 0) {
            throw new RuntimeException("No connection points in " + this);
        }
        LocantList savedLocantInParent = part.locantInParent;
        part.locantInParent = null;
        for (MolAtom connectionPoint : connectionPoints) {
            this.connect(part, connectionPoint);
        }
        part.locantInParent = savedLocantInParent;
        this.applyLocants(part.locantInParent);
    }

    private void applyLocants(LocantList locants) {
        if (locants == null) {
            return;
        }
        for (Locant l : locants.getLocantsList()) {
            l.applyToParent(this);
        }
    }

    public void connect(Str part, MolAtom connectionPoint) {
        MolAtom radical;
        MolAtom OH;
        if (part.is("deoxy")) {
            if (connectionPoint.getAtno() != 8) {
                connectionPoint = this.getNeighbourOH(connectionPoint, 8);
            }
            if (connectionPoint.getAtno() != 8 || connectionPoint.getBondCount() != 1) {
                throw new RuntimeException("Deoxy should refer to an oxygen atom");
            }
            if (part.substituents != null) {
                if (part.substituents.size() != 1) {
                    throw new RuntimeException("Polysubstituted deoxy");
                }
                Str sub = part.substituents.get(0);
                if (sub instanceof HeteroAtomStr) {
                    HeteroAtomStr h = (HeteroAtomStr)sub;
                    this.changeAtom(connectionPoint, h);
                    return;
                }
                throw new RuntimeException("Substituted deoxy");
            }
            MolAtom root = connectionPoint.getLigand(0);
            this.getParentMol().removeAtom(connectionPoint);
            this.getLocantMap().put(Str.getLocant(connectionPoint), root);
            return;
        }
        if (part instanceof HeteroAtomStr) {
            HeteroAtomStr h = (HeteroAtomStr)part;
            this.changeAtom(connectionPoint, h);
            return;
        }
        if (Str.hasKeyword(connectionPoint, "ESTERIFIED")) {
            Suffix amide = part.getSuffix("amide");
            if (amide != null) {
                part.removeSuffixName("amide");
            } else {
                amide = this.getSuffix("amide");
                if (amide != null) {
                    this.remove(amide);
                }
            }
            if (amide != null) {
                Suffix N = new Suffix("amide replacement", "N", null, 1, -1);
                part.addSuffix(N);
                Molecule m = part.getCompleteStructure();
                Str.fuseCleared(this.getParentMol(), m);
                this.mergeAtoms(connectionPoint, N.getMol().getAtom(0));
                return;
            }
        }
        Molecule m = part.getCompleteStructure();
        if (this.is("sulfate") && !part.hasExplicitRadical()) {
            Str.fuseCleared(this.getParentMol(), m);
            return;
        }
        if (Str.hasKeyword(connectionPoint, "ESTERIFIED") && !part.hasExplicitRadical() && (OH = part.getHydroxy()) != null) {
            Str.fuseCleared(this.getParentMol(), m);
            this.mergeAtoms(connectionPoint, OH);
            if (OH.getCharge() == -1) {
                OH.setCharge(0);
            }
            return;
        }
        if (part.isAcid() && !this.getName().endsWith("bis")) {
            radical = part.getEsterificationPoint();
            MolAtom OH2 = this.getOHOrNeighbourOH(connectionPoint);
            if (radical != null && OH2 != null) {
                if (radical.getCharge() == -1) {
                    radical.setCharge(0);
                }
                Str.fuseCleared(this.getParentMol(), m);
                this.mergeAtoms(OH2, radical);
                return;
            }
        }
        radical = Str.getRadical(m);
        int radicalBond = (Integer)m.properties().getObject("radicalBond");
        assert (radicalBond == -1 || radical != null) : "Connecting " + part + " to " + this;
        this.checkLocant(connectionPoint, radical);
        if (part.isReplacement()) {
            if (connectionPoint.getAtno() == 8) {
                this.mergeAtoms(connectionPoint, radical);
                radicalBond = -1;
            } else {
                int b = connectionPoint.getBondCount();
                while (--b >= 0) {
                    MolBond bond = connectionPoint.getBond(b);
                    MolAtom a = bond.getOtherAtom(connectionPoint);
                    if (a.getAtno() != 8) continue;
                    this.mergeAtoms(a, radical);
                    radicalBond = -1;
                    break;
                }
            }
        }
        Str.fuseCleared(this.getParentMol(), m);
        this.addBond(connectionPoint, radical, radicalBond, part);
    }

    private void checkLocant(MolAtom connectionPoint, MolAtom radical) {
        Locant l = (Locant)connectionPoint.getProperty("locant");
        if (l == null) {
            return;
        }
        int unmatchedAtno = l.getUnmatchedAtno();
        if (unmatchedAtno == -1) {
            return;
        }
        if (radical.getAtno() != unmatchedAtno) {
            throw new RuntimeException("Wrong atom locant: expected " + unmatchedAtno + ", was " + radical.getAtno());
        }
    }

    MolAtom getHydroxy() {
        MolAtom a = this.getLocantMap().get("ol");
        if (a != null) {
            return a;
        }
        Suffix ol = this.getSuffix("ol");
        if (ol != null) {
            return ol.getMol().getAtom(0);
        }
        Str hydroxy = this.getSubstituent("hydroxy");
        if (hydroxy != null) {
            return hydroxy.getMol().getAtom(0);
        }
        MolAtom res = null;
        for (MolAtom o : this.getParentMol().getAtomArray()) {
            if (o.getAtno() != 8 || Util.getImplicitHcount(o) != 1) continue;
            if (res != null) {
                return null;
            }
            res = o;
        }
        return res;
    }

    List<MolAtom> getHydroxys() {
        ArrayList<MolAtom> res = new ArrayList<MolAtom>();
        for (MolAtom o : this.getMol().getAtomArray()) {
            if (o.getAtno() != 8 || Util.getImplicitHcount(o) != 1) continue;
            res.add(o);
        }
        return res;
    }

    MolAtom[] getConnectionPoints(Str part) {
        MolAtom[] res;
        if (part.locantInParent == null) {
            if (part.is("hydrogen")) {
                for (MolAtom a : this.getParentMol().getAtomArray()) {
                    if (a.getAtno() != 8 || a.getCharge() != -1) continue;
                    return new MolAtom[]{a};
                }
            }
            if ((res = part.getConnectionPointInParent(this)) != null) {
                return res;
            }
        }
        if (part.hasLocant() && part.isSpaceSeparated() && (res = this.getEsterificationWithLocant(part)) != null) {
            return res;
        }
        if (part.locantInParent != null && part.locantInParent.is(Locant.Per)) {
            return this.getPerLocations();
        }
        return this.getConnectionPoint(part.locantInParent, part.spaceSeparated, part.explicitSingle);
    }

    protected MolAtom[] getConnectionPointInParent(Str parent) {
        return null;
    }

    private MolAtom[] getEsterificationWithLocant(Str part) {
        MolAtom[] res = this.getAllAtoms(part.getLocantInParent());
        for (int i = 0; i < res.length; ++i) {
            MolAtom a = res[i];
            MolAtom oh = this.isCyclic() || part.mustBeEster ? this.getNeighbourOHorCOH(a, this.getAtno(part.getLocantInParent())) : this.getNeighbourOH(a, this.getAtno(part.getLocantInParent()));
            if (!Str.hasKeyword(oh, "ester") && !Str.hasKeyword(oh, "defEster")) {
                if (!part.mustBeEster) {
                    return null;
                }
            } else {
                this.removeEsterificationPoint(oh);
            }
            res[i] = oh;
        }
        return res;
    }

    private int getAtno(LocantList locant) {
        if (locant.is(AtomLocant.S)) {
            return 16;
        }
        return 8;
    }

    private boolean isReplacement() {
        return this.is("thio") || this.is("seleno") || this.is("telluro");
    }

    public void addBond(MolAtom connectionPoint, MolAtom radical, int bondType, Part part) {
        if (bondType == -1) {
            return;
        }
        if (connectionPoint == null) {
            throw new RuntimeException("No connection point for " + part + " in " + this);
        }
        Molecule m = this.getParentMol();
        if (part.is("hydrogen") && this.is("phosphonate")) {
            m.removeAtom(radical);
            return;
        }
        this.removeEsterificationPoint(connectionPoint);
        if (bondType == 2 && connectionPoint.getAtno() == 6) {
            if (UtilLegacy.isNitrogen(radical) && connectionPoint.getCharge() > 0) {
                bondType = 1;
            } else {
                this.hydrogenize(connectionPoint, 2);
            }
        }
        if (bondType == 0) {
            if (UtilLegacy.isRingAtom(connectionPoint)) {
                bondType = 1;
            } else {
                if (connectionPoint.getAtno() != radical.getAtno()) {
                    throw new RuntimeException("Heterogeneous merge");
                }
                radical.putProperty("merged", Boolean.TRUE);
                this.mergeAtoms(connectionPoint, radical);
                return;
            }
        }
        if (part.is("hydrogen") && this.is("phosphite")) {
            m.removeAtom(radical);
            connectionPoint.getBond(0).setType(2);
            connectionPoint.setCharge(0);
            return;
        }
        if (radical.getAtno() == 1 && radical.getCharge() == 1) {
            m.removeAtom(radical);
            connectionPoint.setCharge(0);
            return;
        }
        if (this.merge(radical, connectionPoint)) {
            this.mergeAtoms(connectionPoint, radical);
            radical.setCharge(0);
            return;
        }
        this.addSimpleBond(m, connectionPoint, radical, bondType);
    }

    private boolean merge(MolAtom radical, MolAtom connectionPoint) {
        if (!"esterified".equals(Str.getLocant(radical)) && !Str.hasKeyword(connectionPoint, "ESTERIFIED")) {
            return false;
        }
        if (connectionPoint.getAtno() != 8) {
            return false;
        }
        if (radical.getAtno() == 8) {
            return true;
        }
        if (radical.getProperty(MERGE_WITH_O) != null) {
            return true;
        }
        return radical.getAtno() == 7 && connectionPoint.getProperty(MERGE_WITH_N) != null;
    }

    private void prepareToConnection(MolAtom a) {
        int rad;
        if (a.getCharge() == -1 && Util.getImplicitHcount(a) == 0) {
            a.setCharge(0);
        }
        if ((rad = a.getRadical()) > 0 && rad != 6 && rad != 3 && !"explicitRadical".equals(Str.getLocant(a))) {
            a.setRadical(0);
        }
        if (a.getAtno() == 7 && Str.hasKeyword(a, "ESTERIFIED") && a.getBondCount() == 1) {
            MolBond b = a.getBond(0);
            MolAtom c = b.getOtherAtom(a);
            if (b.getType() == 3 && c.getBondCount() == 2) {
                for (int i = 0; i < 2; ++i) {
                    MolBond b2;
                    if (c.getBond(i) == b || (b2 = c.getBond(i)).getType() != 1) continue;
                    b.setType(2);
                    b2.setType(2);
                }
            }
        }
    }

    public boolean isOH(MolAtom a, int atno) {
        return a.getAtno() == atno && (Util.getImplicitHcount(a) == 1 || a.getCharge() == -1);
    }

    public MolAtom getNeighbourOH(MolAtom a, int atno) {
        int i = a.getBondCount();
        while (--i >= 0) {
            MolAtom other = a.getLigand(i);
            if (!this.isOH(other, atno)) continue;
            return other;
        }
        return null;
    }

    public MolAtom getNeighbourOHorCOH(MolAtom a, int atno) {
        int i = a.getBondCount();
        while (--i >= 0) {
            MolAtom other = a.getLigand(i);
            if (this.isOH(other, atno)) {
                return other;
            }
            if ((other = this.getNeighbourOH(other, atno)) == null) continue;
            return other;
        }
        return null;
    }

    public MolAtom getOHOrNeighbourOH(MolAtom a) {
        if (this.isOH(a, 8)) {
            return a;
        }
        int i = a.getBondCount();
        while (--i >= 0) {
            MolAtom other = a.getLigand(i);
            if (!this.isOH(other, 8)) continue;
            return other;
        }
        return null;
    }

    public MolAtom getNeighbourOxo(MolAtom a) {
        int i = a.getBondCount();
        while (--i >= 0) {
            MolAtom other = a.getLigand(i);
            if (other.getAtno() != 8 || a.getBondTo(other).getType() != 2) continue;
            return other;
        }
        return null;
    }

    public void mergeAtoms(MolAtom oldAtom, MolAtom newAtom) {
        Molecule m = this.getParentMol();
        int b = oldAtom.getBondCount();
        while (--b >= 0) {
            MolBond bond = oldAtom.getBond(b);
            Util.addBond(m, new MolBond(bond.getOtherAtom(oldAtom), newAtom, bond.getFlags()));
        }
        m.removeAtom(oldAtom);
        if (this._locantMap != null) {
            for (String loc : this._locantMap.keySet()) {
                if (this._locantMap.get(loc) != oldAtom) continue;
                this.registerLocant(newAtom, loc);
            }
        }
    }

    boolean hydrogenize(MolAtom a, int count) {
        if (count == 2 && Util.getImplicitHcount(a) >= count) {
            return false;
        }
        if (a.getBondCount() == 1) {
            return false;
        }
        boolean doneSomething = false;
        int b = a.getBondCount();
        while (--b >= 0) {
            MolBond bond = a.getBond(b);
            if (bond.getOtherAtom(a).getBondCount() == 1 || bond.getType() != 4 && bond.getType() != 2) continue;
            bond.setType(1);
            doneSomething = true;
        }
        return doneSomething;
    }

    private MolAtom[] getConnectionPoint(LocantList locant, boolean spaceSeparated, boolean mono) {
        if (locant == null || locant.getLocantsList() == null) {
            MolAtom a;
            if (spaceSeparated && (a = this.getEsterificationPoint()) != null) {
                MolAtom b;
                this.removeEsterificationPoint(a);
                if (!mono && (b = this.duplicateEsterConnection(a)) != null) {
                    this.removeEsterificationPoint(b);
                    return new MolAtom[]{a, b};
                }
                return new MolAtom[]{a};
            }
            a = this.getDefaultConnectionPoint();
            if (!this.canSubstitute(a, false)) {
                a = this.getSomeConnectionPoint();
            }
            if (a != null) {
                return new MolAtom[]{a};
            }
            return null;
        }
        return this.getAllAtoms(locant);
    }

    boolean canSubstitute(MolAtom a, boolean prospective) {
        if (a == null) {
            return false;
        }
        if (prospective && (Str.hasKeyword(a, "ester") || Str.hasKeyword(a, "defEster") || Str.hasKeyword(a, "ESTERIFIED"))) {
            return false;
        }
        if (a.containsPropertyKey("noCon")) {
            return false;
        }
        if (a.getValence() < Chem.maxValence(a.getAtno())) {
            return true;
        }
        return Util.getImplicitHcount(a) != 0;
    }

    protected MolAtom duplicateEsterConnection(MolAtom ester1) {
        if (this.spaceSeparatedSubstituents().size() != 1) {
            return null;
        }
        if (this.name.endsWith("glycol")) {
            return null;
        }
        if (this.is("sulfate")) {
            return null;
        }
        MolAtom[] esters = this.getParentEsterificationPoints();
        if (esters.length != 1) {
            return null;
        }
        MolAtom ester2 = esters[0];
        if (ester1.getAtno() != ester2.getAtno()) {
            return null;
        }
        return ester2;
    }

    private ArrayList<Str> spaceSeparatedSubstituents() {
        ArrayList<Str> res = new ArrayList<Str>();
        if (this.substituents == null) {
            return res;
        }
        for (Str s : this.substituents) {
            if (!s.spaceSeparated) continue;
            res.add(s);
        }
        return res;
    }

    private MolAtom getSomeConnectionPoint() {
        List<MolAtom> candidates = this.getPossibleConnectionPoints();
        if (Str.allEquivalent(this.getParentMol(), candidates)) {
            return candidates.get(0);
        }
        return null;
    }

    static boolean allEquivalent(Molecule m, List<MolAtom> atoms) {
        if (atoms.size() == 0) {
            return false;
        }
        if (atoms.size() == 1) {
            return true;
        }
        int[] grinv = Util.getGraphInvariants(m);
        int uniqueInv = -1;
        for (MolAtom a : atoms) {
            int inv = grinv[m.indexOf(a)];
            if (uniqueInv == -1) {
                uniqueInv = inv;
                continue;
            }
            if (inv == uniqueInv) continue;
            return false;
        }
        return true;
    }

    private List<MolAtom> getPossibleConnectionPoints() {
        ArrayList<MolAtom> res = new ArrayList<MolAtom>();
        for (MolAtom a : this.parentAtoms()) {
            if (!this.canSubstitute(a, true)) continue;
            res.add(a);
        }
        return res;
    }

    private MolAtom betterConnectionPoint(MolAtom a1, MolAtom a2) {
        if (a2 == null) {
            return a1;
        }
        if (a1 == null) {
            return a2;
        }
        if (Util.getImplicitHcount(a1) > Util.getImplicitHcount(a2)) {
            return a1;
        }
        return a2;
    }

    MolAtom[] getAllAtoms(LocantList locants, int desiredNumber) {
        if (locants != null && locants.hasLocant()) {
            return this.getAllAtoms(locants);
        }
        if (desiredNumber == this.getParentMol().getAtomCount()) {
            return this.getParentMol().getAtomArray();
        }
        return null;
    }

    MolAtom[] getAllAtoms(LocantList locants) {
        if (locants.is(Locant.Per)) {
            return this.getAllAtoms();
        }
        MolAtom[] res = new MolAtom[locants.getLocantsList().size()];
        int n = 0;
        for (Locant l : locants.getLocantsList()) {
            MolAtom a = this.getAtom(l);
            if (a == null) {
                throw new RuntimeException("Could not find locant " + l + " in " + this);
            }
            a.putProperty("locant", l);
            res[n++] = a;
        }
        return res;
    }

    private MolAtom getDefaultConnectionPoint() {
        MolAtom res = this.getLocantMap().get("defCon");
        if (res != null) {
            return res;
        }
        res = this.getLocantMap().get("defConA");
        if (res != null && Ambiguity.defaultLocant.allow()) {
            return res;
        }
        res = this.getLocantMap().get("def");
        if (res != null) {
            return res;
        }
        return null;
    }

    public HashMap<String, MolAtom> getLocantMap() {
        if (this._locantMap == null) {
            this._locantMap = new HashMap();
            Molecule m = this.getParentMol();
            if (m.getAtomCount() == 1) {
                this._locantMap.put("defCon", m.getAtom(0));
            }
            int i = m.getAtomCount();
            while (--i >= 0) {
                MolAtom a = m.getAtom(i);
                this.registerLocants(a);
            }
            this.addDefaultLocantsFrom(m, false);
        }
        return this._locantMap;
    }

    void registerLocants(MolAtom a) {
        String[] locants;
        String locantList = Str.getLocant(a);
        if (locantList == null) {
            if ((this.name.endsWith(" acid") || this.name.endsWith("ic")) && Util.isOHOrAnalog(a)) {
                this.setLocant(a, "ester");
                locantList = "ester";
            } else {
                return;
            }
        }
        for (String locant : locants = TextUtils.split(locantList, ',')) {
            this.registerLocant(a, locant);
        }
    }

    void registerLocant(MolAtom a, String locant) {
        this._locantMap.put(locant, a);
    }

    public void addDefaultLocantsFrom(Molecule m, boolean suffix) {
        MolAtom a;
        if (m.getAtomCount() == 1 && !suffix && Str.getLocant(a = m.getAtom(0)) == null) {
            this.setLocant(a, "def");
        }
        int nitrogenCount = 0;
        int i = m.getAtomCount();
        while (--i >= 0) {
            if (m.getAtom(i).getAtno() != 7) continue;
            ++nitrogenCount;
        }
        i = m.getAtomCount();
        while (--i >= 0) {
            MolAtom a2 = m.getAtom(i);
            String locant = Str.getLocant(a2);
            if ("ester".equals(locant)) {
                this.getLocantMap().put("ester", a2);
            }
            if (suffix && Str.hasKeyword(a2, "defaultRadical")) {
                this.getLocantMap().put("defaultRadical", a2);
            }
            if (suffix && locant != null && nitrogenCount > 1 || a2.getAtno() != 7 || !suffix && nitrogenCount != 1) continue;
            String loc = "N" + this.Nprimes;
            if (suffix) {
                this.Nprimes = this.Nprimes + "'";
            }
            this.getLocantMap().put(loc, a2);
        }
    }

    public static String getLocant(MolAtom a) {
        return a.getAliasstr();
    }

    public String[] getLocants(MolAtom a) {
        return TextUtils.split(Str.getLocant(a), ',');
    }

    public void setLocant(MolAtom a, String locant) {
        a.setAliasstr(locant);
        if (this._locantMap != null) {
            Iterator<Map.Entry<String, MolAtom>> entries = this._locantMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<String, MolAtom> entry = entries.next();
                if (entry.getValue() != a) continue;
                entries.remove();
            }
            this.registerLocants(a);
        }
    }

    public void addLocant(MolAtom a, String locant) {
        String currentLocant = Str.getLocant(a);
        if (currentLocant != null) {
            locant = currentLocant + "," + locant;
        }
        this.setLocant(a, locant);
    }

    public MolAtom[] getAtoms(LocantList l) {
        MolAtom[] res = new MolAtom[l.size()];
        int n = 0;
        for (Locant loc : l.getLocantsList()) {
            res[n++] = this.getAtom(loc);
        }
        return res;
    }

    protected MolAtom getAtom(LocantList l) {
        if (l.size() > 1) {
            throw new RuntimeException("Multiple locants unexpected");
        }
        return this.getAtom(l.getSingleLocant());
    }

    public boolean hasLocantForSubstituent(Locant l) {
        return this.hasLocant(l, true);
    }

    @Override
    public final boolean hasLocant(Locant l) {
        return this.hasLocant(l, true);
    }

    public boolean hasLocant(Locant l, boolean strictGreek) {
        return this.getAtom(l, strictGreek) != null;
    }

    public MolAtom getAtom(StereoNumber locant) {
        if (!locant.empty) {
            return this.getAtom(locant.getBasicLocant());
        }
        ArrayList<MolAtom> candidates = new ArrayList<MolAtom>();
        for (MolAtom a : this.parentAtoms()) {
            boolean canBecomeChiral = this.canBecomeChiral(a);
            if (!canBecomeChiral) continue;
            candidates.add(a);
        }
        if (candidates.size() == 0) {
            return null;
        }
        if (Str.allEquivalent(this.getParentMol(), candidates)) {
            return candidates.get(0);
        }
        return ambiguous;
    }

    private boolean canBecomeChiral(MolAtom a) {
        int index;
        Molecule m = this.getMol();
        return m.getChirality(index = m.indexOf(a)) == 3;
    }

    public final MolAtom getAtom(Locant l) {
        return this.getAtom(l, false);
    }

    public MolAtom getAtom(Locant l, boolean strictGreek) {
        AtomLocant al;
        MolAtom res = this.getAtomInCore(l);
        if (res != null) {
            return res;
        }
        if (this.suffixes != null) {
            for (Suffix s : this.suffixes) {
                res = s.getLocantFromParent(l);
                if (res == null) continue;
                return res;
            }
        }
        if (l instanceof AtomLocant && ((AtomLocant)l).getLocantIndex() > 0) {
            al = (AtomLocant)l;
            al.atomUnmatched = false;
            SimpleLocant base = new SimpleLocant(al.getLocantIndex(), al.getParent());
            res = this.getAtom(base);
            if (res != null) {
                if (res.getAtno() == al.getAtno()) {
                    return res;
                }
                for (MolAtom a : res.getLigands()) {
                    if (a.getAtno() != al.getAtno() || Util.getImplicitHcount(a) <= 0) continue;
                    return a;
                }
                al.atomUnmatched = true;
                return res;
            }
        }
        if (l instanceof AtomLocant && l.getParent() == 0 && ((AtomLocant)l).getLocantIndex() <= 0) {
            al = (AtomLocant)l;
            ArrayList<MolAtom> candidates = new ArrayList<MolAtom>();
            for (MolAtom a : this.parentAtoms()) {
                if (a.getAtno() != al.getAtno() || !this.canSubstitute(a, false)) continue;
                candidates.add(a);
            }
            if (Str.allEquivalent(this.getParentMol(), candidates)) {
                res = candidates.get(0);
                if (res.getAtno() == 16 && res.getBondCount() == 1 && res.getBond(0).getType() == 2) {
                    MolBond b1 = res.getBond(0);
                    MolAtom root = res.getLigand(0);
                    for (MolAtom other : root.getLigands()) {
                        MolBond b2;
                        int atno = other.getAtno();
                        if (atno != 8 || (b2 = root.getBondTo(other)).getType() != 1) continue;
                        b1.setType(1);
                        b2.setType(2);
                        if (other.getCharge() == -1) {
                            other.setCharge(0);
                        }
                        return res;
                    }
                }
                return res;
            }
        }
        if ((res = this.getAtomGreek(l, strictGreek)) != null) {
            return res;
        }
        if (this.parent != null && (res = this.parent.getAtomGreek(l, strictGreek)) != null) {
            return res;
        }
        return null;
    }

    private MolAtom getAtomGreek(Locant l, boolean strict) {
        if (l == null || !l.isGreekLetter()) {
            return null;
        }
        if (strict && this.isCyclic()) {
            return null;
        }
        SimpleLocant asNumber = new SimpleLocant(UtilLegacy.greekLetterToNumbering(l.getValue()));
        if (this.shiftGreekLocants()) {
            asNumber.setValue(asNumber.getValue() + 1);
        }
        return this.getAtom(asNumber);
    }

    boolean shiftGreekLocants() {
        if (this.isCyclic()) {
            return this.is("piperidine") || this.is("pyridine");
        }
        if (this.isAcid()) {
            return true;
        }
        if (this.getSuffix("oyl") != null || this.getSuffix("nitrile") != null || this.hasSuffixName("aldehyde") || this.hasSuffixName("al")) {
            return true;
        }
        MolAtom one = this.getAtom(Locant.One);
        return one != null && Util.getImplicitHcount(one) == 0;
    }

    public MolAtom getAtomInCore(Locant l) {
        if (l != null) {
            return l.getAtom(this);
        }
        MolAtom res = this.getLocantMap().get("defaultRadical");
        if (res != null) {
            return res;
        }
        res = this.getLocantMap().get("1");
        if (res != null) {
            return res;
        }
        return null;
    }

    private void setRadical(MolAtom radical, int bondType) {
        this.getParentMol().properties().setObject("radicalAtom", radical);
        this.getParentMol().properties().setObject("radicalBond", bondType);
    }

    public void setRadical() {
        Suffix ylene;
        Molecule m = this.getMol();
        if (Str.getRadical(m) != null) {
            return;
        }
        if (this.radical != null) {
            m.properties().setObject("radicalBond", this.radical.getRadical());
            if (this.radical.hasLocant()) {
                MolAtom radicalAtom = this.getAtom(this.radical.getLocant());
                m.properties().setObject("radicalAtom", radicalAtom);
                return;
            }
        }
        if ((ylene = this.getSuffix("ylene")) != null) {
            if (this.parent == null) {
                throw new RuntimeException("Ethylene and such not yet implemented");
            }
            m.properties().setObject("radicalBond", 2);
            if (ylene.hasLocant()) {
                m.properties().setObject("radicalAtom", this.getAtom(ylene.getLocant()));
                return;
            }
        }
        if (this.locantsBefore != null && this.locantsBefore.hasLocant()) {
            m.properties().setObject("radicalAtom", this.getAtom(this.locantsBefore));
            if (m.properties().getObject("radicalBond") == null) {
                m.properties().setObject("radicalBond", 1);
            }
            return;
        }
        MolAtom a = this.getLocantMap().get("defaultRadical");
        if (a == null) {
            a = this.getLocantMap().get("def");
        }
        if (a == null) {
            a = this.getAtom(Locant.One);
        }
        if (a == null) {
            a = this.getLocantMap().get("defCon");
        }
        m.properties().setObject("radicalAtom", a);
        if (m.properties().getObject("radicalBond") == null) {
            int value;
            if (a != null && a.getRadical() == 6) {
                value = 2;
                a.setRadical(0);
                a.setValenceProp(-1);
            } else if (a != null && a.getRadical() == 3) {
                value = 3;
                a.setRadical(0);
                a.setValenceProp(-1);
            } else {
                value = 1;
            }
            m.properties().setObject("radicalBond", value);
        }
    }

    public void setRadicalBond(int type) {
        Molecule m = this.getMol();
        m.properties().setObject("radicalBond", type);
    }

    private void connect(Molecule part) {
        this.getMol().fuse(part);
    }

    public void replaceKeyword(MolAtom a, String key, String newKey) {
        String loc = Str.getLocant(a);
        if (loc == null || !loc.contains(key)) {
            return;
        }
        this.setLocant(a, Str.getLocant(a).replace(key, newKey));
        this._locantMap = null;
    }

    public static boolean hasKeyword(MolAtom a, String key) {
        if (a == null) {
            return false;
        }
        String locant = Str.getLocant(a);
        if (locant == null) {
            return false;
        }
        return locant.contains(key);
    }

    public String toStringWithStructure() {
        String repr;
        if (this._mol == null) {
            repr = "[]";
        } else {
            try {
                repr = this._mol.toFormat("cxsmiles");
            }
            catch (Exception e) {
                repr = "[exn]";
            }
        }
        return super.toString() + " " + repr;
    }

    public boolean isAcetate() {
        return this.getName().endsWith("ate");
    }

    public Str getParent() {
        return this.parent;
    }

    public void setParent(Str parent) {
        this.parent = parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public LocantList getLocantInParent() {
        return this.locantInParent;
    }

    public int hydroCount() {
        return this.getHydros().size();
    }

    public List<Hydro> getHydros() {
        return this.modifiers.getAll(Hydro.class);
    }

    public void removeLocant(int i) {
        this.locantInParent.removeLocant(i);
    }

    public boolean isSeparate() {
        return false;
    }

    public boolean isSeparateFragment() {
        return this.is("nitrate") || this.is("hemihydrate") || this.is("perchlorate");
    }

    protected void changeAtom(MolAtom atom, int atno) {
        atom.setAtno(atno);
        atom.setImplicitHcount(0);
    }

    protected void changeAtom(MolAtom atom, HeteroAtomStr into) {
        this.changeAtom(atom, into.getAtno());
        if (into.getCharge() != 0) {
            atom.setCharge(into.getCharge());
        }
    }

    public boolean consumeAtom(Str atom, boolean lonely) {
        Suffix ol;
        String a = atom.getValue();
        if (a.length() != 1) {
            return false;
        }
        if (lonely && (ol = this.getSuffix("ol")) != null) {
            ol.setName(atom.getName() + "ol");
            ol.setValue(a);
            return true;
        }
        return false;
    }

    public boolean consume(LocantList locants, int mul) {
        return false;
    }

    public boolean isModified() {
        return this.substituents != null || this.suffixes != null;
    }

    public boolean isSimpleEther() {
        return false;
    }

    public MolBond getSingleDoubleBond() {
        MolBond res = null;
        for (MolBond b : this.getParentMol().getBondArray()) {
            if (b.getType() != 2) continue;
            if (res == null) {
                res = b;
                continue;
            }
            return null;
        }
        return res;
    }

    int getConnectionCount() {
        int res = 0;
        if (this.suffixes != null) {
            res += this.suffixes.size();
        }
        if (this.substituents != null) {
            for (Str s : this.substituents) {
                res += s.multiplicity;
            }
        }
        return res;
    }

    public void attachData(Molecule res, MolAtom a, String key, String value) {
        DataSgroup data = new DataSgroup(res);
        data.add(a);
        data.setFieldName(key);
        data.setData(value);
        res.addSgroup(data, false);
    }

    public void attachData(Molecule res, MolAtom a, String key, int value) {
        DataSgroup data = new DataSgroup(res);
        data.add(a);
        data.setFieldName(key);
        data.setData("" + value);
        res.addSgroup(data, false);
    }

    int getDefaultStereo() {
        return 0;
    }

    public boolean isMultipliedStructure() {
        return this.endsWith("bis");
    }
}

