/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.SimpleLocant;
import chemaxon.naming.n2s.lex.data.StereoNumber;
import chemaxon.naming.n2s.lex.data.StructureToken;
import chemaxon.naming.n2s.parse.SaltEnding;
import chemaxon.naming.n2s.parse.Suffix;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class Sugar
extends StructureToken {
    final Kind kind;
    Locant alphaBeta = null;
    StereoNumber dl = null;

    public Sugar(String name, String struc) {
        this(name, struc, name.contains("pyranos") ? Kind.Pyranose : Kind.Furanose);
    }

    public Sugar(String name, String struc, Kind kind) {
        super(name, struc);
        this.kind = kind;
        this.defaultStereo = 4;
    }

    @Override
    public Molecule createParentMolecule() {
        Molecule res = super.createParentMolecule();
        for (MolAtom a : res.getAtomArray()) {
            if (this.kind == Kind.KetoFuranose && Sugar.hasKeyword(a, this.kind.specialLocant.toString())) {
                this.addLocant(a, "defaultRadical");
            }
            if (a.getAtno() != 8 || a.getBondCount() != 1) continue;
            MolAtom C = a.getLigand(0);
            if (Sugar.hasKeyword(C, this.kind.specialLocant.toString())) {
                this.addLocant(a, "defCon");
                this.addLocant(a, "defEster");
                continue;
            }
            this.addLocant(a, "ester");
        }
        return res;
    }

    @Override
    public boolean consume(LocantList locants, int mul) {
        if (mul != -1) {
            return false;
        }
        return this.consumeAlphaBeta(locants) || this.consumeDL(locants);
    }

    private boolean consumeAlphaBeta(LocantList locants) {
        if (this.alphaBeta != null) {
            return false;
        }
        if (locants.size() != 1) {
            return false;
        }
        Locant l = locants.getLocant(0);
        if (!l.isGreekLetter()) {
            return false;
        }
        if (l.getValue() != Integer.MAX_VALUE && l.getValue() != 0x7FFFFFFE) {
            this.alphaBeta = l;
        }
        return true;
    }

    private boolean consumeDL(LocantList locants) {
        if (this.dl != null) {
            return false;
        }
        if (locants.size() != 1) {
            return false;
        }
        Locant l = locants.getLocant(0);
        if (!(l instanceof StereoNumber)) {
            return false;
        }
        StereoNumber stereo = (StereoNumber)l;
        if (!stereo.isDLconfiguration()) {
            return false;
        }
        this.dl = stereo;
        this.addStereo(locants);
        return true;
    }

    @Override
    public void generate() {
        Suffix ide;
        if (this.alphaBeta == Locant.Beta) {
            int index = this.getMol().indexOf(this.getAtom(this.kind.specialLocant));
            this.getMol().setChirality(index, Chem.reverseChirality(this.getMol().getChirality(index)));
        }
        if ((ide = this.getSuffix("ide")) instanceof SaltEnding && ((SaltEnding)ide).hasHydro()) {
            ide = null;
        }
        if (ide == null && this.isSubstituent()) {
            this.removeSpecialOxy();
        }
        if (ide != null) {
            MolAtom defEster;
            if (ide instanceof SaltEnding) {
                MolAtom OH = this.getSpecialO();
                this.changeAtom(OH, ((SaltEnding)ide).getMolAtom().getAtno());
                this.setLocant(OH, null);
                this.removeSuffixName("yl");
            }
            if ((defEster = this.getLocantMap().get("defEster")) != null) {
                defEster.putProperty("mergeWithN", Boolean.TRUE);
            }
            this.suffixes.remove(ide);
        }
        super.generate();
    }

    private void removeSpecialOxy() {
        this.getParentMol().removeAtom(this.getSpecialO());
    }

    private MolAtom getSpecialO() {
        return this.getNeighbourOH(this.getAtom(this.kind.specialLocant), 8);
    }

    @Override
    public boolean isEsterParent() {
        return true;
    }

    static enum Kind {
        Pyranose(1),
        Furanose(1),
        KetoFuranose(2),
        KetoPyranose(2);

        final Locant specialLocant;

        private Kind(int specialLocant) {
            this.specialLocant = new SimpleLocant(specialLocant);
        }
    }
}

