/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lexer;

import chemaxon.naming.n2s.lexer.SavingReader;
import chemaxon.naming.n2s.lexer.Token;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class Lexer {
    private Token terminal;
    private Lexer[] transition = new Lexer[128];
    public static boolean dbg = false;

    public Lexer addToken(Token t) {
        String name = t.getName();
        if (name.length() == 0) {
            throw new IllegalArgumentException("Trying to add token with zero-length name, that would cause infinite lexings: " + t);
        }
        return this.addToken(name, t);
    }

    private Lexer addToken(String name, Token t) {
        if (name.length() == 0) {
            if (this.terminal != null) {
                throw new RuntimeException("Identical tokens: " + this.terminal + " and " + t);
            }
            this.terminal = t;
            return this;
        }
        char first = name.charAt(0);
        if (this.transition[first] == null) {
            this.transition[first] = new Lexer();
        }
        this.transition[first] = this.transition[first].addToken(name.substring(1), t);
        return this;
    }

    public State lex(Reader in) throws IOException {
        State s = new State(this, in);
        s = this.lex(s);
        if (dbg) {
            System.out.println("FINAL: " + s);
        }
        return s;
    }

    private State lex(State s) throws IOException {
        Lexer next;
        State stateContinued;
        int c;
        if (dbg) {
            System.out.println("=>:" + s);
        }
        boolean eof = (c = (stateContinued = s.clone()).read()) == -1;
        Lexer lexer = next = eof || c > this.transition.length ? null : this.transition[c];
        if (next != null) {
            stateContinued = super.lex(stateContinued);
        }
        if (this.terminal != null && this.terminal.acceptableBefore(c)) {
            s.lexed(this.terminal);
            if (dbg) {
                System.out.println("$$:" + s);
            }
            if (!eof) {
                s = s.completeLexer.lex(s);
            }
        }
        if (dbg) {
            System.out.println(stateContinued + " <> " + s);
        }
        if (s.textLength() != stateContinued.textLength()) {
            if (stateContinued.textLength() > s.textLength()) {
                return stateContinued;
            }
            return s;
        }
        int i = stateContinued.tokens.size();
        int j = s.tokens.size();
        while (--i >= 0 & --j >= 0) {
            if (s.tokens.get(j).getName().length() == stateContinued.tokens.get(i).getName().length()) continue;
            if (s.tokens.get(j).getName().length() < stateContinued.tokens.get(i).getName().length()) {
                return stateContinued;
            }
            return s;
        }
        return s;
    }

    public static class State
    implements Cloneable {
        private final Lexer completeLexer;
        SavingReader in;
        int pos;
        int understood;
        StringBuilder text;
        StringBuilder correctedText;
        List<Token> tokens = new ArrayList<Token>();
        private boolean doneSomething;

        State(Lexer completeLexer, Reader in) {
            this.completeLexer = completeLexer;
            this.in = new SavingReader(in);
        }

        public void lexed(Token t) {
            this.tokens.add(t);
            this.understood = this.in.getSourcePosition(this.pos);
        }

        public int textLength() {
            return this.understood;
        }

        int read() throws IOException {
            int res = this.in.read(this.pos);
            if (res != -1) {
                ++this.pos;
            }
            return res;
        }

        void unread() {
            --this.pos;
        }

        public State clone() {
            try {
                State res = (State)super.clone();
                res.tokens = new ArrayList<Token>(res.tokens);
                return res;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean doneSomething() {
            boolean res = this.doneSomething;
            this.doneSomething = false;
            return res;
        }

        public String getLexedText() {
            return this.in.substring(0, this.understood);
        }

        public String trailingText() {
            return this.in.trailingText(this.understood);
        }

        public List<Token> getTokens() {
            return this.tokens;
        }

        public String toString() {
            return this.in.substring(0, this.understood) + "$" + this.in.substring(this.understood, this.pos) + "^" + this.in.substring(this.pos) + " " + this.tokens.toString();
        }
    }
}

