/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lexer;

import chemaxon.common.util.IntVector;
import chemaxon.naming.n2s.lexer.CharacterExpander;
import java.io.IOException;
import java.io.Reader;

public class SavingReader {
    Reader source;
    StringBuilder read = new StringBuilder();
    private int position = 0;
    private IntVector positions = new IntVector();

    public SavingReader(Reader r) {
        this.source = r;
    }

    public String readText() {
        return this.read.toString();
    }

    public String trailingText(int pos) {
        if (pos >= this.read.length()) {
            return "";
        }
        return this.read.substring(pos);
    }

    public String substring(int start) {
        return this.substring(start, this.read.length());
    }

    public String substring(int start, int end) {
        return this.read.substring(start, end);
    }

    public int getSourcePosition(int pos) {
        return this.positions.get(pos - 1);
    }

    public int read(int pos) throws IOException {
        if (pos < this.read.length()) {
            return this.read.charAt(pos);
        }
        int res = this.source.read();
        if (res == -1) {
            return -1;
        }
        ++this.position;
        String expanded = CharacterExpander.expand((char)res);
        if (expanded == null) {
            this.read.append((char)res);
            this.positions.add(this.position);
            return res;
        }
        this.read.append(expanded);
        int i = expanded.length();
        while (--i >= 0) {
            this.positions.add(this.position);
        }
        return expanded.charAt(0);
    }
}

