/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.parse.Suffix;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

public class Acetal
extends Suffix {
    private int mul;
    private Str str;

    public Acetal(int mul, Str str) {
        super("acetal");
        this.mul = mul;
        this.str = str;
    }

    @Override
    public boolean connect(Str parent) {
        Molecule m = parent.getParentMol();
        List<MolAtom> oxos = this.getOxos(m);
        if (oxos.size() * 2 != this.mul) {
            throw new RuntimeException("acetal mul=" + this.mul + ", oxos=" + oxos.size());
        }
        for (MolAtom o : oxos) {
            assert (o.getBondCount() == 1);
            MolBond b = o.getBond(0);
            assert (b.getType() == 2);
            b.setType(1);
            MolAtom root = b.getOtherAtom(o);
            MolAtom o2 = new MolAtom(8);
            m.add(o2);
            m.add(new MolBond(root, o2, 1));
            parent.connect(this.str.clone(), o);
            parent.connect(this.str.clone(), o2);
        }
        return false;
    }

    private List<MolAtom> getOxos(Molecule m) {
        ArrayList<MolAtom> os = new ArrayList<MolAtom>();
        for (MolAtom a : m.getAtomArray()) {
            if (a.getAtno() != 8 || a.getBondCount() != 1 || a.getBond(0).getType() != 2) continue;
            os.add(a);
        }
        return os;
    }
}

