/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.naming.n2s.Util;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.RatioToken;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.Token;
import chemaxon.naming.n2s.parse.RevolutionParser;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.List;

public class Compound
extends Str {
    Str s1;
    Str s2;
    int ratio1;
    int ratio2;

    public static Str parseRatio(List<Token> tokens, boolean dataMining) {
        for (int i = 0; i < tokens.size(); ++i) {
            Str s2;
            int endS1;
            int startS2;
            int endS2;
            if (!(tokens.get(i) instanceof RatioToken)) continue;
            RatioToken r = (RatioToken)tokens.get(i);
            if (i == tokens.size() - 1) {
                while (Compound.separator(tokens.get(--i))) {
                }
                endS2 = i + 1;
                int ratioSeparator = Compound.findRatioSeparator(tokens, i - 1);
                startS2 = ratioSeparator + 1;
                endS1 = ratioSeparator;
            } else {
                endS1 = i;
                startS2 = i + 1;
                endS2 = tokens.size();
            }
            int startS1 = 0;
            while (tokens.get(startS1).getName().equals(" ")) {
                ++startS1;
            }
            while (tokens.get(endS1 - 1).getName().equals(" ")) {
                --endS1;
            }
            while (tokens.get(startS2).getName().equals(" ")) {
                ++startS2;
            }
            Str s1 = new RevolutionParser().parse(new ArrayList<Token>(tokens.subList(startS1, endS1)), dataMining);
            if (Compound.connected(s1, s2 = new RevolutionParser().parse(new ArrayList<Token>(tokens.subList(startS2, endS2)), dataMining)) && r.ratio2 == 1) {
                s2.spaceSeparated = true;
                int n = r.ratio1;
                while (--n >= 0) {
                    s1.addSubstituent(null, s2.cloneMe());
                }
                return s1;
            }
            return new Compound(s1, s2, r.ratio2, r.ratio1);
        }
        return null;
    }

    private static boolean separator(Token token) {
        return token.is(" ");
    }

    private static boolean connected(Str s1, Str s2) {
        if (s1.is("bor") && s2.isAmine()) {
            return true;
        }
        if (!s1.isAcid()) {
            return false;
        }
        return s2.isAlcohol();
    }

    private static int findRatioSeparator(List<Token> tokens, int end) {
        int i = end;
        while (i > 0 && !tokens.get(--i).is("/")) {
        }
        if (i > 0) {
            return i;
        }
        i = end + 1;
        while (!Compound.separator(tokens.get(--i))) {
        }
        return i;
    }

    Compound(Str s1, Str s2, int ratio1, int ratio2) {
        this.name = "compound";
        this.s1 = s1;
        this.s2 = s2;
        this.ratio1 = ratio1;
        this.ratio2 = ratio2;
    }

    @Override
    public Molecule createParentMolecule() {
        Molecule res = Util.newMolecule();
        Molecule m1 = this.s1.getCompleteStructure();
        Molecule m2 = this.s2.getCompleteStructure();
        int r1 = this.ratio1 == -1 ? 1 : this.ratio1;
        for (int i = 0; i < r1; ++i) {
            res.fuse(m1.cloneMolecule());
        }
        int r2 = this.ratio2 == -1 ? 1 : this.ratio2;
        for (int i = 0; i < r2; ++i) {
            res.fuse(m2.cloneMolecule());
        }
        return res;
    }

    @Override
    public boolean hasLocant(Locant loc, boolean strictGreek) {
        return false;
    }

    @Override
    public Str cloneMe() {
        return this;
    }
}

