/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.marvin.io.formats.name.nameexport.NamingCentral;
import chemaxon.naming.n2s.NameImportException;
import chemaxon.naming.n2s.Util;
import chemaxon.naming.n2s.UtilLegacy;
import chemaxon.naming.n2s.lex.data.FusedLocant;
import chemaxon.naming.n2s.lex.data.Hydro;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.SimpleLocant;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.StructureToken;
import chemaxon.naming.n2s.parse.VonBaeyerStr;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class FusedStr
extends Str {
    Str leftStructure;
    Str rightStructure;
    LocantList numbering;
    Molecule leftMolecule;
    LocantList tmpLocants;
    private static final boolean dbg = false;

    public FusedStr(Str leftStructure, Str rigthStructure, LocantList numbering) {
        if (leftStructure instanceof FusedStr) {
            throw new RuntimeException("Complex Fused");
        }
        this.name = "FusedStr";
        this.leftStructure = leftStructure;
        this.rightStructure = rigthStructure;
        this.numbering = numbering;
        this.leftStructure.setParent(this);
        this.rightStructure.setParent(this);
    }

    @Override
    public boolean isCyclic() {
        return true;
    }

    private LocantList cloneList(LocantList orig) {
        LocantList clone = new LocantList();
        for (int i = 0; i < orig.size(); ++i) {
            FusedLocant fused = (FusedLocant)orig.getLocant(i);
            clone.addLocant(new FusedLocant(fused.getFirst(), fused.getSecond(), fused.getValue()));
        }
        return clone;
    }

    @Override
    public Molecule createParentMolecule() {
        this.getSubstructureHydrogens(this.leftStructure);
        this.getSubstructureSubstituents(this.leftStructure);
        if (this.leftMolecule == null) {
            this.leftMolecule = this.leftStructure.getMolPublic();
        }
        Molecule rightMolecule = this.rightStructure.getMolPublic();
        Molecule molecule = Util.newMolecule();
        molecule.fuse(rightMolecule);
        for (int i = 0; i < this.numbering.size(); ++i) {
            this.fuseAtoms(molecule, (FusedLocant)this.numbering.getLocant(i));
        }
        FusedStr.clearNumbering(molecule);
        int[] numbering = NamingCentral.getNumbering(molecule, true);
        this.setAtomMap(molecule, numbering);
        if (this.stereoDataNeedToAdd(this.leftStructure)) {
            this.addDefaultStereoData(this.leftMolecule);
        }
        return molecule;
    }

    @Override
    public LocantList getLocantInParent() {
        if (this.locantInParent != null && this.locantInParent.size() > 1) {
            this.tmpLocants = this.locantInParent;
            this.locantInParent = new LocantList();
        }
        return super.getLocantInParent();
    }

    private void getFusedAtoms(char bondindex, Str struc, MolAtom[] res) {
        int index = bondindex - 97;
        ArrayList<Locant> atomLocants = this.getRelevantLocants(struc);
        int secondAtomIndex = index < atomLocants.size() - 1 ? index + 1 : 0;
        res[2] = this.rightStructure.getAtom(atomLocants.get(index));
        res[3] = this.rightStructure.getAtom(atomLocants.get(secondAtomIndex));
    }

    private ArrayList<Locant> getRelevantLocants(Str struc) {
        ArrayList<Locant> locants = new ArrayList<Locant>();
        for (MolAtom a : struc.getParentMol().getAtomArray()) {
            String loc = FusedStr.getLocant(a);
            if (loc.contains(",")) {
                loc = loc.substring(0, loc.indexOf(44));
            }
            locants.add(StructureToken.parseLocant(loc));
        }
        LocantList.sort(locants);
        return locants;
    }

    private void fuseAtoms(Molecule molecule, FusedLocant l) {
        Str left = this.leftStructure.clone();
        MolAtom[] fusionAtoms = this.getFusedAtoms(l, left);
        FusedStr.fuseCleared(molecule, left.getParentMol());
        if (!fusionAtoms[2].isBoundTo(fusionAtoms[3])) {
            throw new NameImportException("Invalid fused numbering: " + this.numbering);
        }
        molecule.removeBond(fusionAtoms[2].getBondTo(fusionAtoms[3]));
        Util.mergeAtoms(molecule, fusionAtoms[0], fusionAtoms[2]);
        Util.mergeAtoms(molecule, fusionAtoms[1], fusionAtoms[3]);
    }

    private MolAtom[] getFusedAtoms(FusedLocant numbering, Str left) {
        MolAtom[] res = new MolAtom[4];
        res[0] = left.getAtom(new SimpleLocant(numbering.getFirst()));
        res[1] = left.getAtom(new SimpleLocant(numbering.getSecond()));
        this.getFusedAtoms((char)numbering.getValue(), this.rightStructure, res);
        return res;
    }

    private void setAtomMap(Molecule m, int[] numbering) {
        if (numbering == null) {
            return;
        }
        for (int i = 0; i < numbering.length; ++i) {
            this.setLocant(m.getAtom(i), chemaxon.marvin.io.formats.name.nameexport.Util.locant(numbering[i]));
        }
    }

    private int getLocant(int number) {
        if (number > 100) {
            int letter = number / 100 % 10;
            int index = number / 10000;
            if (letter == 0) {
                index /= 100;
            }
            return index + letter;
        }
        return number;
    }

    private void getSubstructureHydrogens(Str substruc) {
        for (Hydro hydro : substruc.getHydros()) {
            this.addHydro(hydro);
        }
    }

    private void getSubstructureSubstituents(Str substruc) {
        boolean useLocant = false;
        for (int i = 0; i < substruc.substituentCount(); ++i) {
            Str ligand = substruc.substituents.get(i);
            if (UtilLegacy.isHetero(ligand)) continue;
            this.addSubstituent(ligand);
            ligand.setParent(this);
            substruc.removeSubstituent(i);
            if (ligand.getLocantInParent() == null) {
                if (this.tmpLocants != null && this.tmpLocants.size() > 0) {
                    ligand.setLocantInParent(this.tmpLocants.getLocant(0));
                    this.tmpLocants.removeLocant(0);
                    useLocant = true;
                } else if (this.getLocantInParent() != null && !useLocant) {
                    ligand.setLocantInParent(this.getLocantInParent().getLocant(0));
                    this.removeLocant(0);
                }
            }
            --i;
        }
    }

    private boolean needToDeleteHydrogens(Str struc) {
        return struc.is("inden") || struc.is("pyrazol");
    }

    private boolean stereoDataNeedToAdd(Str struc) {
        if (!(struc instanceof VonBaeyerStr)) {
            return false;
        }
        if (!((VonBaeyerStr)struc).aromatic) {
            return false;
        }
        int atomCount = struc.getAtomCountIfKnown();
        return (atomCount - 2) % 4 != 0;
    }

    private void addDefaultStereoData(Molecule molecule) {
        for (int i = 0; i < molecule.getBondCount(); ++i) {
            MolBond bond = molecule.getBond(i);
            if (bond.getType() != 2 || bond.calcStereo2() != 128) continue;
            MolAtom atom2 = bond.getAtom1();
            MolAtom atom3 = bond.getAtom2();
            int bondindex1 = atom2.getBond(0) == bond ? 1 : 0;
            int bondindex2 = atom3.getBond(0) == bond ? 1 : 0;
            MolAtom atom1 = atom2.getBond(bondindex1).getOtherAtom(atom2);
            MolAtom atom4 = atom3.getBond(bondindex2).getOtherAtom(atom3);
            bond.setStereo2Flags(atom1, atom4, 128);
        }
    }

    public boolean hasSubSystem(Str struc) {
        if (struc == null) {
            return false;
        }
        return struc.equals(this.leftStructure) || struc.equals(this.rightStructure);
    }

    @Override
    public Str cloneMe() {
        return this.clone();
    }

    private void dbg(String msg) {
        System.out.println(msg);
    }
}

