/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.naming.n2s.Util;
import chemaxon.naming.n2s.UtilLegacy;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.SpecialLocant;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.parse.HeteroAtomStr;
import chemaxon.naming.n2s.parse.RevolutionParser;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.util.Misc;
import java.util.ArrayList;

public class HantzschWidmanStr
extends Str {
    private int ringSize;
    private boolean aromatic;
    private boolean oline;
    private boolean iso;
    private ArrayList<HeteroAtomStr> heteroAtoms;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HantzschWidmanStr create(LocantList locants, ArrayList<HeteroAtomStr> heteros, String ending, boolean iso) {
        Boolean aromatic;
        int ringSize;
        if (HantzschWidmanStr.is(heteros, ending, "imid", "azo", null)) {
            ringSize = 5;
            aromatic = true;
        } else {
            if (ending == null) {
                return null;
            }
            if (UtilLegacy.isName(ending, "ane")) {
                for (HeteroAtomStr h : heteros) {
                    if (Chem.isChalcogen(h.getAtno())) continue;
                    return null;
                }
            }
            if ((ringSize = HantzschWidmanStr.getRingSize(ending, heteros.get(heteros.size() - 1))) == -1) {
                return null;
            }
            aromatic = HantzschWidmanStr.isAromatic(ending);
            if (aromatic == null) {
                return null;
            }
        }
        if (heteros.get(0).getName().startsWith("pyr") && ringSize != 5) {
            return null;
        }
        if (locants != null) {
            if (locants.is(SpecialLocant.sym)) {
                if (ringSize == 6 && heteros.size() == 3) {
                    locants = LocantList.simpleList(1, 3, 5);
                } else if (ringSize == 6 && heteros.size() == 4) {
                    locants = LocantList.simpleList(1, 2, 4, 5);
                } else {
                    if (ringSize != 5 || heteros.size() != 3) return null;
                    locants = LocantList.simpleList(1, 2, 4);
                }
            } else if (locants.is(SpecialLocant.asym)) {
                if (ringSize != 5 && ringSize != 6 || heteros.size() != 3) return null;
                locants = LocantList.simpleList(1, 2, 4);
            } else if (locants.is(SpecialLocant.vicinal)) {
                if (ringSize != 5 && ringSize != 6 || heteros.size() != 3) return null;
                locants = LocantList.simpleList(1, 2, 3);
            } else if ((locants = locants.expandOMP(heteros.size())).size() != heteros.size()) {
                return null;
            }
        }
        HantzschWidmanStr hw = new HantzschWidmanStr(ringSize, heteros, aromatic, ending == "oline", iso);
        if (locants == null) return hw;
        hw.locantsBefore = locants;
        return hw;
    }

    private static boolean is(ArrayList<HeteroAtomStr> heteros, String ending, String ... components) {
        if (!Misc.isEqual(components[components.length - 1], ending)) {
            return false;
        }
        if (heteros.size() != components.length - 1) {
            return false;
        }
        int i = components.length - 1;
        while (--i >= 0) {
            if (components[i].equals(heteros.get(i).getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCyclic() {
        return true;
    }

    private int getDoubleBondPosition() {
        if (!this.oline) {
            return -1;
        }
        LocantList l = this.getLocantsBefore();
        if (l == null) {
            return 2;
        }
        if (l.size() != 1) {
            throw new RuntimeException("imidazoline");
        }
        Locant loc = l.removeLocant(0);
        if (loc.getValue() == 2) {
            return 2;
        }
        if (loc.getValue() == 4) {
            return 4;
        }
        throw new RuntimeException("imidazoline");
    }

    @Override
    public Molecule createParentMolecule() {
        int i;
        if (this.locantsBefore != null && this.useLocantsForSuffixes(this.locantsBefore, true)) {
            this.locantsBefore = null;
        }
        if (this.locantsBefore != null && this.locantsBefore.size() == this.heteroAtoms.size()) {
            int n = 0;
            for (Locant l : this.locantsBefore.getLocantsList()) {
                this.heteroAtoms.get(n++).setLocantInParent(l);
            }
            this.locantsBefore = null;
        } else if (this.heteroAtoms.get(0).getLocantInParent() == null) {
            LocantList locants = null;
            if (HantzschWidmanStr.is(this.heteroAtoms, null, "pyr", "az", null)) {
                locants = LocantList.simpleList(1, 2);
            } else if (this.iso) {
                locants = LocantList.simpleList(1, 2);
            }
            RevolutionParser.setLocants(this.heteroAtoms, locants, this.ringSize);
        }
        int doubleBond = this.getDoubleBondPosition();
        if (doubleBond != -1) {
            this.aromatic = false;
        }
        int bondType = this.aromatic ? 4 : 1;
        String currentN = "N";
        Molecule res = Util.newMolecule();
        for (i = 0; i < this.ringSize; ++i) {
            HeteroAtomStr hetero = this.getHeteroAt(i + 1);
            int atno = hetero == null ? 6 : hetero.getAtno();
            MolAtom a = new MolAtom(atno);
            if (hetero != null) {
                hetero.getLocantInParent().getLocant(0).applyTo(a);
            }
            this.addLocant(a, Integer.toString(i + 1));
            if (atno == 7) {
                this.addLocant(a, currentN);
                currentN = currentN + "'";
            }
            res.add(a);
            if (i == 0) {
                Util.enableDefaultHydro(a);
            }
            int bond = doubleBond == i ? 2 : bondType;
            if (i > 0) {
                res.add(new MolBond(res.getAtom(i - 1), a, bond));
            }
            if (i != this.ringSize - 1) continue;
            res.add(new MolBond(res.getAtom(0), a, bondType));
        }
        Util.valenceCheck(res);
        for (i = 0; i < this.ringSize; ++i) {
            MolAtom a = res.getAtom(i);
            if (a.getImplicitHcount() <= 0) continue;
            this.addLocant(a, "defCon");
            this.addLocant(a, "defaultRadical");
            break;
        }
        return res;
    }

    private HeteroAtomStr getHeteroAt(int locant) {
        for (HeteroAtomStr hetero : this.heteroAtoms) {
            if (hetero.getLocantInParent().getSimpleLocant().getValue() != locant) continue;
            return hetero;
        }
        return null;
    }

    private HantzschWidmanStr(int ringSize, ArrayList<HeteroAtomStr> heteroAtoms, boolean aromatic, boolean oline, boolean iso) {
        this.name = "HW";
        this.ringSize = ringSize;
        this.aromatic = aromatic;
        this.oline = oline;
        this.heteroAtoms = heteroAtoms;
        this.iso = iso;
    }

    @Override
    public Str cloneMe() {
        return this.clone();
    }

    private static int getRingSize(String ending, HeteroAtomStr h) {
        if (ending.startsWith("ir")) {
            return 3;
        }
        if (ending.startsWith("et")) {
            return 4;
        }
        if (ending.startsWith("ol")) {
            return 5;
        }
        if (ending.startsWith("ep")) {
            return 7;
        }
        if (ending.startsWith("oc")) {
            return 8;
        }
        if (ending.startsWith("on")) {
            return 9;
        }
        if (ending.startsWith("ec")) {
            return 10;
        }
        int atno = h.getAtno();
        if (UtilLegacy.isName(ending, "ane")) {
            if (Chem.getHantzschWidmanGroup(atno) != Chem.HantzschWidmanGroup.Group6A) {
                return -1;
            }
            return 6;
        }
        if (UtilLegacy.isName(ending, "inine")) {
            if (Chem.getHantzschWidmanGroup(atno) != Chem.HantzschWidmanGroup.Group6C) {
                return -1;
            }
            return 6;
        }
        if (UtilLegacy.isName(ending, "inane")) {
            Chem.HantzschWidmanGroup group = Chem.getHantzschWidmanGroup(atno);
            if (group != Chem.HantzschWidmanGroup.Group6B && group != Chem.HantzschWidmanGroup.Group6C) {
                return -1;
            }
            return 6;
        }
        if (UtilLegacy.isName(ending, "ine")) {
            Chem.HantzschWidmanGroup group = Chem.getHantzschWidmanGroup(atno);
            if (group != Chem.HantzschWidmanGroup.Group6A && group != Chem.HantzschWidmanGroup.Group6B && !h.is("phosphor")) {
                return -1;
            }
            return 6;
        }
        return -1;
    }

    private static Boolean isAromatic(String ending) {
        if (ending.endsWith("ane") || ending.endsWith("an") || ending.endsWith("idine") || ending.endsWith("idin")) {
            return false;
        }
        if (ending.endsWith("ine") || ending.endsWith("in") || UtilLegacy.isName(ending, "irene") || UtilLegacy.isName(ending, "ete") || UtilLegacy.isName(ending, "ole")) {
            return true;
        }
        if (ending == "olid") {
            return false;
        }
        return null;
    }

    @Override
    public void addSubstituent(Locant locant, Str substituent) {
        if (locant == null && substituent.is("benz")) {
            throw new RuntimeException("Unrecognized benzofused");
        }
        super.addSubstituent(locant, substituent);
    }

    @Override
    public void addDefaultLocantsFrom(Molecule m, boolean suffix) {
        if (suffix) {
            super.addDefaultLocantsFrom(m, true);
        }
    }

    @Override
    public boolean hasLocant(Locant l, boolean strictGreek) {
        if (l.isGreekLetter()) {
            return false;
        }
        int val = l.getSimpleValue();
        if (val >= 1 && val <= this.ringSize) {
            return true;
        }
        return super.hasLocant(l, strictGreek);
    }
}

