/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.naming.n2s.Util;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.Token;
import chemaxon.naming.n2s.parse.HeteroAtomStr;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class HeteroChainStr
extends Str {
    final HeteroAtomStr atom;
    final HeteroAtomStr atom2;
    final int mul;

    public HeteroChainStr(HeteroAtomStr atom, int multiplicity) {
        this(atom, null, multiplicity);
    }

    public HeteroChainStr(HeteroAtomStr atom1, HeteroAtomStr atom2, int multiplicity) {
        this.name = "HeteroChain " + atom1;
        if (atom2 != null) {
            this.name = this.name + "-" + atom2;
        }
        this.name = this.name + " \u00d7" + multiplicity;
        this.atom = atom1;
        this.atom2 = atom2;
        this.mul = multiplicity;
    }

    public boolean hasBoth() {
        return this.atom2 != null;
    }

    public int getMultiplicity() {
        return this.mul;
    }

    protected String printValue() {
        String atom2 = this.atom2 == null ? "" : " " + this.atom2;
        return "\"" + this.atom + atom2 + " " + this.mul + '\"';
    }

    public boolean checkSyntax(ArrayList<Token> tokenlist) {
        return true;
    }

    @Override
    public Str cloneMe() {
        return this.clone();
    }

    @Override
    public Molecule createParentMolecule() {
        Molecule res = Util.newMolecule();
        MolAtom prev = null;
        int locant = 1;
        if (this.atom2 == null) {
            int i = this.mul;
            while (--i >= 0) {
                MolAtom a = new MolAtom(this.atom.getAtno());
                this.setLocant(a, Integer.toString(locant++));
                res.add(a);
                if (prev != null) {
                    res.add(new MolBond(prev, a));
                }
                prev = a;
            }
        } else {
            MolAtom a2 = new MolAtom(this.atom2.getAtno());
            res.add(a2);
            this.setLocant(a2, Integer.toString(locant++));
            prev = a2;
            int i = this.mul;
            while (--i > 0) {
                MolAtom a1 = new MolAtom(this.atom.getAtno());
                res.add(a1);
                this.setLocant(a1, Integer.toString(locant++));
                if (prev != null) {
                    res.add(new MolBond(prev, a1));
                }
                a2 = new MolAtom(this.atom2.getAtno());
                res.add(a2);
                this.setLocant(a2, Integer.toString(locant++));
                res.add(new MolBond(a1, a2));
                prev = a2;
            }
        }
        return res;
    }

    public int getAtom() {
        return this.atom.getAtno();
    }

    public int getAtom2() {
        if (this.atom2 == null) {
            return -1;
        }
        return this.atom2.getAtno();
    }
}

