/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.naming.n2s.lex.data.SimpleLocant;
import chemaxon.naming.n2s.lex.data.StructureToken;
import chemaxon.naming.n2s.parse.HeteroAtomStr;

public class PhenoIneStr
extends StructureToken {
    private HeteroAtomStr atom1;
    private HeteroAtomStr atom2;
    private static final String BASICSMILES = "c1c2ccccc2cc3ccccc13 |$10;10a;1;2;3;4;4a;5;5a;6;7;8;9;9a$|";

    public static PhenoIneStr create(HeteroAtomStr atom1, HeteroAtomStr atom2) {
        if (atom2 == null) {
            return new PhenoIneStr("PhenoIneStr(" + atom1 + ")", atom1, atom1);
        }
        return new PhenoIneStr("PhenoIneStr(" + atom1 + "," + atom2 + ")", atom1, atom2);
    }

    private PhenoIneStr(String name, HeteroAtomStr atom1, HeteroAtomStr atom2) {
        super(name, BASICSMILES);
        if (atom2.getAtno() == 7 && (atom1.getAtno() == 15 || atom1.getAtno() == 33)) {
            this.atom1 = atom2;
            this.atom2 = atom1;
        } else {
            this.atom1 = atom1;
            this.atom2 = atom2;
        }
    }

    @Override
    public void generate() {
        this.changeAtom(this.getAtom(new SimpleLocant(5)), this.atom1.getAtno());
        this.changeAtom(this.getAtom(new SimpleLocant(10)), this.atom2.getAtno());
        super.generate();
    }
}

