/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.StructureToken;
import chemaxon.naming.n2s.parse.Suffix;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class PolyMethylene
extends StructureToken {
    public static Str create(String name, int num) {
        String struc = "";
        String locs = " |$loc2," + num;
        while (num-- > 0) {
            struc = struc + "C";
            if (num <= 0) continue;
            locs = locs + ";" + num;
        }
        locs = locs + ",loc1$|";
        return new PolyMethylene(name, struc + locs);
    }

    private PolyMethylene(String name, String value) {
        super(name, value);
    }

    @Override
    public boolean connect(Suffix s) {
        Molecule m;
        if (this.suffixes.size() == 1 && !s.hasLocant() && s.getMultiplicity() == 1 && (m = s.getCompleteStructure()).getAtomCount() == 1) {
            MolAtom suffixAtom = m.getAtom(0);
            if (Chem.standardValence(suffixAtom.getAtno()) == 1) {
                s.setMultiplicity(2);
            } else {
                Molecule me = this.getParentMol();
                MolAtom root1 = me.getAtom(0);
                MolAtom root2 = me.getAtom(me.getAtomCount() - 1);
                PolyMethylene.fuseCleared(me, m);
                this.addBond(root1, suffixAtom, 1, s);
                this.addBond(root2, suffixAtom, 1, s);
                return false;
            }
        }
        return super.connect(s);
    }
}

