/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.common.util.IntVector;
import chemaxon.naming.n2s.UtilLegacy;
import chemaxon.naming.n2s.lex.data.ComplexLocant;
import chemaxon.naming.n2s.lex.data.LocantList;

public class RingUtil {
    public static void appendAtom(StringBuffer strbuff, StringBuffer numbering, String str, int number) {
        strbuff.append(str);
        numbering.append(Integer.toString(number) + ";");
    }

    protected static void appendAtom(StringBuffer strbuff, IntVector atomnumbers, String str, int number) {
        strbuff.append(str);
        atomnumbers.add(number);
    }

    public static void appendBridge(StringBuffer strbuff, StringBuffer numbering, int parent1, int parent2, int len, int ringNum, String atom, int startnum) {
        StringBuffer bridge;
        int index1 = RingUtil.getIndexInString(strbuff.toString(), numbering.toString(), parent1);
        int index2 = RingUtil.getIndexInString(strbuff.toString(), numbering.toString(), parent2);
        String ringIndex = ringNum > 9 ? "%" + ringNum : "" + ringNum;
        StringBuffer numbers = new StringBuffer();
        if (len == 0) {
            bridge = new StringBuffer(ringIndex);
        } else {
            bridge = new StringBuffer("(");
            for (int i = 0; i < len; ++i) {
                RingUtil.appendAtom(bridge, numbers, atom, startnum++);
            }
            bridge.append(ringIndex).append(')');
        }
        RingUtil.insertString(strbuff, new StringBuffer(ringIndex), index2);
        RingUtil.insertString(strbuff, bridge, index1);
        RingUtil.insertString(numbering, numbers, index1);
    }

    protected static void appendBridge(StringBuffer strbuff, IntVector atomnumbers, int parent1, int parent2, int len, int ringNum, String atom, int startnum) {
        StringBuffer bridge;
        int index1 = RingUtil.getIndexInString(strbuff.toString(), atomnumbers, parent1);
        int index2 = RingUtil.getIndexInString(strbuff.toString(), atomnumbers, parent2);
        String ringIndex = ringNum > 9 ? "%" + ringNum : "" + ringNum;
        IntVector numbers = new IntVector();
        if (len == 0) {
            bridge = new StringBuffer(ringIndex);
        } else {
            bridge = new StringBuffer("(");
            for (int i = 0; i < len; ++i) {
                RingUtil.appendAtom(bridge, numbers, atom, startnum++);
            }
            bridge.append(ringIndex).append(')');
        }
        RingUtil.insertString(strbuff, new StringBuffer(ringIndex), index2);
        RingUtil.insertString(strbuff, bridge, index1);
        RingUtil.insertAtomNumbering(atomnumbers, numbers, index1);
    }

    public static void appendBridge(StringBuffer strbuff, StringBuffer numbering, int parent1, int parent2, int len, int ringNum, String[] atoms, int startnum, int shift) {
        StringBuffer bridge;
        int index1 = RingUtil.getIndexInString(strbuff.toString(), numbering.toString(), parent1);
        int index2 = RingUtil.getIndexInString(strbuff.toString(), numbering.toString(), parent2);
        String ringIndex = ringNum > 9 ? "%" + ringNum : "" + ringNum;
        StringBuffer numbers = new StringBuffer();
        if (len == 0) {
            bridge = new StringBuffer(ringIndex);
        } else {
            bridge = new StringBuffer("(");
            for (int i = 0; i < len; ++i) {
                String str = atoms[shift++ % 2];
                RingUtil.appendAtom(bridge, numbers, str, startnum++);
            }
            bridge.append(ringIndex).append(')');
        }
        RingUtil.insertString(strbuff, new StringBuffer(ringIndex), index2);
        RingUtil.insertString(strbuff, bridge, index1);
        RingUtil.insertString(numbering, numbers, index1);
    }

    protected static void appendBridge(StringBuffer strbuff, IntVector atomnumbers, int parent1, int parent2, int len, int ringNum, String[] atoms, int startnum, int shift) {
        StringBuffer bridge;
        int index1 = RingUtil.getIndexInString(strbuff.toString(), atomnumbers, parent1);
        int index2 = RingUtil.getIndexInString(strbuff.toString(), atomnumbers, parent2);
        String ringIndex = ringNum > 9 ? "%" + ringNum : "" + ringNum;
        IntVector numbers = new IntVector();
        if (len == 0) {
            bridge = new StringBuffer(ringIndex);
        } else {
            bridge = new StringBuffer("(");
            for (int i = 0; i < len; ++i) {
                String str = atoms[shift++ % 2];
                RingUtil.appendAtom(bridge, numbers, str, startnum++);
            }
            bridge.append(ringIndex).append(')');
        }
        RingUtil.insertString(strbuff, new StringBuffer(ringIndex), index2);
        RingUtil.insertString(strbuff, bridge, index1);
        RingUtil.insertAtomNumbering(atomnumbers, numbers, index1);
    }

    private static int getIndexInString(String smiles, String numbering, int index) {
        String[] numbers = numbering.substring(2).split(";");
        for (int i = 0; i < numbers.length; ++i) {
            if (new Integer(numbers[i]) != index) continue;
            return i + 1;
        }
        return -1;
    }

    private static int getIndexInString(String smiles, IntVector numbering, int index) {
        for (int i = 0; i < numbering.size(); ++i) {
            if (numbering.get(i) != index) continue;
            return i + 1;
        }
        return -1;
    }

    private static void insertAtomNumbering(IntVector parent, IntVector child, int position) {
        for (int i = 0; i < child.size(); ++i) {
            parent.add(position + i, child.get(i));
        }
    }

    private static void insertString(StringBuffer parent, StringBuffer child, int index) {
        int indexInString = -1;
        if (parent.indexOf(";") > -1) {
            indexInString = RingUtil.indexOf(parent, ';', index) + 1;
        } else {
            for (indexInString = UtilLegacy.getLastIndexOfElement(parent.toString(), index) + 1; indexInString > 0 && (parent.charAt(indexInString - 1) == ')' || parent.charAt(indexInString - 1) == '('); --indexInString) {
            }
        }
        parent = parent.insert(indexInString, child);
    }

    private static int indexOf(StringBuffer string, char pattern, int matchIndex) {
        int match = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == pattern) {
                ++match;
            }
            if (match != matchIndex) continue;
            return i;
        }
        return -1;
    }

    public static String dictFormatToSmiles(String str) {
        StringBuffer atom;
        int index = str.indexOf("|$");
        if (index > -1 && str.indexOf("_R", index) < 0) {
            return str;
        }
        String molinfo = "";
        index = str.indexOf(" |");
        if (index > -1) {
            molinfo = str.substring(index);
            str = str.substring(0, index);
        }
        StringBuffer sb = new StringBuffer(str);
        StringBuffer smi = new StringBuffer();
        StringBuffer numbering = new StringBuffer(" |$");
        while ((atom = RingUtil.remFirstAtom(sb)) != null) {
            StringBuffer smiAtom = new StringBuffer();
            index = RingUtil.convertAtomToSmiles(atom, smiAtom);
            smi.append(smiAtom);
            if (index > 0) {
                numbering.append(index);
            }
            numbering.append(";");
        }
        smi.append(molinfo);
        numbering.deleteCharAt(numbering.length() - 1);
        if (numbering.length() > 3) {
            smi.append(numbering).append("$|");
        }
        return smi.toString();
    }

    private static StringBuffer remFirstAtom(StringBuffer string) {
        if (string.length() == 0) {
            return null;
        }
        StringBuffer atom = new StringBuffer();
        boolean start = false;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '[') {
                if (start) {
                    atom.append(string.substring(0, i));
                    string.delete(0, i);
                } else {
                    int index = string.indexOf("]");
                    atom.append(string.substring(0, index + 1));
                    string.delete(0, index + 1);
                }
                return atom;
            }
            if (!Character.isUpperCase(string.charAt(i)) && (!Character.isLowerCase(string.charAt(i)) || i != 0 && Character.isUpperCase(string.charAt(i - 1)))) continue;
            if (start) {
                atom.append(string.substring(0, i));
                string.delete(0, i);
                return atom;
            }
            start = true;
        }
        atom.append(string);
        string.delete(0, string.length());
        return atom;
    }

    private static int convertAtomToSmiles(StringBuffer atom, StringBuffer smiAtom) {
        int index = 0;
        String[] commonAtoms = new String[]{"B", "C", "N", "O", "P", "S", "F", "Cl", "Br", "I"};
        boolean common = false;
        char bond = ' ';
        if (atom.indexOf(":") < 0) {
            smiAtom.append(atom);
        } else {
            int begin = atom.indexOf("[");
            int center = atom.indexOf(":");
            int end = atom.indexOf("]");
            String a = atom.substring(begin + 1, center);
            if (a.startsWith("=") || a.startsWith("#")) {
                bond = a.charAt(0);
                a = a.substring(1);
            }
            index = UtilLegacy.stringToLocant(atom.substring(center + 1, end));
            for (int i = 0; i < commonAtoms.length; ++i) {
                if (!a.equalsIgnoreCase(commonAtoms[i])) continue;
                common = true;
            }
            if (bond != ' ') {
                a = bond + a;
            }
            if (common) {
                smiAtom.append(atom.substring(0, begin)).append(a).append(atom.substring(end + 1, atom.length()));
            } else {
                smiAtom.append(atom.substring(0, begin)).append("[").append(a).append("]").append(atom.substring(end + 1, atom.length()));
            }
        }
        return index;
    }

    protected static int getMaxParent(LocantList list) {
        int maxParent = 0;
        for (int i = 0; i < list.size(); ++i) {
            ComplexLocant locant = (ComplexLocant)list.getLocant(i);
            maxParent = Math.max(locant.getFirstLocant().getParent(), maxParent);
            maxParent = Math.max(locant.getSecondLocant().getParent(), maxParent);
        }
        return maxParent;
    }
}

