/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.naming.n2s.Util;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.parse.Suffix;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;

public class SaltEnding
extends Suffix
implements Cloneable {
    private String atom = null;
    private boolean hydro = false;

    public SaltEnding(String name, String value, int mul, String atom, boolean hasHydro) {
        super(name, value, null, mul, 3);
        this.atom = atom;
        this.hydro = hasHydro;
    }

    public String getAtom() {
        return this.atom;
    }

    public void setAtom(String atom) {
        this.atom = atom;
    }

    public boolean hasHydro() {
        return this.hydro;
    }

    public void setHydro(boolean hydro) {
        this.hydro = hydro;
    }

    @Override
    public String toString() {
        return super.toString() + " atom:" + this.atom + (this.hydro ? " hydro" : "");
    }

    @Override
    public boolean is(String name) {
        if ("sulfide".equals(name)) {
            return "S".equals(this.atom);
        }
        return super.is(name);
    }

    @Override
    protected Molecule buildMol() {
        Molecule res = Util.newMolecule();
        MolAtom a = this.getMolAtom();
        res.add(a);
        if (a.getAtno() != 8) {
            this.radical = Chem.standardValence(a.getAtno());
        }
        return res;
    }

    public MolAtom getMolAtom() {
        return new MolAtom(PeriodicSystem.getAtomicNumber(this.atom));
    }

    @Override
    public MolAtom getRadicalAtom() {
        return this.getMol().getAtom(0);
    }

    @Override
    public int getRadical(Str parent) {
        if (this.doNotConnect(parent)) {
            if (!this.hydro && this.is("ide")) {
                this.getMol().getAtom(0).setCharge(-1);
            }
            return -1;
        }
        return super.getRadical(parent);
    }

    @Override
    public boolean connect(Str parent) {
        MolAtom a;
        int atno;
        if (this.multiplicity == -1 && !this.atom.equals("S") && parent.isMonoAtomic() && parent.substituentCount() == 0 && PeriodicSystem.isMetal(atno = (a = parent.getParentMol().getAtom(0)).getAtno())) {
            this.multiplicity = Chem.standardValence(atno);
        }
        return super.connect(parent);
    }

    private boolean doNotConnect(Str parent) {
        if (this.hydro) {
            return true;
        }
        if (parent.isMultipliedStructure()) {
            return true;
        }
        Molecule parentM = parent.getParentMol();
        for (MolAtom a : parentM.getAtomArray()) {
            if (a.getCharge() == 0 || a.getCharge() > 0 == this.getRadicalAtom().getCharge() > 0) continue;
            return true;
        }
        return false;
    }
}

