/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.parse;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.naming.n2s.lex.data.AtomLocant;
import chemaxon.naming.n2s.lex.data.EndingToken;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.SpecialLocant;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.Token;
import chemaxon.naming.n2s.parse.Radical;
import chemaxon.naming.n2s.util.Formats;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class Suffix
extends Token {
    public static final int NOT_SET = -1;
    public static final int ACID = 0;
    public static final int AMINE = 1;
    public static final int RADICAL = 2;
    public static final int SALT = 3;
    public static final int ACETATE = 4;
    public static final int AMIDE = 5;
    public static final int POLYRINGSYSTEM = 6;
    public static final int ION = 7;
    protected int type;
    protected String value;
    private Molecule mol;
    protected LocantList locant = new LocantList();
    protected int multiplicity;
    protected boolean locantCalculated = false;
    protected int radical = 1;
    protected boolean spaceSeparated = false;
    protected static String abstractSuffix = "[ABSTRACT SUFFIX]";

    public static Suffix create(EndingToken ending, LocantList locants, int multiplier) {
        String name;
        String value = ending.getValue();
        if (value.startsWith("^")) {
            return new Radical(ending.getName(), value.substring(1), locants, multiplier);
        }
        if (ending.getName().equals("salt")) {
            value = "";
        }
        if ((name = ending.getName()).endsWith("ate") || name.equals("one")) {
            name = name.substring(0, name.length() - 1);
        }
        int type = Suffix.getSuffixType(ending);
        return new Suffix(name, value, locants, multiplier, type);
    }

    private static int getSuffixType(EndingToken actToken) {
        int type = -1;
        if (actToken.getName().endsWith("ate") && !actToken.getName().equals("hydrate")) {
            type = 4;
        } else if (actToken.getName().indexOf("amid") > -1 || actToken.getName().indexOf("hydrazide") > -1) {
            type = 5;
        } else if (actToken.getName().indexOf("imin") > -1 || actToken.getName().indexOf("amin") > -1) {
            type = 1;
        } else if (actToken.getValue().startsWith("[POLY_")) {
            type = 6;
        } else if (actToken.getValue().matches("([+|-]h[+|-])|\\+|-") || actToken.getName().equals("!ION")) {
            type = 7;
        }
        if (actToken.getValue().equals("!SALT")) {
            type = 3;
        } else if (actToken.getName().endsWith("acid")) {
            type = 0;
        }
        return type;
    }

    public Suffix(String name, String value, LocantList locant, int mul, int type) {
        super(name);
        if (value.startsWith(":")) {
            value = value.substring(1);
        }
        if (value.startsWith("?")) {
            this.radical = 0;
            value = value.substring(1);
        }
        if (value.startsWith("=")) {
            this.radical = 2;
            value = value.substring(1);
        }
        int index = -1;
        index = value.indexOf("Radical:");
        if (index > 0) {
            this.radical = Integer.parseInt(value.substring(index + 8, index + 9));
            value = value.substring(0, index) + value.substring(index + 9);
        }
        this.value = value;
        if (locant != null) {
            this.locant.tryAddLocant(locant);
        }
        this.multiplicity = mul;
        this.type = type;
    }

    protected Suffix(String name) {
        this.name = name;
        this.value = abstractSuffix;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        this.mol = null;
    }

    public LocantList getLocant() {
        return this.locant;
    }

    public void setLocant(LocantList locant) {
        this.locant = locant;
    }

    public void setLocant(LocantList locant, Str parent) {
        if (locant.size() <= 1 || this.isSubstituentEnding()) {
            this.setLocant(locant);
            return;
        }
        for (Locant l : locant.getLocantsList()) {
            Suffix s = this.clone();
            s.setLocant(l);
            parent.addSuffix(s);
        }
        parent.suffixes.remove(this);
    }

    public boolean setLocantIfExpectedSize(LocantList locant) {
        if ((locant = locant.expandOMP(this.locant.size())).size() == this.locant.size()) {
            this.locant = locant;
            return true;
        }
        return false;
    }

    public void setLocant(Locant locant) {
        this.locant = new LocantList();
        this.locant.addLocant(locant);
    }

    public void addLocant(Locant locant) {
        this.locant.tryAddLocant(locant);
    }

    public boolean mono() {
        return this.multiplicity == 1;
    }

    public int getMultiplicity() {
        if (this.multiplicity == -1) {
            return 1;
        }
        return this.multiplicity;
    }

    public void setMultiplicity(int mul) {
        this.multiplicity = mul;
    }

    public boolean isLocantCalculated() {
        return this.locantCalculated;
    }

    public void setLocantCalculated(boolean locantCalculated) {
        this.locantCalculated = locantCalculated;
    }

    public boolean is(String name, int multiplicity) {
        return this.is(name) && this.multiplicity == multiplicity;
    }

    public boolean isSubstituentEnding() {
        return this.is("yl") || this.is("ylidene") || this.is("ylidyne");
    }

    public int getRadical(Str parent) {
        return this.getRadical();
    }

    public int getRadical() {
        return this.radical;
    }

    public void setRadical(int radical) {
        this.radical = radical;
    }

    public boolean isSpaceSeparated() {
        return this.spaceSeparated;
    }

    public void setSpaceSeparated(boolean spaceSeparated) {
        this.spaceSeparated = spaceSeparated;
    }

    @Override
    public Suffix clone() {
        return (Suffix)super.clone();
    }

    public boolean hasLocant() {
        return this.getLocant() != null && this.getLocant().size() != 0;
    }

    public int getLocantCount() {
        if (this.getLocant() == null) {
            return 0;
        }
        return this.getLocant().size();
    }

    @Override
    public String toString() {
        StringBuilder res = new StringBuilder();
        if (this.multiplicity > 1) {
            res.append(this.multiplicity).append("\u00d7 ");
        }
        res.append(this.locant).append(" ");
        res.append(this.name);
        if (this.value != abstractSuffix) {
            res.append(" ");
            res.append(this.value);
        }
        return res.toString();
    }

    public boolean nothingToGenerate() {
        return this.value == null || this.value.equals("") || this.value.equals("#");
    }

    public Molecule getMol() {
        if (this.mol != null) {
            return this.mol;
        }
        this.mol = this.buildMol();
        return this.mol;
    }

    protected Molecule buildMol() {
        Molecule mol;
        if (this.nothingToGenerate()) {
            mol = null;
        } else {
            try {
                mol = Formats.importCxSmiles(this.value);
            }
            catch (MolFormatException e) {
                throw new RuntimeException(e);
            }
        }
        return mol;
    }

    public Molecule getCompleteStructure() {
        if (this.getMol() == null) {
            return null;
        }
        this.mol = this.getMol().cloneMolecule();
        return this.mol;
    }

    public MolAtom getRadicalAtom() {
        if (this.getMol() == null) {
            return null;
        }
        return this.mol.getAtom(0);
    }

    public MolAtom getLocantFromParent(Locant l) {
        if (l == SpecialLocant.n) {
            l = Locant.N;
        }
        if (l instanceof AtomLocant) {
            MolAtom a;
            AtomLocant al = (AtomLocant)l;
            if (al.getLocantIndex() > 0 && al.getLocantIndex() != this.locant.getSimpleLocantValue()) {
                return null;
            }
            if (this.getMol() == null) {
                return null;
            }
            String loc = l.toString();
            int i = this.getMol().getAtomCount();
            while (--i >= 0) {
                a = this.getMol().getAtom(i);
                if (!Str.hasKeyword(a, loc)) continue;
                return a;
            }
            i = this.getMol().getAtomCount();
            while (--i >= 0) {
                a = this.getMol().getAtom(i);
                if (a.getAtno() != al.getAtno()) continue;
                return a;
            }
        }
        return null;
    }

    public boolean isSeparateFragment() {
        return this.is("hydrat");
    }

    public boolean connect(Str parent) {
        MolAtom[] OHs;
        if (this.oxide(parent)) {
            return false;
        }
        if (this.is("ide") && parent.is("sulf")) {
            if (parent.hasParent()) {
                parent.setRadicalBond(2);
            }
            return false;
        }
        if (this.is("hydrazide") && parent.isAcid() && (OHs = parent.getParentEsterificationPoints()).length > 0) {
            Molecule hydrazide;
            try {
                hydrazide = MolImporter.importMol("NN", "smiles");
            }
            catch (MolFormatException e) {
                throw new RuntimeException(e);
            }
            for (MolAtom OH : OHs) {
                Molecule NN = hydrazide.cloneMolecule();
                parent.getMolPublic().fuse(NN);
                parent.mergeAtoms(OH, NN.getAtom(0));
            }
            return false;
        }
        if (this.value == abstractSuffix) {
            throw new RuntimeException("Abstract: " + this);
        }
        return parent.connect(this);
    }

    private boolean oxide(Str parent) {
        MolBond b;
        MolAtom[] roots;
        MolBond b2;
        int atno;
        if (this.is("oxide")) {
            atno = 8;
        } else if (this.is("imine")) {
            atno = 7;
        } else if (this.is("sulfide")) {
            atno = 16;
        } else {
            return false;
        }
        if (this.locant.size() == 2 && (b2 = (roots = parent.getAtoms(this.locant))[0].getBondTo(roots[1])) != null && b2.getType() == 2) {
            this.oxide(b2, parent.getParentMol(), atno);
            return true;
        }
        if (!this.locant.hasLocant() && (b = parent.getSingleDoubleBond()) != null) {
            this.oxide(b, parent.getParentMol(), atno);
            return true;
        }
        return false;
    }

    private void oxide(MolBond b, Molecule m, int atno) {
        b.setType(1);
        MolAtom o = new MolAtom(atno);
        m.add(o);
        m.add(new MolBond(b.getAtom1(), o));
        m.add(new MolBond(b.getAtom2(), o));
    }

    public MolAtom[] getGeneratedAtoms() {
        MolAtom[] res = this.getMol().getAtomArray();
        return res;
    }
}

