/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.util;

import chemaxon.formats.MolFormatException;
import chemaxon.marvin.io.formats.smiles.CxsmilesImport;
import chemaxon.struc.Molecule;
import java.io.IOException;

public class Formats {
    private static final ThreadLocal<CxsmilesImport> cxsmilesImporter = new ThreadLocal<CxsmilesImport>(){

        @Override
        protected CxsmilesImport initialValue() {
            return new CxsmilesImport();
        }
    };

    public static Molecule importCxSmiles(String cxsmiles) throws MolFormatException {
        CxsmilesImport imp = cxsmilesImporter.get();
        Molecule res = imp.createMol();
        try {
            imp.readMol(cxsmiles, res);
        }
        catch (IOException e) {
            throw new MolFormatException(e);
        }
        res = res.getSimplifiedMolecule();
        return res;
    }
}

