/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.tools;

import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.PositionedInputStream;
import chemaxon.marvin.io.SeekableInputStream;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.Molecule;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;

public class Sort {
    MolImporter importer;
    ArrayList<MoleculeValue> molecules = new ArrayList();
    private PositionedInputStream in;

    public static void main(String[] args) {
        String inputFilename = args[0];
        String outputFilename = args.length > 1 ? args[1] : "-";
        Sort sort = new Sort();
        try {
            SeekableInputStream input = new SeekableInputStream(new File(inputFilename));
            sort.load(input);
        }
        catch (IOException e) {
            System.out.println("Could not read input file " + inputFilename + ": " + e);
            System.exit(1);
        }
        try {
            OutputStream output = outputFilename == "-" ? System.out : new FileOutputStream(outputFilename);
            sort.output(output);
            output.close();
        }
        catch (IOException e) {
            System.out.println("Could not write to output file " + outputFilename + ": " + e);
            System.exit(1);
        }
    }

    public void load(InputStream input) throws IOException {
        Molecule m;
        this.in = new PositionedInputStream(input);
        this.importer = new MolImporter(this.in);
        long startPos = 0L;
        while ((m = this.importer.read()) != null) {
            long endPos = m.getEndPosition();
            int length = (int)(endPos - startPos);
            long value = this.evaluate(m);
            this.molecules.add(new MoleculeValue(startPos, length, value));
            startPos = endPos;
        }
        Collections.sort(this.molecules);
    }

    public void output(OutputStream output) throws IOException {
        for (MoleculeValue mv : this.molecules) {
            this.in.seek(mv.position, 0);
            byte[] data = new byte[mv.length];
            this.in.read(data);
            output.write(data);
        }
    }

    public long evaluate(Molecule m) {
        return this.evaluateNameLength(m);
    }

    private long evaluateNameLength(Molecule m) {
        return m.getName().length();
    }

    private long evaluateGeneratedNameLength(Molecule m) {
        try {
            return m.exportToFormat("name").length();
        }
        catch (MolExportException e) {
            return Integer.MAX_VALUE;
        }
    }

    public long evaluateAtomCount(Molecule m) {
        return m.getAtomCount();
    }

    public long evaluateLevenshteinDistance(Molecule m) {
        String name1 = m.getProperty("field_0");
        String name2 = m.getProperty("field_1");
        return Util.levenshteinDistance(name1, name2);
    }

    private static class MoleculeValue
    implements Comparable<MoleculeValue> {
        long position;
        int length;
        long value;

        MoleculeValue(long position, int length, long value) {
            this.position = position;
            this.length = length;
            this.value = value;
        }

        @Override
        public int compareTo(MoleculeValue that) {
            if (this.value < that.value) {
                return -1;
            }
            if (this.value > that.value) {
                return 1;
            }
            return 0;
        }
    }
}

