/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.nfunk.jep;

import chemaxon.nfunk.jep.EvaluatorVisitor;
import chemaxon.nfunk.jep.FunctionTable;
import chemaxon.nfunk.jep.Node;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.Parser;
import chemaxon.nfunk.jep.ParserDumpVisitor;
import chemaxon.nfunk.jep.SymbolTable;
import chemaxon.nfunk.jep.TokenMgrError;
import chemaxon.nfunk.jep.function.Abs;
import chemaxon.nfunk.jep.function.Angle;
import chemaxon.nfunk.jep.function.ArcCosine;
import chemaxon.nfunk.jep.function.ArcCosineH;
import chemaxon.nfunk.jep.function.ArcSine;
import chemaxon.nfunk.jep.function.ArcSineH;
import chemaxon.nfunk.jep.function.ArcTanH;
import chemaxon.nfunk.jep.function.ArcTangent;
import chemaxon.nfunk.jep.function.Cosine;
import chemaxon.nfunk.jep.function.CosineH;
import chemaxon.nfunk.jep.function.Imaginary;
import chemaxon.nfunk.jep.function.Logarithm;
import chemaxon.nfunk.jep.function.Modulus;
import chemaxon.nfunk.jep.function.NaturalLogarithm;
import chemaxon.nfunk.jep.function.PostfixMathCommandI;
import chemaxon.nfunk.jep.function.Random;
import chemaxon.nfunk.jep.function.Real;
import chemaxon.nfunk.jep.function.Sine;
import chemaxon.nfunk.jep.function.SineH;
import chemaxon.nfunk.jep.function.SquareRoot;
import chemaxon.nfunk.jep.function.Sum;
import chemaxon.nfunk.jep.function.TanH;
import chemaxon.nfunk.jep.function.Tangent;
import chemaxon.nfunk.jep.type.Complex;
import chemaxon.nfunk.jep.type.DoubleNumberFactory;
import chemaxon.nfunk.jep.type.NumberFactory;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;

public class JEP
implements Serializable {
    private static final String lineSep = System.getProperty("line.separator");
    public static final String COMPILE_ERROR = "Error while compiling expression:";
    public static final String EVALUATION_ERROR = "Error while evaluating expression:";
    private static final boolean debug = false;
    private boolean traverse;
    protected boolean allowUndeclared;
    protected boolean implicitMul;
    protected SymbolTable symTab;
    protected FunctionTable funTab;
    protected Vector errorList;
    private transient Parser parser;
    private Node topNode = null;
    private EvaluatorVisitor ev;
    private NumberFactory numberFactory;
    private String expression;

    public JEP() {
        this.traverse = false;
        this.allowUndeclared = false;
        this.implicitMul = false;
        this.numberFactory = new DoubleNumberFactory();
        this.initSymTab();
        this.initFunTab();
        this.errorList = new Vector();
        this.ev = new EvaluatorVisitor();
    }

    public JEP(boolean traverse_in, boolean allowUndeclared_in, boolean implicitMul_in, NumberFactory numberFactory_in) {
        this.traverse = traverse_in;
        this.allowUndeclared = allowUndeclared_in;
        this.implicitMul = implicitMul_in;
        this.numberFactory = numberFactory_in == null ? new DoubleNumberFactory() : numberFactory_in;
        this.initSymTab();
        this.initFunTab();
        this.errorList = new Vector();
        this.ev = new EvaluatorVisitor();
    }

    private void initParser() {
        if (this.parser == null) {
            this.parser = new Parser(new StringReader(""));
        }
    }

    public void initSymTab() {
        this.symTab = new SymbolTable();
    }

    public void initFunTab() {
        this.funTab = new FunctionTable();
    }

    public void addStandardFunctions() {
        this.funTab.put("sin", new Sine());
        this.funTab.put("cos", new Cosine());
        this.funTab.put("tan", new Tangent());
        this.funTab.put("asin", new ArcSine());
        this.funTab.put("acos", new ArcCosine());
        this.funTab.put("atan", new ArcTangent());
        this.funTab.put("sinh", new SineH());
        this.funTab.put("cosh", new CosineH());
        this.funTab.put("tanh", new TanH());
        this.funTab.put("asinh", new ArcSineH());
        this.funTab.put("acosh", new ArcCosineH());
        this.funTab.put("atanh", new ArcTanH());
        this.funTab.put("log", new Logarithm());
        this.funTab.put("ln", new NaturalLogarithm());
        this.funTab.put("sqrt", new SquareRoot());
        this.funTab.put("angle", new Angle());
        this.funTab.put("abs", new Abs());
        this.funTab.put("mod", new Modulus());
        this.funTab.put("sum", new Sum());
        this.funTab.put("rand", new Random());
    }

    public void addStandardConstants() {
        this.symTab.put("pi", new Double(Math.PI));
        this.symTab.put("e", new Double(Math.E));
    }

    public void addComplex() {
        this.symTab.put("i", new Complex(0.0, 1.0));
        this.funTab.put("re", new Real());
        this.funTab.put("im", new Imaginary());
    }

    public PostfixMathCommandI getFunction(String name) {
        PostfixMathCommandI fun = (PostfixMathCommandI)this.funTab.get(name);
        return fun != null ? fun.getFunction() : null;
    }

    public void addFunction(String name, PostfixMathCommandI function) throws ParseException {
        this.funTab.put(name, function);
    }

    public Double addVariable(String name, double value) {
        Double object = new Double(value);
        this.symTab.put(name, object);
        return object;
    }

    public Complex addComplexVariable(String name, double re, double im) {
        Complex object = new Complex(re, im);
        this.symTab.put(name, object);
        return object;
    }

    public void addVariableAsObject(String name, Object object) {
        this.symTab.put(name, object);
    }

    public Object removeVariable(String name) {
        return this.symTab.remove(name);
    }

    public Object removeFunction(String name) {
        return this.funTab.remove(name);
    }

    public void setTraverse(boolean value) {
        this.traverse = value;
    }

    public void setImplicitMul(boolean value) {
        this.implicitMul = value;
    }

    public void setAllowUndeclared(boolean value) {
        this.allowUndeclared = value;
    }

    public void parseExpression(String expression_in) throws ParseException {
        this.expression = expression_in;
        StringReader reader = new StringReader(expression_in);
        try {
            this.errorList.removeAllElements();
            this.initParser();
            this.topNode = this.parser.parseStream(reader, this);
        }
        catch (Exception e) {
            this.topNode = null;
            this.errorList.addElement(e);
        }
        catch (TokenMgrError err) {
            this.topNode = null;
            this.errorList.addElement(new ParseException(err));
        }
        if (this.hasError()) {
            throw new ParseException("Error while compiling expression:\n" + expression_in, this.getError(0));
        }
        if (this.traverse) {
            ParserDumpVisitor v = new ParserDumpVisitor();
            this.topNode.jjtAccept(v, null);
        }
    }

    public double getValue() throws ParseException {
        Object value = this.getValueAsObject();
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof Complex) {
            return ((Complex)value).re();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        throw new ParseException("could not convert to double: " + value);
    }

    public Complex getComplexValue() throws ParseException {
        Object value = this.getValueAsObject();
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return new Complex(((Number)value).doubleValue(), 0.0);
        }
        if (value instanceof Complex) {
            return (Complex)value;
        }
        throw new ParseException("could not convert to Complex: " + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAsObject() throws ParseException {
        if (this.hasError()) {
            this.errorList.removeAllElements();
            this.ev.clear();
        }
        if (this.topNode != null) {
            try {
                Object object = this.ev.getValue(this.topNode, this.errorList, this.symTab);
                return object;
            }
            catch (Exception e) {
                this.errorList.addElement(e);
                Object var2_3 = null;
                return var2_3;
            }
            finally {
                if (this.hasError()) {
                    throw new ParseException("Error while evaluating expression:\n" + this.expression, this.getError(0));
                }
            }
        }
        return null;
    }

    public boolean hasError() {
        return !this.errorList.isEmpty();
    }

    public String getErrorInfo() {
        if (this.hasError()) {
            String str = "";
            for (int i = 0; i < this.errorList.size(); ++i) {
                str = str + ((Exception)this.errorList.elementAt(i)).getMessage() + lineSep;
            }
            return str;
        }
        return null;
    }

    public int getErrorCount() {
        return this.errorList.size();
    }

    public Exception getError(int i) {
        Object error = this.errorList.elementAt(i);
        Exception exception = error instanceof Exception ? (Exception)error : new ParseException(error.toString());
        return exception;
    }

    public Throwable[] getErrors() {
        if (this.errorList == null || this.errorList.isEmpty()) {
            return null;
        }
        Throwable[] errors = new Throwable[this.errorList.size()];
        for (int i = 0; i < errors.length; ++i) {
            errors[i] = this.getError(i);
        }
        return errors;
    }

    protected void addError(Exception ex) {
        this.errorList.addElement(ex);
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public SymbolTable getSymbolTable() {
        return this.symTab;
    }

    public NumberFactory getNumberFactory() {
        return this.numberFactory;
    }
}

