/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.nfunk.jep.function;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommand;
import chemaxon.nfunk.jep.type.Complex;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;

public class Add
extends PostfixMathCommand {
    public Add() {
        this.numberOfParameters = -1;
    }

    @Override
    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object sum = stack.pop();
        for (int i = 1; i < this.curNumberOfParameters; ++i) {
            Object param = stack.pop();
            sum = this.add(param, sum);
        }
        stack.push(sum);
    }

    public Object add(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Number) {
            if (param2 instanceof Number) {
                return this.add((Number)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.add((Complex)param2, (Number)param1);
            }
            if (param2 instanceof double[]) {
                return this.add((double[])param2, (Number)param1);
            }
        } else if (param1 instanceof Complex) {
            if (param2 instanceof Number) {
                return this.add((Complex)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.add((Complex)param1, (Complex)param2);
            }
        } else if (param1 instanceof double[]) {
            if (param2 instanceof Number) {
                return this.add((double[])param1, (Number)param2);
            }
            if (param2 instanceof double[]) {
                return this.add((double[])param1, (double[])param2);
            }
        }
        return this.addInSet(param1, param2);
    }

    public Double add(Number d1, Number d2) {
        return new Double(d1.doubleValue() + d2.doubleValue());
    }

    public Complex add(Complex c1, Complex c2) {
        return new Complex(c1.re() + c2.re(), c1.im() + c2.im());
    }

    public Complex add(Complex c, Number d) {
        return new Complex(c.re() + d.doubleValue(), c.im());
    }

    public double[] add(double[] a1, double[] a2) {
        int i;
        if (a1.length > a2.length) {
            double[] tmp = a1;
            a1 = a2;
            a2 = tmp;
        }
        double[] r = new double[a2.length];
        for (i = 0; i < a1.length; ++i) {
            r[i] = a1[i] + a2[i];
        }
        for (i = a1.length; i < a2.length; ++i) {
            r[i] = a2[i];
        }
        return r;
    }

    public double[] add(double[] a, Number d) {
        double[] r = new double[a.length];
        double v = d.doubleValue();
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i] + v;
        }
        return r;
    }

    public Collection addInSet(Object a, Object b) {
        HashSet<Object> coll = null;
        if (a instanceof Collection) {
            coll = new HashSet<Object>((Collection)a);
            if (b instanceof Collection) {
                coll.addAll((Collection)b);
            } else {
                coll.add(b);
            }
        } else if (b instanceof Collection) {
            coll = new HashSet((Collection)b);
            coll.add(a);
        } else {
            coll = new HashSet();
            coll.add(a);
            coll.add(b);
        }
        return coll;
    }
}

