/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.nfunk.jep.function;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommand;
import java.util.Stack;

public class Logical
extends PostfixMathCommand {
    int id;

    public Logical(int id_in) {
        this.id = id_in;
        this.numberOfParameters = 1;
    }

    @Override
    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        Double r = null;
        if (param == null) {
            switch (this.id) {
                case 0: {
                    r = TRUE;
                    break;
                }
                case 1: {
                    r = FALSE;
                }
            }
        } else if (param instanceof Boolean) {
            boolean b = (Boolean)param;
            switch (this.id) {
                case 0: {
                    r = !b ? FALSE : null;
                    break;
                }
                case 1: {
                    r = b ? TRUE : null;
                }
            }
        } else if (param instanceof Number) {
            double x = ((Number)param).doubleValue();
            switch (this.id) {
                case 0: {
                    r = x <= 0.5 ? FALSE : null;
                    break;
                }
                case 1: {
                    r = x > 0.5 ? TRUE : null;
                }
            }
        } else {
            throw new ParseException("Invalid parameter type");
        }
        inStack.push(r);
    }
}

