/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.nfunk.jep.function;

import chemaxon.nfunk.jep.ParseException;
import chemaxon.nfunk.jep.function.PostfixMathCommand;
import chemaxon.nfunk.jep.type.Complex;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;

public class Subtract
extends PostfixMathCommand {
    public Subtract() {
        this.numberOfParameters = 2;
    }

    @Override
    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        inStack.push(this.sub(param1, param2));
    }

    public Object sub(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Number) {
            if (param2 instanceof Number) {
                return this.sub((Number)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.sub((Number)param1, (Complex)param2);
            }
        } else if (param1 instanceof Complex) {
            if (param2 instanceof Number) {
                return this.sub((Complex)param1, (Number)param2);
            }
            if (param2 instanceof Complex) {
                return this.sub((Complex)param1, (Complex)param2);
            }
        } else if (param1 instanceof double[]) {
            if (param2 instanceof Number) {
                return this.sub((double[])param1, (Number)param2);
            }
            if (param2 instanceof double[]) {
                return this.sub((double[])param1, (double[])param2);
            }
        } else if (param1 instanceof Collection) {
            return this.sub((Collection)param1, param2);
        }
        throw new ParseException("Invalid parameter type");
    }

    public Double sub(Number d1, Number d2) {
        return new Double(d1.doubleValue() - d2.doubleValue());
    }

    public Complex sub(Complex c1, Complex c2) {
        return new Complex(c1.re() - c2.re(), c1.im() - c2.im());
    }

    public Complex sub(Complex c, Number d) {
        return new Complex(c.re() - d.doubleValue(), c.im());
    }

    public Complex sub(Number d, Complex c) {
        return new Complex(d.doubleValue() - c.re(), -c.im());
    }

    public double[] sub(double[] a1, double[] a2) {
        double[] r = new double[Math.max(a1.length, a2.length)];
        for (int i = 0; i < r.length; ++i) {
            if (i < a1.length) {
                int n = i;
                r[n] = r[n] + a1[i];
            }
            if (i >= a2.length) continue;
            int n = i;
            r[n] = r[n] - a2[i];
        }
        return r;
    }

    public double[] sub(double[] a, Number d) {
        double[] r = new double[a.length];
        double v = d.doubleValue();
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i] - v;
        }
        return r;
    }

    public Collection sub(Collection a, Object b) {
        HashSet coll = a;
        if (coll.contains(b)) {
            coll = new HashSet(a);
            coll.remove(b);
        } else if (b instanceof Collection) {
            coll = new HashSet(a);
            coll.removeAll((Collection)b);
        }
        return coll;
    }
}

