/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.pharmacophore;

import chemaxon.pharmacophore.PSymbols;
import java.util.BitSet;
import java.util.StringTokenizer;

public class PMap {
    private BitSet[] features = null;
    private int natoms = 0;

    public PMap(int natoms, int nfeatures) {
        this.natoms = natoms;
        this.features = new BitSet[nfeatures];
        for (int i = 0; i < this.features.length; ++i) {
            this.features[i] = new BitSet(natoms);
        }
    }

    public PMap(int natoms, BitSet[] features) {
        this.natoms = natoms;
        this.features = features;
    }

    public Object clone() {
        BitSet[] cfeatures = new BitSet[this.features.length];
        for (int i = 0; i < this.features.length; ++i) {
            cfeatures[i] = (BitSet)this.features[i].clone();
        }
        return new PMap(this.natoms, cfeatures);
    }

    public void clear() {
        for (int i = 0; i < this.features.length; ++i) {
            for (int j = 0; j < this.natoms; ++j) {
                this.features[i].clear(j);
            }
        }
    }

    public int getAtomCount() {
        return this.natoms;
    }

    public int getFeatureCount() {
        return this.features.length;
    }

    public void setFeature(int atomIndex, int featureIndex) {
        this.features[featureIndex].set(atomIndex);
    }

    public boolean hasFeature(int atomIndex, int featureIndex) {
        return this.features[featureIndex].get(atomIndex);
    }

    public boolean hasFeature(int atomIndex) {
        for (int i = 0; i < this.features.length; ++i) {
            if (!this.features[i].get(atomIndex)) continue;
            return true;
        }
        return false;
    }

    private int cardinality(BitSet bitset) {
        int result = 0;
        for (int i = 0; i < this.natoms; ++i) {
            if (!bitset.get(i)) continue;
            ++result;
        }
        return result;
    }

    public int getFeatureCount(int atomIndex) {
        int result = 0;
        for (int i = 0; i < this.features.length; ++i) {
            if (!this.features[i].get(atomIndex)) continue;
            ++result;
        }
        return result;
    }

    public int[] getFeatures(int atomIndex) {
        int[] result = new int[this.getFeatureCount(atomIndex)];
        int k = 0;
        for (int i = 0; i < this.features.length; ++i) {
            if (!this.features[i].get(atomIndex)) continue;
            result[k++] = i;
        }
        return result;
    }

    public void clearFeatures(int atomIndex) {
        for (int i = 0; i < this.features.length; ++i) {
            this.features[i].clear(atomIndex);
        }
    }

    public int[] getAtoms(int featureIndex) {
        BitSet feature = this.features[featureIndex];
        int[] atoms = new int[this.cardinality(feature)];
        int j = 0;
        for (int i = 0; i < this.natoms; ++i) {
            if (!feature.get(i)) continue;
            atoms[j++] = i;
        }
        return atoms;
    }

    public int getAtoms(int featureIndex, int[] atomIndices) throws ArrayIndexOutOfBoundsException {
        BitSet feature = this.features[featureIndex];
        int n = 0;
        for (int i = 0; i < this.natoms; ++i) {
            if (!feature.get(i)) continue;
            atomIndices[n++] = i;
        }
        return n;
    }

    public String toString(PSymbols symbols) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.natoms; ++i) {
            if (i > 0) {
                buffer.append(";");
            }
            boolean hasHit = false;
            for (int j = 0; j < this.features.length; ++j) {
                if (!this.hasFeature(i, j)) continue;
                if (hasHit) {
                    buffer.append("/");
                }
                buffer.append(symbols.getSymbol(j));
                hasHit = true;
            }
        }
        return new String(buffer);
    }

    public static PMap create(String plist, PSymbols symbols) {
        int natoms = 1;
        int length = plist.length();
        for (int i = 0; i < length; ++i) {
            if (plist.charAt(i) != ';') continue;
            ++natoms;
        }
        int nfeatures = symbols.getSymbolCount();
        PMap pmap = new PMap(natoms, nfeatures);
        int atom = 0;
        StringTokenizer st = new StringTokenizer(plist, "/;", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(";")) {
                ++atom;
                continue;
            }
            if (token.equals("/")) continue;
            for (int j = 0; j < nfeatures; ++j) {
                if (!token.equals(symbols.getSymbol(j))) continue;
                pmap.setFeature(atom, j);
            }
        }
        return pmap;
    }
}

