/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.reaction.ReactantSetEnumeration;
import chemaxon.reaction.Standardizer;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import chemaxon.util.MolFilter;
import chemaxon.util.iterator.CachedMoleculeIterator;
import chemaxon.util.iterator.FilteredMoleculeIterator;
import chemaxon.util.iterator.MoleculeIterator;

class CombinatorialModeReactantSetEnumerator
implements ReactantSetEnumeration {
    private static final String DEFAULT_CACHE_FORMAT = "mrv";
    private static final double DEFAULT_RESERVED_MEMORY_SIZE = 64.0;
    private static final String REACTANT_STANDARDIZER_TASK_GROUP_PREFIX = "reactant";
    private CachedMoleculeIterator[] cachedReactantIterators;
    private Molecule[] nextMols;

    public CombinatorialModeReactantSetEnumerator(MoleculeIterator[] reactantIterators, boolean ignoreError) {
        this(reactantIterators, null, null, DEFAULT_CACHE_FORMAT, 64.0, ignoreError);
    }

    CombinatorialModeReactantSetEnumerator(MoleculeIterator[] reactantIterators, MolFilter[] filters, Standardizer standardizer, String cacheFormat, double reservedMemorySize, boolean ignoreError) {
        this.nextMols = new Molecule[reactantIterators.length];
        for (int i = 0; i < reactantIterators.length; ++i) {
            if (this.cachedReactantIterators == null) {
                this.cachedReactantIterators = new CachedMoleculeIterator[reactantIterators.length];
            }
            this.cachedReactantIterators[i] = filters != null ? new FilteredCachedMoleculeIterator(reactantIterators[i], filters[i], this.getActiveStandardizer(standardizer, i), cacheFormat, reservedMemorySize) : new CachedMoleculeIterator(reactantIterators[i], cacheFormat, reservedMemorySize);
            if (!this.cachedReactantIterators[i].hasNext()) continue;
            this.nextMols[i] = this.cachedReactantIterators[i].next();
        }
    }

    private Standardizer getActiveStandardizer(Standardizer standardizer, int i) {
        if (standardizer != null) {
            Standardizer newStandardizer = Standardizer.newInstance(standardizer);
            newStandardizer.setActiveGroup(REACTANT_STANDARDIZER_TASK_GROUP_PREFIX + Integer.toString(i + 1));
            return newStandardizer;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.nextMols != null;
    }

    @Override
    public Molecule[] next() {
        int i;
        if (!this.hasNext()) {
            return null;
        }
        Molecule[] mols = this.nextMols;
        this.nextMols = new Molecule[this.cachedReactantIterators.length];
        for (i = 0; i < this.cachedReactantIterators.length - 1; ++i) {
            this.nextMols[i] = mols[i];
        }
        for (i = this.cachedReactantIterators.length - 1; i >= 0 && !this.cachedReactantIterators[i].hasNext(); --i) {
            this.cachedReactantIterators[i].restart();
            this.nextMols[i] = this.cachedReactantIterators[i].next();
        }
        if (i != -1) {
            this.nextMols[i] = this.cachedReactantIterators[i].next();
        } else {
            this.nextMols = null;
        }
        return mols;
    }

    @Override
    public double getProgress() {
        return this.cachedReactantIterators[0].estimateProgress();
    }

    private static class FilteredCachedMoleculeIterator
    extends CachedMoleculeIterator {
        public FilteredCachedMoleculeIterator(MoleculeIterator iterator, MolFilter filter, Standardizer standardizer, String format2, double reserveMemorySize) {
            super(new FilteredMoleculeIterator(new StandardizedMoleculeIterator(iterator, standardizer), filter), format2, reserveMemorySize);
        }
    }

    private static class StandardizedMoleculeIterator
    implements MoleculeIterator {
        private MoleculeIterator iterator = null;
        private Standardizer standardizer = null;

        public StandardizedMoleculeIterator(MoleculeIterator iterator, Standardizer standardizer) {
            this.iterator = iterator;
            this.standardizer = standardizer;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Molecule next() {
            Molecule next = this.iterator.next();
            next.getSSSR();
            try {
                return this.standardizer == null ? next : this.standardizer.standardize(next);
            }
            catch (SearchException e) {
                return next;
            }
        }

        @Override
        public double estimateProgress() {
            return this.iterator.estimateProgress();
        }

        @Override
        public Throwable getThrowable() {
            return this.iterator.getThrowable();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

