/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.reaction.PatternProperty;
import chemaxon.reaction.ReactantSetEnumeration;
import chemaxon.reaction.ReactantSetEnumeratorFactory;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.Reactor;
import chemaxon.reaction.Standardizer;
import chemaxon.reaction.tester.ReactionExampleTester;
import chemaxon.reaction.util.PropertyInjectorMoleculeIterator;
import chemaxon.struc.Molecule;
import chemaxon.util.CLQ;
import chemaxon.util.ConfigTools;
import chemaxon.util.MolFilter;
import chemaxon.util.concurrent.ConcurrentProcessor;
import chemaxon.util.concurrent.InputProducer;
import chemaxon.util.concurrent.WorkUnit;
import chemaxon.util.concurrent.WorkUnitFactory;
import chemaxon.util.concurrent.processors.ConcurrentProcessors;
import chemaxon.util.concurrent.util.LogUtil;
import chemaxon.util.iterator.MoleculeIterator;
import chemaxon.util.iterator.MoleculeIteratorFactory;
import chemaxon.util.logging.CustomFormatter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class ConcurrentReactorProcessor {
    public static final int MODE_SEQUENTIAL = 0;
    public static final int MODE_COMBINATORIAL = 1;
    private static final int CONCURRENT_PROCESSOR_OUTPUT_QUEUE_SIZE_MULTIPLIER = 40;
    private static final String[] DEFAULT_REACTION_ID_TAGS = new String[]{"Synthesis Code", "NAME"};
    private static final String DEFAULT_CACHE_FORMAT = "mrv";
    private static final double DEFAULT_RESERVED_MEMORY_SIZE = 64.0;
    private static final String CRITICAL_ERROR_MESSAGE = "ERROR: An error occured, check the log for details. Use --ignore-error option to ignore errors during reaction processing.";
    private static final String lineSep = System.getProperty("line.separator");
    private static final String helptext = "Reactor " + VersionInfo.JCHEM_VERSION + ", (C) 1999-2012 ChemAxon Ltd." + lineSep + "Reaction product generator." + lineSep + "Usage:" + lineSep + "  react [input file(s)/string(s)] -r <reaction file/string> [options]" + lineSep + lineSep + "General options: " + lineSep + "  -h, --help                          this help message" + lineSep + "  -s, --reverse                       reverse reaction" + lineSep + "  -z, --transform                     transform mode:" + lineSep + "                                      creates 1-reactant 1-product" + lineSep + "                                      reaction to process all reaction" + lineSep + "                                      centers at the same time" + lineSep + "                                      (deprecated, use Standardizer)" + lineSep + "  -u, --use-cache                     cache search/plugin results" + lineSep + "  -l, --single                        process unambiguous reactions only" + lineSep + "                                      (with each reactant having a single" + lineSep + "                                      active reaction site)" + lineSep + "  -n, --no-rules <type>               ignore reaction rules," + lineSep + "                                      depending on type:" + lineSep + "                                      r  - ignore reactivity rule" + lineSep + "                                      s  - ignore selectivity rule" + lineSep + "                                      t  - ignore selectivity tolerance" + lineSep + "                                      rs - ignore both reactivity and" + lineSep + "                                           selectivity rules" + lineSep + "                                      rt - ignore reactivity rule and" + lineSep + "                                           selectivity tolerance" + lineSep + "  -S, --standardize <file/string>     standardize reactants according to" + lineSep + "                                      configuration" + lineSep + "  -T, --standardize-products <file/string>" + lineSep + "                                      standardize products according to" + lineSep + "                                      configuration" + lineSep + "  -m, --mode <mode>                   processing mode," + lineSep + "                                      valid modes are:" + lineSep + "                                      comb for combinatorial," + lineSep + "                                      seq for sequential" + lineSep + "                                      (default: seq)" + lineSep + "  -X, --ratio <ratio>                 ratio of the reactants (e.g. 1:4:4)" + lineSep + "      --list-reaction-names <filename>" + lineSep + "                                      list reaction names" + lineSep + "      --test-examples <filename>      test reaction examples" + lineSep + lineSep + "Input options:" + lineSep + "  -N, --reaction-name <name>          reaction name" + lineSep + "  -i, --reaction-id <id>              reaction ID" + lineSep + "  -I, --reaction-id-tag <id-tag>      RDF/MRV tag storing the reaction ID" + lineSep + "  -R, --reactant-id-tag <id-tag(s)>   SDF/MRV tag storing the reactant IDs" + lineSep + "                                      a comma-separated list of tags" + lineSep + "                                      if it differs for each reactant" + lineSep + "  -P, --product-id-tag <id-tag(s)>    SDF/MRV tag storing the product IDs" + lineSep + "                                      a comma-separated list of tags" + lineSep + "                                      if it differs for each product" + lineSep + "  -G, --generate-id                   generate ID" + lineSep + "      --copy-reactant-properties      copy reactant properties to output:" + lineSep + "                                      ID->R1ID,LOGP->R1LOGP;ID->R2ID... is the" + lineSep + "                                      comma-separated list of property names," + lineSep + "                                      semicolon separates reactants;" + lineSep + "      --generate-properties           creates pattern-based properties in output" + lineSep + "            Pattern:" + lineSep + "            \"<propertyName>=[<text>*#{<moleculeID>.<propertyID>}]*<text>*\"" + lineSep + "            Where:" + lineSep + "                propertyName - the name of the property in the output file" + lineSep + "                text - may contain anything except \"#{\" and .." + lineSep + "                moleculeID - a text that has a numeric postfix optionally:" + lineSep + "                    Non-numeric postfix - property of the reaction itself" + lineSep + "                    Numeric postfix - index of a reactant " + lineSep + "                                      (indexing starts from 1)" + lineSep + "                propertyID - a property of the input molecule" + lineSep + "            Examples of pattern:" + lineSep + "                \"logP=logP values of reactants: 1st:#{r1.LOGP}, 2nd:#{r2.LOGP}\"" + lineSep + "                \"id=#{Reaction.ID}(#{mol1.ID}, #{mol2.ID}, #{mol3.ID})\"" + lineSep + "                \"corp_ID=#{R.ID}(#{R1.corp_ID}, #{R2.corp_ID}, #{R3.corp_ID})\"" + lineSep + "  -r, --reaction <filepath/string>    reaction file or SMARTS string" + lineSep + "                                      optionally with reaction rules" + lineSep + "  -A, --skip-reaction-mapping-check   skip reaction mapping check" + lineSep + "                                      (default: check reaction mapping)" + lineSep + "  -g, --ignore-error                  continue with next molecule on error" + lineSep + lineSep + "Output options:" + lineSep + "  -f, --format <format>               output file format (default: smiles)" + lineSep + "  -o, --output <filepath>             output file (default: standard output)" + lineSep + "  -p, --pieces <pieces>               number of product lists to be returned" + lineSep + "                                      (default: all)" + lineSep + "  -w, --allow-duplicates              allow product list duplicates for" + lineSep + "                                      efficiency (default: no duplicates)" + lineSep + "  -t, --type <output-type>            output type" + lineSep + "                                      (not available in transform mode):" + lineSep + "                                      product for product array output," + lineSep + "                                      reaction for reaction molecule output," + lineSep + "                                      fused for fused reaction molecule output" + lineSep + "                                      (default: product)" + lineSep + "  -M, --map-result <mapping-style>    output reaction mapping style:" + lineSep + "                                      changing for ChemAxon style" + lineSep + "                                         (map all changing atoms)" + lineSep + "                                      matching for Daylight style" + lineSep + "                                         (map all matching atoms)" + lineSep + "                                      complete for complete mapping" + lineSep + "                                         (map all atoms)" + lineSep + "                                      (default: none)" + lineSep + "  -x, --extract <i1,i2,...>           return only the specified products:" + lineSep + "                                      i1,i2,... is the comma-separated" + lineSep + "                                      list of 1-based product indexes" + lineSep + "                                      according to reaction equation" + lineSep + "  -k, --remove-duplicate-refs         remove duplicate product references" + lineSep + "                                      within product lists" + lineSep + "      --show-unsuccessful-reactions   show unsuccessful reactions" + lineSep + "                                      (reactions which do not result products)" + lineSep + "  -v, --verbose                       verbose output with time results" + lineSep + "      --log <filepath>                write log messages to file" + lineSep + "                                      default: write log to system error" + lineSep + "      --loglevel <level>              sets the log level" + lineSep + "                                      levels: [severe|warning|info|off]" + lineSep + lineSep + "Examples:" + lineSep + "  react a.mol b.mol -r r.rxn" + lineSep + "  react a.sdf b.sdf -r reaction.mrv -m comb --generate-id -f sdf" + lineSep + "  react a.smiles -r \"[H:2][c:1]>>[Br:3][c:1]..s:-charge(ratom(1))\"" + lineSep;
    private Reactor reactor;
    private ReactantSetEnumeration rse;
    private ReactantSetEnumeratorOptions rseopts;
    private boolean initialized = false;
    private double progress = -1.0;
    private ConcurrentProcessor cwup;
    private int workerThreadCount = 0;
    private ReactorResult reactorResult;
    private long processedElementCount;
    private long returnedElementCount;
    private static Logger logger = Logger.getLogger(ConcurrentReactorProcessor.class.getName());

    public void setReactor(Reactor reactor) {
        this.reactor = reactor;
    }

    public void setReactantIterators(MoleculeIterator[] reactantIterators, int mode) throws ReactionException, IOException {
        this.setReactantIterators(reactantIterators, 0, mode, null, null, DEFAULT_CACHE_FORMAT, 64.0, false);
    }

    public void setReactantIterators(MoleculeIterator[] reactantIterators, int mode, String cacheFormat, double reservedMemorySize, boolean ignoreError) throws ReactionException, IOException {
        this.setReactantIterators(reactantIterators, 0, mode, null, null, cacheFormat, reservedMemorySize, ignoreError);
    }

    private void setReactantIterators(MoleculeIterator[] reactantIterators, int numberOfReactants, int mode, MolFilter filter, Standardizer standardizer, String cacheFormat, double reservedMemorySize, boolean ignoreError) throws ReactionException, IOException {
        this.rseopts = new ReactantSetEnumeratorOptions(reactantIterators, numberOfReactants, mode, filter, standardizer, cacheFormat, reservedMemorySize, ignoreError);
    }

    public void setReactantSetEnumerator(ReactantSetEnumeration e) {
        this.rse = e;
    }

    public void initialize() throws ReactionException {
        this.init();
    }

    private void init() throws ReactionException {
        if (!this.initialized) {
            if (this.reactor == null) {
                throw new ReactionException("Reactor is not set.");
            }
            if (this.rse == null && this.rseopts == null) {
                throw new ReactionException("Reactant iterators are not set.");
            }
            if (this.rse == null && this.rseopts != null) {
                this.rse = ReactantSetEnumeratorFactory.createReactantSetEnumerator(this.rseopts.getReactantIterators(), this.reactor.getReactantCount(), this.rseopts.getMode(), this.reactor.isShowUnsuccessfulReactions() ? null : this.reactor.getReactantFilters(), this.reactor.isReverse() ? null : this.reactor.getStandardizer(), this.rseopts.getCacheFormat(), this.rseopts.getReservedMemorySize(), this.rseopts.isIgnoreError());
            }
            if (this.cwup == null) {
                this.cwup = ConcurrentProcessors.create(1, new ReactantSetProducer(this.rse), new ReactorWorkUnitFactory(this.reactor));
                this.cwup.setWorkerThreadCount(this.workerThreadCount);
                if (this.workerThreadCount != 0) {
                    this.cwup.setMaxOutputQueueSize(this.workerThreadCount * 40);
                } else {
                    this.cwup.setMaxOutputQueueSize(Runtime.getRuntime().availableProcessors() * 40);
                }
                try {
                    this.cwup.start();
                }
                catch (ExecutionException e) {
                    throw new ReactionException("Failed starting concurrent processors.", e.getCause());
                }
            }
            this.initialized = true;
        }
    }

    public Molecule[] react() throws ReactionException {
        this.init();
        try {
            while (this.cwup.hasNext() && (this.reactorResult == null || this.reactorResult.isEmpty())) {
                this.reactorResult = (ReactorResult)this.cwup.getNext();
                this.incrementReturnedElementCount();
                if (this.cwup.hasNext() || !this.reactorResult.isEmpty()) continue;
                this.progress = 1.0;
            }
        }
        catch (InterruptedException e) {
            throw new ReactionException("Interrupted.");
        }
        catch (ExecutionException e) {
            throw new ReactionException(e.getCause());
        }
        if (this.reactorResult != null && !this.reactorResult.isEmpty()) {
            Molecule[] reactResult = this.reactorResult.getResultList().removeFirst();
            try {
                if (!this.cwup.hasNext() && this.reactorResult.isEmpty()) {
                    this.progress = 1.0;
                }
            }
            catch (InterruptedException e) {
                throw new ReactionException("Interrupted.");
            }
            catch (ExecutionException e) {
                throw new ReactionException(e.getCause());
            }
            return reactResult;
        }
        return null;
    }

    public List<Molecule[]> reactNext() throws ReactionException {
        this.init();
        try {
            if (this.cwup.hasNext()) {
                this.reactorResult = (ReactorResult)this.cwup.getNext();
                this.incrementReturnedElementCount();
                if (this.reactorResult.isEmpty()) {
                    return this.reactNext();
                }
                return this.reactorResult.getResultList();
            }
            this.progress = 1.0;
            return null;
        }
        catch (InterruptedException e) {
            throw new ReactionException("Interrupted.");
        }
        catch (ExecutionException e) {
            throw new ReactionException(e.getCause());
        }
    }

    public Molecule[] getReactants() {
        return this.reactorResult == null ? null : this.reactorResult.getReactants();
    }

    public void setWorkerThreadCount(int workerThreadCount) {
        this.workerThreadCount = workerThreadCount;
        if (this.cwup != null) {
            this.cwup.setWorkerThreadCount(workerThreadCount);
        }
    }

    private void incrementReturnedElementCount() {
        ++this.returnedElementCount;
    }

    private long getReturnedElementCount() {
        return this.returnedElementCount;
    }

    private synchronized long getProcessedElementCount() {
        return this.processedElementCount;
    }

    public double getProgress() {
        return this.progress == 1.0 ? this.progress : this.rse.getProgress() * (double)this.getReturnedElementCount() / (double)this.getProcessedElementCount();
    }

    private static void run(Reactor reactor, MoleculeIterator[] reactantIterators, int mode, MolExporter exporter, String format2, boolean ignoreError, boolean verbose) throws Exception {
        exporter.setClean(2, null, MolExporter.FILTER_DIM0);
        ConcurrentReactorProcessor crp = new ConcurrentReactorProcessor();
        crp.setReactor(reactor);
        crp.setReactantIterators(reactantIterators, mode, DEFAULT_CACHE_FORMAT, 64.0, ignoreError);
        Molecule[] result = null;
        do {
            try {
                result = crp.react();
            }
            catch (Exception e) {
                if (ignoreError) {
                    logger.log(Level.SEVERE, LogUtil.getInnermostMessage(e), e);
                    continue;
                }
                throw e;
            }
            if (result == null) continue;
            for (int i = 0; i < result.length; ++i) {
                ConfigTools.writeMol(result[i], exporter, ignoreError);
            }
        } while (result != null);
    }

    private static int[] getIntArray(String list) throws NumberFormatException {
        if (list == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(list, ", ");
        int[] inds = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            inds[i++] = Integer.parseInt(st.nextToken());
        }
        return inds;
    }

    private static String[] getStringArray(String list) throws NumberFormatException {
        if (list == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(list, ", ");
        String[] strs = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            strs[i++] = st.nextToken();
        }
        return strs;
    }

    private static Molecule getReactionFromLibrary(String filename, String reactionName) throws IOException, ReactionException {
        MolImporter importer = new MolImporter(filename);
        importer.setQueryMode(true);
        Molecule rxmol = null;
        if (reactionName != null) {
            while ((rxmol = importer.read()) != null && rxmol.getProperty("name") != null && !rxmol.getProperty("name").equalsIgnoreCase(reactionName)) {
            }
            if (rxmol == null) {
                throw new ReactionException("reaction not found: " + reactionName);
            }
            if (!rxmol.isReaction()) {
                throw new ReactionException("reaction is not in rxn format.");
            }
        } else {
            rxmol = importer.read();
            if (rxmol != null && !rxmol.isReaction()) {
                throw new ReactionException("reaction is not in rxn format.");
            }
        }
        importer.close();
        return rxmol;
    }

    private static void listNames(String filename) throws IOException {
        MolImporter importer = new MolImporter(filename);
        Molecule rxmol = null;
        String name = null;
        int count = 0;
        while ((rxmol = importer.read()) != null) {
            name = rxmol.getProperty("name");
            ++count;
            if (name == null) continue;
            System.out.println(count + "\t" + name);
        }
        importer.close();
    }

    private static void closeImporters(MolImporter[] in, Logger logger, boolean ignoreError) throws IOException {
        if (in == null) {
            return;
        }
        for (MolImporter importer : in) {
            try {
                importer.close();
            }
            catch (IOException e) {
                if (ignoreError) {
                    if (!logger.isLoggable(Level.SEVERE)) continue;
                    logger.log(Level.SEVERE, "error while closing " + importer, e);
                    continue;
                }
                throw e;
            }
        }
    }

    private static void closeExporter(MolExporter exporter, Logger logger, boolean ignoreError) throws IOException {
        if (exporter == null) {
            return;
        }
        try {
            exporter.close();
        }
        catch (IOException e) {
            if (ignoreError) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "error while closing " + exporter, e);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        MolExporter exporter;
        MolImporter[] in;
        boolean isExporterCloseable;
        boolean ignoreError;
        Logger logger;
        block70: {
            long t0;
            Reactor reactor;
            MoleculeIterator[] reactantIterators;
            int outputReactionMappingStyle;
            boolean rmduprefs;
            int[] inds;
            Standardizer productStandardizer;
            Standardizer standardizer;
            int mode;
            int type;
            String format2;
            int pieces;
            Map<String, String> patternBasedProperties;
            String[][] targetProperties;
            String[][] sourceProperties;
            boolean copyAllReactantProperties;
            String[] ptags;
            String[] rtags;
            String ridtag;
            boolean verbose;
            int[] ratios;
            int norules;
            boolean showUnsuccessfulReactions;
            boolean single;
            boolean transform;
            boolean reverse;
            boolean cached;
            int duplicateFilteringMethod;
            block69: {
                CLQ.Parameter pTestReactionExamples;
                String reactionFileToTest;
                StreamHandler handler;
                CLQ.Parameter pLogFileName;
                CLQ.Parameter pExtract;
                CLQ.Parameter pStandardizeProducts;
                CLQ.Parameter pPatternReactantProperies;
                boolean generateId;
                String[] sratios;
                CLQ.Parameter pRatio;
                String reactionFileName;
                CLQ clq = new CLQ(args, null);
                if (args.length == 0 || clq.lookup("-h", "--help", "", 1, false, false) != null) {
                    System.out.println(helptext);
                    return;
                }
                logger = Logger.getLogger("chemaxon");
                CLQ.Parameter pListReactionNames = clq.lookup("-L", "--list-reaction-names", "", 2, false, false);
                String string = reactionFileName = pListReactionNames == null ? null : pListReactionNames.getString();
                if (reactionFileName != null) {
                    ConcurrentReactorProcessor.listNames(reactionFileName);
                    return;
                }
                CLQ.Parameter pNonUnique = clq.lookup("-w", "--allow-duplicates", "", 1, false, false);
                boolean unique = pNonUnique == null;
                duplicateFilteringMethod = unique ? 1 : 0;
                CLQ.Parameter pCached = clq.lookup("-u", "--use-cache", "", 1, false, false);
                cached = pCached != null;
                CLQ.Parameter pReverse = clq.lookup("-s", "--reverse", "", 1, false, false);
                reverse = pReverse != null;
                CLQ.Parameter pTransform = clq.lookup("-z", "--transform", "", 1, false, false);
                transform = pTransform != null;
                CLQ.Parameter pSingle = clq.lookup("-l", "--single", "", 1, false, false);
                single = pSingle != null;
                CLQ.Parameter pShowUnsuccessfulReactions = clq.lookup(null, "--show-unsuccessful-reactions", "", 1, false, false);
                showUnsuccessfulReactions = pShowUnsuccessfulReactions != null;
                CLQ.Parameter pNoRules = clq.lookup("-n", "--no-rules", "", 2, false, false);
                norules = 0;
                if (pNoRules != null) {
                    String str = pNoRules.getString().toLowerCase();
                    if (str.indexOf("r") != -1) {
                        norules |= 1;
                    }
                    if (str.indexOf("s") != -1) {
                        norules |= 2;
                    }
                    if (str.indexOf("t") != -1) {
                        norules |= 4;
                    }
                }
                String sratio = (pRatio = clq.lookup("-X", "--ratio", "", 2, false, false)) == null ? null : pRatio.getString().toLowerCase();
                ratios = null;
                if (sratio != null && (sratios = sratio.split(":")).length > 0) {
                    ratios = new int[sratios.length];
                    for (int i = 0; i < sratios.length; ++i) {
                        try {
                            ratios[i] = Integer.parseInt(sratios[i]);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new ReactionException("Ratios are not set correctly: " + sratio);
                        }
                    }
                }
                ignoreError = clq.lookup("-g", "--ignore-error", "", 1, false, false) != null;
                CLQ.Parameter pVerbose = clq.lookup("-v", "--verbose", "", 1, false, false);
                verbose = pVerbose != null;
                CLQ.Parameter pReactionName = clq.lookup("-N", "--reaction-name", "", 2, false, false);
                String rname = pReactionName == null ? null : pReactionName.getString();
                CLQ.Parameter pReactionID = clq.lookup("-i", "--reaction-id", "", 2, false, false);
                String rid = pReactionID == null ? null : pReactionID.getString();
                CLQ.Parameter pReactionIDTag = clq.lookup("-I", "--reaction-id-tag", "", 2, false, false);
                ridtag = pReactionIDTag == null ? null : pReactionIDTag.getString();
                CLQ.Parameter pReactantIDTag = clq.lookup("-R", "--reactant-id-tag", "", 2, false, false);
                rtags = pReactantIDTag == null ? null : ConcurrentReactorProcessor.getStringArray(pReactantIDTag.getString());
                CLQ.Parameter pProductIDTag = clq.lookup("-P", "--product-id-tag", "", 2, false, false);
                ptags = pProductIDTag == null ? null : ConcurrentReactorProcessor.getStringArray(pProductIDTag.getString());
                boolean bl = generateId = clq.lookup("-G", "--generate-id", "", 1, false, false) != null;
                if (!(rtags == null && ptags == null || generateId || rid != null || ridtag != null)) {
                    System.out.println("Reaction ID (--reaction-id or --reaction-id-tag) not specified.");
                    return;
                }
                CLQ.Parameter pCopyReactantProperies = clq.lookup(null, "--copy-reactant-properties", "", 2, false, false);
                copyAllReactantProperties = pCopyReactantProperies != null && pCopyReactantProperies.getString().equals("#");
                sourceProperties = null;
                targetProperties = null;
                if (!copyAllReactantProperties && pCopyReactantProperies != null && ratios == null) {
                    String[] reactantPropertyListsToCopy = pCopyReactantProperies.getString().split(";");
                    String[][] sourceAndTargetProperties = new String[reactantPropertyListsToCopy.length][];
                    sourceProperties = new String[reactantPropertyListsToCopy.length][];
                    targetProperties = new String[reactantPropertyListsToCopy.length][];
                    for (int i = 0; i < reactantPropertyListsToCopy.length; ++i) {
                        sourceAndTargetProperties[i] = reactantPropertyListsToCopy[i].split(",");
                        sourceProperties[i] = new String[sourceAndTargetProperties[i].length];
                        targetProperties[i] = new String[sourceAndTargetProperties[i].length];
                        for (int j = 0; j < sourceAndTargetProperties[i].length; ++j) {
                            int indexOfArrow = sourceAndTargetProperties[i][j].indexOf("->");
                            if (indexOfArrow != -1) {
                                sourceProperties[i][j] = sourceAndTargetProperties[i][j].substring(0, indexOfArrow);
                                targetProperties[i][j] = sourceAndTargetProperties[i][j].substring(indexOfArrow + 2);
                                continue;
                            }
                            sourceProperties[i][j] = sourceAndTargetProperties[i][j];
                        }
                    }
                }
                patternBasedProperties = (pPatternReactantProperies = clq.lookup(null, "--generate-properties", "", 2, false, false)) == null ? null : PatternProperty.parsePatternsOfProperties(pPatternReactantProperies.getString());
                CLQ.Parameter pReaction = clq.lookup("-r", "--reaction", "", 2, false, false);
                String re = pReaction == null ? null : pReaction.getString();
                CLQ.Parameter pSkipReactionMappingCheck = clq.lookup("-A", "--skip-reaction-mapping-check", "", 1, false, false);
                boolean skipReactionMappingCheck = pSkipReactionMappingCheck != null;
                CLQ.Parameter pPieces = clq.lookup("-p", "--pieces", "", 2, false, false);
                pieces = pPieces != null ? pPieces.getInt() : Integer.MAX_VALUE;
                CLQ.Parameter pFormat = clq.lookup("-f", "--format", "", 2, false, false);
                format2 = pFormat == null ? "smiles" : pFormat.getString();
                CLQ.Parameter pType = clq.lookup("-t", "--type", "", 2, false, false);
                String sType = pType == null ? "product" : pType.getString().toLowerCase();
                type = -1;
                if (sType.startsWith("fused")) {
                    type = 4;
                } else if (sType.startsWith("reaction")) {
                    type = 1;
                } else if (sType.startsWith("product")) {
                    type = 0;
                } else {
                    System.out.println("Invalid output type: " + sType + " - should be 'reaction', 'product', or 'fused'.");
                    return;
                }
                CLQ.Parameter pMode = clq.lookup("-m", "--mode", "", 2, false, false);
                String sMode = pMode == null ? "seq" : pMode.getString();
                mode = -1;
                if (sMode.equalsIgnoreCase("seq")) {
                    mode = 0;
                } else if (sMode.equalsIgnoreCase("comb")) {
                    mode = 1;
                } else {
                    System.out.println("Invalid processing mode: " + sMode + " - should be 'seq' or 'comb'.");
                    return;
                }
                CLQ.Parameter pStandardize = clq.lookup("-S", "--standardize", "", 2, false, false);
                String stconfig = pStandardize == null ? null : pStandardize.getString();
                standardizer = null;
                if (stconfig != null) {
                    File file = new File(stconfig);
                    standardizer = file.exists() ? new Standardizer(file) : new Standardizer(stconfig);
                }
                String prodstconfig = (pStandardizeProducts = clq.lookup("-T", "--standardize-products", "", 2, false, false)) == null ? null : pStandardizeProducts.getString();
                productStandardizer = null;
                if (prodstconfig != null) {
                    File file = new File(prodstconfig);
                    productStandardizer = file.exists() ? new Standardizer(file) : new Standardizer(prodstconfig);
                }
                String extract = (pExtract = clq.lookup("-x", "--extract", "", 2, false, false)) != null ? pExtract.getString() : null;
                inds = ConcurrentReactorProcessor.getIntArray(extract);
                CLQ.Parameter pRemoveDupRefs = clq.lookup("-k", "--remove-duplicate-refs", "", 1, false, false);
                rmduprefs = pRemoveDupRefs != null;
                CLQ.Parameter pOutputReactionMappingStyle = clq.lookup("-M", "--map-result", "", 2, false, false);
                String sOutputReactionMappingStyle = pOutputReactionMappingStyle != null ? pOutputReactionMappingStyle.getString() : null;
                outputReactionMappingStyle = 0;
                if (sOutputReactionMappingStyle != null) {
                    if (sOutputReactionMappingStyle.equalsIgnoreCase("changing")) {
                        outputReactionMappingStyle = 1;
                    } else if (sOutputReactionMappingStyle.equalsIgnoreCase("complete")) {
                        outputReactionMappingStyle = 2;
                    } else if (sOutputReactionMappingStyle.equalsIgnoreCase("matching")) {
                        outputReactionMappingStyle = 3;
                    } else {
                        System.out.println("Invalid mapping style: " + sOutputReactionMappingStyle + " - should be 'changing', 'complete' or 'matching'.");
                        return;
                    }
                }
                if ((pLogFileName = clq.lookup(null, "--log", "", 2, false, false)) == null) {
                    handler = new ConsoleHandler();
                    handler.setFormatter(new CustomFormatter());
                    logger.addHandler(handler);
                    logger.setUseParentHandlers(false);
                } else if (pLogFileName != null) {
                    try {
                        handler = new FileHandler(pLogFileName.getString());
                        handler.setFormatter(new CustomFormatter());
                        logger.addHandler(handler);
                        logger.setUseParentHandlers(false);
                        if (logger.isLoggable(Level.CONFIG)) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("react");
                            for (String arg : args) {
                                sb.append(" " + arg);
                            }
                            logger.log(Level.CONFIG, sb.toString());
                        }
                    }
                    catch (IOException e) {
                        System.err.println("Error creating log file: " + pLogFileName.getString());
                    }
                }
                CLQ.Parameter pLogLevel = clq.lookup(null, "--loglevel", "", 2, false, false);
                if (pLogLevel != null) {
                    try {
                        logger.setLevel(Level.parse(pLogLevel.getString().toUpperCase()));
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println("Invalid log level: " + pLogLevel.getString().toUpperCase() + ". Using level " + Level.WARNING + " instead.");
                        logger.setLevel(Level.WARNING);
                    }
                }
                String string2 = reactionFileToTest = (pTestReactionExamples = clq.lookup(null, "--test-examples", "", 2, false, false)) == null ? null : pTestReactionExamples.getString();
                if (reactionFileToTest != null) {
                    if (MFileFormatUtil.isURLOrFileName(reactionFileToTest)) {
                        MolImporter importer = null;
                        try {
                            importer = new MolImporter(reactionFileToTest);
                            System.out.println(ReactionExampleTester.testReactionExamples(importer.getMoleculeIterator()));
                            return;
                        }
                        finally {
                            if (importer != null) {
                                importer.close();
                            }
                        }
                    }
                    System.err.println("Error: Only reaction files can be tested.");
                    return;
                }
                CLQ.Parameter pOutput = clq.lookup("-o", "--output", "", 2, false, false);
                PrintStream out = pOutput == null ? new PrintStream(new BufferedOutputStream(System.out)) : new PrintStream(new BufferedOutputStream(new FileOutputStream(pOutput.getString())));
                isExporterCloseable = pOutput != null;
                in = null;
                exporter = null;
                ArrayList<String> inputFilesAndMols = new ArrayList<String>();
                for (MolImporter importer : in = ConfigTools.getTargetMolImporters(clq, inputFilesAndMols)) {
                    importer.setThreadCount(1);
                }
                reactantIterators = MoleculeIteratorFactory.getMoleculeIterators(in);
                if (generateId) {
                    if (rtags == null) {
                        for (int i = 0; i < reactantIterators.length; ++i) {
                            if (i < inputFilesAndMols.size()) {
                                if (MFileFormatUtil.isURLOrFileName(inputFilesAndMols.get(i))) {
                                    String filename = new File(inputFilesAndMols.get(i)).getName();
                                    reactantIterators[i] = new PropertyInjectorMoleculeIterator(reactantIterators[i], "Synthesis Code", filename + "#", true);
                                    continue;
                                }
                                reactantIterators[i] = new PropertyInjectorMoleculeIterator(reactantIterators[i], "Synthesis Code", inputFilesAndMols.get(i), false);
                                continue;
                            }
                            reactantIterators[i] = new PropertyInjectorMoleculeIterator(reactantIterators[i], "Synthesis Code", "INPUT" + i + "#", true);
                        }
                        rtags = new String[]{"Synthesis Code"};
                    }
                    if (ptags == null) {
                        ptags = new String[]{"Synthesis Code"};
                    }
                }
                exporter = new MolExporter(out, format2);
                reactor = new Reactor();
                t0 = System.currentTimeMillis();
                reactor.setSkipReactionMappingCheck(skipReactionMappingCheck);
                Molecule reaction = null;
                if (re == null) throw new ReactionException("no reaction is given");
                if (MFileFormatUtil.isURLOrFileName(re)) {
                    reaction = ConcurrentReactorProcessor.getReactionFromLibrary(re, rname);
                    reactor.setReaction(reaction, rid);
                } else {
                    reactor.setReactionString(re, rid);
                }
                if (rid != null || ridtag != null || !generateId) break block69;
                for (String tag : DEFAULT_REACTION_ID_TAGS) {
                    if (reaction.getProperty(tag) == null) continue;
                    ridtag = tag;
                }
                if (ridtag != null) break block69;
                System.out.println("Reaction ID (--reaction-id or --reaction-id-tag) not specified.");
                ConcurrentReactorProcessor.closeImporters(in, logger, ignoreError);
                if (!isExporterCloseable) return;
                ConcurrentReactorProcessor.closeExporter(exporter, logger, ignoreError);
                return;
            }
            try {
                reactor.setReactionIDPropertyName(ridtag);
                reactor.setIgnoreRules(norules);
                reactor.setSingle(single);
                reactor.setShowUnsuccessfulReactions(showUnsuccessfulReactions);
                reactor.setDuplicateFiltering(pieces > 1 ? duplicateFilteringMethod : 0);
                reactor.setRemoveDuplicateProductReferences(rmduprefs);
                reactor.setCached(cached);
                reactor.setReverse(reverse);
                reactor.setTransform(transform);
                reactor.setComponentIDPropertyNames(rtags, ptags);
                if (copyAllReactantProperties) {
                    reactor.setCopyAllReactantProperties(true);
                } else {
                    reactor.setCopyReactantProperties(sourceProperties, targetProperties);
                }
                reactor.setCopyReactantProperties(patternBasedProperties);
                reactor.setMaxNumberOfProductSets(pieces);
                reactor.setProductIndexes(inds);
                reactor.setResultType(type);
                reactor.setOutputReactionMappingStyle(outputReactionMappingStyle);
                reactor.setRatio(ratios);
                if (standardizer != null) {
                    reactor.setStandardizer(standardizer);
                }
                if (productStandardizer != null) {
                    reactor.setProductStandardizer(productStandardizer);
                }
                long t1 = System.currentTimeMillis();
                ConcurrentReactorProcessor.run(reactor, reactantIterators, mode, exporter, format2, ignoreError, verbose);
                long t2 = System.currentTimeMillis();
                if (!verbose) break block70;
                System.err.println("Total running time (ms) : " + (t2 - t0));
                System.err.println("Reaction setting (ms)   : " + (t1 - t0));
                System.err.println("Reaction processing (ms): " + (t2 - t1));
            }
            catch (Exception e) {
                try {
                    logger.log(Level.SEVERE, LogUtil.getInnermostMessage(e), e);
                    System.err.println(CRITICAL_ERROR_MESSAGE);
                }
                catch (Throwable throwable) {
                    ConcurrentReactorProcessor.closeImporters(in, logger, ignoreError);
                    if (!isExporterCloseable) throw throwable;
                    ConcurrentReactorProcessor.closeExporter(exporter, logger, ignoreError);
                    throw throwable;
                }
                ConcurrentReactorProcessor.closeImporters(in, logger, ignoreError);
                if (!isExporterCloseable) return;
                ConcurrentReactorProcessor.closeExporter(exporter, logger, ignoreError);
                return;
            }
        }
        ConcurrentReactorProcessor.closeImporters(in, logger, ignoreError);
        if (!isExporterCloseable) return;
        ConcurrentReactorProcessor.closeExporter(exporter, logger, ignoreError);
        return;
    }

    private class ReactorResult {
        private Molecule[] reactants;
        private LinkedList<Molecule[]> resultList = new LinkedList();

        public ReactorResult(Molecule[] reactants, LinkedList<Molecule[]> productSetList) {
            this.reactants = reactants;
            this.resultList = productSetList;
        }

        public Molecule[] getReactants() {
            return this.reactants;
        }

        public LinkedList<Molecule[]> getResultList() {
            return this.resultList;
        }

        public boolean isEmpty() {
            return this.resultList.isEmpty();
        }
    }

    private class ReactorWorkUnitFactory
    implements WorkUnitFactory {
        Reactor reactor;

        public ReactorWorkUnitFactory(Reactor reactor) {
            this.reactor = reactor;
        }

        @Override
        public synchronized WorkUnit createWorkUnit() throws Exception {
            return new ReactorWorkUnit(this.reactor);
        }
    }

    private class ReactorWorkUnit
    implements WorkUnit {
        private Reactor reactor;

        public ReactorWorkUnit(Reactor reactor) {
            this.reactor = reactor.newInstance();
        }

        private synchronized void incrementProcessedElementCount() {
            ConcurrentReactorProcessor.this.processedElementCount++;
        }

        @Override
        public void setInput(Object obj) throws ExecutionException {
            try {
                this.reactor.setReactants((Molecule[])obj);
            }
            catch (ReactionException e) {
                throw new ExecutionException(e);
            }
        }

        public Object call() throws Exception {
            Molecule[] reactResult;
            LinkedList<Molecule[]> productSetList = new LinkedList<Molecule[]>();
            while ((reactResult = this.reactor.react()) != null) {
                productSetList.add(reactResult);
            }
            this.incrementProcessedElementCount();
            return new ReactorResult(this.reactor.getReactants(), productSetList);
        }
    }

    private class ReactantSetProducer
    implements InputProducer<Molecule[]> {
        private ReactantSetEnumeration e;

        public ReactantSetProducer(ReactantSetEnumeration e) {
            this.e = e;
        }

        @Override
        public boolean hasNext() throws InterruptedException, ExecutionException {
            return this.e.hasNext();
        }

        @Override
        public Molecule[] getNext() throws InterruptedException, ExecutionException {
            return this.e.next();
        }
    }

    private static class ReactantSetEnumeratorOptions {
        private final MoleculeIterator[] reactantIterators;
        private final int numberOfReactants;
        private final int mode;
        private final MolFilter filter;
        private final Standardizer standardizer;
        private final String cacheFormat;
        private final double reservedMemorySize;
        private final boolean ignoreError;

        public ReactantSetEnumeratorOptions(MoleculeIterator[] reactantIterators, int numberOfReactants, int mode, MolFilter filter, Standardizer standardizer, String cacheFormat, double reservedMemorySize, boolean ignoreError) throws ReactionException {
            if (Arrays.asList(reactantIterators).contains(null)) {
                throw new ReactionException("Reactant iterator is null.");
            }
            this.reactantIterators = reactantIterators;
            this.numberOfReactants = numberOfReactants;
            this.mode = mode;
            this.filter = filter;
            this.standardizer = standardizer;
            this.cacheFormat = cacheFormat;
            this.reservedMemorySize = reservedMemorySize;
            this.ignoreError = ignoreError;
        }

        public MoleculeIterator[] getReactantIterators() {
            return this.reactantIterators;
        }

        public int getNumberOfReactants() {
            return this.numberOfReactants;
        }

        public int getMode() {
            return this.mode;
        }

        public MolFilter getFilter() {
            return this.filter;
        }

        public Standardizer getStandardizer() {
            return this.standardizer;
        }

        public String getCacheFormat() {
            return this.cacheFormat;
        }

        public double getReservedMemorySize() {
            return this.reservedMemorySize;
        }

        public boolean isIgnoreError() {
            return this.ignoreError;
        }
    }
}

