/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFileHandler;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.MRecordReader;
import chemaxon.reaction.Standardizer;
import chemaxon.reaction.StandardizerException;
import chemaxon.struc.Molecule;
import chemaxon.util.CLQ;
import chemaxon.util.ConfigTools;
import chemaxon.util.MolHandler;
import chemaxon.util.MolTransformer;
import chemaxon.util.concurrent.ConcurrentProcessor;
import chemaxon.util.concurrent.InputProducer;
import chemaxon.util.concurrent.WorkUnit;
import chemaxon.util.concurrent.WorkUnitFactory;
import chemaxon.util.concurrent.processors.ConcurrentProcessors;
import chemaxon.util.concurrent.util.LogUtil;
import chemaxon.util.iterator.MoleculeIterator;
import chemaxon.util.iterator.MoleculeIteratorChain;
import chemaxon.util.iterator.MoleculeIteratorFactory;
import chemaxon.util.logging.CustomFormatter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class ConcurrentStandardizerProcessor {
    public static final int PREPROCESS_SET_DIM_0 = 1;
    public static final MolTransformer TRANSFORMER_SET_DIM_0 = new MolTransformer(){

        @Override
        public Molecule transform(Molecule mol) {
            mol.setDim(0);
            return mol;
        }
    };
    private static final String CRITICAL_ERROR_MESSAGE = "ERROR: An error occured during standardization, check the log for details. Use the --ignore-error option to ignore errors.";
    private static final String STANDARDIZER_EXCEPTION_PROPERTY_NAME = "STANDARDIZER_EXCEPTION";
    private static final Logger logger = Logger.getLogger(ConcurrentStandardizerProcessor.class.getName());
    private static final String lineSep = System.getProperty("line.separator");
    private static final String helptext = "Standardizer " + VersionInfo.JCHEM_VERSION + ", (C) 1999-2012 ChemAxon Ltd." + lineSep + "Molecule standardizer." + lineSep + "Usage:" + lineSep + "  standardize [input file(s)/string(s)] -c <config file/string> [options]" + lineSep + lineSep + "General options: " + lineSep + "  -h, --help                          this help message" + lineSep + "  -g, --ignore-error                  continue with next molecule on error" + lineSep + "      --empty-mol-on-error            write an empty molecule, and continue" + lineSep + "                                      with next molecule on error" + lineSep + "      --unstandardized-mol-on-error   write the original molecule, and continue" + lineSep + "                                      with next molecule on error" + lineSep + lineSep + "Input options:" + lineSep + "  -c, --config <filepath|string>      configuration XML file" + lineSep + "                                      or action string," + lineSep + "                                      actions separated by \"..\"," + lineSep + "                                      valid actions are:" + lineSep + "                                      - reaction SMARTS" + lineSep + "                                      - \"aromatize\" (Daylight, general)" + lineSep + "                                      - \"aromatize:b\" (ChemAxon, basic)" + lineSep + "                                      - \"aromatize:l\" (loose)" + lineSep + "                                      - \"dearomatize\"" + lineSep + "                                      - \"addexplicitH\" (\"hydrogenize\")" + lineSep + "                                        (converts implicit H-s to explicit)" + lineSep + "                                      - \"removeexplicitH[:lonely:isotope:" + lineSep + "                                        charged:radical:mapped:wedged]\"" + lineSep + "                                        (\"dehydrogenize\")" + lineSep + "                                        (converts explicit H-s to implicit," + lineSep + "                                        except for lonely, isotope, charged," + lineSep + "                                        radical, mapped and wedged H-s;" + lineSep + "                                        if some of these are specified in a" + lineSep + "                                        ':'-separated list, then the given" + lineSep + "                                        H types are also converted)" + lineSep + "                                      - \"clearisotopes\"" + lineSep + "                                        (converts isotopes to non-isotopic form)" + lineSep + "                                      - \"neutralize\" (neutralize molecule)" + lineSep + "                                      - \"clean\" (partial clean in 2D)" + lineSep + "                                      - \"clean:full\" (full clean in 2D)" + lineSep + "                                      - \"clean:removezcoordinate\"" + lineSep + "                                        (remove Z coordinate)" + lineSep + "                                      - \"clean:<template file>\"" + lineSep + "                                        (template based clean in 2D)" + lineSep + "                                      - \"clean:3\" (clean in 3D)" + lineSep + "                                      - \"aliastogroup\" (converts pseudo" + lineSep + "                                        and alias atoms to groups)" + lineSep + "                                      - \"aliastoatom\" (converts pseudo and" + lineSep + "                                        alias atoms to normal atoms)" + lineSep + "                                      - \"keepone\" (largest atom count)" + lineSep + "                                      - \"keepone:mass\" (largest mass)" + lineSep + "                                      - \"removergroupdefinitions\"" + lineSep + "                                        (remove R-group definitions)" + lineSep + "                                      - \"removeatomvalues\"" + lineSep + "                                        (remove atom values)" + lineSep + "                                      - \"removeattacheddata\"" + lineSep + "                                        (remove attached data)" + lineSep + "                                      - \"sgroups:contract\" (contract Sgroups)" + lineSep + "                                      - \"sgroups:expand\" (expand Sgroups)" + lineSep + "                                      - \"sgroups:ungroup\" (ungroup Sgroups)" + lineSep + "                                      - \"clearstereo\" (chirality, double bond)" + lineSep + "                                      - \"clearstereo:chirality\" (chirality)" + lineSep + "                                      - \"clearstereo:doublebond\" (double bond)" + lineSep + "                                      - \"clearstereo:singleupordownbond\"" + lineSep + "                                        (single up or down bond)" + lineSep + "                                      - \"absolutestereo:clear\"" + lineSep + "                                        (clear absolute stereo flag)" + lineSep + "                                      - \"absolutestereo:set\"" + lineSep + "                                        (set absolute stereo flag)" + lineSep + "                                      - \"converttoenhancedstereo:abs\"" + lineSep + "                                        (converts to enhanced stereo, unlabeled" + lineSep + "                                         stereo atoms go into a new \"abs\" group)" + lineSep + "                                      - \"converttoenhancedstereo:and\"" + lineSep + "                                        (converts to enhanced stereo, unlabeled" + lineSep + "                                         stereo atoms go into a new \"and\" group)" + lineSep + "                                      - \"converttoenhancedstereo:or\"" + lineSep + "                                        (converts to enhanced stereo, unlabeled" + lineSep + "                                         stereo atoms go into a new \"or\" group)" + lineSep + "                                      - \"wedgeclean\"" + lineSep + "                                        (rearranges stereo wedges according to" + lineSep + "                                        the IUPAC recommendations)" + lineSep + "                                      - \"convertwedgeinterpretation\"" + lineSep + "                                        (converts each wedge between two stereo" + lineSep + "                                        centers into two wedges)" + lineSep + "                                      - \"convertdoublebonds:wiggly\"" + lineSep + "                                        (converts double bonds with unspecified" + lineSep + "                                        CIS/TRANS stereo information to wiggly" + lineSep + "                                        representation)" + lineSep + "                                      - \"convertdoublebonds:crossed\"" + lineSep + "                                        (converts double bonds with unspecified" + lineSep + "                                        CIS/TRANS stereo information to crossed" + lineSep + "                                        representation)" + lineSep + "                                      - \"removestereocarebox\"" + lineSep + "                                        (remove stereo search markers from" + lineSep + "                                         double bonds)" + lineSep + "                                      - \"tautomerize\"" + lineSep + "                                        (take canonical tautomer form)" + lineSep + "                                      - \"mesomerize\"" + lineSep + "                                        (take canonical mesomer form)" + lineSep + "                                      - \"mapreaction\"" + lineSep + "                                        (add atom maps to reaction)" + lineSep + "                                      - \"map\"" + lineSep + "                                        (add atom maps)" + lineSep + "                                      - \"unmap\"" + lineSep + "                                        (remove atom maps)" + lineSep + lineSep + "Output options:" + lineSep + "  -f, --format <format>               output file format (default: smiles)" + lineSep + "  -o, --output <filepath>             output file (default: standard output)" + lineSep + "  -e, --export-fields-to-smiles       export property fields to SMILES" + lineSep + "  -v, --verbose                       verbose output with time results" + lineSep + "      --log <filepath>                write log messages to file" + lineSep + "                                      default: write log to system error" + lineSep + "      --loglevel <level>              sets the log level" + lineSep + "                                      levels: [severe|warning|info|off]" + lineSep + lineSep + "Examples:" + lineSep + "  standardize in.sdf -c \"keepone..aromatize..[O-][N+]=O>>O=N=O\"" + lineSep + "  standardize in.sdf -c \"aromatize..clean:templates.sdf\"" + lineSep + "  standardize in.sdf -c Standardizer.xml -f sdf -o o.sdf";
    private Standardizer standardizer;
    private MoleculeIterator molIterator;
    private ConcurrentProcessor cwup;
    private int workerThreadCount = 0;
    private MolTransformer preprocessor = null;
    private boolean initialized = false;
    private StandardizerResultData standardizerResultData = null;
    private boolean storeAppliedTaskData = false;
    private long processedElementCount;
    private long returnedElementCount;
    private long errorCount;

    public void setStandardizer(Standardizer standardizer) {
        this.standardizer = standardizer;
        this.initialized = false;
    }

    public void setMoleculeIterator(MoleculeIterator iterator) {
        this.molIterator = iterator;
        this.initialized = false;
    }

    public void setWorkerThreadCount(int workerThreadCount) {
        this.workerThreadCount = workerThreadCount;
        if (this.cwup != null) {
            this.cwup.setWorkerThreadCount(workerThreadCount);
        }
    }

    public void setPreprocessing(int f) {
    }

    public void setPreprocessor(MolTransformer tr) {
        this.preprocessor = tr;
    }

    private Molecule preprocess(Molecule mol) {
        return this.preprocessor == null ? mol : this.preprocessor.transform(mol);
    }

    private void init() throws StandardizerException {
        if (!this.initialized) {
            this.processedElementCount = 0L;
            this.returnedElementCount = 0L;
            this.errorCount = 0L;
            if (this.standardizer == null) {
                throw new StandardizerException("Standardizer is not set.");
            }
            if (this.molIterator == null) {
                throw new StandardizerException("Molecule iterator is not set.");
            }
            this.cwup = ConcurrentProcessors.create(1, new MolInputProducer(this.molIterator), new StandardizerWorkUnitFactory(this.standardizer));
            this.cwup.setWorkerThreadCount(this.workerThreadCount);
            try {
                this.cwup.start();
            }
            catch (ExecutionException e) {
                throw new StandardizerException("Starting concurrent executor threads failed or concurrent processing error.", e);
            }
            this.initialized = true;
        }
    }

    public Molecule standardize() throws StandardizerException {
        this.init();
        try {
            if (this.cwup.hasNext()) {
                if (this.storeAppliedTaskData) {
                    this.standardizerResultData = (StandardizerResultData)this.cwup.getNext();
                    if (this.standardizerResultData.getException() != null) {
                        Exception e = this.standardizerResultData.getException();
                        if (e instanceof StandardizerException) {
                            throw (StandardizerException)e;
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                    }
                    this.incrementReturnedElementCount();
                    return this.standardizerResultData.getStandardizedMolecule();
                }
                Molecule mol = (Molecule)this.cwup.getNext();
                this.incrementReturnedElementCount();
                return mol;
            }
            this.initialized = false;
            return null;
        }
        catch (StandardizerException e) {
            this.incrementErrorCount();
            throw e;
        }
        catch (InterruptedException e) {
            this.incrementErrorCount();
            throw new StandardizerException("Interrupted.", e);
        }
        catch (ExecutionException e) {
            this.incrementErrorCount();
            throw new StandardizerException(e);
        }
        catch (RuntimeException e) {
            this.incrementErrorCount();
            throw e;
        }
    }

    private void incrementReturnedElementCount() {
        ++this.returnedElementCount;
    }

    private long getReturnedElementCount() {
        return this.returnedElementCount;
    }

    private void incrementErrorCount() {
        ++this.errorCount;
    }

    private long getErrorCount() {
        return this.errorCount;
    }

    private synchronized long getProcessedElementCount() {
        return this.processedElementCount;
    }

    public double getProgress() {
        return this.molIterator.estimateProgress() * (double)this.getReturnedElementCount() / (double)this.getProcessedElementCount();
    }

    public void setStoreAppliedTaskData(boolean store) {
        this.storeAppliedTaskData = store;
    }

    public Molecule getInputMolecule() {
        return this.standardizerResultData.getInputMolecule();
    }

    public int[] getAppliedTaskIndexes() {
        return this.standardizerResultData.getAppliedTaskIndexes();
    }

    public String[] getAppliedTaskIDs() {
        return this.standardizerResultData.getAppliedTaskIDs();
    }

    private static String[] collectFields(MolImporter[] in, int maxRecords, boolean ignoreError) throws IOException, MRecordParseException {
        ArrayList fieldsList = new ArrayList();
        for (int i = 0; i < in.length; ++i) {
            MolImporter importer = in[i];
            String filename = importer.getFileName();
            if (filename == null) continue;
            Vector fieldsVector = new Vector();
            try {
                MRecordReader mrr = MolFileHandler.collectFileInfo(new FileInputStream(filename), maxRecords, fieldsVector);
                mrr.close();
            }
            catch (IOException e) {
                if (ignoreError) continue;
                throw e;
            }
            for (int j = 0; j < fieldsVector.size(); ++j) {
                if (fieldsList.contains(fieldsVector.elementAt(j))) continue;
                fieldsList.add(fieldsVector.elementAt(j));
            }
        }
        String[] fields = new String[fieldsList.size()];
        fieldsList.toArray(fields);
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(Standardizer standardizer, MolImporter[] importers, PrintStream out, String format2, boolean exportFieldsToSmiles, boolean ignoreError, boolean emptyMolOnError, boolean unstandardizedMolOnError, boolean verbose, boolean singleThread) throws Exception {
        block33: {
            long t0 = System.currentTimeMillis();
            MoleculeIteratorChain iterator = new MoleculeIteratorChain(MoleculeIteratorFactory.getMoleculeIterators(importers));
            String[] fields = null;
            if (exportFieldsToSmiles && MolHandler.isDaylightFormat(format2)) {
                fields = ConcurrentStandardizerProcessor.collectFields(importers, 500, ignoreError);
            }
            MolExporter exporter = new MolExporter(out, format2, false, fields);
            boolean cleanable = MFileFormatUtil.isOutputCleanable(format2);
            if (cleanable && !standardizer.isLastTaskClean()) {
                standardizer.setFinalClean();
            }
            standardizer.setFinalStereoFix(cleanable);
            try {
                if (!singleThread) {
                    ConcurrentStandardizerProcessor csp = new ConcurrentStandardizerProcessor();
                    csp.setStandardizer(standardizer);
                    csp.setMoleculeIterator(iterator);
                    csp.setStoreAppliedTaskData(unstandardizedMolOnError);
                    Molecule mol = null;
                    do {
                        try {
                            mol = csp.standardize();
                        }
                        catch (Exception e) {
                            if (ignoreError || emptyMolOnError || unstandardizedMolOnError) {
                                if (emptyMolOnError || unstandardizedMolOnError) {
                                    Molecule outMol = unstandardizedMolOnError ? csp.getInputMolecule() : new Molecule();
                                    outMol.setProperty(STANDARDIZER_EXCEPTION_PROPERTY_NAME, LogUtil.getInnermostMessage(e));
                                    ConfigTools.writeMol(outMol, exporter, ignoreError);
                                }
                                logger.log(Level.SEVERE, "Error at molecule No. " + (csp.getReturnedElementCount() + csp.getErrorCount()) + ": " + LogUtil.getInnermostMessage(e), e);
                                continue;
                            }
                            throw e;
                        }
                        if (mol == null) continue;
                        ConfigTools.writeMol(mol, exporter, ignoreError || emptyMolOnError || unstandardizedMolOnError);
                    } while (mol != null);
                } else {
                    Molecule mol = null;
                    Molecule clone = null;
                    int processedElementCount = 0;
                    while (iterator.hasNext()) {
                        mol = iterator.next();
                        if (unstandardizedMolOnError) {
                            clone = mol.cloneMolecule();
                        }
                        try {
                            ++processedElementCount;
                            standardizer.standardize(mol);
                        }
                        catch (Exception e) {
                            if (ignoreError || emptyMolOnError || unstandardizedMolOnError) {
                                if (emptyMolOnError || unstandardizedMolOnError) {
                                    Molecule outMol = unstandardizedMolOnError ? clone : new Molecule();
                                    outMol.setProperty(STANDARDIZER_EXCEPTION_PROPERTY_NAME, LogUtil.getInnermostMessage(e));
                                    ConfigTools.writeMol(outMol, exporter, ignoreError || emptyMolOnError || unstandardizedMolOnError);
                                }
                                logger.log(Level.SEVERE, "Error at molecule No. " + processedElementCount + ": " + LogUtil.getInnermostMessage(e), e);
                                continue;
                            }
                            throw e;
                        }
                        if (mol == null) continue;
                        ConfigTools.writeMol(mol, exporter, ignoreError || emptyMolOnError || unstandardizedMolOnError);
                    }
                }
                long t1 = System.currentTimeMillis();
                if (!verbose) break block33;
                System.err.println("\nTotal running time (ms): " + (t1 - t0));
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, LogUtil.getInnermostMessage(e), e);
                System.err.println(CRITICAL_ERROR_MESSAGE);
            }
            finally {
                block34: {
                    try {
                        exporter.close();
                    }
                    catch (Throwable t) {
                        System.err.println("Error while closing " + exporter);
                        if (!logger.isLoggable(Level.SEVERE)) break block34;
                        logger.log(Level.SEVERE, "Error while closing " + exporter, t);
                    }
                }
                for (MolImporter importer : importers) {
                    try {
                        importer.close();
                    }
                    catch (Throwable t) {
                        System.err.println("Error while closing " + importer);
                        if (!logger.isLoggable(Level.SEVERE)) continue;
                        logger.log(Level.SEVERE, "Error while closing " + importer, t);
                    }
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        CLQ.Parameter pOutput;
        StreamHandler handler;
        StringTokenizer st;
        int count;
        CLQ clq = new CLQ(args, null);
        if (args.length == 0 || clq.lookup("-h", "--help", "", 1, false, false) != null) {
            System.out.println(helptext);
            return;
        }
        Logger logger = Logger.getLogger("chemaxon");
        CLQ.Parameter pVerbose = clq.lookup("-v", "--verbose", "", 1, false, false);
        boolean verbose = pVerbose != null;
        CLQ.Parameter pSingleThread = clq.lookup("-s", "--single-thread", "", 1, false, false);
        boolean singleThread = pSingleThread != null;
        CLQ.Parameter pGroups = clq.lookup("-u", "--active-groups", "", 2, false, false);
        String groupsStr = pGroups != null ? pGroups.getString() : null;
        String[] groups = null;
        if (groupsStr != null && (count = (st = new StringTokenizer(groupsStr, ", \t")).countTokens()) > 0) {
            groups = new String[count];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = st.nextToken().toLowerCase();
            }
        }
        CLQ.Parameter pConfig = clq.lookup("-c", "--config", "", 2, true, false);
        String config = pConfig.getString();
        CLQ.Parameter pMappingStyle = clq.lookup("-a", "--mapping-style", "", 2, false, false);
        boolean ignoreError = clq.lookup("-g", "--ignore-error", "", 1, false, false) != null;
        boolean emptyMolOnError = clq.lookup(null, "--empty-mol-on-error", "", 1, false, false) != null;
        boolean unstandardizedMolOnError = clq.lookup(null, "--unstandardized-mol-on-error", "", 1, false, false) != null;
        CLQ.Parameter pFormat = clq.lookup("-f", "--format", "", 2, false, false);
        String format2 = pFormat == null ? "smiles" : pFormat.getString();
        CLQ.Parameter pExportFieldsToSmiles = clq.lookup("-e", "--export-fields-to-smiles", "", 1, false, false);
        boolean exportFieldsToSmiles = pExportFieldsToSmiles != null;
        CLQ.Parameter pLogFileName = clq.lookup(null, "--log", "", 2, false, false);
        CLQ.Parameter parameter = pLogFileName = pLogFileName == null ? clq.lookup(null, "--logfile", "", 2, false, false) : pLogFileName;
        if (pLogFileName == null) {
            handler = new ConsoleHandler();
            handler.setFormatter(new CustomFormatter());
            logger.addHandler(handler);
            logger.setUseParentHandlers(false);
        } else if (pLogFileName != null) {
            try {
                handler = new FileHandler(pLogFileName.getString());
                handler.setFormatter(new CustomFormatter());
                logger.addHandler(handler);
                logger.setUseParentHandlers(false);
                if (logger.isLoggable(Level.CONFIG)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("standardize");
                    for (String arg : args) {
                        sb.append(" " + arg);
                    }
                    logger.log(Level.CONFIG, sb.toString());
                }
            }
            catch (IOException e) {
                System.err.println("Error creating log file: " + pLogFileName.getString());
            }
        }
        CLQ.Parameter pLogLevel = clq.lookup(null, "--loglevel", "", 2, false, false);
        if (pLogLevel != null) {
            try {
                logger.setLevel(Level.parse(pLogLevel.getString().toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid log level: " + pLogLevel.getString().toUpperCase() + ". Using level " + Level.WARNING + " instead.");
                logger.setLevel(Level.WARNING);
            }
        }
        PrintStream out = (pOutput = clq.lookup("-o", "--output", "", 2, false, false)) == null ? new PrintStream(new BufferedOutputStream(System.out)) : new PrintStream(new BufferedOutputStream(new FileOutputStream(pOutput.getString())));
        Standardizer standardizer = null;
        File file = new File(config);
        standardizer = file.exists() ? new Standardizer(file) : new Standardizer(config);
        standardizer.setActiveGroups(groups);
        MolImporter[] importers = ConfigTools.getTargetMolImporters(clq);
        ConcurrentStandardizerProcessor.run(standardizer, importers, out, format2, exportFieldsToSmiles, ignoreError, emptyMolOnError, unstandardizedMolOnError, verbose, singleThread);
    }

    private class StandardizerResultData {
        private Molecule standardizedMolecule;
        private Molecule inputMolecule;
        private int[] appliedTaskIndexes;
        private String[] appliedTaskIDs;
        private Exception exception;

        private StandardizerResultData() {
        }

        Molecule getStandardizedMolecule() {
            return this.standardizedMolecule;
        }

        void setStandardizedMolecule(Molecule standardizedMolecule) {
            this.standardizedMolecule = standardizedMolecule;
        }

        Molecule getInputMolecule() {
            return this.inputMolecule;
        }

        void setInputMolecule(Molecule inputMolecule) {
            this.inputMolecule = inputMolecule;
        }

        int[] getAppliedTaskIndexes() {
            return this.appliedTaskIndexes;
        }

        void setAppliedTaskIndexes(int[] appliedTaskIndexes) {
            this.appliedTaskIndexes = appliedTaskIndexes;
        }

        String[] getAppliedTaskIDs() {
            return this.appliedTaskIDs;
        }

        void setAppliedTaskIDs(String[] appliedTaskIDs) {
            this.appliedTaskIDs = appliedTaskIDs;
        }

        Exception getException() {
            return this.exception;
        }

        void setException(Exception e) {
            this.exception = e;
        }
    }

    private class StandardizerWorkUnitFactory
    implements WorkUnitFactory {
        Standardizer standardizer;

        StandardizerWorkUnitFactory(Standardizer standardizer) {
            this.standardizer = standardizer;
        }

        @Override
        public WorkUnit createWorkUnit() throws Exception {
            return new StandardizerWorkUnit(this.standardizer);
        }
    }

    private class StandardizerWorkUnit
    implements WorkUnit {
        private Standardizer standardizer;
        private Molecule mol;
        private StandardizerResultData standardizerResultData;

        StandardizerWorkUnit(Standardizer standardizer) {
            this.standardizer = Standardizer.newInstance(standardizer);
        }

        private synchronized void incrementProcessedElementCount() {
            ConcurrentStandardizerProcessor.this.processedElementCount++;
        }

        @Override
        public void setInput(Object obj) throws ExecutionException {
            this.mol = (Molecule)obj;
        }

        public Object call() throws Exception {
            if (ConcurrentStandardizerProcessor.this.storeAppliedTaskData) {
                this.standardizerResultData = new StandardizerResultData();
                this.standardizerResultData.setInputMolecule(this.mol.cloneMolecule());
                try {
                    this.standardizerResultData.setStandardizedMolecule(this.standardizer.standardize(ConcurrentStandardizerProcessor.this.preprocess(this.mol)));
                }
                catch (Exception e) {
                    this.standardizerResultData.setException(e);
                }
                this.standardizerResultData.setAppliedTaskIndexes(this.standardizer.getAppliedTaskIndexes());
                this.standardizerResultData.setAppliedTaskIDs(this.standardizer.getAppliedTaskIDs());
                this.incrementProcessedElementCount();
                return this.standardizerResultData;
            }
            this.mol = this.standardizer.standardize(ConcurrentStandardizerProcessor.this.preprocess(this.mol));
            this.incrementProcessedElementCount();
            return this.mol;
        }
    }

    private class MolInputProducer
    implements InputProducer {
        private MoleculeIterator it;

        MolInputProducer(MoleculeIterator it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() throws InterruptedException, ExecutionException {
            return this.it.hasNext();
        }

        @Override
        public Object getNext() throws InterruptedException, ExecutionException {
            return this.it.next();
        }
    }
}

