/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.reaction.EqualableMoleculeArray;
import chemaxon.sss.screen.HashCode;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EqualableMolecule
extends Molecule {
    private static final Logger logger = Logger.getLogger(EqualableMolecule.class.getName());
    private static final int HASHCODE_RECURSION_LEVEL = 15;
    private Molecule mol = null;
    private int hashcode = 0;

    public EqualableMolecule(Molecule mol) {
        this.mol = mol;
    }

    public Molecule getMolecule() {
        return this.mol;
    }

    private MolSearch initPerfectSearcher() {
        MolSearch perfectSearcher = new MolSearch();
        perfectSearcher.setLicenseEnvironment("StructureSearchForInternalMolSearchLicenseEnvironment");
        perfectSearcher.setStandardizer(null, true, true);
        perfectSearcher.setSearchOptions(new MolSearchOptions(5));
        MolSearchOptions mso = perfectSearcher.getSearchOptions();
        mso.setKeepQueryOrder(true);
        mso.setStereoSearchType(0);
        perfectSearcher.setSearchOptions(mso);
        return perfectSearcher;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EqualableMolecule)) {
            return false;
        }
        EqualableMolecule other = (EqualableMolecule)o;
        if (this.mol instanceof RxnMolecule && other.mol instanceof RxnMolecule) {
            EqualableMoleculeArray molArray = new EqualableMoleculeArray(((RxnMolecule)this.mol).getProducts());
            EqualableMoleculeArray otherMolArray = new EqualableMoleculeArray(((RxnMolecule)other.mol).getProducts());
            return molArray.equals(otherMolArray);
        }
        try {
            MolSearch perfectSearcher = this.initPerfectSearcher();
            this.mol.getSSSR();
            perfectSearcher.setTarget(this.mol);
            other.mol.getSSSR();
            perfectSearcher.setQuery(other.mol);
            return perfectSearcher.isMatching();
        }
        catch (SearchException e) {
            logger.log(Level.SEVERE, "Error occured during search.", e);
            return false;
        }
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.regenHashCode();
        }
        return this.hashcode;
    }

    private void regenHashCode() {
        if (this.mol instanceof RxnMolecule) {
            EqualableMoleculeArray ema = new EqualableMoleculeArray(((RxnMolecule)this.mol).getProducts());
            this.hashcode = ema.hashCode();
        } else {
            this.hashcode = new HashCode().getHashCode(this.mol, 15);
        }
    }

    @Override
    public String toString() {
        return this.mol.toFormat("cxsmiles:u");
    }
}

