/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.struc.Molecule;
import java.io.Serializable;
import java.util.List;

public class GroupDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String abbreviation;
    private Molecule group;

    public GroupDefinition() {
    }

    public GroupDefinition(String abbreviation, Molecule group) {
        this();
        this.abbreviation = abbreviation;
        this.group = group;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public Molecule getGroup() {
        return this.group;
    }

    public void setGroup(Molecule group) {
        this.group = group;
    }

    public boolean parse(String text, List<GroupDefinition> groups) {
        Molecule group = GroupDefinition.getMoleculeOf(text, groups);
        if (group != null) {
            this.setAbbreviation(text);
            this.setGroup(group);
            return true;
        }
        return false;
    }

    private static Molecule getMoleculeOf(String text, List<GroupDefinition> groupDefinition) {
        for (GroupDefinition definition : groupDefinition) {
            if (!text.equals(definition.getAbbreviation())) continue;
            return definition.getGroup();
        }
        return null;
    }

    public boolean equals(Object other) {
        try {
            GroupDefinition definition = (GroupDefinition)other;
            return definition.getAbbreviation().equals(this.getAbbreviation());
        }
        catch (Exception e) {
            return false;
        }
    }
}

