/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.reaction.ReactionUtil;
import chemaxon.sss.screen.HashCode;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;

class ProductSet
implements Comparable<ProductSet>,
Serializable {
    private static final int HASHCODE_RECURSION_LEVEL = 14;
    protected Molecule[] products = null;
    protected Molecule fusedProducts = null;
    double[] measures = null;
    private String[] idPropertyNames;
    private int[] productIndexes;
    private String id;
    private Properties properties;

    public static ProductSet createProductSet(Molecule[] products, int filteringMethod) {
        return ProductSet.createProductSet(products, (double[])null, filteringMethod);
    }

    public static ProductSet createProductSet(Molecule[] products, double[] measures, int filteringMethod) {
        if (filteringMethod == 1) {
            return new OrderSensitiveProductSet(products, measures);
        }
        if (filteringMethod == 2) {
            return new OrderInsensitiveProductSet(products, measures);
        }
        return new ProductSet(products, measures);
    }

    public static ProductSet createProductSet(Molecule[] reactants, Molecule[] products, int filteringMethod) {
        return ProductSet.createProductSet(reactants, products, null, filteringMethod);
    }

    public static ProductSet createProductSet(Molecule[] reactants, Molecule[] products, double[] measures, int filteringMethod) {
        if (filteringMethod == 1) {
            return new OrderSensitiveReactionSet(reactants, products, measures);
        }
        if (filteringMethod == 2) {
            return new OrderInsensitiveReactionSet(reactants, products, measures);
        }
        return new ReactionSet(reactants, products, measures);
    }

    private ProductSet(Molecule[] products) {
        this(products, null);
    }

    private ProductSet(Molecule[] products, double[] measures) {
        this.products = products;
        this.measures = measures;
    }

    public Molecule[] getProducts() {
        return this.products;
    }

    public Molecule[] getReactants() {
        throw new UnsupportedOperationException("Operation not supported in case of product output.");
    }

    public RxnMolecule getReaction() {
        throw new UnsupportedOperationException("Operation not supported in case of product output.");
    }

    public Molecule[] getResultAsMoleculeArray() {
        if (!this.isReactionSet()) {
            int i;
            Molecule[] products = this.getProducts();
            if (this.idPropertyNames != null && products != null) {
                for (i = 0; i < products.length; ++i) {
                    String cidprop = i < this.idPropertyNames.length ? this.idPropertyNames[i] : this.idPropertyNames[this.idPropertyNames.length - 1];
                    int productIndex = 0;
                    if (this.productIndexes != null) {
                        productIndex = this.productIndexes[i] + 1;
                    } else if (products.length > 1) {
                        productIndex = i + 1;
                    }
                    products[i].setProperty(cidprop, this.id + (productIndex != 0 ? "/" + productIndex : ""));
                }
            }
            if (products != null) {
                for (i = 0; i < products.length; ++i) {
                    ReactionUtil.setProperties(products[i], this.properties);
                }
            }
            return products;
        }
        RxnMolecule rxn = this.getReaction();
        if (rxn == null) {
            return null;
        }
        if (this.idPropertyNames != null && this.idPropertyNames[0] != null) {
            rxn.setProperty(this.idPropertyNames[0], this.id);
        }
        ReactionUtil.setProperties(rxn, this.properties);
        return new Molecule[]{rxn};
    }

    protected boolean isReactionSet() {
        return false;
    }

    public void setID(String[] propertyNames, int[] productIndexes, String id) {
        this.idPropertyNames = propertyNames;
        this.productIndexes = productIndexes;
        this.id = id;
    }

    public void setReactantPropertiesToCopy(Properties properties) {
        this.properties = properties;
    }

    public void removeDuplicateProductReferences() {
        this.products = ProductSet.removeDuplicateProductReferences(this.products);
        this.fusedProducts = null;
    }

    private static Molecule[] removeDuplicateProductReferences(Molecule[] products) {
        if (products != null) {
            ArrayList<Molecule> v = new ArrayList<Molecule>(products.length);
            int j = 0;
            for (int i = 0; i < products.length; ++i) {
                for (j = 0; j < i && products[j] != products[i]; ++j) {
                }
                if (j != i) continue;
                v.add(products[i]);
            }
            if (v.size() < products.length) {
                products = new Molecule[v.size()];
                v.toArray(products);
            }
        }
        return products;
    }

    MolSearch initPerfectSearcher() {
        MolSearch perfectSearcher = new MolSearch();
        perfectSearcher.setLicenseEnvironment("StructureSearchForInternalMolSearchLicenseEnvironment");
        perfectSearcher.setStandardizer(null, true, true);
        perfectSearcher.setSearchOptions(new MolSearchOptions(5));
        MolSearchOptions mso = perfectSearcher.getSearchOptions();
        mso.setKeepQueryOrder(true);
        perfectSearcher.setSearchOptions(mso);
        return perfectSearcher;
    }

    @Override
    public int compareTo(ProductSet ps) {
        if (this.measures == null) {
            return ps.measures == null ? 0 : -1;
        }
        if (ps.measures == null) {
            return 1;
        }
        int n = Math.min(this.measures.length, ps.measures.length);
        for (int i = 0; i < n; ++i) {
            double measure = this.measures[i];
            double psmeasure = ps.measures[i];
            if (Double.isNaN(measure)) {
                if (Double.isNaN(psmeasure)) continue;
                return -1;
            }
            if (Double.isNaN(psmeasure)) {
                return 1;
            }
            double epsilon = (Math.abs(measure) + Math.abs(psmeasure)) * 1.0E-4;
            if (measure < psmeasure - epsilon) {
                return -1;
            }
            if (!(measure > psmeasure + epsilon)) continue;
            return 1;
        }
        return 0;
    }

    void cloneStructures() {
        if (this.products != null) {
            Molecule[] origProducts = this.products;
            this.products = new Molecule[origProducts.length];
            for (int i = 0; i < origProducts.length; ++i) {
                if (this.products[i] != null) continue;
                this.products[i] = (Molecule)origProducts[i].clone();
                for (int j = i + 1; j < origProducts.length; ++j) {
                    if (origProducts[i] != origProducts[j]) continue;
                    this.products[j] = this.products[i];
                }
            }
        }
    }

    public String toString() {
        String s = "";
        if (this.measures != null) {
            for (int i = 0; i < this.measures.length; ++i) {
                s = s + this.measures[i] + ";";
            }
        }
        if (s.length() == 0) {
            s = "null";
        }
        return this.getProductsSmiles() + "\t" + s + "\n";
    }

    private String getProductsSmiles() {
        StringBuilder sb = new StringBuilder();
        for (Molecule product : this.products) {
            sb.append(product.toFormat("smiles") + ".");
        }
        return sb.toString();
    }

    static class OrderSensitiveReactionSet
    extends OrderSensitiveProductSet {
        protected Molecule[] reactants = null;

        private OrderSensitiveReactionSet(Molecule[] reactants, Molecule[] products, double[] measures) {
            super(products, measures);
            this.reactants = reactants;
        }

        @Override
        public Molecule[] getReactants() {
            return this.reactants;
        }

        @Override
        public RxnMolecule getReaction() {
            return ReactionUtil.createReactionMolecule(this.reactants, this.products, null, false);
        }

        @Override
        protected boolean isReactionSet() {
            return true;
        }
    }

    static class OrderSensitiveProductSet
    extends ProductSet {
        private int hashcode = 0;

        private OrderSensitiveProductSet(Molecule[] products, double[] measures) {
            super(products, measures);
        }

        public int hashCode() {
            if (this.hashcode == 0) {
                this.regenHashCode();
            }
            return this.hashcode;
        }

        private void regenHashCode() {
            int[] productHashcodes = null;
            if (this.products != null) {
                productHashcodes = new int[this.products.length];
                for (int i = 0; i < this.products.length; ++i) {
                    productHashcodes[i] = new HashCode().getHashCode(this.products[i], 14);
                }
            }
            if (productHashcodes != null) {
                this.hashcode = Arrays.hashCode(productHashcodes);
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrderSensitiveProductSet)) {
                return false;
            }
            OrderSensitiveProductSet other = (OrderSensitiveProductSet)o;
            try {
                return this.sameStructuresOrderSensitiveMatch(other);
            }
            catch (SearchException e) {
                return false;
            }
        }

        private boolean sameStructuresOrderSensitiveMatch(ProductSet ps) throws SearchException {
            if (this.products.length != ps.products.length) {
                return false;
            }
            MolSearch perfectSearcher = this.initPerfectSearcher();
            for (int i = 0; i < this.products.length; ++i) {
                perfectSearcher.setTarget(this.products[i]);
                perfectSearcher.setQuery(ps.products[i]);
                if (perfectSearcher.isMatching()) continue;
                return false;
            }
            return true;
        }
    }

    static class OrderInsensitiveReactionSet
    extends OrderInsensitiveProductSet {
        protected Molecule[] reactants = null;

        private OrderInsensitiveReactionSet(Molecule[] reactants, Molecule[] products, double[] measures) {
            super(products, measures);
            this.reactants = reactants;
        }

        @Override
        public Molecule[] getReactants() {
            return this.reactants;
        }

        @Override
        public RxnMolecule getReaction() {
            return ReactionUtil.createReactionMolecule(this.reactants, this.products, null, false);
        }

        @Override
        protected boolean isReactionSet() {
            return true;
        }
    }

    static class OrderInsensitiveProductSet
    extends ProductSet {
        private int hashcode = 0;

        private OrderInsensitiveProductSet(Molecule[] products, double[] measures) {
            super(products, measures);
        }

        public int hashCode() {
            if (this.hashcode == 0) {
                this.regenHashCode();
            }
            return this.hashcode;
        }

        private void regenHashCode() {
            if (this.products != null) {
                this.fusedProducts = ReactionUtil.fuseStructures(this.products);
                this.hashcode = new HashCode().getHashCode(this.fusedProducts, 14);
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrderInsensitiveProductSet)) {
                return false;
            }
            OrderInsensitiveProductSet other = (OrderInsensitiveProductSet)o;
            try {
                return this.sameStructuresOrderInsensitiveMatch(other);
            }
            catch (SearchException e) {
                return false;
            }
        }

        private boolean sameStructuresOrderInsensitiveMatch(ProductSet ps) throws SearchException {
            if (this.products.length != ps.products.length) {
                return false;
            }
            MolSearch perfectSearcher = this.initPerfectSearcher();
            if (this.fusedProducts == null) {
                this.fusedProducts = ReactionUtil.fuseStructures(this.products);
            }
            perfectSearcher.setTarget(this.fusedProducts);
            if (ps.fusedProducts == null) {
                ps.fusedProducts = ReactionUtil.fuseStructures(ps.products);
            }
            perfectSearcher.setQuery(ps.fusedProducts);
            return perfectSearcher.isMatching();
        }
    }

    static class ReactionSet
    extends ProductSet {
        protected Molecule[] reactants = null;

        private ReactionSet(Molecule[] reactants, Molecule[] products) {
            this(reactants, products, null);
        }

        private ReactionSet(Molecule[] reactants, Molecule[] products, double[] measures) {
            super(products, measures);
            this.reactants = reactants;
        }

        @Override
        public Molecule[] getReactants() {
            return this.reactants;
        }

        @Override
        public RxnMolecule getReaction() {
            return ReactionUtil.createReactionMolecule(this.reactants, this.products, null, false);
        }

        @Override
        protected boolean isReactionSet() {
            return true;
        }

        @Override
        void cloneStructures() {
            super.cloneStructures();
            if (this.reactants != null) {
                Molecule[] origReactants = this.reactants;
                this.reactants = new Molecule[origReactants.length];
                for (int i = 0; i < origReactants.length; ++i) {
                    if (this.reactants[i] != null) continue;
                    this.reactants[i] = (Molecule)origReactants[i].clone();
                    for (int j = i + 1; j < origReactants.length; ++j) {
                        if (origReactants[i] != origReactants[j]) continue;
                        this.reactants[j] = this.reactants[i];
                    }
                }
            }
        }
    }
}

