/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.reaction.EqualableMoleculeArray;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.ReactionResultEnumerator;
import chemaxon.reaction.ReactionUtil;
import chemaxon.reaction.ReactorOptions;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;

class ReactantRatioHandlerEnumerator
implements ReactionResultEnumerator {
    private ReactionResultEnumerator reactIterator = null;
    private boolean initialized = false;
    private boolean skipThisReactIterator = false;
    private ReactorOptions options = null;
    private Molecule[] reactants = null;
    private ArrayList<Molecule[]> productSets = null;
    private Iterator<Molecule[]> productSetsIterator = null;
    private int[] ratio = null;
    private int fixedReactantIndex = -1;
    private int fixedProductIndex = 0;
    private int surplus = -1;

    public ReactantRatioHandlerEnumerator(ReactionResultEnumerator reactIterator) {
        this.reactIterator = reactIterator;
    }

    @Override
    public void setReactants(Molecule[] reactants) throws ReactionException {
        this.reactants = reactants;
        this.reactIterator.setReactants(reactants);
        this.reset();
    }

    @Override
    public Molecule[] react() throws ReactionException {
        this.init();
        if (this.skipThisReactIterator) {
            return this.reactIterator.react();
        }
        if (this.productSets == null) {
            this.productSets = this.reactRatio();
            this.productSetsIterator = this.productSets.iterator();
        }
        return this.productSetsIterator.hasNext() ? this.productSetsIterator.next() : null;
    }

    @Override
    public void setOptions(ReactorOptions options) {
        this.options = options;
        this.reactIterator.setOptions(options);
    }

    private void init() throws ReactionException {
        if (!this.initialized) {
            this.ratio = this.options.getRatio();
            if (this.ratio == null) {
                this.skipThisReactIterator = true;
                return;
            }
            if (this.ratio.length == 1) {
                this.fixedReactantIndex = 0;
                this.surplus = this.ratio[0];
            } else {
                Integer[] ratioI = new Integer[this.ratio.length];
                for (int i = 0; i < this.ratio.length; ++i) {
                    ratioI[i] = this.ratio[i];
                }
                ArrayList<Integer> list = new ArrayList<Integer>(Arrays.asList(ratioI));
                this.fixedReactantIndex = list.indexOf(new Integer(1));
                list.remove(new Integer(1));
                this.surplus = Collections.min(list);
            }
            if (this.surplus == 1) {
                this.skipThisReactIterator = true;
            }
            if (this.fixedReactantIndex == -1) {
                throw new ReactionException("One of the reactant ratios should be 1.");
            }
            this.initialized = true;
        }
    }

    private void reset() {
        this.productSets = null;
        this.productSetsIterator = null;
    }

    private ArrayList<Molecule[]> reactRatio() throws ReactionException {
        if (this.surplus < 0) {
            return new ArrayList<Molecule[]>();
        }
        ArrayList<Object> productSets = new ArrayList();
        ArrayList<Molecule[]> prevProductSets = new ArrayList();
        FilteredMoleculeArrayContainer leafs = new FilteredMoleculeArrayContainer();
        int count = 0;
        productSets = ReactionUtil.reactAll(this.reactIterator, this.reactants);
        if (productSets.isEmpty()) {
            return new ArrayList<Molecule[]>();
        }
        ++count;
        while (count < this.surplus || this.surplus == 0) {
            prevProductSets = productSets;
            productSets = this.reactAll(prevProductSets);
            leafs.addAll(prevProductSets);
            if (productSets.isEmpty()) break;
            ++count;
        }
        leafs.addAll(productSets);
        if (this.options.getResultType() == 1) {
            return ReactantRatioHandlerEnumerator.replaceReactantsInReactionOutput(leafs.asList(), this.reactants);
        }
        return leafs.asList();
    }

    private ArrayList<Molecule[]> reactAll(ArrayList<Molecule[]> moleculeSets) throws ReactionException {
        ArrayList<Molecule[]> allProductSets = new ArrayList<Molecule[]>();
        Iterator<Molecule[]> iterator = moleculeSets.iterator();
        while (iterator.hasNext()) {
            Molecule[] reactants = this.createNextReactantSet(this.reactants, iterator.next());
            ArrayList<Molecule[]> productSets = ReactionUtil.reactAll(this.reactIterator, reactants);
            if (productSets.isEmpty()) continue;
            allProductSets.addAll(productSets);
            iterator.remove();
        }
        return allProductSets;
    }

    private Molecule[] createNextReactantSet(Molecule[] reactants, Molecule[] products) {
        Molecule[] nextReactans = ReactionUtil.cloneMoleculeArray(reactants);
        nextReactans[this.fixedReactantIndex] = products != null && products.length == 1 && products[0] instanceof RxnMolecule ? ((RxnMolecule)products[0]).getProduct(this.fixedProductIndex) : products[this.fixedProductIndex];
        return nextReactans;
    }

    private static ArrayList<Molecule[]> replaceReactantsInReactionOutput(ArrayList<Molecule[]> productLists, Molecule[] reactants) {
        for (int i = 0; i < productLists.size(); ++i) {
            Molecule[] products = productLists.get(i);
            RxnMolecule rxn = null;
            for (Molecule product : products) {
                if (!product.isReaction()) continue;
                rxn = ReactionUtil.createReactionMolecule(ReactionUtil.cloneMoleculeArray(reactants), ((RxnMolecule)product).getProducts(), null, false);
            }
            if (rxn == null) continue;
            productLists.set(i, new Molecule[]{rxn});
        }
        return productLists;
    }

    private static class FilteredMoleculeArrayContainer {
        private LinkedHashSet<EqualableMoleculeArray> container = new LinkedHashSet();

        private FilteredMoleculeArrayContainer() {
        }

        public void add(Molecule[] mols) {
            this.container.add(new EqualableMoleculeArray(mols));
        }

        public void addAll(Collection<Molecule[]> coll) {
            for (Molecule[] molecules : coll) {
                this.add(molecules);
            }
        }

        public ArrayList<Molecule[]> asList() {
            ArrayList<Molecule[]> list = new ArrayList<Molecule[]>();
            Iterator iterator = this.container.iterator();
            while (iterator.hasNext()) {
                list.add(((EqualableMoleculeArray)iterator.next()).getMoleculeArray());
            }
            return list;
        }
    }
}

