/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.jep.ChemJEP;
import chemaxon.jep.Evaluator;
import chemaxon.jep.context.ReactionContext;
import chemaxon.marvin.modules.AutoMapper;
import chemaxon.marvin.modules.AutoMapperException;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.reaction.HitData;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.ReactionUtil;
import chemaxon.sss.search.ReactionSearch;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class Reaction
implements Serializable {
    protected static final int MAXMAPS = 1024;
    protected static final int LEN = 16;
    protected static final int PROP_CHARGE = 1;
    protected static final int PROP_RADICAL = 2;
    protected static final int PROP_STGRP = 4;
    protected static final int PROP_HCOUNT = 8;
    protected static final int PROP_MASSNO = 32;
    protected static final int PROP_VALENCE = 64;
    public static final int REACTANT_SIDE = 1;
    public static final int PRODUCT_SIDE = 2;
    public static final int ALL_SIDE = 0;
    public static final int DATA_ATOMS = 1;
    public static final int DATA_BONDS = 2;
    public static final int DATA_PARITY = 4;
    public static final int DATA_DOUBLE_BOND_STEREO = 8;
    public static final int DATA_ALL = 15;
    private static final String[] UNUSED_RXN_MOL_PROPERTIES = new String[]{"DESCRIPTION", "EXAMPLE", "EXPLAIN_REACTIVITY", "EXPLAIN_EXCLUDE", "EXPLAIN_SELECTIVITY", "EXPLAIN_TOLERANCE", "PREPARATION", "SOLVENT", "REFERENCES"};
    private int data = 15;
    private String id = null;
    protected RxnMolecule rxn = null;
    protected ChemJEP rjep = null;
    protected ChemJEP sjep = null;
    protected double[] tolerances = null;
    private int[] map2nopar = new int[1024];
    protected int[] map2map = new int[1024];
    protected int[] smaps = new int[16];
    protected int[] emaps = new int[16];
    protected int[] rbondtypes = new int[16];
    protected int[] pbondtypes = new int[16];
    protected int bcount = 0;
    protected transient ArrayList<Integer> proptypes = new ArrayList();
    protected transient ArrayList<MolAtom> ratomprops = null;
    protected transient ArrayList<MolAtom> patomprops = null;
    protected int[] map2stereo = new int[1024];
    private ArrayList<int[]>[] rmaps = new ArrayList[4];
    private ArrayList<int[]>[] pmaps = new ArrayList[4];
    private transient ArrayList<MolAtom> ratoms = null;
    private transient ArrayList<MolAtom> patoms = null;
    private int[] map2raindex = new int[1024];
    private int[] map2paindex = new int[1024];
    protected int[] map2rindex = new int[1024];
    protected int[] map2pindex = new int[1024];
    protected int[] rindex2map = new int[4];
    protected int[] pindex2map = new int[4];
    protected ArrayList<int[]> rparities = new ArrayList(10);
    protected ArrayList<int[]> pparities = new ArrayList(10);
    protected ArrayList<int[]> rcistrans = new ArrayList(10);
    protected ArrayList<int[]> pcistrans = new ArrayList(10);
    private Molecule[] reactants = null;
    private Molecule[] products = null;

    public Reaction() {
    }

    public Reaction(Molecule reaction) throws ReactionException {
        this.setReaction(reaction);
    }

    public Reaction(String id) {
        this.id = id;
    }

    public void setRequiredData(int data) {
        this.data = data;
    }

    public int[][] getChangingBondData(boolean all) {
        Object result = this.getChangingBondData();
        if (all) {
            return result;
        }
        ArrayList<int[]> list = new ArrayList<int[]>(((int[][])result).length);
        for (int i = 0; i < ((int[][])result).length; ++i) {
            if ((result[i][1] == -1 || result[i][4] == -1) && (result[i][2] == -1 || result[i][5] == -1)) continue;
            list.add(result[i]);
        }
        if (list.size() < ((int[][])result).length) {
            result = new int[list.size()][];
            list.toArray((T[])result);
        }
        return result;
    }

    private int[][] getChangingBondData() {
        int[][] result = new int[this.bcount][6];
        for (int i = 0; i < this.bcount; ++i) {
            int smap = this.smaps[i];
            int emap = this.emaps[i];
            MolAtom ra1 = this.map2rindex[smap] != -1 ? this.getReactant(this.map2rindex[smap]).getAtom(this.map2raindex[smap]) : null;
            MolAtom ra2 = this.map2rindex[emap] != -1 ? this.getReactant(this.map2rindex[emap]).getAtom(this.map2raindex[emap]) : null;
            MolAtom pa1 = this.map2pindex[smap] != -1 ? this.getProduct(this.map2pindex[smap]).getAtom(this.map2paindex[smap]) : null;
            MolAtom pa2 = this.map2pindex[emap] != -1 ? this.getProduct(this.map2pindex[emap]).getAtom(this.map2paindex[emap]) : null;
            MolBond redge = ra1 != null && ra2 != null ? ra1.getBondTo(ra2) : null;
            MolBond pedge = pa1 != null && pa2 != null ? pa1.getBondTo(pa2) : null;
            result[i][0] = redge != null ? this.rxn.indexOf(redge) : -1;
            result[i][1] = ra1 != null ? this.rxn.indexOf(ra1) : -1;
            result[i][2] = ra2 != null ? this.rxn.indexOf(ra2) : -1;
            result[i][3] = pedge != null ? this.rxn.indexOf(pedge) : -1;
            result[i][4] = pa1 != null ? this.rxn.indexOf(pa1) : -1;
            result[i][5] = pa2 != null ? this.rxn.indexOf(pa2) : -1;
        }
        return result;
    }

    public int[] getChangingAtoms(boolean all, int side) {
        HashSet<MolAtom> set = new HashSet<MolAtom>(this.rxn.getAtomCount());
        this.getChangingAtoms(set, side);
        if (!all) {
            Iterator<MolAtom> it = set.iterator();
            while (it.hasNext()) {
                MolAtom atom = it.next();
                int map = atom.getAtomMap();
                int[] index2map = null;
                if (this.map2rindex[map] == -1 && this.map2pindex[map] != -1) {
                    index2map = this.pindex2map;
                } else if (this.map2pindex[map] == -1 && this.map2rindex[map] != -1) {
                    index2map = this.rindex2map;
                }
                if ((this.map2rindex[map] != -1 || this.map2pindex[map] == -1) && (this.map2rindex[map] == -1 || this.map2pindex[map] != -1)) continue;
                boolean keep = false;
                for (int i = atom.getBondCount() - 1; i >= 0; --i) {
                    MolAtom ligand = atom.getLigand(i);
                    int lmap = ligand.getAtomMap();
                    if (lmap != 0 && (this.map2rindex[lmap] == -1 || this.map2pindex[lmap] == -1)) continue;
                    keep = true;
                    break;
                }
                if (keep) continue;
                it.remove();
            }
        }
        return this.getAtomIndexes(set);
    }

    private int[] getAtomIndexes(Set<MolAtom> set) {
        int k = 0;
        int[] indexes = new int[set.size()];
        for (MolAtom atom : set) {
            indexes[k++] = this.rxn.indexOf(atom);
        }
        Arrays.sort(indexes);
        return indexes;
    }

    private void getChangingAtoms(Set<MolAtom> set, int side) {
        if (side == 0 || side == 1) {
            this.addAtoms(set, this.getReactantSideAtoms());
        }
        if (side == 0 || side == 2) {
            this.addAtoms(set, this.getProductSideAtoms());
        }
        for (int i = 0; i < this.bcount; ++i) {
            int smap = this.smaps[i];
            int emap = this.emaps[i];
            if ((side == 0 || side == 1) && this.map2rindex[smap] != -1) {
                set.add(this.getReactant(this.map2rindex[smap]).getAtom(this.map2raindex[smap]));
            }
            if ((side == 0 || side == 1) && this.map2rindex[emap] != -1) {
                set.add(this.getReactant(this.map2rindex[emap]).getAtom(this.map2raindex[emap]));
            }
            if ((side == 0 || side == 2) && this.map2pindex[smap] != -1) {
                set.add(this.getProduct(this.map2pindex[smap]).getAtom(this.map2paindex[smap]));
            }
            if (side != 0 && side != 2 || this.map2pindex[emap] == -1) continue;
            set.add(this.getProduct(this.map2pindex[emap]).getAtom(this.map2paindex[emap]));
        }
        if (side == 0 || side == 1) {
            set.addAll(this.getReactantAtomProps());
        }
        if (side == 0 || side == 2) {
            set.addAll(this.getProductAtomProps());
        }
    }

    private ArrayList<MolAtom> getReactantSideAtoms() {
        this.collectReactantAndProductSideAtoms();
        return this.ratoms;
    }

    private ArrayList<MolAtom> getProductSideAtoms() {
        this.collectReactantAndProductSideAtoms();
        return this.patoms;
    }

    private void collectReactantAndProductSideAtoms() {
        if (this.ratoms == null || this.patoms == null) {
            this.ratoms = new ArrayList();
            this.patoms = new ArrayList();
            for (int i = this.rxn.getAtomCount() - 1; i >= 0; --i) {
                MolAtom atom = this.rxn.getAtom(i);
                int map = atom.getAtomMap();
                if (map <= 0) continue;
                if (this.map2rindex[map] == -1) {
                    this.patoms.add(atom);
                    continue;
                }
                if (this.map2pindex[map] == -1) {
                    this.ratoms.add(atom);
                    continue;
                }
                if (atom.getAtno() != 1) continue;
                this.ratoms.add(atom);
                this.patoms.add(atom);
            }
        }
    }

    ArrayList<Integer> getPropertyTypes() {
        if (this.proptypes == null) {
            this.storeAtomProperties();
        }
        return this.proptypes;
    }

    ArrayList<MolAtom> getReactantAtomProps() {
        if (this.ratomprops == null) {
            this.storeAtomProperties();
        }
        return this.ratomprops;
    }

    ArrayList<MolAtom> getProductAtomProps() {
        if (this.patomprops == null) {
            this.storeAtomProperties();
        }
        return this.patomprops;
    }

    private void addAtoms(Set<MolAtom> set, ArrayList<MolAtom> atoms) {
        for (int i = atoms.size() - 1; i >= 0; --i) {
            MolAtom atom = atoms.get(i);
            int map = atom.getAtomMap();
            if (this.map2rindex[map] != -1 && this.map2pindex[map] != -1) continue;
            set.add(atom);
        }
    }

    public static String getReactivity(String reactivity, String exclude) {
        if (exclude != null) {
            reactivity = reactivity != null ? "(" + reactivity + ") && !(" + exclude + ")" : "!(" + exclude + ")";
        }
        return reactivity;
    }

    public static double[] getTolerances(String tolerances) throws ReactionException {
        if (tolerances == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(" " + tolerances, ";");
        double[] t = new double[st.countTokens()];
        for (int i = 0; i < t.length; ++i) {
            String token = st.nextToken().trim();
            if (token.length() == 0) {
                t[i] = 1.0E-4;
                continue;
            }
            try {
                t[i] = Double.parseDouble(token);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ReactionException("Tolerance value is not a real number: " + token);
            }
        }
        return t;
    }

    public void setReactivityRule(String rule, Evaluator evaluator) throws ReactionException {
        try {
            this.rjep = evaluator.compile(rule, ReactionContext.class);
        }
        catch (ParseException e) {
            throw new ReactionException("Error while setting reactivity rule.", e);
        }
    }

    public void setSelectivityRule(String rule, Evaluator evaluator) throws ReactionException {
        this.setSelectivityRule(rule, (double[])null, evaluator);
    }

    public void setSelectivityRule(String rule, String tolerances, Evaluator evaluator) throws ReactionException {
        this.setSelectivityRule(rule, Reaction.getTolerances(tolerances), evaluator);
    }

    public void setSelectivityRule(String rule, double[] tolerances, Evaluator evaluator) throws ReactionException {
        try {
            this.sjep = evaluator.compile(rule, ReactionContext.class);
        }
        catch (ParseException e) {
            throw new ReactionException("Error while setting selectivity rule.", e);
        }
        this.tolerances = tolerances;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public void setFID(String fid) {
    }

    protected String getFID() {
        return null;
    }

    public Molecule getReactant(int i) {
        return this.reactants[i];
    }

    protected Molecule[] getReactants() {
        return this.reactants;
    }

    public int getReactantCount() {
        return this.reactants.length;
    }

    protected Molecule getProduct(int i) {
        return this.products[i];
    }

    protected Molecule[] getProducts() {
        return this.products;
    }

    protected int getProductCount() {
        return this.products.length;
    }

    protected int getProductAtomCount() {
        return this.getProductSideAtoms().size();
    }

    protected MolAtom getProductAtom(int i) {
        return (MolAtom)this.getProductSideAtoms().get(i).clone();
    }

    protected int getReactantAtomCount() {
        return this.getReactantSideAtoms().size();
    }

    protected MolAtom getReactantAtom(int i) {
        return (MolAtom)this.getReactantSideAtoms().get(i).clone();
    }

    public RxnMolecule getReaction() {
        return this.rxn == null ? null : (RxnMolecule)this.rxn.cloneMolecule();
    }

    public void setReaction(Molecule mol) throws ReactionException {
        this.setReaction(mol, false, false);
    }

    public void setReaction(Molecule mol, boolean fuse) throws ReactionException {
        this.setReaction(mol, fuse, false);
    }

    public void setReaction(Molecule mol, boolean fuse, boolean skipMappingCheck) throws ReactionException {
        this.setReaction(mol, fuse, skipMappingCheck, true);
    }

    public void setReaction(Molecule mol, boolean fuse, boolean skipMappingCheck, boolean visualOrder) throws ReactionException {
        int map;
        MolAtom atom;
        int j;
        int i;
        mol = mol.cloneMolecule();
        Reaction.clearUnusedProperties(mol);
        this.rxn = RxnMolecule.getReaction(mol);
        if (this.rxn == null) {
            throw new ReactionException("Not a reaction molecule: " + ReactionUtil.toFormat(mol, new String[]{"smiles", "cxsmiles", "smarts", "cxsmarts", "mrv"}));
        }
        if (fuse) {
            this.rxn = ReactionUtil.fuseReactionMolecule(this.rxn);
        }
        this.rxn.setGUIContracted(true);
        boolean areAllReactionComponentsMapped = ReactionUtil.areAllReactionComponentsMapped(this.rxn);
        if (!(areAllReactionComponentsMapped && skipMappingCheck || areAllReactionComponentsMapped && ReactionUtil.areAllChangingAtomsMapped(this.rxn))) {
            AutoMapper mapper = new AutoMapper();
            mapper.setMappingStyle(2);
            try {
                mapper.map(this.rxn);
            }
            catch (AutoMapperException e) {
                throw new ReactionException("Error while mapping the reaction.", e);
            }
        }
        ReactionUtil.makeUniqueMaps(this.rxn, this.map2map);
        if (visualOrder && this.rxn.getDim() != 0) {
            this.rxn.rebuildStructures();
        }
        this.reactants = ReactionUtil.getStructures(this.rxn, 0, 4);
        this.products = ReactionUtil.getStructures(this.rxn, 1, 5);
        if ((this.data & 4) != 0 || (this.data & 8) != 0) {
            this.rxn.setDim(0);
        }
        this.ratoms = null;
        this.patoms = null;
        this.proptypes = null;
        this.ratomprops = null;
        this.patomprops = null;
        Arrays.fill(this.map2raindex, -1);
        Arrays.fill(this.map2paindex, -1);
        Arrays.fill(this.map2rindex, -1);
        Arrays.fill(this.map2pindex, -1);
        if (this.rindex2map.length < this.reactants.length) {
            this.rindex2map = new int[this.reactants.length];
            this.rmaps = new ArrayList[this.reactants.length];
        }
        if (this.pindex2map.length < this.products.length) {
            this.pindex2map = new int[this.products.length];
            this.pmaps = new ArrayList[this.products.length];
        }
        Arrays.fill(this.rindex2map, -1);
        Arrays.fill(this.pindex2map, -1);
        for (i = 0; i < this.reactants.length; ++i) {
            if (this.rmaps[i] == null) {
                this.rmaps[i] = new ArrayList();
                continue;
            }
            this.rmaps[i].clear();
        }
        for (i = 0; i < this.products.length; ++i) {
            if (this.pmaps[i] == null) {
                this.pmaps[i] = new ArrayList();
                continue;
            }
            this.pmaps[i].clear();
        }
        for (i = 0; i < this.reactants.length; ++i) {
            for (j = this.reactants[i].getAtomCount() - 1; j >= 0; --j) {
                atom = this.reactants[i].getAtom(j);
                map = atom.getAtomMap();
                if (map == 0) continue;
                this.map2raindex[map] = j;
                this.map2rindex[map] = i;
                if (this.rindex2map[i] == -1 || !atom.isImplicitizableH(16)) {
                    this.rindex2map[i] = map;
                }
                this.rmaps[i].add(new int[]{map, j});
            }
        }
        for (i = 0; i < this.products.length; ++i) {
            for (j = this.products[i].getAtomCount() - 1; j >= 0; --j) {
                atom = this.products[i].getAtom(j);
                map = atom.getAtomMap();
                if (map == 0) continue;
                this.map2paindex[map] = j;
                this.map2pindex[map] = i;
                if (this.pindex2map[i] == -1 || !atom.isImplicitizableH(16)) {
                    this.pindex2map[i] = map;
                }
                this.pmaps[i].add(new int[]{map, j});
            }
        }
        block8: for (i = 0; i < this.reactants.length; ++i) {
            if (this.rindex2map[i] < 0 || this.map2pindex[this.rindex2map[i]] != -1) continue;
            for (j = this.rmaps[i].size() - 2; j >= 0; --j) {
                int map2 = this.rmaps[i].get(j)[0];
                if (this.map2pindex[map2] == -1) continue;
                this.rindex2map[i] = map2;
                continue block8;
            }
        }
        block10: for (i = 0; i < this.products.length; ++i) {
            if (this.pindex2map[i] < 0 || this.map2rindex[this.pindex2map[i]] != -1) continue;
            for (j = this.pmaps[i].size() - 2; j >= 0; --j) {
                int map3 = this.pmaps[i].get(j)[0];
                if (this.map2rindex[map3] == -1) continue;
                this.pindex2map[i] = map3;
                continue block10;
            }
        }
        if ((this.data & 4) != 0) {
            this.storeParities();
            this.storeStereo();
        }
        if ((this.data & 8) != 0) {
            this.storeCisTrans();
        }
        this.bcount = 0;
        if ((this.data & 2) != 0) {
            for (i = this.rxn.getBondCount() - 1; i >= 0; --i) {
                int map2;
                int map1;
                int j2;
                MolBond bond = this.rxn.getBond(i);
                int smap = bond.getAtom1().getAtomMap();
                int emap = bond.getAtom2().getAtomMap();
                if (smap == 0 || emap == 0) continue;
                if (smap > emap) {
                    int map4 = smap;
                    smap = emap;
                    emap = map4;
                }
                boolean processed = false;
                for (int j3 = 0; j3 < this.bcount; ++j3) {
                    if (this.smaps[j3] != smap || this.emaps[j3] != emap) continue;
                    processed = true;
                    break;
                }
                if (processed) continue;
                if (this.bcount == this.smaps.length) {
                    this.realloc();
                }
                this.smaps[this.bcount] = smap;
                this.emaps[this.bcount] = emap;
                int rindex = this.map2rindex[smap];
                int pindex = this.map2pindex[smap];
                MolBond rbond = null;
                MolBond pbond = null;
                if (rindex != -1) {
                    for (j2 = this.reactants[rindex].getBondCount() - 1; j2 >= 0; --j2) {
                        MolBond rb = this.reactants[rindex].getBond(j2);
                        map1 = rb.getAtom1().getAtomMap();
                        map2 = rb.getAtom2().getAtomMap();
                        if ((smap != map1 || emap != map2) && (smap != map2 || emap != map1)) continue;
                        rbond = rb;
                        break;
                    }
                }
                if (pindex != -1) {
                    for (j2 = this.products[pindex].getBondCount() - 1; j2 >= 0; --j2) {
                        MolBond pb = this.products[pindex].getBond(j2);
                        map1 = pb.getAtom1().getAtomMap();
                        map2 = pb.getAtom2().getAtomMap();
                        if ((smap != map1 || emap != map2) && (smap != map2 || emap != map1)) continue;
                        pbond = pb;
                        break;
                    }
                }
                if (rbond != null && pbond != null && rbond.getType() == pbond.getType() && rbond.getAtom1().getAtno() != 1 && rbond.getAtom2().getAtno() != 1) continue;
                this.rbondtypes[this.bcount] = rbond != null ? Reaction.getBondType(rbond) : -1;
                this.pbondtypes[this.bcount] = pbond != null ? Reaction.getBondType(pbond) : -1;
                ++this.bcount;
            }
        }
    }

    private static void clearUnusedProperties(Molecule mol) {
        for (String propertyKey : UNUSED_RXN_MOL_PROPERTIES) {
            for (int i = 0; i < mol.getPropertyCount(); ++i) {
                if (!mol.getPropertyKey(i).equalsIgnoreCase(propertyKey)) continue;
                mol.setProperty(mol.getPropertyKey(i), null);
            }
        }
    }

    private static int getBondType(MolBond bond) {
        int type = bond.getType();
        switch (type) {
            case 0: 
            case 5: 
            case 6: {
                return 1;
            }
            case 7: {
                return 2;
            }
        }
        return type;
    }

    private void storeAtomProperties() {
        if (this.proptypes == null) {
            this.proptypes = new ArrayList(16);
        }
        if (this.ratomprops == null) {
            this.ratomprops = new ArrayList(16);
        }
        if (this.patomprops == null) {
            this.patomprops = new ArrayList(16);
        }
        if ((this.data & 1) == 0) {
            return;
        }
        for (int i = this.rxn.getAtomCount() - 1; i >= 0; --i) {
            int proptype;
            MolAtom patom = this.rxn.getAtom(i);
            int map = patom.getAtomMap();
            int pindex = this.map2pindex[map];
            int rindex = this.map2rindex[map];
            if (rindex == -1 || pindex == -1) continue;
            MolAtom ratom = null;
            for (int j = this.reactants[rindex].getAtomCount() - 1; j >= 0; --j) {
                MolAtom atom0 = this.reactants[rindex].getAtom(j);
                if (atom0.getAtomMap() != map) continue;
                ratom = atom0;
                break;
            }
            if ((proptype = Reaction.getChangingAtomPropType(ratom, patom)) == 0) continue;
            this.getPropertyTypes().add(proptype);
            this.getReactantAtomProps().add(ratom);
            this.getProductAtomProps().add(patom);
        }
    }

    private static int getChangingAtomPropType(MolAtom ratom, MolAtom patom) {
        int proptype = 0;
        if (ratom.getCharge() != patom.getCharge()) {
            proptype |= 1;
        }
        if (ratom.getRadical() != patom.getRadical()) {
            proptype |= 2;
        }
        if (ratom.getStereoGroupType() != 0 || patom.getStereoGroupType() != 0) {
            proptype |= 4;
        }
        if (ratom.getQPropAsInt("H") != -1 || patom.getQPropAsInt("H") != -1) {
            proptype |= 8;
        }
        if (ratom.getMassno() != patom.getMassno()) {
            proptype |= 0x20;
        }
        if (ratom.getValenceProp() != patom.getValenceProp()) {
            proptype |= 0x40;
        }
        return proptype;
    }

    private void storeParities() {
        Arrays.fill(this.map2nopar, 0);
        this.storeParities(this.rparities, this.reactants, 1);
        this.storeParities(this.pparities, this.products, 2);
        for (int map = 1; map < 1024; ++map) {
            if (this.map2nopar[map] == 1) {
                this.rparities.add(new int[]{map});
            }
            if (this.map2nopar[map] != 2) continue;
            this.pparities.add(new int[]{map});
        }
    }

    private void storeParities(ArrayList<int[]> parities, Molecule[] mols, int nopar) {
        parities.clear();
        int[] indices = new int[4];
        int[] maps = new int[4];
        for (int i = 0; i < mols.length; ++i) {
            Molecule mol = mols[i];
            for (int j = mol.getAtomCount() - 1; j >= 0; --j) {
                int lcount;
                MolAtom atom = mol.getAtom(j);
                int map = atom.getAtomMap();
                if (map == 0 || (lcount = atom.getBondCount()) > 4) continue;
                int parity = mol.getLocalParity(j);
                if (parity == 1 || parity == 2) {
                    Arrays.fill(indices, Integer.MAX_VALUE);
                    Arrays.fill(maps, -1);
                    int k = 0;
                    int unmapped = -1;
                    for (int l = 0; l < lcount; ++l) {
                        MolAtom ligand = atom.getLigand(l);
                        if (ligand.getAtno() == 1) continue;
                        maps[k] = ligand.getAtomMap();
                        if (maps[k] != 0) {
                            indices[k++] = mol.indexOf(ligand);
                            continue;
                        }
                        if (unmapped == -1) {
                            unmapped = mol.indexOf(ligand);
                            continue;
                        }
                        map = 0;
                        break;
                    }
                    if (map == 0) continue;
                    if (unmapped != -1) {
                        maps[k] = 0;
                        indices[k] = unmapped;
                    }
                    parities.add(new int[]{map, maps[0], maps[1], maps[2], maps[3], MolAtom.paritySign(indices[0], indices[1], indices[2], indices[3]), parity});
                    continue;
                }
                int n = map;
                this.map2nopar[n] = this.map2nopar[n] | nopar;
            }
        }
    }

    private void storeStereo() throws ReactionException {
        Arrays.fill(this.map2stereo, 0);
        boolean searched = false;
        for (int map = 1; map < 1024; ++map) {
            int rindex = this.map2rindex[map];
            int pindex = this.map2pindex[map];
            if (rindex == -1 || pindex == -1) continue;
            int ra = this.map2raindex[map];
            int pa = this.map2paindex[map];
            MolAtom ratom = this.reactants[rindex].getAtom(ra);
            MolAtom patom = this.products[pindex].getAtom(pa);
            int rstereo = ratom.getReactionStereo();
            int pstereo = patom.getReactionStereo();
            int stereo = 0;
            if (rstereo != 0) {
                stereo = rstereo;
            } else if (pstereo != 0) {
                stereo = pstereo;
            } else {
                int rparity = this.reactants[rindex].getLocalParity(ra);
                int pparity = this.products[pindex].getLocalParity(pa);
                if (!(rparity != 1 && rparity != 2 || pparity != 1 && pparity != 2)) {
                    int d = 0;
                    ArrayList<int[]> parities = this.rparities;
                    while (parities != null) {
                        for (int i = parities.size() - 1; i >= 0; --i) {
                            if (parities.get(i)[0] != map) continue;
                            ++d;
                            break;
                        }
                        parities = parities == this.rparities ? this.pparities : null;
                    }
                    if (d < 2) {
                        if (searched) {
                            throw new ReactionException("The reaction stereo type could not be determined: multiple stereo centers with unmapped ligands - map more ligands around stereo centers.");
                        }
                        ReactionSearch rs = new ReactionSearch();
                        rs.setTarget(this.rxn);
                        try {
                            stereo = rs.reactionStereoType(this.rxn.indexOf(ratom), this.rxn.indexOf(patom));
                        }
                        catch (SearchException e) {
                            throw new ReactionException("The reaction stereo type could not be determined", e);
                        }
                        searched = true;
                    }
                }
            }
            this.map2stereo[map] = stereo;
        }
    }

    private void storeCisTrans() {
        this.storeCisTrans(this.rcistrans, this.reactants);
        this.storeCisTrans(this.pcistrans, this.products);
    }

    private void storeCisTrans(ArrayList<int[]> cistrans, Molecule[] mols) {
        cistrans.clear();
        for (int i = 0; i < mols.length; ++i) {
            Molecule mol = mols[i];
            for (int j = mol.getBondCount() - 1; j >= 0; --j) {
                MolBond bond = mol.getBond(j);
                if (bond.getType() != 2) continue;
                MolAtom atom1 = bond.getAtom1();
                MolAtom atom2 = bond.getAtom2();
                int map1 = atom1.getAtomMap();
                int map2 = atom2.getAtomMap();
                if (map1 == 0 || map2 == 0) continue;
                MolAtom ligand1 = Reaction.getMappedLigand(atom1, atom2);
                MolAtom ligand2 = Reaction.getMappedLigand(atom2, atom1);
                if (ligand1 == null || ligand2 == null) continue;
                cistrans.add(new int[]{ligand1.getAtomMap(), map1, map2, ligand2.getAtomMap(), mol.getStereo2(bond, ligand1, ligand2)});
            }
        }
    }

    private static MolAtom getMappedLigand(MolAtom atom1, MolAtom atom2) {
        for (int i = atom1.getBondCount() - 1; i >= 0; --i) {
            MolAtom ligand = atom1.getLigand(i);
            if (ligand == atom2 || ligand.getAtomMap() == 0) continue;
            return ligand;
        }
        return null;
    }

    int getSgroupAtomAttachmentPointIndex(int sgmap, int amap, boolean reverse) {
        MolAtom atom;
        MolAtom sgatom = !reverse ? this.products[this.map2pindex[sgmap]].getAtom(this.map2paindex[sgmap]) : this.reactants[this.map2rindex[sgmap]].getAtom(this.map2raindex[sgmap]);
        MolAtom molAtom = atom = !reverse ? this.products[this.map2pindex[amap]].getAtom(this.map2paindex[amap]) : this.reactants[this.map2rindex[amap]].getAtom(this.map2raindex[amap]);
        if (sgatom.getAtno() == 135) {
            for (int i = 0; i < sgatom.getBondCount(); ++i) {
                if (sgatom.getLigand(i) != atom) continue;
                return i;
            }
        }
        return -1;
    }

    HitData convert(int[] searchHit, int index, boolean reverse) {
        ArrayList<int[]> tmap = reverse ? this.pmaps[index] : this.rmaps[index];
        HitData hd = new HitData();
        for (int i = 0; i < tmap.size(); ++i) {
            int[] item = tmap.get(i);
            hd.add(item[0], searchHit[item[1]]);
        }
        return hd;
    }

    protected int getBaseMap(int map) {
        while (this.map2map[map] > map) {
            map = this.map2map[map];
        }
        return this.map2map[map];
    }

    private void realloc() {
        int len = this.smaps.length;
        int[] tmp = new int[2 * len];
        System.arraycopy(this.smaps, 0, tmp, 0, len);
        this.smaps = tmp;
        tmp = new int[2 * len];
        System.arraycopy(this.emaps, 0, tmp, 0, len);
        this.emaps = tmp;
        tmp = new int[2 * len];
        System.arraycopy(this.rbondtypes, 0, tmp, 0, len);
        this.rbondtypes = tmp;
        tmp = new int[2 * len];
        System.arraycopy(this.pbondtypes, 0, tmp, 0, len);
        this.pbondtypes = tmp;
    }
}

