/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.common.util.IntVector;
import chemaxon.jep.ChemJEP;
import chemaxon.jep.context.ReactionContext;
import chemaxon.marvin.io.formats.smiles.SmilesImport;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.reaction.HitData;
import chemaxon.reaction.ProductSet;
import chemaxon.reaction.Reaction;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.ReactionResultEnumerator;
import chemaxon.reaction.ReactionSearcher;
import chemaxon.reaction.ReactionUtil;
import chemaxon.reaction.ReactorOptions;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.Search;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.util.SearchAttributes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

class ReactionPerformer
implements ReactionResultEnumerator,
Serializable {
    private static final Logger logger = Logger.getLogger(ReactionPerformer.class.getName());
    private static final String HCOUNT = "__HCOUNT__";
    static final String STRUCTURE_SEARCH_FOR_INTERNAL_MOLSEARCH_LICENSE_ENVIRONMENT = "StructureSearchForInternalMolSearchLicenseEnvironment";
    static final int NO_DUPLICATE_FILTERING = 0;
    static final int ORDER_SENSITIVE_DUPLICATE_FILTERING = 1;
    static final int ORDER_INSENSITIVE_DUPLICATE_FILTERING = 2;
    private Reaction reaction = null;
    private ReactionSearcher searcher = null;
    private ReactionContext context = null;
    private transient ArrayList<MolAtom> origmapped = null;
    private int[] origmaps = new int[16];
    private transient MolAtom[] map2ratom;
    private transient MolAtom[] map2patom;
    private transient ArrayList<MolAtom> hlist = null;
    private transient ArrayList<MolAtom> hcuts = null;
    private transient HashSet<MolAtom> changedAtomSet = null;
    private ArrayList<LigandSet> rligandsets = new ArrayList(5);
    private ArrayList<CisTransSet> rcistranssets = new ArrayList();
    private Molecule[] reactants = null;
    private Molecule[] currentReactants = null;
    private ArrayList<ProductSet> productsets = null;
    private ProductSet transformedProductSet = null;
    private boolean absStereo = false;
    private ReactorOptions options = new ReactorOptions(0, 1, 0, null, false, false, false, null, null, null);
    private String baseProductID = null;
    private int globalProductIndex = 0;
    private Properties reactantProperties = null;
    private ArrayList<int[]> stgrpMap = new ArrayList(10);
    private transient LinkedHashSet<ProductSet> psFilter = null;
    private transient HashSet<List<HitData>> hitDataArrayFilterSet = null;

    static <E> void removeDuplicates(Collection<E> c) {
        if (c.size() <= 1) {
            return;
        }
        LinkedHashSet filteringLHS = new LinkedHashSet();
        filteringLHS.addAll(c);
        if (c.size() != filteringLHS.size()) {
            c.clear();
            c.addAll(filteringLHS);
        }
    }

    private static void filter(ArrayList<ProductSet> list, double[] tolerances) {
        if (list.isEmpty()) {
            return;
        }
        double[] m = list.get((int)(list.size() - 1)).measures;
        if (m == null) {
            return;
        }
        for (int i = list.size() - 2; i >= 0; --i) {
            double[] measures = list.get((int)i).measures;
            if (measures != null && m.length == measures.length) continue;
            list.remove(i);
        }
        double[] maxMeasures = new double[m.length];
        System.arraycopy(m, 0, maxMeasures, 0, maxMeasures.length);
        for (int i = 0; i < maxMeasures.length; ++i) {
            double[] measures;
            if (!Double.isNaN(maxMeasures[i])) {
                for (int j = list.size() - 1; j >= 0; --j) {
                    double tolerance;
                    double[] measures2 = list.get((int)j).measures;
                    double d = tolerances == null ? 1.0E-4 : (tolerance = i < tolerances.length ? tolerances[i] : 1.0E-4);
                    if (!Double.isNaN(measures2[i]) && !(Math.abs(maxMeasures[i] - measures2[i]) > tolerance)) continue;
                    list.remove(j);
                }
            }
            if (i + 1 >= maxMeasures.length || (measures = list.get((int)(list.size() - 1)).measures) == null) continue;
            maxMeasures[i + 1] = measures[i + 1];
            for (int j = list.size() - 2; j >= 0; --j) {
                measures = list.get((int)j).measures;
                if (Double.isNaN(maxMeasures[i + 1]) && Double.isNaN(measures[i + 1])) continue;
                if (Double.isNaN(maxMeasures[i + 1]) && !Double.isNaN(measures[i + 1])) {
                    maxMeasures[i + 1] = measures[i + 1];
                    continue;
                }
                if (!(maxMeasures[i + 1] < measures[i + 1])) continue;
                maxMeasures[i + 1] = measures[i + 1];
            }
        }
    }

    ReactionPerformer(Reaction reaction) {
        this.reaction = reaction;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Reaction: " + ReactionUtil.toFormat(reaction.rxn, new String[]{"smarts", "cxsmarts", "mrv"}));
        }
        this.searcher = new ReactionSearcher(reaction, this.options);
    }

    ReactionPerformer(Reaction reaction, ReactorOptions options) {
        this.reaction = reaction;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Reaction: " + ReactionUtil.toFormat(reaction.rxn, new String[]{"smarts", "cxsmarts", "mrv"}));
        }
        this.searcher = new ReactionSearcher(reaction, options);
    }

    Reaction getReaction() {
        return this.reaction;
    }

    void setSearchAttributes(SearchAttributes attributes) {
        this.options.setSearchAttributes(attributes);
        this.searcher.setOptions(this.options);
    }

    SearchAttributes getSearchAttributes() {
        return this.options.getSearchAttributes();
    }

    void setSearchOptions(String optionString) {
        this.searcher.setSearchOptions(optionString);
    }

    MolSearchOptions getSearchOptions() {
        return this.searcher.getSearchOptions();
    }

    MolSearch[] getReactantSearchers() {
        return this.searcher.getSearchers();
    }

    void setTransform(boolean transform) {
        if (this.options.isTransform() != transform) {
            this.options.setTransform(transform);
            this.options.setExcludeOverlappingHits(transform);
            int mode = transform ? 1 : 0;
            this.searcher.setDoubleBondStereoMatchingMode(mode);
        }
    }

    void setChangedAtomSet(HashSet<MolAtom> changedAtomSet) {
        this.changedAtomSet = changedAtomSet;
    }

    void setDuplicateFiltering(int duplicateFilteringMethod) {
        this.options.setDuplicateFilteringMethod(duplicateFilteringMethod);
    }

    @Override
    public void setOptions(ReactorOptions options) {
        this.options = options;
        this.searcher.setOptions(options);
    }

    void restart() {
        this.searcher.restart();
        this.productsets = null;
        this.transformedProductSet = null;
        this.hitDataArrayFilterSet = null;
        this.psFilter = null;
    }

    int getReactantCount() {
        return this.searcher.isReverse() ? this.reaction.getProductCount() : this.reaction.getReactantCount();
    }

    int getProductCount() {
        return this.searcher.isReverse() ? this.reaction.getReactantCount() : this.reaction.getProductCount();
    }

    void setReactant(Molecule reactant) throws ReactionException {
        this.setReactants(new Molecule[]{reactant});
    }

    @Override
    public void setReactants(Molecule[] reactants) throws ReactionException {
        this.reactants = reactants;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Reactants: " + ReactionUtil.toFormat(reactants, new String[]{"smiles", "cxsmiles", "mrv"}));
        }
        this.absStereo = ReactionPerformer.isAbsStereo(reactants);
        this.searcher.setTargets(reactants);
        this.restart();
        this.baseProductID = this.getBaseProductID();
        this.globalProductIndex = 0;
        this.reactantProperties = ReactionUtil.getSelectedMoleculeProperties(reactants, this.options.isCopyAllReactantProperties(), this.options.getReactantPropertiesToCopy(), this.options.getTargetProperties(), this.getReaction().getReaction(), this.options.getPatternBasedProperties());
    }

    Molecule[] getCurrentReactants() {
        return this.currentReactants;
    }

    private String getBaseProductID() {
        if (this.options.getReactantIDProps() == null && this.options.getProductIDProps() == null) {
            return null;
        }
        String rid = this.reaction.getID();
        if (rid == null && this.options.getReactionIDProp() != null) {
            rid = this.reaction.rxn.getProperty(this.options.getReactionIDProp());
        }
        if (rid == null) {
            return null;
        }
        String[] props = null;
        if (this.searcher.isReverse()) {
            rid = rid + "_";
        }
        props = this.options.getReactantIDProps() != null ? this.options.getReactantIDProps() : this.options.getProductIDProps();
        StringBuffer sb = new StringBuffer();
        sb.append(rid + "(");
        for (int i = 0; i < this.reactants.length; ++i) {
            String cidprop = i < props.length ? props[i] : props[props.length - 1];
            String cid = this.reactants[i].getProperty(cidprop);
            if (cid == null) {
                cid = "" + (i + 1);
            }
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(cid);
        }
        sb.append(")");
        return new String(sb);
    }

    private String getNextID() {
        return this.baseProductID + ":" + ++this.globalProductIndex;
    }

    private String[] getProductIDProperyNames() {
        return this.options.getProductIDProps() != null ? this.options.getProductIDProps() : this.options.getReactantIDProps();
    }

    @Override
    public Molecule[] react() throws ReactionException {
        if (this.options.isTransform()) {
            ProductSet ps = this.reactTransform();
            return ps == null ? null : ps.getResultAsMoleculeArray();
        }
        ProductSet ps = null;
        ps = this.options.isSingle() ? this.reactSingle() : (this.isSelectivityBasedOrdering() ? this.reactSelectivityBased() : this.reactBase());
        if (ps != null) {
            ps.setID(this.getProductIDProperyNames(), this.options.getProductIndexes(), this.getNextID());
            ps.setReactantPropertiesToCopy(this.reactantProperties);
            return ps.getResultAsMoleculeArray();
        }
        return null;
    }

    private ProductSet reactBase() throws ReactionException {
        if (this.options.getDuplicateFilteringMethod() == 0) {
            return this.reactOne();
        }
        return this.reactOneDuplicateFiltered();
    }

    private ProductSet reactOneDuplicateFiltered() throws ReactionException {
        ProductSet ps;
        if (this.psFilter == null) {
            this.psFilter = new LinkedHashSet();
        }
        if ((ps = this.reactOne()) == null) {
            return null;
        }
        if (this.psFilter.add(ps)) {
            return ps;
        }
        return this.reactOneDuplicateFiltered();
    }

    private ProductSet reactOne() throws ReactionException {
        ProductSet ps = null;
        while (ps == null) {
            try {
                if (!this.searcher.find()) {
                    return null;
                }
            }
            catch (SearchException e) {
                throw new ReactionException(e);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Match found. Processing reaction...");
            }
            ps = this.reactHit();
        }
        if (this.options.isRemoveDuplicateProductReferences() && ps != null) {
            ps.removeDuplicateProductReferences();
        }
        return ps;
    }

    private ProductSet reactTransform() throws ReactionException {
        if (this.reactants.length != 1) {
            throw new ReactionException("Multiple reactants in transform mode.");
        }
        ProductSet ps = null;
        while ((ps = this.reactOne()) != null) {
            this.transformedProductSet = ps;
        }
        return this.transformedProductSet;
    }

    private ProductSet reactSingle() throws ReactionException {
        this.productsets = this.fillProductSetsInSelectivityOrder();
        return this.productsets.size() == 1 ? this.productsets.get(0) : null;
    }

    private boolean isSelectivityBasedOrdering() {
        return this.reaction.sjep != null && (this.options.getIgnoreRules() & 2) == 0;
    }

    private ProductSet reactSelectivityBased() throws ReactionException {
        ProductSet ps = null;
        if (this.productsets == null) {
            this.productsets = this.fillProductSetsInSelectivityOrder();
        }
        if (this.productsets.isEmpty()) {
            return null;
        }
        ps = this.productsets.remove(this.productsets.size() - 1);
        return ps;
    }

    private ArrayList<ProductSet> fillProductSetsInSelectivityOrder() throws ReactionException {
        this.productsets = new ArrayList();
        ProductSet ps = null;
        while ((ps = this.reactOne()) != null) {
            this.productsets.add(ps);
        }
        Collections.sort(this.productsets);
        if ((this.options.getIgnoreRules() & 4) == 0) {
            ReactionPerformer.filter(this.productsets, this.reaction.tolerances);
        }
        if (this.options.getDuplicateFilteringMethod() != 0) {
            ReactionPerformer.removeDuplicates(this.productsets);
        }
        Collections.reverse(this.productsets);
        Collections.sort(this.productsets);
        return this.productsets;
    }

    private ProductSet reactHit() throws ReactionException {
        int i;
        Molecule[] products;
        Molecule[] moleculeArray;
        if (!this.options.isTransform() && this.initHitDataArrayFilter() && !this.hitDataArrayFilterSet.add(Arrays.asList(this.searcher.getHitData()))) {
            return null;
        }
        ChemJEP rjep = (this.options.getIgnoreRules() & 1) == 0 ? this.reaction.rjep : null;
        ChemJEP sjep = (this.options.getIgnoreRules() & 2) == 0 ? this.reaction.sjep : null;
        boolean addMappedH = this.options.isMapResult() || rjep != null || sjep != null;
        Molecule[] rmols = addMappedH ? ReactionUtil.cloneMoleculeArray(this.reactants) : this.reactants;
        this.initTemporaryHydrogenStorage();
        this.map2ratom = this.getSearchData(this.searcher.getHitData(), rmols, addMappedH ? this.hlist : null, addMappedH);
        this.currentReactants = rmols;
        Molecule[] mols = this.options.isTransform() ? this.reactants : ReactionUtil.cloneMoleculeArray(this.reactants);
        this.setEnhancedStereo(mols);
        this.map2patom = this.getSearchData(this.searcher.getHitData(), mols, this.hlist, addMappedH);
        this.setAtomMaps(mols);
        Molecule[] unmappedFrags = null;
        Molecule mol = null;
        if (this.options.isTransform()) {
            mol = mols[0];
        } else {
            mol = new Molecule();
            mol.setDim(0);
            for (int i2 = 0; i2 < mols.length; ++i2) {
                if (mols[i2].getFragCount() > 1) {
                    Molecule[] frags = mols[i2].convertToFrags();
                    for (int j = 0; j < frags.length; ++j) {
                        for (int k = frags[j].getAtomCount() - 1; k >= 0; --k) {
                            if (frags[j].getAtom(k).getAtomMap() == 0) continue;
                            mol.fuse(frags[j]);
                            frags[j] = null;
                            break;
                        }
                        if (frags[j] == null) continue;
                        if (unmappedFrags == null) {
                            unmappedFrags = new Molecule[mols.length];
                        }
                        if (unmappedFrags[i2] == null) {
                            unmappedFrags[i2] = frags[j];
                            continue;
                        }
                        unmappedFrags[i2].fuse(frags[j]);
                    }
                    continue;
                }
                mol.fuse(mols[i2]);
            }
        }
        this.fillRLigandSets(mol);
        if (!this.options.isTransform()) {
            this.fillRCisTransSets(mol);
        }
        if (this.isAromaticBondChanging()) {
            mol.aromatize();
        }
        this.transformAtoms(mol);
        boolean rearomatize = this.transformBonds(mol);
        this.transformAtomProperties(mol);
        this.setParities(mol);
        this.setCisTrans(mol);
        mol.valenceCheck();
        if (this.options.isTransform()) {
            Molecule[] moleculeArray2 = new Molecule[1];
            moleculeArray = moleculeArray2;
            moleculeArray2[0] = mol;
        } else {
            moleculeArray = products = this.fragment(mol);
        }
        if (unmappedFrags != null) {
            int[] index2map = this.searcher.isReverse() ? this.reaction.pindex2map : this.reaction.rindex2map;
            for (i = 0; i < unmappedFrags.length; ++i) {
                MolAtom atom;
                if (unmappedFrags[i] == null || (atom = this.map2patom[index2map[i]]) == null) continue;
                atom.getParent().fuse(unmappedFrags[i]);
            }
        }
        if (this.absStereo) {
            for (int i3 = 0; i3 < products.length; ++i3) {
                products[i3].setAbsStereo(ReactionUtil.isAbsoluteStereoRelevant(products[i3]));
            }
        }
        if (rearomatize) {
            for (int i4 = 0; i4 < products.length; ++i4) {
                products[i4].aromatize();
            }
        }
        if (rjep != null || sjep != null) {
            this.setContext(this.reactants, products);
        }
        if (rjep != null) {
            try {
                if (!rjep.evaluate_boolean(this.context)) {
                    this.clear();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Reactivity rule is not fulfilled.");
                    }
                    return null;
                }
            }
            catch (ParseException e) {
                this.clear();
                throw new ReactionException("An error occured while evaluating reactivity rule.", e);
            }
        }
        double[] measures = null;
        if (sjep != null) {
            try {
                measures = sjep.evaluate_doubles(this.context);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Selectivity values: " + Arrays.toString(measures));
                }
            }
            catch (ParseException e) {
                this.clear();
                throw new ReactionException("An error occured while evaluating selectivity rule.", e);
            }
        }
        if (!this.options.isMapResult()) {
            this.restoreAtomMaps();
        }
        this.removeNewHydrogens();
        for (i = 0; i < products.length; ++i) {
            products[i].valenceCheck();
        }
        this.clear();
        if (products != null && this.options.getProductIndexes() != null) {
            Molecule[] result = new Molecule[this.options.getProductIndexes().length];
            for (int i5 = 0; i5 < this.options.getProductIndexes().length; ++i5) {
                result[i5] = products[this.options.getProductIndexes()[i5]];
            }
            products = result;
        }
        for (int i6 = 0; i6 < products.length; ++i6) {
            ReactionPerformer.removeDoubleBondStereoFlagsFromSingleBonds(products[i6]);
            SmilesImport.fixCisInSmallRings(products[i6]);
        }
        if (products != null) {
            if (this.options.getResultType() == 0) {
                return ProductSet.createProductSet(products, measures, this.options.getDuplicateFilteringMethod());
            }
            if (this.options.getResultType() == 1) {
                return ProductSet.createProductSet(this.currentReactants, products, measures, this.options.getDuplicateFilteringMethod());
            }
        }
        return null;
    }

    private boolean initHitDataArrayFilter() {
        if (this.hitDataArrayFilterSet == null) {
            this.hitDataArrayFilterSet = new HashSet();
        }
        return true;
    }

    private void initTemporaryHydrogenStorage() {
        if (this.hlist == null) {
            this.hlist = new ArrayList();
        }
        if (this.hcuts == null) {
            this.hcuts = new ArrayList();
        }
    }

    private static void removeDoubleBondStereoFlagsFromSingleBonds(MoleculeGraph mol) {
        for (int i = 0; i < mol.getBondCount(); ++i) {
            MolBond bond = mol.getBond(i);
            if (bond.getType() != 1) continue;
            bond.setFlags(bond.getFlags() & 0xFFFFFE3F);
        }
    }

    private MolAtom[] getSearchData(HitData[] hd, Molecule[] mols, ArrayList<MolAtom> hlist, boolean addMappedH) throws ReactionException {
        MolBond b;
        MolAtom h;
        MolAtom[] map2atom = new MolAtom[1024];
        for (int i = 0; i < hd.length; ++i) {
            for (int j = 0; j < hd[i].size(); ++j) {
                int index;
                int m = hd[i].getMap(j);
                int a = hd[i].getAtomIndex(j);
                if (a >= 0) {
                    this.assignMap(m, mols[i].getAtom(a), map2atom);
                    continue;
                }
                if (!addMappedH && hlist == null) continue;
                int n = index = a == Integer.MIN_VALUE ? 0 : -a;
                if (index >= mols[i].getAtomCount()) continue;
                MolAtom atom = mols[i].getAtom(index);
                int hcount = atom.getImplicitHcount();
                h = new MolAtom(1);
                b = new MolBond(atom, h);
                mols[i].add(h);
                mols[i].add(b);
                if (hlist != null) {
                    hlist.add(h);
                }
                this.assignMap(m, h, map2atom);
                atom.setImplicitHcount(hcount - 1);
            }
        }
        if (hlist != null) {
            boolean reverse = this.searcher.isReverse();
            int n = reverse ? this.reaction.getReactantAtomCount() : this.reaction.getProductAtomCount();
            for (int j = 0; j < n; ++j) {
                MolAtom atom = reverse ? this.reaction.getReactantAtom(j) : this.reaction.getProductAtom(j);
                int m = atom.getAtomMap();
                atom.setAtomMap(0);
                atom.clearQProps();
                if (map2atom[m] != null) continue;
                map2atom[m] = atom;
                if (!this.options.isTransform()) continue;
                for (int i = 0; i < hd.length; ++i) {
                    this.searcher.exclude(i, map2atom[m]);
                }
            }
            for (int i = 0; i < hd.length; ++i) {
                for (int j = 0; j < hd[i].size(); ++j) {
                    MolAtom atom;
                    int a = hd[i].getAtomIndex(j);
                    if (a < 0 || !ReactionUtil.isHProblematicAtno((atom = mols[i].getAtom(a)).getAtno())) continue;
                    for (int k = atom.getImplicitHcount() - 1; k >= 0; --k) {
                        h = new MolAtom(1);
                        b = new MolBond(atom, h);
                        mols[i].add(h);
                        mols[i].add(b);
                        hlist.add(h);
                    }
                    atom.setImplicitHcount(0);
                }
            }
        }
        return map2atom;
    }

    private void assignMap(int m, MolAtom atom, MolAtom[] map2atom) throws ReactionException {
        if (ReactionUtil.hasIdenticalMapsOnProductSide(this.reaction.rxn)) {
            throw new ReactionException("Unsupported mapping style: " + ReactionUtil.toFormat(this.reaction.rxn, new String[]{"smarts", "cxsmarts", "mrv"}));
        }
        while (map2atom[m] != null) {
            m = this.reaction.map2map[m];
        }
        map2atom[m] = atom;
    }

    private void transformAtoms(Molecule mol) {
        boolean reverse = this.searcher.isReverse();
        int[] map2rindex = reverse ? this.reaction.map2pindex : this.reaction.map2rindex;
        int[] map2pindex = reverse ? this.reaction.map2rindex : this.reaction.map2pindex;
        this.stgrpMap.clear();
        this.initTemporaryHydrogenStorage();
        for (int i = 1; i < this.map2patom.length; ++i) {
            if (this.map2patom[i] == null) continue;
            if (map2pindex[i] == -1 && map2rindex[i] != -1) {
                int hcount = -1;
                MolAtom ligand = null;
                if (this.map2patom[i].getAtno() == 1 && this.map2patom[i].getBondCount() == 1 && ReactionUtil.isHProblematicAtno((ligand = this.map2patom[i].getLigand(0)).getAtno())) {
                    hcount = ligand.getImplicitHcount();
                }
                for (int j = 0; j < this.map2patom[i].getBondCount(); ++j) {
                    ligand = this.map2patom[i].getLigand(j);
                    if (ligand.getCharge() == 0) continue;
                    ligand.setFlags(0, 65536);
                }
                mol.removeAtom(this.map2patom[i]);
                if (hcount != -1 && ligand.getImplicitHcount() == hcount + 1) {
                    this.hcuts.add(ligand);
                }
                this.map2patom[i] = null;
                continue;
            }
            if (map2pindex[i] != -1 && map2rindex[i] == -1) {
                this.map2patom[i].setQProp(HCOUNT, this.map2patom[i].getImplicitHcount());
                mol.add(this.map2patom[i]);
                int stgrpType = this.map2patom[i].getStereoGroupType();
                if (stgrpType == 3 || stgrpType == 2) {
                    int stgrpNumber = this.map2patom[i].getStereoGroupNumber();
                    stgrpNumber = this.transformStereoGroupNumber(mol, stgrpType, stgrpNumber);
                    this.map2patom[i].setStereoGroupNumber(stgrpNumber);
                }
                if (this.changedAtomSet == null) continue;
                this.changedAtomSet.add(this.map2patom[i]);
                continue;
            }
            if (mol.indexOf(this.map2patom[i]) != -1) continue;
            mol.add(this.map2patom[i]);
            if (this.changedAtomSet == null) continue;
            this.changedAtomSet.add(this.map2patom[i]);
        }
    }

    private void transformAtomProperties(Molecule mol) {
        int i;
        this.stgrpMap.clear();
        ArrayList<MolAtom> atomprops = this.searcher.isReverse() ? this.reaction.getReactantAtomProps() : this.reaction.getProductAtomProps();
        for (i = atomprops.size() - 1; i >= 0; --i) {
            int hcount;
            MolAtom atomprop = atomprops.get(i);
            int map = atomprop.getAtomMap();
            MolAtom atom = this.map2patom[map];
            if (atom == null) continue;
            int proptype = this.getReaction().getPropertyTypes().get(i);
            if ((proptype & 1) != 0) {
                atom.setCharge(atomprop.getCharge());
            }
            if ((proptype & 2) != 0) {
                atom.setRadical(atomprop.getRadical());
            }
            if ((proptype & 4) != 0) {
                int stgrpType = atomprop.getStereoGroupType();
                atom.setStereoGroupType(stgrpType);
                if (stgrpType == 3 || stgrpType == 2) {
                    int stgrpNumber = atomprop.getStereoGroupNumber();
                    stgrpNumber = this.transformStereoGroupNumber(mol, stgrpType, stgrpNumber);
                    atom.setStereoGroupNumber(stgrpNumber);
                }
            }
            if ((proptype & 8) != 0 && (hcount = atomprop.getQPropAsInt("H")) != -1) {
                this.removeH(atom);
                atom.setImplicitHcount(hcount);
            }
            if ((proptype & 0x20) != 0) {
                atom.setMassno(atomprop.getMassno());
            }
            atom.setValenceProp(-1);
            if ((proptype & 0x40) == 0) continue;
            atom.setValenceProp(atomprop.getValenceProp());
        }
        for (i = 1; i < this.map2patom.length; ++i) {
            int hcount;
            MolAtom atom = this.map2patom[i];
            if (atom == null || (hcount = atom.getQPropAsInt(HCOUNT)) == -1) continue;
            atom.setImplicitHcount(hcount);
            atom.setQProp(HCOUNT, -1);
        }
    }

    private void setEnhancedStereo(Molecule[] mols) {
        for (int i = 1; i < mols.length; ++i) {
            this.stgrpMap.clear();
            for (int j = mols[i].getAtomCount() - 1; j >= 0; --j) {
                MolAtom atom = mols[i].getAtom(j);
                int stgrpType = atom.getStereoGroupType();
                if (stgrpType != 3 && stgrpType != 2) continue;
                int stgrpNumber = atom.getStereoGroupNumber();
                int stgrpNumberMapped = -1;
                stgrpNumberMapped = this.getMappedStereoGroup(stgrpType, stgrpNumber);
                if (stgrpNumberMapped == -1) {
                    stgrpNumberMapped = ReactionPerformer.getFreeStereoGroupNumber(mols, i, stgrpType, stgrpNumber);
                    this.stgrpMap.add(new int[]{stgrpType, stgrpNumber, stgrpNumberMapped});
                }
                atom.setStereoGroupNumber(stgrpNumberMapped);
            }
        }
    }

    private int transformStereoGroupNumber(Molecule mol, int stgrpType, int stgrpNumber) {
        int stgrpNumberMapped = -1;
        stgrpNumberMapped = this.getMappedStereoGroup(stgrpType, stgrpNumber);
        if (stgrpNumberMapped == -1) {
            stgrpNumberMapped = ReactionPerformer.getFreeStereoGroupNumber(mol, stgrpType, stgrpNumber);
            this.stgrpMap.add(new int[]{stgrpType, stgrpNumber, stgrpNumberMapped});
        }
        return stgrpNumberMapped;
    }

    private int getMappedStereoGroup(int strgrpType, int stgrpNumber) {
        for (int j = this.stgrpMap.size() - 1; j >= 0; --j) {
            int[] m = this.stgrpMap.get(j);
            if (m[0] != strgrpType || m[1] != stgrpNumber) continue;
            return m[2];
        }
        return -1;
    }

    private static int getFreeStereoGroupNumber(Molecule mol, int type, int number) {
        return ReactionPerformer.getFreeStereoGroupNumber(new Molecule[]{mol}, 1, type, number);
    }

    private static int getFreeStereoGroupNumber(Molecule[] mols, int index, int type, int number) {
        int max = Math.min(mols.length - 1, index);
        IntVector used = null;
        boolean free = true;
        for (int i = 0; i <= max; ++i) {
            Molecule mol = mols[i];
            for (int j = mol.getAtomCount() - 1; j >= 0; --j) {
                MolAtom atom = mol.getAtom(j);
                if (atom.getStereoGroupType() != type) continue;
                int n = atom.getStereoGroupNumber();
                if (i != index && n == number) {
                    free = false;
                }
                if (i == index && n == number) continue;
                if (used == null) {
                    used = new IntVector(10);
                }
                used.addElement(n);
            }
        }
        if (free) {
            return number;
        }
        int p = 0;
        used.sort();
        int size = used.size();
        for (int k = 0; k < size; ++k) {
            int m = used.elementAt(k);
            if (m - p > 1) {
                return m - 1;
            }
            p = m;
        }
        return p + 1;
    }

    private boolean isAromaticBondChanging() {
        boolean reverse = this.searcher.isReverse();
        for (int i = 0; i < this.reaction.bcount; ++i) {
            int pbondtype;
            int rbondtype = reverse ? this.reaction.pbondtypes[i] : this.reaction.rbondtypes[i];
            int n = pbondtype = reverse ? this.reaction.rbondtypes[i] : this.reaction.pbondtypes[i];
            if (rbondtype != 4 || pbondtype == 4) continue;
            return true;
        }
        return false;
    }

    private boolean transformBonds(Molecule mol) throws ReactionException {
        boolean reverse = this.searcher.isReverse();
        boolean rearomatize = false;
        boolean regenSgroups = false;
        this.initTemporaryHydrogenStorage();
        for (int i = 0; i < this.reaction.bcount; ++i) {
            int hcount2;
            int hcount1;
            MolBond bond;
            Sgroup sgroup2;
            Sgroup sgroup1;
            int smap = this.reaction.smaps[i];
            int emap = this.reaction.emaps[i];
            int pbondtype = reverse ? this.reaction.rbondtypes[i] : this.reaction.pbondtypes[i];
            MolAtom atom1 = this.map2patom[smap];
            MolAtom atom2 = this.map2patom[emap];
            if (atom1 == null && atom2 == null) continue;
            if (atom1 != null && atom2 == null) {
                sgroup1 = mol.findSgroupContaining(atom1);
                if (sgroup1 == null) continue;
                mol.ungroupSgroup(sgroup1);
                continue;
            }
            if (atom1 == null && atom2 != null) {
                sgroup2 = mol.findSgroupContaining(atom2);
                if (sgroup2 == null) continue;
                mol.ungroupSgroup(sgroup2);
                continue;
            }
            sgroup1 = mol.findSgroupContaining(atom1);
            if (sgroup1 != null && sgroup1.hasAtom(atom2)) {
                mol.ungroupSgroup(sgroup1);
            }
            if ((sgroup2 = mol.findSgroupContaining(atom2)) != null && sgroup2.hasAtom(atom1)) {
                mol.ungroupSgroup(sgroup2);
            }
            if ((bond = atom1.getBondTo(atom2)) == null && pbondtype != -1 && this.changedAtomSet != null) {
                this.changedAtomSet.add(atom1);
                this.changedAtomSet.add(atom2);
            }
            if (bond != null && pbondtype != -1 && !Search.areMatchingBondTypes(pbondtype, bond.getType())) {
                hcount1 = -1;
                hcount2 = -1;
                if (bond.getType() == 4 || pbondtype == 4) {
                    if (ReactionUtil.isHProblematicAtno(atom1.getAtno())) {
                        hcount1 = atom1.getImplicitHcount();
                    }
                    if (ReactionUtil.isHProblematicAtno(atom2.getAtno())) {
                        hcount2 = atom2.getImplicitHcount();
                    }
                    rearomatize = true;
                }
                bond.setFlags(bond.getFlags() & 0xFFFFFFF0 & 0xFFFFFC0F | pbondtype);
                if (hcount1 != -1 || hcount2 != -1) {
                    atom1.valenceCheck();
                    atom2.valenceCheck();
                    if (hcount1 != -1 && atom1.getImplicitHcount() == hcount1 + 1) {
                        this.hcuts.add(atom1);
                    }
                    if (hcount2 != -1 && atom2.getImplicitHcount() == hcount2 + 1) {
                        this.hcuts.add(atom2);
                    }
                }
                atom1.setValenceProp(-1);
                atom2.setValenceProp(-1);
            } else if (bond != null && pbondtype == -1) {
                hcount1 = -1;
                hcount2 = -1;
                if (pbondtype == -1) {
                    if (ReactionUtil.isHProblematicAtno(atom1.getAtno()) && atom2.getAtno() == 1) {
                        hcount1 = atom1.getImplicitHcount();
                    } else if (ReactionUtil.isHProblematicAtno(atom2.getAtno()) && atom1.getAtno() == 1) {
                        hcount2 = atom2.getImplicitHcount();
                    }
                }
                if (bond.getType() == 4) {
                    rearomatize = true;
                }
                mol.removeBond(bond);
                if (hcount1 != -1 && atom1.getImplicitHcount() == hcount1 + 1) {
                    this.hcuts.add(atom1);
                }
                if (hcount2 != -1 && atom2.getImplicitHcount() == hcount2 + 1) {
                    this.hcuts.add(atom2);
                }
                bond = null;
            } else if (bond == null && pbondtype != -1) {
                int attachmentPointIndex;
                if (atom1.getAtno() != 135 && atom2.getAtno() != 135) {
                    bond = new MolBond(atom1, atom2);
                } else if (atom1.getAtno() == 135 && atom2.getAtno() != 135) {
                    attachmentPointIndex = this.getReaction().getSgroupAtomAttachmentPointIndex(smap, emap, reverse);
                    bond = new MolBond(((SgroupAtom)atom1).getSgroup().getAttachAtoms()[attachmentPointIndex], atom2);
                    regenSgroups = true;
                } else if (atom1.getAtno() != 135 && atom2.getAtno() == 135) {
                    attachmentPointIndex = this.getReaction().getSgroupAtomAttachmentPointIndex(emap, smap, reverse);
                    bond = new MolBond(atom1, ((SgroupAtom)atom2).getSgroup().getAttachAtoms()[attachmentPointIndex]);
                    regenSgroups = true;
                } else if (atom1.getAtno() == 135 && atom2.getAtno() == 135) {
                    int attachmentPointIndex1 = this.getReaction().getSgroupAtomAttachmentPointIndex(smap, emap, reverse);
                    int attachmentPointIndex2 = this.getReaction().getSgroupAtomAttachmentPointIndex(emap, smap, reverse);
                    bond = new MolBond(((SgroupAtom)atom1).getSgroup().getAttachAtoms()[attachmentPointIndex1], ((SgroupAtom)atom2).getSgroup().getAttachAtoms()[attachmentPointIndex2]);
                    regenSgroups = true;
                }
                bond.setType(pbondtype);
                mol.add(bond);
                atom1.setValenceProp(-1);
                atom2.setValenceProp(-1);
                if (pbondtype == 4) {
                    rearomatize = true;
                }
            }
            if (bond != null && bond.isQuery()) {
                this.clear();
                throw new ReactionException("Query bond should not be added to target - correct reaction: " + ReactionUtil.toFormat(this.reaction.rxn, new String[]{"smarts", "cxsmarts", "mrv"}));
            }
            if (bond == null) continue;
        }
        if (regenSgroups) {
            ReactionPerformer.regenSgroups(mol);
        }
        if (rearomatize) {
            mol.dearomatize();
        }
        return rearomatize;
    }

    private static void regenSgroups(Molecule mol) {
        if (mol.isGUIContracted()) {
            mol.setGUIContracted(false);
            mol.setGUIContracted(true);
        }
    }

    private void setAtomMaps(Molecule[] mols) {
        if (this.options.isMapResult()) {
            for (int i = 0; i < this.currentReactants.length; ++i) {
                Molecule mol = this.currentReactants[i];
                for (int j = mol.getAtomCount() - 1; j >= 0; --j) {
                    mol.getAtom(j).setAtomMap(0);
                }
            }
        }
        if (this.origmapped == null) {
            this.origmapped = new ArrayList();
        }
        int t = 0;
        for (int i = 0; i < mols.length; ++i) {
            Molecule mol = mols[i];
            for (int j = mol.getAtomCount() - 1; j >= 0; --j) {
                MolAtom atom = mol.getAtom(j);
                int map = atom.getAtomMap();
                if (map == 0) continue;
                if (!this.options.isMapResult()) {
                    this.origmapped.add(atom);
                    if (t == this.origmaps.length) {
                        int[] p = new int[t + t];
                        System.arraycopy(this.origmaps, 0, p, 0, this.origmaps.length);
                        this.origmaps = p;
                    }
                    this.origmaps[t++] = atom.getAtomMap();
                }
                atom.setAtomMap(0);
            }
        }
        for (int map = 1; map < 1024; ++map) {
            MolAtom patom;
            MolAtom ratom;
            if (this.options.isMapResult() && (ratom = this.map2ratom[map]) != null) {
                ratom.setAtomMap(map);
            }
            if ((patom = this.map2patom[map]) == null) continue;
            patom.setAtomMap(map);
        }
    }

    private void restoreAtomMaps() {
        MolAtom atom;
        for (int map = 1; map < 1024; ++map) {
            atom = this.map2patom[map];
            if (atom == null) continue;
            atom.setAtomMap(0);
        }
        if (this.origmapped != null) {
            for (int i = this.origmapped.size() - 1; i >= 0; --i) {
                atom = this.origmapped.get(i);
                atom.setAtomMap(this.origmaps[i]);
            }
        }
    }

    private void removeNewHydrogens() {
        int c;
        int i;
        if (this.hcuts != null) {
            for (i = this.hcuts.size() - 1; i >= 0; --i) {
                MolAtom a = this.hcuts.get(i);
                int hcount = a.getImplicitHcount() - 1;
                if (hcount < 0) continue;
                a.setImplicitHcount(hcount);
            }
        }
        if (this.hlist != null) {
            for (i = this.hlist.size() - 1; i >= 0; --i) {
                MolAtom h = this.hlist.get(i);
                c = h.getBondCount();
                if ((c != 0 || !this.options.isTransform()) && (c <= 0 || h.getLigand(0).getAtno() == 1)) continue;
                int map = h.getAtomMap();
                if (!(this.options.isMapResult() && map != 0 || h.getMassno() != 0 || h.getParent() == null)) {
                    h.getParent().removeAtom(h);
                }
                if (map == 0) continue;
                this.map2patom[map] = null;
            }
        }
        for (int map = 1; map < 1024; ++map) {
            MolAtom atom;
            if (this.map2ratom[map] != null || (atom = this.map2patom[map]) == null || !atom.isImplicitizableH(0) || ((c = atom.getBondCount()) != 0 || !this.options.isTransform()) && (c <= 0 || atom.getLigand(0).getAtno() == 1)) continue;
            if (!this.options.isMapResult() && atom.getParent() != null) {
                atom.getParent().removeAtom(atom);
            }
            this.map2patom[map] = null;
        }
    }

    private void clear() {
        this.clearContext();
        this.rligandsets.clear();
        this.rcistranssets.clear();
        this.origmapped = null;
        this.hlist = null;
        this.hcuts = null;
    }

    private void setContext(Molecule[] rmols, Molecule[] pmols) {
        if (this.context == null) {
            this.context = new ReactionContext();
        }
        if (this.searcher.isReverse()) {
            this.context.setReactants(pmols);
            this.context.setProducts(rmols);
            this.context.setReactantAtomsByMap(this.map2patom);
            this.context.setProductAtomsByMap(this.map2ratom);
        } else {
            this.context.setReactants(rmols);
            this.context.setProducts(pmols);
            this.context.setReactantAtomsByMap(this.map2ratom);
            this.context.setProductAtomsByMap(this.map2patom);
        }
    }

    private void clearContext() {
        if (this.context != null) {
            this.context.clear();
        }
        Arrays.fill(this.map2ratom, null);
        Arrays.fill(this.map2patom, null);
    }

    private Molecule[] fragment(Molecule mol) {
        MoleculeGraph frag;
        Molecule[] frags = mol.convertToFrags();
        Molecule[] products = new Molecule[this.getProductCount()];
        boolean reverse = this.searcher.isReverse();
        int[] index2map = reverse ? this.reaction.rindex2map : this.reaction.pindex2map;
        block0: for (int i = 0; i < products.length; ++i) {
            int map = index2map[i];
            frag = this.map2patom[map].getParent();
            products[i] = (Molecule)frag;
            for (int j = 0; j < frags.length; ++j) {
                if (frag != frags[j]) continue;
                frags[j] = null;
                continue block0;
            }
        }
        int[] map2index = reverse ? this.reaction.map2rindex : this.reaction.map2pindex;
        block2: for (int i = 0; i < frags.length; ++i) {
            frag = frags[i];
            if (frag == null) continue;
            int map = 0;
            for (int j = frag.getAtomCount() - 1; j >= 0; --j) {
                map = frag.getAtom(j).getAtomMap();
                if (map == 0) continue;
                int index = map2index[map];
                products[index].fuse(frag);
                continue block2;
            }
        }
        return products;
    }

    private void fillRLigandSets(Molecule mol) {
        int count = mol.getAtomCount();
        for (int i = 0; i < count; ++i) {
            int lcount;
            int stereo;
            MolAtom atom = mol.getAtom(i);
            int map = atom.getAtomMap();
            int parity = mol.getParity(i);
            int n = stereo = map != 0 ? this.reaction.map2stereo[map] : 0;
            if (stereo == 0 && parity != 1 && parity != 2 || (lcount = atom.getBondCount()) > 4) continue;
            MolAtom[] ligands = new MolAtom[4];
            int[] indices = new int[4];
            Arrays.fill(indices, Integer.MAX_VALUE);
            int k = 0;
            for (int j = 0; j < lcount; ++j) {
                MolAtom ligand = atom.getLigand(j);
                if (ligand.getAtno() == 1) continue;
                ligands[k] = ligand;
                indices[k] = mol.indexOf(ligand);
                ++k;
            }
            this.rligandsets.add(new LigandSet(atom, parity, ligands, indices));
        }
    }

    private void setParities(Molecule mol) throws ReactionException {
        int map;
        int count = mol.getAtomCount();
        int[] indices = new int[4];
        int[] parities = new int[count];
        for (int i = 0; i < count; ++i) {
            MolAtom atom = mol.getAtom(i);
            LigandSet ligandset = this.getLigandSet(atom);
            if (ligandset != null) {
                int stereo;
                boolean changed = ReactionPerformer.fillLigandIndices(indices, ligandset, atom, mol);
                map = atom.getAtomMap();
                int n = stereo = changed ? 0 : 2;
                if (map != 0 && this.reaction.map2stereo[map] != 0) {
                    stereo = this.reaction.map2stereo[map];
                }
                if (stereo != 0) {
                    boolean same = MolAtom.isSameParityClass(ligandset.indices[0], ligandset.indices[1], ligandset.indices[2], ligandset.indices[3], indices[0], indices[1], indices[2], indices[3]);
                    parities[i] = ReactionPerformer.getParity(ligandset.parity, same, stereo);
                    continue;
                }
                parities[i] = 3;
                continue;
            }
            parities[i] = mol.getParity(i);
        }
        boolean reverse = this.searcher.isReverse();
        ArrayList<int[]> plist = reverse ? this.reaction.rparities : this.reaction.pparities;
        for (int i = plist.size() - 1; i >= 0; --i) {
            int index;
            MolAtom atom;
            int[] p = plist.get(i);
            map = p[0];
            if (this.reaction.map2stereo[map] != 0 || (atom = this.map2patom[map]) == null || (index = mol.indexOf(atom)) == -1) continue;
            if (p.length == 1) {
                parities[index] = 0;
                continue;
            }
            for (int j = 1; j < 5; ++j) {
                int m = p[j];
                indices[j - 1] = m > 0 ? mol.indexOf(this.map2patom[m]) : (m == 0 ? mol.indexOf(ReactionPerformer.getUnmappedLigand(atom)) : Integer.MAX_VALUE);
            }
            int psign1 = p[5];
            int psign2 = MolAtom.paritySign(indices[0], indices[1], indices[2], indices[3]);
            parities[index] = ReactionPerformer.getParity(p[6], psign1 == psign2, 2);
        }
        mol.setParity(parities);
    }

    private LigandSet getLigandSet(MolAtom atom) {
        for (int j = this.rligandsets.size() - 1; j >= 0; --j) {
            LigandSet ligandset = this.rligandsets.get(j);
            if (ligandset.atom != atom) continue;
            return ligandset;
        }
        return null;
    }

    private static boolean fillLigandIndices(int[] indices, LigandSet ligandset, MolAtom atom, Molecule mol) {
        int k;
        int changed = -1;
        Arrays.fill(indices, Integer.MAX_VALUE);
        for (int j = atom.getBondCount() - 1; j >= 0; --j) {
            MolAtom ligand = atom.getLigand(j);
            if (ligand.getAtno() == 1) continue;
            int index = mol.indexOf(ligand);
            int t = -1;
            for (int k2 = 0; k2 < 4; ++k2) {
                if (ligandset.ligands[k2] != ligand) continue;
                t = k2;
                break;
            }
            if (t != -1) {
                indices[t] = index;
                continue;
            }
            if (changed != -1 && logger.isLoggable(Level.FINE)) {
                logger.fine("More than one atom has changed around stereo center: " + (changed + 1) + ", " + (index + 1));
            }
            changed = index;
        }
        if (changed == -1) {
            return false;
        }
        for (k = 0; k < 4; ++k) {
            if (indices[k] != Integer.MAX_VALUE || ligandset.indices[k] == Integer.MAX_VALUE) continue;
            indices[k] = changed;
            return true;
        }
        for (k = 0; k < 4; ++k) {
            if (indices[k] != Integer.MAX_VALUE || ligandset.indices[k] != Integer.MAX_VALUE) continue;
            indices[k] = changed;
            return true;
        }
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("stereo error: changed = " + changed);
        }
        return true;
    }

    private void fillRCisTransSets(Molecule mol) {
        for (int j = mol.getBondCount() - 1; j >= 0; --j) {
            MolBond bond = mol.getBond(j);
            if (bond.getType() != 2) continue;
            MolAtom atom1 = bond.getAtom1();
            MolAtom atom2 = bond.getAtom2();
            int count1 = atom1.getBondCount();
            int count2 = atom2.getBondCount();
            if (count1 < 2 || count2 < 2 || count1 > 3 || count2 > 3 || atom1.getExplicitHcount() + atom1.getImplicitHcount() >= 2 || atom2.getExplicitHcount() + atom2.getImplicitHcount() >= 2) continue;
            MolAtom[] atoms = new MolAtom[4];
            int k = 0;
            MolAtom ligand = atom1.getLigand(0);
            if (ligand != atom2) {
                atoms[k++] = ligand;
            }
            if ((ligand = atom1.getLigand(1)) != atom2) {
                atoms[k++] = ligand;
            }
            MolAtom molAtom = ligand = count1 == 3 ? atom1.getLigand(2) : null;
            if (ligand != atom2) {
                atoms[k++] = ligand;
            }
            if ((ligand = atom2.getLigand(0)) != atom1) {
                atoms[k++] = ligand;
            }
            if ((ligand = atom2.getLigand(1)) != atom1) {
                atoms[k++] = ligand;
            }
            MolAtom molAtom2 = ligand = count2 == 3 ? atom2.getLigand(2) : null;
            if (ligand != atom1) {
                atoms[k++] = ligand;
            }
            int[] cts = new int[]{ReactionPerformer.getCisTrans(mol, bond, atoms[0], atoms[2]), ReactionPerformer.getCisTrans(mol, bond, atoms[0], atoms[3]), ReactionPerformer.getCisTrans(mol, bond, atoms[1], atoms[2]), ReactionPerformer.getCisTrans(mol, bond, atoms[1], atoms[3])};
            this.rcistranssets.add(new CisTransSet(bond, atoms, cts));
        }
    }

    private static int getCisTrans(Molecule mol, MolBond bond, MolAtom ligand1, MolAtom ligand2) {
        return ligand1 != null && ligand2 != null ? mol.getStereo2(bond, ligand1, ligand2) : -1;
    }

    private void setCisTrans(Molecule mol) throws ReactionException {
        MolAtom atom2;
        MolAtom atom1;
        int i;
        ArrayList<int[]> cistrans = this.searcher.isReverse() ? this.reaction.rcistrans : this.reaction.pcistrans;
        ArrayList<MolBond> mbonds = new ArrayList<MolBond>();
        for (i = cistrans.size() - 1; i >= 0; --i) {
            int[] t = cistrans.get(i);
            MolAtom ligand1 = this.map2patom[t[0]];
            atom1 = this.map2patom[t[1]];
            atom2 = this.map2patom[t[2]];
            MolAtom ligand2 = this.map2patom[t[3]];
            MolBond bond = atom1.getBondTo(atom2);
            if (ReactionPerformer.ctunspec(t[4])) {
                if (!this.options.isTransform()) {
                    bond.setStereo2Flags(ligand1, ligand2, 192);
                    MolBond b = null;
                    if (ligand1.getBondCount() == 1 || ligand2.getBondCount() != 1) {
                        b = atom1.getBondTo(ligand1);
                        if (b.getAtom1() != atom1) {
                            b.swap();
                        }
                    } else {
                        b = atom2.getBondTo(ligand2);
                        if (b.getAtom1() != atom2) {
                            b.swap();
                        }
                    }
                    b.setFlags(48, 48);
                }
            } else {
                bond.setStereo2Flags(ligand1, ligand2, t[4]);
            }
            mbonds.add(bond);
        }
        for (i = this.rcistranssets.size() - 1; i >= 0; --i) {
            CisTransSet ctset = this.rcistranssets.get(i);
            int bind = mol.indexOf(ctset.bond);
            if (bind == -1 || mol.getBond(bind) != ctset.bond || ctset.bond.getType() != 2 || mbonds.contains(ctset.bond)) continue;
            atom1 = ctset.bond.getAtom1();
            atom2 = ctset.bond.getAtom2();
            int count1 = atom1.getBondCount();
            int count2 = atom2.getBondCount();
            if (count1 < 2 || count2 < 2 || count1 > 3 || count2 > 3) continue;
            int h1 = -1;
            int i1 = -1;
            MolAtom ligand = null;
            for (int j = 0; j < count1; ++j) {
                MolAtom l1 = atom1.getLigand(j);
                if (l1 == ctset.atoms[0]) {
                    i1 = 0;
                    break;
                }
                if (l1 == ctset.atoms[1]) {
                    i1 = 1;
                    break;
                }
                if (l1.getAtno() == 1) {
                    h1 = j;
                    continue;
                }
                if (l1 == atom2) continue;
                ligand = l1;
            }
            MolAtom ligand1 = null;
            if (i1 == -1) {
                if (count1 == 2 || h1 != -1) {
                    if (ctset.atoms[0] == null || ctset.atoms[0].getAtno() == 1) {
                        ligand1 = ligand;
                        i1 = 1;
                    } else if (ctset.atoms[1] == null || ctset.atoms[1].getAtno() == 1) {
                        ligand1 = ligand;
                        i1 = 0;
                    }
                }
            } else {
                ligand1 = ctset.atoms[i1];
            }
            int h2 = -1;
            int i2 = -1;
            ligand = null;
            for (int j = 0; j < count2; ++j) {
                MolAtom l2 = atom2.getLigand(j);
                if (l2 == ctset.atoms[2]) {
                    i2 = 2;
                    break;
                }
                if (l2 == ctset.atoms[3]) {
                    i2 = 3;
                    break;
                }
                if (l2.getAtno() == 1) {
                    h2 = j;
                    continue;
                }
                if (l2 == atom1) continue;
                ligand = l2;
            }
            MolAtom ligand2 = null;
            if (i2 == -1) {
                if (count2 == 2 || h2 != -1) {
                    if (ctset.atoms[2] == null || ctset.atoms[2].getAtno() == 1) {
                        ligand2 = ligand;
                        i2 = 3;
                    } else if (ctset.atoms[3] == null || ctset.atoms[3].getAtno() == 1) {
                        ligand2 = ligand;
                        i2 = 2;
                    }
                }
            } else {
                ligand2 = ctset.atoms[i2];
            }
            if (ligand1 != null && ligand2 != null) {
                ctset.bond.setStereo2Flags(ligand1, ligand2, ctset.cts[i1 * 2 + i2 - 2]);
                continue;
            }
            ctset.bond.setFlags(256, 448);
        }
    }

    private static boolean ctunspec(int f) {
        return (f & 0x100) != 0 || (f & 0x80) != 0 && (f & 0x40) != 0;
    }

    private void removeH(MolAtom atom) {
        for (int i = atom.getBondCount() - 1; i >= 0; --i) {
            MolAtom ligand = atom.getLigand(i);
            if (!ligand.isImplicitizableH(0)) continue;
            atom.getParent().removeAtom(ligand);
        }
    }

    private static MolAtom getUnmappedLigand(MolAtom atom) throws ReactionException {
        MolAtom uligand = null;
        for (int i = atom.getBondCount() - 1; i >= 0; --i) {
            MolAtom ligand = atom.getLigand(i);
            if (ligand.getAtno() == 1 || ligand.getAtomMap() != 0) continue;
            if (uligand == null) {
                uligand = ligand;
                continue;
            }
            throw new ReactionException("Unmapped ligand is not unique.");
        }
        if (uligand == null) {
            throw new ReactionException("There is no unmapped ligand.");
        }
        return uligand;
    }

    private static int getParity(int parity, boolean same, int stereo) {
        if (same && stereo == 1 || !same && stereo == 2) {
            if (parity == 1) {
                return 2;
            }
            if (parity == 2) {
                return 1;
            }
        }
        return parity;
    }

    private static boolean isAbsStereo(Molecule[] mols) {
        for (int i = 0; i < mols.length; ++i) {
            if (!mols[i].isAbsStereo() || !ReactionUtil.isAbsoluteStereoRelevant(mols[i])) continue;
            return true;
        }
        return false;
    }

    class CisTransSet
    implements Serializable {
        MolBond bond = null;
        MolAtom[] atoms = null;
        int[] cts = null;

        CisTransSet(MolBond bond, MolAtom[] atoms, int[] cts) {
            this.bond = bond;
            this.atoms = atoms;
            this.cts = cts;
        }
    }

    class LigandSet
    implements Serializable {
        MolAtom atom = null;
        int parity = 0;
        MolAtom[] ligands = null;
        int[] indices = null;

        LigandSet(MolAtom atom, int parity, MolAtom[] ligands, int[] indices) {
            this.atom = atom;
            this.parity = parity;
            this.ligands = ligands;
            this.indices = indices;
        }
    }
}

