/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.reaction.EqualableMoleculeArray;
import chemaxon.reaction.PatternProperty;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.ReactionResultEnumerator;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RxnMolecule;
import chemaxon.util.SearchAttributes;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;

public class ReactionUtil {
    private static final String STRUCTURE_SEARCH_FOR_INTERNAL_MOLSEARCH_LICENSE_ENVIRONMENT = "StructureSearchForInternalMolSearchLicenseEnvironment";

    static ArrayList<Molecule[]> reactAll(ReactionResultEnumerator rre, Collection<Molecule[]> reactantSets) throws ReactionException {
        return ReactionUtil.reactAll(rre, reactantSets, true);
    }

    static ArrayList<Molecule[]> reactAll(ReactionResultEnumerator rre, Collection<Molecule[]> reactantSets, boolean filterDuplicates) throws ReactionException {
        MultiReact mr = new MultiReact(rre);
        return mr.reactAll(reactantSets, filterDuplicates);
    }

    static ArrayList<Molecule[]> reactAll(ReactionResultEnumerator rre, Molecule[] reactants) throws ReactionException {
        ArrayList<Molecule[]> productList = new ArrayList<Molecule[]>();
        rre.setReactants(reactants);
        Molecule[] products = null;
        while ((products = rre.react()) != null) {
            productList.add(products);
        }
        return productList;
    }

    static RxnMolecule createReactionMolecule(Molecule[] reactants, Molecule[] products, Molecule[] agents) {
        return ReactionUtil.createReactionMolecule(reactants, products, agents, true);
    }

    static RxnMolecule createReactionMolecule(Molecule[] reactants, Molecule[] products, Molecule[] agents, boolean clean) {
        Molecule mol;
        int i;
        RxnMolecule rxn = new RxnMolecule();
        rxn.setDim(0);
        if (reactants != null) {
            for (i = 0; i < reactants.length; ++i) {
                mol = reactants[i];
                if (mol == null) continue;
                rxn.addComponent(mol, 0);
            }
        }
        if (products != null) {
            for (i = 0; i < products.length; ++i) {
                mol = products[i];
                if (mol == null) continue;
                rxn.addComponent(products[i], 1);
            }
        }
        if (agents != null) {
            for (i = 0; i < agents.length; ++i) {
                mol = agents[i];
                if (mol == null) continue;
                rxn.addComponent(agents[i], 2);
            }
        }
        if (clean) {
            rxn.clean(2, null);
        }
        return rxn;
    }

    static Molecule[] getAgents(RxnMolecule rxn) {
        Molecule[] agents = new Molecule[rxn.getAgentCount()];
        for (int i = 0; i < agents.length; ++i) {
            agents[i] = (Molecule)rxn.getAgent(i).clone();
        }
        return agents;
    }

    static RxnMolecule fuseReactionMolecule(RxnMolecule rxn) {
        if (rxn.getReactantCount() <= 1 && rxn.getProductCount() <= 1) {
            return rxn;
        }
        rxn = (RxnMolecule)rxn.clone();
        RxnMolecule fusedrxn = (RxnMolecule)rxn.newInstance();
        Molecule reactant = ReactionUtil.fuseStructures(rxn, 0);
        Molecule product = ReactionUtil.fuseStructures(rxn, 1);
        if (reactant != null) {
            fusedrxn.addComponent(reactant, 0);
        }
        if (product != null) {
            fusedrxn.addComponent(product, 1);
        }
        int n = rxn.getAgentCount();
        for (int i = 0; i < n; ++i) {
            fusedrxn.addComponent(rxn.getAgent(i), 2);
        }
        return fusedrxn;
    }

    public static Molecule fuseStructures(RxnMolecule rxn, int type) {
        MoleculeGraph m = null;
        int n = rxn.getComponentCount(type);
        type |= 4;
        for (int i = 0; i < n; ++i) {
            Molecule structure = rxn.getComponent(type, i);
            if (m == null) {
                m = (Molecule)structure.newInstance();
            }
            m.fuse(structure);
        }
        return m;
    }

    static Molecule fuseStructures(Molecule[] mols) {
        Molecule m = (Molecule)mols[0].newInstance();
        for (int i = 0; i < mols.length; ++i) {
            m.fuse(mols[i]);
        }
        return m;
    }

    static Molecule[] getStructures(RxnMolecule rxn, int type, int flags) {
        int size = rxn.getComponentCount(type);
        Molecule[] res = new Molecule[size];
        for (int i = 0; i < size; ++i) {
            res[i] = rxn.getComponent(flags, i);
        }
        return res;
    }

    public static String toFormat(Molecule mol, String[] formats) {
        if (mol == null || formats == null) {
            return null;
        }
        try {
            return formats.length >= 1 ? mol.toFormat(formats[0]) : null;
        }
        catch (IllegalArgumentException e) {
            if (formats.length >= 2) {
                String[] remainingFormats = new String[formats.length - 1];
                System.arraycopy(formats, 1, remainingFormats, 0, formats.length - 1);
                return ReactionUtil.toFormat(mol, remainingFormats);
            }
            return null;
        }
    }

    public static String toFormat(Molecule[] mols, String[] formats) {
        StringBuilder sb = new StringBuilder();
        for (Molecule mol : mols) {
            sb.append(ReactionUtil.toFormat(mol, formats));
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    static void makeUniqueMaps(RxnMolecule rxn, int[] map2map) throws ReactionException {
        Molecule reactant;
        int j;
        int i;
        ArrayList<MolAtom> plist = new ArrayList<MolAtom>(rxn.getAtomCount());
        for (i = rxn.getProductCount() - 1; i >= 0; --i) {
            Molecule product = rxn.getProduct(i);
            for (j = product.getAtomCount() - 1; j >= 0; --j) {
                MolAtom atom = product.getAtom(j);
                if (atom.getAtomMap() == 0) continue;
                plist.add(atom);
            }
        }
        Arrays.fill(map2map, -1);
        for (i = rxn.getReactantCount() - 1; i >= 0; --i) {
            reactant = rxn.getReactant(i);
            for (j = reactant.getAtomCount() - 1; j >= 0; --j) {
                int map = reactant.getAtom(j).getAtomMap();
                if (map == 0) continue;
                map2map[map] = 0;
            }
        }
        for (i = rxn.getReactantCount() - 1; i >= 0; --i) {
            reactant = rxn.getReactant(i);
            block5: for (j = reactant.getAtomCount() - 1; j >= 0; --j) {
                int m;
                int map = reactant.getAtom(j).getAtomMap();
                if (map == 0) continue;
                if (map2map[map] == 0) {
                    map2map[map] = map;
                    continue;
                }
                int pmap = map;
                while (map2map[pmap] != map) {
                    pmap = map2map[pmap];
                }
                for (m = map + 1; m < 1024; ++m) {
                    if (map2map[m] != -1) continue;
                    map2map[pmap] = m;
                    map2map[m] = map;
                    break;
                }
                if (m == 1024) {
                    throw new ReactionException("There is not enough free maps.");
                }
                reactant.getAtom(j).setAtomMap(m);
                for (int k = plist.size() - 1; k >= 0; --k) {
                    MolAtom atom = (MolAtom)plist.get(k);
                    if (atom.getAtomMap() != map) continue;
                    atom.setAtomMap(m);
                    continue block5;
                }
            }
        }
    }

    public static boolean areAllReactionComponentsMapped(RxnMolecule rxn) {
        Molecule[] reactants = ReactionUtil.getStructures(rxn, 0, 4);
        for (int i = 0; i < reactants.length; ++i) {
            if (!ReactionUtil.isUnmapped(reactants[i])) continue;
            return false;
        }
        Molecule[] products = ReactionUtil.getStructures(rxn, 1, 5);
        for (int i = 0; i < products.length; ++i) {
            if (!ReactionUtil.isUnmapped(products[i])) continue;
            return false;
        }
        return true;
    }

    static boolean hasIdenticalMapsOnProductSide(RxnMolecule rxn) {
        HashSet<Integer> mapset = new HashSet<Integer>();
        for (int i = rxn.getProductCount() - 1; i >= 0; --i) {
            Molecule product = rxn.getProduct(i);
            for (int j = product.getAtomCount() - 1; j >= 0; --j) {
                int map = product.getAtom(j).getAtomMap();
                if (map == 0 || mapset.add(map)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean areAllChangingAtomsMapped(RxnMolecule rxn) {
        Molecule product;
        if (rxn.getReactantCount() == 0 || rxn.getProductCount() == 0) {
            return false;
        }
        RxnMolecule rxnmol = ReactionUtil.fuseReactionMolecule(rxn);
        Molecule reactant = rxnmol == rxn ? rxnmol.getReactant(0).cloneMolecule() : rxnmol.getReactant(0);
        Molecule molecule = product = rxnmol == rxn ? rxnmol.getProduct(0).cloneMolecule() : rxnmol.getProduct(0);
        if (!ReactionUtil.removeChangingBonds(reactant) || !ReactionUtil.removeChangingBonds(product)) {
            return false;
        }
        if (reactant.getAtomCount() == 0 && product.getAtomCount() == 0) {
            return true;
        }
        if (reactant.getAtomCount() != product.getAtomCount()) {
            return false;
        }
        MolSearch perfectSearcher = new MolSearch();
        perfectSearcher.setLicenseEnvironment(STRUCTURE_SEARCH_FOR_INTERNAL_MOLSEARCH_LICENSE_ENVIRONMENT);
        perfectSearcher.setSearchOptions(new MolSearchOptions(5));
        perfectSearcher.getSearchOptions().setUndefinedRAtom(0);
        perfectSearcher.setQuery(reactant);
        perfectSearcher.setTarget(product);
        try {
            return perfectSearcher.isMatching();
        }
        catch (SearchException e) {
            return false;
        }
    }

    private static boolean removeChangingBonds(Molecule mol) {
        HashSet<Integer> mapset = new HashSet<Integer>();
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = mol.getAtom(i);
            int map = atom.getAtomMap();
            if (map == 0 && (map != 0 || atom.getAtno() != 1)) continue;
            if (map != 0 && !mapset.add(map)) {
                return false;
            }
            for (int j = atom.getBondCount() - 1; j >= 0; --j) {
                MolBond bond = atom.getBond(j);
                if (bond.getOtherAtom(atom).getAtomMap() == 0) continue;
                mol.removeBond(bond);
            }
            if (atom.getBondCount() != 0) continue;
            mol.removeAtom(atom);
        }
        return true;
    }

    static MolSearchOptions setSearchAttributes(MolSearchOptions mso, SearchAttributes attributes) {
        if (attributes != null) {
            mso.setStereoSearchType(attributes.isStereoSearch() ? 0 : 1);
            mso.setDoubleBondStereoMatchingMode(attributes.getDoubleBondStereoMatchingMode());
            mso.setSubgraphSearch(attributes.isSubgraphSearch());
            boolean exact = attributes.isExactAtomMatching();
            if (exact) {
                mso.setRadicalMatching(1);
                mso.setChargeMatching(1);
                mso.setIsotopeMatching(1);
            } else {
                mso.setRadicalMatching(0);
                mso.setChargeMatching(0);
                mso.setIsotopeMatching(0);
            }
            mso.setExactQueryAtomMatching(exact);
            mso.setStereoSearchType(attributes.isExactStereoMatching() ? 2 : (mso.getStereoSearchType() == 2 ? 0 : mso.getStereoSearchType()));
        }
        return mso;
    }

    static void setSearchAttributes(MolSearch searcher, SearchAttributes attributes) {
        if (attributes != null) {
            MolSearchOptions mso = searcher.getSearchOptions();
            mso.setStereoSearchType(attributes.isStereoSearch() ? 0 : 1);
            mso.setDoubleBondStereoMatchingMode(attributes.getDoubleBondStereoMatchingMode());
            mso.setSubgraphSearch(attributes.isSubgraphSearch());
            boolean exact = attributes.isExactAtomMatching();
            if (exact) {
                mso.setRadicalMatching(1);
                mso.setChargeMatching(1);
                mso.setIsotopeMatching(1);
            } else {
                mso.setRadicalMatching(0);
                mso.setChargeMatching(0);
                mso.setIsotopeMatching(0);
            }
            mso.setExactQueryAtomMatching(exact);
            mso.setStereoSearchType(attributes.isExactStereoMatching() ? 2 : (mso.getStereoSearchType() == 2 ? 0 : mso.getStereoSearchType()));
            searcher.setSearchOptions(mso);
        }
    }

    public static boolean isAbsoluteStereoRelevant(Molecule mol) {
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            int ch = mol.getChirality(i);
            if (ch != 8 && ch != 16 || mol.getAtom(i).getStereoGroupType() != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnmapped(Molecule mol) {
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            if (mol.getAtom(i).getAtomMap() == 0) continue;
            return false;
        }
        return true;
    }

    static boolean isHProblematicAtno(int atno) {
        return atno == 7 || atno == 15;
    }

    static Molecule[] cloneMoleculeArray(Molecule[] mols) {
        Molecule[] clone = new Molecule[mols.length];
        for (int i = 0; i < mols.length; ++i) {
            clone[i] = mols[i] == null ? null : mols[i].cloneMolecule();
        }
        return clone;
    }

    static Molecule[] clearCachedInfo(Molecule[] mols) {
        for (Molecule molecule : mols) {
            molecule.clearCachedInfo(0);
        }
        return mols;
    }

    static Properties getSelectedMoleculeProperties(Molecule[] mols, boolean all, String[][] sourceProperties, String[][] targetProperties) throws ReactionException {
        Properties properties = new Properties();
        if (all) {
            for (int i = 0; i < mols.length; ++i) {
                String[] propertyKeys;
                for (String key : propertyKeys = mols[i].properties().getKeys()) {
                    if (properties.containsKey(key)) {
                        throw new ReactionException("Property key collision, property key \"" + key + "\" found more than once in reactants.");
                    }
                    properties.put(key, mols[i].getProperty(key));
                }
            }
        } else {
            if (sourceProperties == null) {
                return null;
            }
            for (int i = 0; i < mols.length; ++i) {
                if (i >= sourceProperties.length) continue;
                for (int j = 0; j < sourceProperties[i].length; ++j) {
                    String targetProperty = targetProperties != null && targetProperties.length > i && targetProperties[i] != null && targetProperties[i].length > j && targetProperties[i][j] != null ? targetProperties[i][j] : sourceProperties[i][j];
                    String propertyValue = mols[i].getProperty(sourceProperties[i][j]);
                    if (propertyValue == null) continue;
                    if (properties.containsKey(targetProperty)) {
                        throw new ReactionException("Property key collision, property key \"" + targetProperty + "\" found more than once in reactants.");
                    }
                    properties.put(targetProperty, propertyValue);
                }
            }
        }
        return properties;
    }

    static Properties getSelectedMoleculeProperties(Molecule[] mols, boolean all, String[][] sourceProperties, String[][] targetProperties, Molecule reaction, Map<String, String> patternBasedProperties) throws ReactionException {
        Properties properties = ReactionUtil.getSelectedMoleculeProperties(mols, all, sourceProperties, targetProperties);
        if (patternBasedProperties == null) {
            return properties;
        }
        if (properties == null) {
            properties = new Properties();
        }
        for (String key : patternBasedProperties.keySet()) {
            PatternProperty property = new PatternProperty(patternBasedProperties.get(key));
            properties.put(key, property.getValue(reaction, mols));
        }
        return properties;
    }

    static void setProperties(Molecule mol, Properties properties) {
        if (properties != null) {
            for (String string : properties.keySet()) {
                mol.setProperty(string, properties.getProperty(string));
            }
        }
    }

    private static class MultiReact {
        private ReactionResultEnumerator rre = null;

        private MultiReact(ReactionResultEnumerator rre) {
            this.rre = rre;
        }

        private ArrayList<Molecule[]> reactAll(Collection<Molecule[]> reactantSets, boolean filterDuplicates) throws ReactionException {
            return this.reactAllSingle(reactantSets, filterDuplicates);
        }

        private ArrayList<Molecule[]> reactAllSingle(Collection<Molecule[]> reactantSets, boolean filterDuplicates) throws ReactionException {
            Collection<EqualableMoleculeArray> productList = MultiReact.initProductListFilter(filterDuplicates);
            Iterator<Molecule[]> reactantSetIterator = reactantSets.iterator();
            while (reactantSetIterator.hasNext()) {
                this.rre.setReactants(reactantSetIterator.next());
                Molecule[] products = null;
                while ((products = this.rre.react()) != null) {
                    productList.add(new EqualableMoleculeArray(products));
                }
            }
            ArrayList<Molecule[]> returnMolsList = new ArrayList<Molecule[]>();
            Iterator<EqualableMoleculeArray> iterator = productList.iterator();
            while (iterator.hasNext()) {
                returnMolsList.add(iterator.next().getMoleculeArray());
            }
            return returnMolsList;
        }

        private static Collection<EqualableMoleculeArray> initProductListFilter(boolean filterDuplicates) {
            AbstractCollection productListFilter = null;
            productListFilter = filterDuplicates ? new LinkedHashSet() : new ArrayList();
            return productListFilter;
        }
    }
}

