/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.util.SearchAttributes;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

public class ReactorOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int resultType;
    private int duplicateFilteringMethod;
    private int norules;
    private int[] ratio;
    private int[] pinds;
    private boolean reverse;
    private boolean transform;
    private boolean excludeOverlappingHits = false;
    private boolean mapResult;
    private boolean single;
    private boolean rmduprefs;
    private boolean cached;
    private SearchAttributes attributes;
    private String searchOptionsString;
    private String reactionIDProp;
    private String[] reactantIDProps;
    private String[] productIDProps;
    private boolean copyAllReactantProperties;
    private String[][] sourceProperties;
    private String[][] targetProperties;
    private Map<String, String> patternBasedProperties;
    private boolean showUnsuccessfulReactions;

    public ReactorOptions(int resultType, int duplicateFilteringMethod, int norules, int[] pinds, boolean transform, boolean mapResult, boolean single, String reactionIDProp, String[] reactantIDProps, String[] productIDProps) {
        this.resultType = resultType;
        this.duplicateFilteringMethod = duplicateFilteringMethod;
        this.norules = norules;
        this.pinds = pinds;
        this.transform = transform;
        this.mapResult = mapResult;
        this.single = single;
        this.reactionIDProp = reactionIDProp;
        this.reactantIDProps = reactantIDProps;
        this.productIDProps = productIDProps;
    }

    public ReactorOptions(int resultType, int duplicateFilteringMethod, int norules, int[] ratio, int[] pinds, boolean reverse, boolean transform, boolean mapResult, boolean single, boolean showUnsuccessfulReactions, boolean rmduprefs, boolean cached, SearchAttributes attributes, String searchOptionsString, String reactionIDProp, String[] reactantIDProps, String[] productIDProps) {
        this.resultType = resultType;
        this.duplicateFilteringMethod = duplicateFilteringMethod;
        this.norules = norules;
        this.ratio = ratio;
        this.pinds = pinds;
        this.reverse = reverse;
        this.transform = transform;
        this.mapResult = mapResult;
        this.single = single;
        this.showUnsuccessfulReactions = showUnsuccessfulReactions;
        this.rmduprefs = rmduprefs;
        this.cached = cached;
        this.attributes = attributes;
        this.searchOptionsString = searchOptionsString;
        this.reactionIDProp = reactionIDProp;
        this.reactantIDProps = reactantIDProps;
        this.productIDProps = productIDProps;
    }

    public int getResultType() {
        return this.resultType;
    }

    public void setResultType(int resultType) {
        this.resultType = resultType;
    }

    public int getDuplicateFilteringMethod() {
        return this.duplicateFilteringMethod;
    }

    public void setDuplicateFilteringMethod(int duplicateFilteringMethod) {
        this.duplicateFilteringMethod = duplicateFilteringMethod;
    }

    public int getIgnoreRules() {
        return this.norules;
    }

    public void setIgnoreRules(int norules) {
        this.norules = norules;
    }

    public int[] getRatio() {
        return this.ratio;
    }

    public void setRatio(int[] ratio) {
        this.ratio = ratio;
    }

    public int[] getProductIndexes() {
        return this.pinds;
    }

    public void setProductIndexes(int[] pinds) {
        this.pinds = pinds;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public boolean isTransform() {
        return this.transform;
    }

    public void setTransform(boolean transform) {
        this.transform = transform;
    }

    public boolean isExcludeOverlappingHits() {
        return this.excludeOverlappingHits;
    }

    public void setExcludeOverlappingHits(boolean excludeOverlappingHits) {
        this.excludeOverlappingHits = excludeOverlappingHits;
    }

    public boolean isMapResult() {
        return this.mapResult;
    }

    public void setMapResult(boolean mapResult) {
        this.mapResult = mapResult;
    }

    public boolean isSingle() {
        return this.single;
    }

    public void setSingle(boolean single) {
        this.single = single;
    }

    public boolean isShowUnsuccessfulReactions() {
        return this.showUnsuccessfulReactions;
    }

    public void setShowUnsuccessfulReactions(boolean showUnsuccessfulReactions) {
        this.showUnsuccessfulReactions = showUnsuccessfulReactions;
    }

    public boolean isRemoveDuplicateProductReferences() {
        return this.rmduprefs;
    }

    public void setRemoveDuplicateProductReferences(boolean rmduprefs) {
        this.rmduprefs = rmduprefs;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    public SearchAttributes getSearchAttributes() {
        return this.attributes;
    }

    public void setSearchAttributes(SearchAttributes attributes) {
        this.attributes = attributes;
    }

    public String getSearchOptionsString() {
        return this.searchOptionsString;
    }

    public void setSearchOptionsString(String searchOptionsString) {
        this.searchOptionsString = searchOptionsString;
    }

    public String getReactionIDProp() {
        return this.reactionIDProp;
    }

    public void setReactionIDProp(String reactionIDProp) {
        this.reactionIDProp = reactionIDProp;
    }

    public String[] getReactantIDProps() {
        return this.reverse ? this.productIDProps : this.reactantIDProps;
    }

    public void setReactantIDProps(String[] reactantIDProps) {
        this.reactantIDProps = reactantIDProps;
    }

    public String[] getProductIDProps() {
        return this.reverse ? this.reactantIDProps : this.productIDProps;
    }

    public void setProductIDProps(String[] productIDProps) {
        this.productIDProps = productIDProps;
    }

    public boolean isCopyAllReactantProperties() {
        return this.copyAllReactantProperties;
    }

    public void setCopyAllReactantProperties(boolean copyAllReactantProperties) {
        this.copyAllReactantProperties = copyAllReactantProperties;
    }

    public String[][] getReactantPropertiesToCopy() {
        return this.sourceProperties;
    }

    public String[][] getTargetProperties() {
        return this.targetProperties;
    }

    public Map<String, String> getPatternBasedProperties() {
        return this.patternBasedProperties;
    }

    public void setPatternBasedProperties(Map<String, String> patternBasedProperties) {
        this.patternBasedProperties = patternBasedProperties;
    }

    public void setCopyReactantProperties(String[][] sourceProperties, String[][] targetProperties) {
        this.sourceProperties = sourceProperties;
        this.targetProperties = targetProperties;
    }

    public String toString() {
        return "ReactorOptions [attributes=" + this.attributes + ", cached=" + this.cached + ", duplicateFilteringMethod=" + this.duplicateFilteringMethod + ", excludeOverlappingHits=" + this.excludeOverlappingHits + ", mapResult=" + this.mapResult + ", norules=" + this.norules + ", pinds=" + Arrays.toString(this.pinds) + ", productIDProps=" + Arrays.toString(this.productIDProps) + ", ratio=" + Arrays.toString(this.ratio) + ", reactantIDProps=" + Arrays.toString(this.reactantIDProps) + ", reactionIDProp=" + this.reactionIDProp + ", resultType=" + this.resultType + ", reverse=" + this.reverse + ", rmduprefs=" + this.rmduprefs + ", searchOptionsString=" + this.searchOptionsString + ", single=" + this.single + ", transform=" + this.transform + "]";
    }
}

