/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.reaction.ReactantSetEnumeration;
import chemaxon.struc.Molecule;
import chemaxon.util.iterator.MoleculeIterator;

class SequentialModeReactantSetEnumerator
implements ReactantSetEnumeration {
    private MoleculeIterator[] reactantIterators;
    private Molecule[] nextMols;

    public SequentialModeReactantSetEnumerator(MoleculeIterator[] reactantIterators, boolean ignoreError) {
        this.reactantIterators = reactantIterators;
        this.nextMols = new Molecule[reactantIterators.length];
        this.next();
    }

    @Override
    public boolean hasNext() {
        return this.nextMols != null;
    }

    @Override
    public Molecule[] next() {
        if (!this.hasNext()) {
            return null;
        }
        Molecule[] mols = this.nextMols;
        this.nextMols = new Molecule[this.reactantIterators.length];
        boolean isEndReached = true;
        for (int i = 0; i < this.reactantIterators.length; ++i) {
            isEndReached &= !this.reactantIterators[i].hasNext();
            this.nextMols[i] = this.reactantIterators[i].hasNext() ? this.reactantIterators[i].next() : mols[i];
        }
        if (isEndReached) {
            this.nextMols = null;
        }
        return mols;
    }

    @Override
    public double getProgress() {
        double min = 1.0;
        for (MoleculeIterator it : this.reactantIterators) {
            double p = it.estimateProgress();
            min = Math.min(p, min);
        }
        return min;
    }
}

