/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class SgroupUtil {
    SgroupUtil() {
    }

    public static Sgroup[] filterSgroups(Sgroup[] sgroups, int ... types) {
        ArrayList<Sgroup> filteredSgroups = new ArrayList<Sgroup>();
        for (Sgroup sgroup : sgroups) {
            for (int type : types) {
                if (sgroup.getType() != type) continue;
                filteredSgroups.add(sgroup);
            }
        }
        return filteredSgroups.toArray(new Sgroup[filteredSgroups.size()]);
    }

    public static MolAtom[] getAtomsInSgroups(Sgroup[] sgroups) {
        ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
        for (Sgroup sgroup : sgroups) {
            atoms.addAll(Arrays.asList(sgroup.getAtomArray()));
        }
        return atoms.toArray(new MolAtom[atoms.size()]);
    }

    public static MolAtom[] getConnectedAtoms(Molecule mol, MolAtom[] atoms) {
        List<MolAtom> atomList = Arrays.asList(atoms);
        ArrayList<MolAtom> ligands = new ArrayList<MolAtom>();
        for (MolAtom atom : atoms) {
            for (MolAtom ligand : atom.getLigands()) {
                if (atomList.contains(ligand)) continue;
                ligands.add(ligand);
            }
        }
        return ligands.toArray(new MolAtom[ligands.size()]);
    }
}

