/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.reaction.ReactantSetEnumeration;
import chemaxon.struc.Molecule;
import chemaxon.util.iterator.MoleculeIterator;

class SingleFileReactantSetEnumerator
implements ReactantSetEnumeration {
    private Molecule[] nextMols;
    private double progress = 0.0;

    public SingleFileReactantSetEnumerator(MoleculeIterator[] reactantIterators, int numberOfReactants) {
        if (numberOfReactants != 0 && reactantIterators.length == 1 && numberOfReactants != reactantIterators.length) {
            this.nextMols = new Molecule[numberOfReactants];
            for (int count = 0; count < numberOfReactants; ++count) {
                if (!reactantIterators[0].hasNext()) continue;
                this.nextMols[count] = reactantIterators[0].next();
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextMols != null;
    }

    @Override
    public Molecule[] next() {
        Molecule[] mols = this.nextMols;
        this.nextMols = null;
        this.progress = 1.0;
        return mols;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    Throwable getThrowable() {
        return null;
    }
}

