/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.calculations.ElementalAnalyser;
import chemaxon.calculations.stereo.StereoCorrector;
import chemaxon.common.util.BasicEnvironment;
import chemaxon.core.util.BondTable;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.calculations.ResonancePlugin;
import chemaxon.marvin.calculations.TautomerizationPlugin;
import chemaxon.marvin.io.formats.peptide.AminoAcidSource;
import chemaxon.marvin.modules.AutoMapper;
import chemaxon.marvin.modules.AutoMapperException;
import chemaxon.marvin.plugin.PluginException;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.reaction.ConcurrentStandardizerProcessor;
import chemaxon.reaction.GroupDefinition;
import chemaxon.reaction.GroupList;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.ReactionPerformer;
import chemaxon.reaction.ReactionUtil;
import chemaxon.reaction.SerializationUtils;
import chemaxon.reaction.SgroupUtil;
import chemaxon.reaction.StandardizerConfiguration;
import chemaxon.reaction.StandardizerData;
import chemaxon.reaction.StandardizerException;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.StandardizedMolSearch;
import chemaxon.sss.search.TemplateBasedClean;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PeriodicSystem;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.Expandable;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import chemaxon.util.EnhStereoConverter;
import chemaxon.util.NumberUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dom4j.Element;

public class Standardizer
implements Licensable,
Serializable,
chemaxon.jep.Standardizer {
    public static final String GROUP_QUERY = "query";
    public static final String GROUP_TARGET = "target";
    public static HashSet SET_TARGET = null;
    private static final String DEFAULT_ABBREVGROUP_FILE = "/chemaxon/marvin/templates/default.abbrevgroup";
    private transient Hashtable<String, Molecule> abbrevGroups = null;
    private transient HashSet<String> oneLetterAminoAcidAbbreviations;
    private transient HashSet<String> threeLetterAminoAcidAbbreviations;
    private String licenseEnvironment = "";
    private static final String lineSep;
    private static final String LICENSE_MSG;
    public static final String FINAL_CLEAN_ID = "FINAL_CLEAN";
    private static final Logger logger;
    private transient StandardizerConfiguration config = new StandardizerConfiguration();
    private StandardizerData[] stdata = null;
    private boolean finalStereoFix = false;
    private boolean[] appliedTask = null;
    private StandardizerData cldata = null;
    private transient TemplateBasedClean tbCleaner = null;
    private Molecule[] cleanTemplates = null;
    private transient TautomerizationPlugin tautomerizationPlugin = null;
    private transient ResonancePlugin resonancePlugin = null;
    private transient NumberUtil numberUtil = null;
    private boolean partialClean = false;
    private transient HashSet<MolAtom> changedAtomSet = null;
    private String[] activeGroups = null;
    private HashSet<StandardizerData> inactiveTasks = null;
    private boolean atomIndexQuery = false;
    private int[] old2new = null;
    private int[] new2old = null;
    private transient AutoMapper autoMapper = null;
    private boolean isReaction = false;

    public Standardizer(String str) throws StandardizerException {
        this.config.read(str);
        this.init();
    }

    public Standardizer(File file) throws StandardizerException {
        this.config.read(file);
        this.init();
    }

    public Standardizer(InputStream is) throws StandardizerException {
        this.config.read(is);
        this.init();
    }

    public Standardizer(Element configElement, String dir) throws StandardizerException {
        this.config.read(configElement, dir);
        this.init();
    }

    public Standardizer(Element configElement) throws StandardizerException {
        this(configElement, null);
    }

    static Standardizer newInstance(Standardizer other) {
        try {
            return (Standardizer)SerializationUtils.clone(other);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Standardizer", this.licenseEnvironment);
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Standardizer", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    public void setAtomIndexQuery(boolean atomIndexQuery) {
        this.atomIndexQuery = atomIndexQuery;
        this.new2old = null;
        this.old2new = null;
    }

    public int[] getOldToNew() {
        return this.old2new;
    }

    public int[] getNewToOld() {
        return this.new2old;
    }

    private void setAtomIndexData(Molecule mol, MolAtom[] oldAtoms) {
        this.old2new = new int[oldAtoms.length];
        this.new2old = new int[mol.getGraphUnion().getAtomCount()];
        Arrays.fill(this.new2old, -1);
        for (int i = 0; i < oldAtoms.length; ++i) {
            int j;
            this.old2new[i] = j = mol.indexOf(oldAtoms[i]);
            if (j == -1) continue;
            this.new2old[j] = i;
        }
    }

    public void setCleanTemplates(Molecule[] templates) {
        this.cleanTemplates = templates;
    }

    public void setActiveGroup(String group) {
        String[] stringArray;
        if (group != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = group;
        } else {
            stringArray = null;
        }
        this.setActiveGroups(stringArray);
    }

    public void setActiveGroups(String[] groups) {
        this.activeGroups = groups;
    }

    public String[] getActiveGroups() {
        return this.activeGroups;
    }

    private boolean isActiveTask(StandardizerData task) {
        if (this.isInactiveTask(task)) {
            return false;
        }
        if (this.activeGroups == null || task.groups == null) {
            return true;
        }
        for (int i = 0; i < this.activeGroups.length; ++i) {
            if (!task.groups.contains(this.activeGroups[i])) continue;
            return true;
        }
        return false;
    }

    public void setInactiveTasks(String str) throws StandardizerException {
        this.addInactiveTasks(str);
    }

    public boolean addInactiveTasks(String str) throws StandardizerException {
        boolean added = false;
        StandardizerConfiguration config = new StandardizerConfiguration();
        config.read(str);
        StandardizerData[] tasks = config.getData();
        if (this.inactiveTasks == null) {
            this.inactiveTasks = new HashSet();
        }
        for (int i = 0; i < tasks.length; ++i) {
            added |= this.inactiveTasks.add(tasks[i]);
        }
        return added;
    }

    public boolean removeInactiveTasks(String str) throws StandardizerException {
        boolean removed = false;
        StandardizerConfiguration config = new StandardizerConfiguration();
        config.read(str);
        StandardizerData[] tasks = config.getData();
        if (this.inactiveTasks != null) {
            for (int i = 0; i < tasks.length; ++i) {
                removed |= this.inactiveTasks.remove(tasks[i]);
            }
        }
        return removed;
    }

    public void clearInactiveTasks() {
        if (this.inactiveTasks != null) {
            this.inactiveTasks.clear();
        }
    }

    private boolean isInactiveTask(StandardizerData task) {
        return this.inactiveTasks != null && this.inactiveTasks.contains(task);
    }

    private void init() throws StandardizerException {
        StandardizerData[] sdata = this.config.getData();
        ArrayList<StandardizerData> v = new ArrayList<StandardizerData>(sdata.length);
        block4: for (int i = 0; i < sdata.length; ++i) {
            switch (sdata[i].type) {
                case 3: {
                    if (sdata[i].cleantype == 1) {
                        this.partialClean = true;
                    }
                }
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    v.add(sdata[i]);
                    continue block4;
                }
                default: {
                    throw new StandardizerException("record " + i + ": Unknown standardization type: " + sdata[i].type);
                }
            }
        }
        this.stdata = new StandardizerData[v.size()];
        v.toArray(this.stdata);
        this.appliedTask = new boolean[this.stdata.length + 1];
    }

    public void setFinalClean() throws StandardizerException {
        this.setFinalClean(-1);
    }

    public void setFinalClean(int dim) throws StandardizerException {
        this.setFinalClean(dim, true);
    }

    public void setFinalClean(int dim, boolean partial) throws StandardizerException {
        this.setFinalClean(dim, partial, SET_TARGET);
    }

    public void setFinalClean(int dim, boolean partial, HashSet groups) throws StandardizerException {
        this.cldata = new StandardizerData(3, FINAL_CLEAN_ID, dim, partial ? 1 : 2, null);
        this.partialClean = partial;
    }

    void setFinalStereoFix(boolean fsf) {
        this.finalStereoFix = fsf;
    }

    private void initPartialClean() {
        if (this.changedAtomSet == null) {
            this.changedAtomSet = new HashSet();
        }
    }

    private void performAction(Molecule mol, int action) throws StandardizerException {
        switch (action) {
            case 1: {
                mol.aromatize(1);
                break;
            }
            case 2: {
                mol.aromatize(2);
                break;
            }
            case 3: {
                mol.aromatize(3);
                break;
            }
            case 4: {
                mol.dearomatize();
                break;
            }
            case 5: {
                int ac = mol.getAtomCount();
                mol.hydrogenize(true);
                if (this.changedAtomSet == null) break;
                for (int i = mol.getAtomCount() - 1; i >= ac; --i) {
                    this.changedAtomSet.add(mol.getAtom(i));
                }
                break;
            }
        }
    }

    private void performRemoval(Molecule mol, int rmethod, int rmeasure) {
        boolean removeFragment;
        if (rmethod == 5) {
            this.performKeepRoot(mol);
            return;
        }
        if (mol.getFragCount() <= 1) {
            return;
        }
        MoleculeGraph[] frags = mol.findFrags(SelectionMolecule.class);
        int t = 0;
        double m = this.getMolMeasure(frags[0], rmeasure);
        boolean selectSmallest = rmethod == 1 || rmethod == 4;
        for (int i = 1; i < frags.length; ++i) {
            double mi = this.getMolMeasure(frags[i], rmeasure);
            if (!(selectSmallest && mi < m) && (selectSmallest || !(mi > m))) continue;
            m = mi;
            t = i;
        }
        boolean bl = removeFragment = rmethod == 1 || rmethod == 3;
        if (removeFragment) {
            for (int i = frags[t].getAtomCount() - 1; i >= 0; --i) {
                mol.removeAtom(frags[t].getAtom(i));
            }
        } else {
            int[] fragids = mol.getFragIds();
            MolAtom node = frags[t].getAtom(0);
            int fragid = fragids[mol.indexOf(node)];
            for (int i = fragids.length - 1; i >= 0; --i) {
                if (fragids[i] == fragid) continue;
                mol.removeAtom(i);
            }
        }
    }

    private double getMolMeasure(MoleculeGraph mol, int rmeasure) {
        switch (rmeasure) {
            case 1: {
                return Standardizer.getAllAtomCount(mol);
            }
            case 2: {
                return mol.getMass();
            }
        }
        return 0.0;
    }

    private static int getAllAtomCount(MoleculeGraph mol) {
        ElementalAnalyser elemanal = new ElementalAnalyser();
        elemanal.setMolecule(mol);
        return elemanal.atomCount();
    }

    private void performRemoveAtomValues(Molecule mol) {
        for (MolAtom atom : mol.getAtomArray()) {
            atom.setExtraLabel(null);
        }
    }

    private void performRemoveAttachedData(Molecule mol) {
        Sgroup[] sgroups = mol.getSgroupArray();
        if (sgroups != null) {
            for (int i = 0; i < sgroups.length; ++i) {
                if (!(sgroups[i] instanceof DataSgroup)) continue;
                mol.ungroupSgroup(sgroups[i]);
            }
        }
    }

    private void performKeepRoot(Molecule mol) {
        if (!(mol instanceof RgMolecule)) {
            return;
        }
        RgMolecule rgmol = (RgMolecule)mol;
        if (rgmol.getRgroupCount() == 0) {
            return;
        }
        Molecule root = rgmol.getRoot();
        MoleculeGraph tmp = root.newInstance();
        tmp.fuse(root);
        rgmol.removeAll();
        rgmol.fuse(tmp);
    }

    private void performClean(Molecule mol, int dim, int type, TemplateBasedClean tbCleaner) throws StandardizerException {
        if (type == 3) {
            if (tbCleaner == null) {
                if (this.tbCleaner != null) {
                    tbCleaner = this.tbCleaner;
                } else if (this.cleanTemplates != null) {
                    tbCleaner = new TemplateBasedClean(this.cleanTemplates);
                } else {
                    throw new StandardizerException("No templates for template based clean.");
                }
            }
            try {
                if (tbCleaner.clean(mol) == null && mol.getDim() != 2) {
                    mol.clean(2, null);
                }
            }
            catch (SearchException e) {
                throw new StandardizerException(e);
            }
            return;
        }
        if (dim == -1 && (dim = mol.getDim()) == 0) {
            dim = 2;
        }
        if (type == 2) {
            mol.clean(dim, null);
            return;
        }
        if (type == 4) {
            for (MolAtom atom : mol.getAtomArray()) {
                atom.setZ(0.0);
            }
        }
        if (this.changedAtomSet != null && !this.changedAtomSet.isEmpty() || dim != mol.getDim()) {
            if (dim != 2 || dim != mol.getDim()) {
                mol.clean(dim, null);
            } else {
                this.partialClean(mol, dim);
            }
        }
    }

    private void partialClean(Molecule mol, int dim) {
        int i;
        if (mol.getDim() > 0) {
            for (i = 0; i < mol.getAtomCount(); ++i) {
                MolAtom a = mol.getAtom(i);
                int p = mol.getLocalParity(i);
                a.setFlags(p, 7);
            }
        }
        if (mol.getDim() > 0) {
            for (i = 0; i < mol.getBondCount(); ++i) {
                MolBond b = mol.getBond(i);
                MolAtom l1 = b.getCTAtom1();
                MolAtom l4 = b.getCTAtom4();
                if (l1 == null || l4 == null) continue;
                int s = mol.getStereo2(b, l1, l4);
                b.setFlags(s, 448);
            }
        }
        mol.partialClean(dim, this.getFixedComponent(mol), null);
    }

    private int[] getFixedComponent(Molecule mol) {
        ArrayList<MolAtom> fixedAtomList = new ArrayList<MolAtom>();
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = mol.getAtom(i);
            if (this.changedAtomSet == null || this.changedAtomSet.contains(atom)) continue;
            fixedAtomList.add(atom);
        }
        int[] fixed = new int[fixedAtomList.size()];
        for (int i = 0; i < fixed.length; ++i) {
            MolAtom atom = (MolAtom)fixedAtomList.get(i);
            fixed[i] = mol.indexOf(atom);
        }
        fixedAtomList.clear();
        int[] ids = mol.findComponentIds(fixed);
        boolean onecomp = true;
        for (int i = 1; i < ids.length; ++i) {
            if (ids[i - 1] == ids[i]) continue;
            onecomp = false;
            break;
        }
        if (onecomp) {
            return fixed;
        }
        int[] counts = new int[mol.getAtomCount()];
        for (int i = 0; i < ids.length; ++i) {
            int n = ids[i];
            counts[n] = counts[n] + 1;
        }
        int m = -1;
        int id = -1;
        for (int i = 0; i < ids.length; ++i) {
            if (counts[ids[i]] <= m) continue;
            m = counts[ids[i]];
            id = ids[i];
        }
        int j = 0;
        int[] compfixed = new int[m];
        for (int i = 0; i < fixed.length; ++i) {
            if (ids[i] != id) continue;
            compfixed[j++] = fixed[i];
        }
        return compfixed;
    }

    private void performImplH(Molecule mol, int flags) {
        mol.implicitizeHydrogens(flags);
    }

    private void performNeutralize(Molecule mol) {
        MolAtom atom;
        Molecule clone = mol.cloneMoleculeWithDocument();
        if (mol.getFragCount() > 1) {
            for (int count = mol.getAtomCount() - 1; count >= 0; --count) {
                atom = mol.getAtom(count);
                if (atom.getAtno() != 1 || atom.getCharge() == 0 || atom.getBondCount() != 0) continue;
                mol.removeAtom(count);
            }
        }
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            atom = mol.getAtom(i);
            int charge = atom.getCharge();
            boolean hasNeighbourAtomWithOppositeCharge = false;
            for (int j = 0; j < atom.getBondCount(); ++j) {
                int ligandCharge = atom.getLigand(j).getCharge();
                if (charge * ligandCharge >= 0) continue;
                hasNeighbourAtomWithOppositeCharge = true;
                break;
            }
            if (charge > 0 && !hasNeighbourAtomWithOppositeCharge) {
                int implicitHcount = atom.getImplicitHcount();
                if (implicitHcount > 0) {
                    atom.setCharge(Math.max(0, charge - implicitHcount));
                }
                boolean isExplicitHRemoved = false;
                for (int j = atom.getBondCount() - 1; (charge = atom.getCharge()) > 0 && j >= 0; --j) {
                    MolBond bond = atom.getBond(j);
                    MolAtom h = bond.getOtherAtom(atom);
                    if (!h.isImplicitizableH(2047)) continue;
                    atom.setCharge(--charge);
                    mol.removeBond(bond);
                    mol.removeAtom(h);
                    isExplicitHRemoved = true;
                }
                if (this.changedAtomSet == null || !isExplicitHRemoved) continue;
                this.changedAtomSet.add(atom);
                for (int k = 0; k <= atom.getBondCount() - 1; ++k) {
                    this.changedAtomSet.add(atom.getLigand(k));
                }
                continue;
            }
            if (charge >= 0 || hasNeighbourAtomWithOppositeCharge) continue;
            atom.setCharge(0);
            if (atom.getAtno() != 7) continue;
            atom.setImplicitHcount(atom.getImplicitHcount() - charge);
        }
        if (mol.getTotalCharge() != 0 && clone.getFragCount() > 1 && clone.getTotalCharge() == 0) {
            mol.removeAll();
            mol.fuse(clone);
        }
        mol.valenceCheck();
    }

    private void performClearIsotopes(Molecule mol) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            mol.getAtom(i).setMassno(0);
        }
    }

    private void performSgroups(Molecule mol, int sgact, HashSet sgroupsToExclude) {
        switch (sgact) {
            case 1: {
                Standardizer.contractSgroups(mol, sgroupsToExclude);
                break;
            }
            case 2: {
                Standardizer.expandSgroups(mol, sgroupsToExclude);
                break;
            }
            case 3: {
                this.ungroupSgroups(mol, sgroupsToExclude);
            }
        }
    }

    private static void contractSgroups(Molecule mol, HashSet sgroupsToExclude) {
        if (sgroupsToExclude == null) {
            mol.contractSgroups();
        } else {
            boolean isGUIContracted = mol.isGUIContracted();
            mol.setGUIContracted(true);
            for (int i = mol.getSgroupCount() - 1; i >= 0; --i) {
                Sgroup sgroup = mol.getSgroup(i);
                if (sgroup.getParentSgroup() != null) continue;
                Standardizer.contractSgroupsRecursively(sgroup, sgroupsToExclude);
            }
            mol.setGUIContracted(isGUIContracted);
        }
    }

    private static void contractSgroupsRecursively(Sgroup sgroup, HashSet sgroupsToExclude) {
        if (!(sgroup instanceof Expandable)) {
            return;
        }
        if (sgroup.getChildSgroupCount() != 0) {
            boolean expanded = ((Expandable)((Object)sgroup)).isExpanded();
            if (!expanded) {
                ((Expandable)((Object)sgroup)).expand(4);
            }
            for (int i = 0; i < sgroup.getChildSgroupCount(); ++i) {
                Sgroup child = sgroup.getChildSgroup(i);
                Standardizer.contractSgroupsRecursively(child, sgroupsToExclude);
            }
            if (!sgroupsToExclude.contains(sgroup.getSubscript()) || sgroupsToExclude.contains(sgroup.getSubscript()) && !expanded) {
                ((Expandable)((Object)sgroup)).contract(4);
            }
        } else if (!sgroupsToExclude.contains(sgroup.getSubscript()) && ((Expandable)((Object)sgroup)).isExpanded()) {
            ((Expandable)((Object)sgroup)).contract(4);
        }
    }

    private static void expandSgroups(Molecule mol, HashSet sgroupsToExclude) {
        if (sgroupsToExclude == null) {
            mol.expandSgroups();
        } else {
            boolean isGUIContracted = mol.isGUIContracted();
            mol.setGUIContracted(true);
            for (int i = mol.getSgroupCount() - 1; i >= 0; --i) {
                Sgroup sgroup = mol.getSgroup(i);
                if (sgroup.getParentSgroup() != null) continue;
                Standardizer.expandSgroupsRecursively(sgroup, sgroupsToExclude);
            }
            mol.setGUIContracted(isGUIContracted);
        }
    }

    private static void expandSgroupsRecursively(Sgroup sgroup, HashSet sgroupsToExclude) {
        if (!(sgroup instanceof Expandable)) {
            return;
        }
        if (sgroup.getChildSgroupCount() != 0) {
            boolean expanded = ((Expandable)((Object)sgroup)).isExpanded();
            if (!expanded) {
                ((Expandable)((Object)sgroup)).expand(4);
            }
            for (int i = 0; i < sgroup.getChildSgroupCount(); ++i) {
                Sgroup child = sgroup.getChildSgroup(i);
                Standardizer.expandSgroupsRecursively(child, sgroupsToExclude);
            }
            if (!expanded && sgroupsToExclude.contains(sgroup.getSubscript())) {
                ((Expandable)((Object)sgroup)).contract(4);
            }
        } else if (!sgroupsToExclude.contains(sgroup.getSubscript()) && !((Expandable)((Object)sgroup)).isExpanded()) {
            ((Expandable)((Object)sgroup)).expand(4);
        }
    }

    private void ungroupSgroups(Molecule mol, HashSet sgroupsToExclude) {
        if (sgroupsToExclude == null) {
            if (this.changedAtomSet != null) {
                Sgroup[] sgroups = SgroupUtil.filterSgroups(mol.getSgroupArray(), 0, 1);
                MolAtom[] atomsInSgroups = SgroupUtil.getAtomsInSgroups(sgroups);
                this.changedAtomSet.addAll(Arrays.asList(atomsInSgroups));
                this.changedAtomSet.addAll(Arrays.asList(SgroupUtil.getConnectedAtoms(mol, atomsInSgroups)));
            }
            mol.ungroupSgroups(0);
            mol.ungroupSgroups(1);
        } else {
            boolean isGUIContracted = mol.isGUIContracted();
            mol.setGUIContracted(true);
            Sgroup[] sgroups = mol.getSgroupArray();
            if (this.changedAtomSet != null) {
                MolAtom[] atomsInSgroups = SgroupUtil.getAtomsInSgroups(sgroups);
                this.changedAtomSet.addAll(Arrays.asList(atomsInSgroups));
                this.changedAtomSet.addAll(Arrays.asList(SgroupUtil.getConnectedAtoms(mol, atomsInSgroups)));
            }
            for (int i = 0; i < sgroups.length; ++i) {
                Sgroup sgroup = sgroups[i];
                if (sgroup == null || sgroup.getParentSgroup() != null) continue;
                Standardizer.ungroupSgroupsRecursively(mol, sgroup, sgroupsToExclude);
            }
            mol.setGUIContracted(isGUIContracted);
        }
    }

    private static void ungroupSgroupsRecursively(Molecule mol, Sgroup sgroup, HashSet sgroupsToExclude) {
        if (sgroup.getChildSgroupCount() != 0) {
            if (sgroup instanceof Expandable) {
                boolean expanded = ((Expandable)((Object)sgroup)).isExpanded();
                if (!expanded) {
                    ((Expandable)((Object)sgroup)).expand(4);
                }
                for (int i = 0; i < sgroup.getChildSgroupCount(); ++i) {
                    Sgroup child = sgroup.getChildSgroup(i);
                    Standardizer.ungroupSgroupsRecursively(mol, child, sgroupsToExclude);
                }
                if (sgroupsToExclude.contains(sgroup.getSubscript())) {
                    if (!expanded) {
                        ((Expandable)((Object)sgroup)).contract(4);
                    }
                } else {
                    mol.ungroupSgroup(sgroup, 0);
                }
            } else {
                int i;
                Sgroup[] sgroups = new Sgroup[sgroup.getChildSgroupCount()];
                for (i = 0; i < sgroup.getChildSgroupCount(); ++i) {
                    sgroups[i] = sgroup.getChildSgroup(i);
                }
                if (!sgroupsToExclude.contains(sgroup.getSubscript())) {
                    mol.ungroupSgroup(sgroup, 0);
                }
                for (i = 0; i < sgroups.length; ++i) {
                    Standardizer.ungroupSgroupsRecursively(mol, sgroups[i], sgroupsToExclude);
                }
            }
        } else if (!sgroupsToExclude.contains(sgroup.getSubscript())) {
            mol.ungroupSgroup(sgroup, 0);
        }
    }

    private void performAliasToAtom(Molecule mol) throws StandardizerException {
        int count = mol.getAtomCount();
        for (int i = count - 1; i >= 0; --i) {
            int atomicNumber;
            MolAtom atom = mol.getAtom(i);
            if (atom.getAliasstr() == null || (atomicNumber = PeriodicSystem.getAtomicNumber(atom.getAliasstr())) <= 0) continue;
            MolAtom newAtom = new MolAtom(atomicNumber);
            mol.add(newAtom);
            for (int j = atom.getBondCount() - 1; j >= 0; --j) {
                mol.add(new MolBond(newAtom, atom.getLigand(j), atom.getBond(j).getFlags()));
                mol.removeBond(atom.getBond(j));
            }
            newAtom.setLocation(atom.getLocation());
            mol.removeAtom(atom);
        }
    }

    private void performAliasToGroup(Molecule mol) throws StandardizerException {
        this.convertPeptideAliasChainToMoleculeRepresentation(mol);
        if (this.abbrevGroups == null) {
            try {
                this.abbrevGroups = this.getDefaultAbbrevgroups();
            }
            catch (IOException e) {
                throw new StandardizerException(e);
            }
        }
        int count = mol.getAtomCount();
        for (int i = count - 1; i >= 0; --i) {
            MolAtom atom = mol.getAtom(i);
            if (atom.getBondCount() != 1 || atom.getAliasstr() == null || !this.abbrevGroups.containsKey(atom.getAliasstr())) continue;
            Molecule abbrevGroupMol = this.abbrevGroups.get(atom.getAliasstr()).cloneMolecule();
            if (mol.getDim() != 0 && abbrevGroupMol.getDim() != mol.getDim()) {
                abbrevGroupMol.clean(mol.getDim(), null);
                this.abbrevGroups.put(atom.getAliasstr(), abbrevGroupMol);
            }
            SgroupAtom sgroupAtom = (SgroupAtom)abbrevGroupMol.getAtom(0);
            mol.add(sgroupAtom);
            mol.add(new MolBond(sgroupAtom, atom.getLigand(0), atom.getBond(0).getFlags()));
            sgroupAtom.setLocation(atom.getLocation());
            mol.removeBond(atom.getBond(0));
            mol.removeAtom(atom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable<String, Molecule> getDefaultAbbrevgroups() throws MolFormatException, IOException {
        Hashtable<String, Molecule> abbrevGroups = new Hashtable<String, Molecule>();
        InputStream is = null;
        MolImporter importer = null;
        try {
            is = BasicEnvironment.getResourceAsStream(Standardizer.class, DEFAULT_ABBREVGROUP_FILE);
            importer = new MolImporter(is);
            Molecule mol = null;
            while ((mol = importer.read()) != null) {
                mol.contractSgroups();
                mol.setGUIContracted(true);
                abbrevGroups.put(mol.getName(), mol);
                SgroupAtom sgroupAtom = (SgroupAtom)mol.getAtom(0);
                if (sgroupAtom.getLeftName() != null && !mol.getName().equals(sgroupAtom.getLeftName())) {
                    abbrevGroups.put(sgroupAtom.getLeftName(), mol);
                }
                if (sgroupAtom.getRightName() == null || mol.getName().equals(sgroupAtom.getRightName())) continue;
                abbrevGroups.put(sgroupAtom.getRightName(), mol);
            }
        }
        finally {
            importer.close();
            is.close();
        }
        return abbrevGroups;
    }

    private void convertPeptideAliasChainToMoleculeRepresentation(Molecule mol) throws StandardizerException {
        this.initAminoAcidAbbreviationSets();
        try {
            if (Standardizer.isPeptideChain(mol, this.oneLetterAminoAcidAbbreviations)) {
                String importablePeptideString = Standardizer.convertToImportablePeptideString(mol, this.oneLetterAminoAcidAbbreviations);
                if (importablePeptideString == null) {
                    return;
                }
                Molecule peptide = MolImporter.importMol(importablePeptideString, "peptide:1");
                mol.clear();
                mol.fuse(peptide);
                return;
            }
        }
        catch (MolFormatException e) {
            throw new StandardizerException(e);
        }
        catch (SearchException e) {
            throw new StandardizerException(e);
        }
        try {
            if (Standardizer.isPeptideChain(mol, this.threeLetterAminoAcidAbbreviations)) {
                String importablePeptideString = Standardizer.convertToImportablePeptideString(mol, this.threeLetterAminoAcidAbbreviations);
                if (importablePeptideString == null) {
                    return;
                }
                Molecule peptide = MolImporter.importMol(importablePeptideString, "peptide:3");
                mol.clear();
                mol.fuse(peptide);
                return;
            }
        }
        catch (MolFormatException e) {
            throw new StandardizerException(e);
        }
        catch (SearchException e) {
            throw new StandardizerException(e);
        }
    }

    private static String convertToImportablePeptideString(Molecule mol, HashSet<String> aminoAcidAbbreviations) {
        String aliasString;
        MolAtom nTerminal = Standardizer.findNTerminal(mol, aminoAcidAbbreviations);
        if (nTerminal == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (aminoAcidAbbreviations.contains(nTerminal.getAliasstr())) {
            sb.append(nTerminal.getAliasstr());
        }
        HashSet<MolAtom> visitedAtoms = new HashSet<MolAtom>();
        visitedAtoms.add(nTerminal);
        MolAtom next = nTerminal.getBond(0).getOtherAtom(nTerminal);
        while (next != null && (aliasString = next.getAliasstr()) != null && next.getBondCount() >= 1) {
            visitedAtoms.add(next);
            sb.append(aliasString);
            if (next.getBondCount() == 2) {
                MolAtom nextInChain = next.getBond(0).getOtherAtom(next);
                if (visitedAtoms.contains(nextInChain)) {
                    next = next.getBond(1).getOtherAtom(next);
                    continue;
                }
                next = nextInChain;
                continue;
            }
            next = null;
        }
        return sb.toString();
    }

    private static MolAtom findNTerminal(Molecule mol, HashSet<String> aminoAcidAbbreviations) {
        MolAtom atom;
        int i;
        for (i = 0; i < mol.getAtomCount(); ++i) {
            atom = mol.getAtom(i);
            if (atom.getAtno() != 7 || !atom.isTerminalAtom() || atom.getBondCount() <= 0) continue;
            return atom;
        }
        for (i = 0; i < mol.getAtomCount(); ++i) {
            atom = mol.getAtom(i);
            if (atom.getAtno() != 1 || atom.getBondCount() != 1) continue;
            return atom;
        }
        for (i = 0; i < mol.getAtomCount(); ++i) {
            atom = mol.getAtom(i);
            if (!atom.isTerminalAtom() || atom.getAtno() == 1 || atom.getAtno() == 8 || !aminoAcidAbbreviations.contains(atom.getAliasstr())) continue;
            return atom;
        }
        return null;
    }

    private static boolean isPeptideChain(Molecule mol, HashSet<String> aminoAcidAbbreviations) throws MolFormatException, SearchException {
        MolAtom[] atoms = mol.getAtomArray();
        int hydrogenCount = 0;
        int terminalNitrogenCount = 0;
        int terminalOxigenCount = 0;
        int chainAminoAcidCount = 0;
        int terminalAminoAcidCount = 0;
        for (MolAtom atom : atoms) {
            if (atom.getBondCount() == 2 && aminoAcidAbbreviations.contains(atom.getAliasstr())) {
                ++chainAminoAcidCount;
                continue;
            }
            if (atom.getBondCount() == 1 && aminoAcidAbbreviations.contains(atom.getAliasstr())) {
                ++terminalAminoAcidCount;
                continue;
            }
            if (atom.getBondCount() > 2 && aminoAcidAbbreviations.contains(atom.getAliasstr())) {
                return false;
            }
            if (!atom.isPseudo()) {
                if (atom.getAtno() == 1) {
                    ++hydrogenCount;
                    continue;
                }
                if (atom.getAtno() == 7 && atom.isTerminalAtom()) {
                    ++terminalNitrogenCount;
                    continue;
                }
                if (atom.getAtno() == 8 && atom.isTerminalAtom()) {
                    ++terminalOxigenCount;
                    continue;
                }
                return false;
            }
            return false;
        }
        return chainAminoAcidCount > 0 && terminalAminoAcidCount <= 1 && terminalNitrogenCount <= 1 && terminalOxigenCount <= 1 && hydrogenCount <= 3 && hydrogenCount + terminalNitrogenCount + terminalOxigenCount >= 1;
    }

    private void initAminoAcidAbbreviationSets() {
        if (this.oneLetterAminoAcidAbbreviations == null || this.threeLetterAminoAcidAbbreviations == null) {
            AminoAcidSource aas = AminoAcidSource.getInstance();
            this.oneLetterAminoAcidAbbreviations = new HashSet();
            this.oneLetterAminoAcidAbbreviations.addAll(Arrays.asList(aas.getImportNamesWithOneLetter()));
            this.threeLetterAminoAcidAbbreviations = new HashSet();
            this.threeLetterAminoAcidAbbreviations.addAll(Arrays.asList(aas.getImportNamesWithThreeLetters()));
        }
    }

    private void performClearStereo(Molecule mol, int csact) {
        if (mol.getDim() == 3) {
            mol.setDim(0);
        }
        if ((csact & 1) != 0) {
            Standardizer.clearTetrahedralStereo(mol);
        }
        if ((csact & 2) != 0) {
            Standardizer.clearDoubleBondStereo(mol);
        }
        if ((csact & 4) != 0) {
            Standardizer.clearSingleUpOrDownBonds(mol);
        }
    }

    private static void clearTetrahedralStereo(Molecule mol) {
        mol.setParity(new int[mol.getAtomCount()], false);
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            mol.getAtom(i).setStereoGroupType(0);
        }
    }

    private static boolean hasConnectedDoubleBond(MolAtom atom) {
        for (int i = 0; i < atom.getBondCount(); ++i) {
            if (atom.getBond(i).getType() != 2) continue;
            return true;
        }
        return false;
    }

    private static void clearSingleUpOrDownBonds(Molecule mol) {
        for (int i = 0; i < mol.getBondCount(); ++i) {
            MolBond bond = mol.getBond(i);
            if (bond.getType() != 1 || (bond.getFlags() & 0x30) != 48 || Standardizer.hasConnectedDoubleBond(bond.getAtom1())) continue;
            bond.setFlags(0, 48);
        }
    }

    private static void clearDoubleBondStereo(Molecule mol) {
        boolean cleared = false;
        BitSet ras = Standardizer.generateRingAtomSet(mol);
        int[][] ctab = mol.getCtab();
        BondTable btab = mol.getBondTable();
        for (int j = mol.getBondCount() - 1; j >= 0; --j) {
            int stereo;
            MolBond bond = mol.getBond(j);
            if (bond.getType() != 2) continue;
            MolAtom atom1 = bond.getAtom1();
            MolAtom atom2 = bond.getAtom2();
            int i1 = mol.indexOf(atom1);
            int i2 = mol.indexOf(atom2);
            if (!ras.get(i1) && !ras.get(i2) && !mol.canBeCT(i1, i2)) continue;
            MolAtom ctAtom1 = bond.getCTAtom1();
            MolAtom ctAtom4 = bond.getCTAtom4();
            if (ctAtom1 == null || ctAtom4 == null || (stereo = mol.getStereo2(bond, ctAtom1, ctAtom4, true)) == 0 && (!ras.get(i1) || !Standardizer.canBeCTAtom(atom2, ctab[i2], btab.getBondIndexesToAtom(i2), i1, mol)) && (!ras.get(i2) || !Standardizer.canBeCTAtom(atom1, ctab[i1], btab.getBondIndexesToAtom(i1), i2, mol))) continue;
            bond.setStereo2Flags(ctAtom1, ctAtom4, 192);
            cleared = true;
        }
        if (cleared && mol.getDim() != 0) {
            CleanUtil.setCTWigglyBond(mol);
        }
    }

    private static BitSet generateRingAtomSet(Molecule m) {
        int[][] sssr = m.getSSSR();
        BitSet s = new BitSet(m.getAtomCount());
        for (int i = sssr.length - 1; i >= 0; --i) {
            int[] r = sssr[i];
            for (int j = r.length - 1; j >= 0; --j) {
                s.set(r[j]);
            }
        }
        return s;
    }

    private static boolean canBeCTAtom(MolAtom a2, int[] an, int[] bn, int i3, MoleculeGraph m) {
        int nSingles = 0;
        for (int i = 0; i < an.length; ++i) {
            int i1 = an[i];
            if (i1 == i3) continue;
            int t = m.getBond(bn[i1]).getType();
            if (t != 0 && t != 1 && t != 4 && t != 6) {
                return false;
            }
            ++nSingles;
        }
        if (nSingles == 1) {
            nSingles = 2;
        }
        if (nSingles == 2) {
            int[] g = new int[m.getAtomCount()];
            m.getGrinv(g);
            for (int i = 1; i < an.length; ++i) {
                int i1 = an[i];
                if (i1 == i3) continue;
                for (int j = 0; j < i; ++j) {
                    int i4 = an[j];
                    if (i4 == i3 || g[an[i]] != g[an[j]]) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private void performAbsoluteStereo(Molecule mol, int act) {
        switch (act) {
            case 1: {
                mol.setAbsStereo(false);
                break;
            }
            case 2: {
                if (ReactionUtil.isAbsoluteStereoRelevant(mol)) {
                    mol.setAbsStereo(true);
                    break;
                }
                mol.setAbsStereo(false);
            }
        }
    }

    private void performConvertToEnhancedStereo(Molecule mol, int flags) {
        if (mol.isAbsStereo() || (flags & 1) != 0) {
            EnhStereoConverter.convert(mol, true);
        } else if ((flags & 2) != 0) {
            EnhStereoConverter.convert(mol, false, 3);
        } else if ((flags & 4) != 0) {
            EnhStereoConverter.convert(mol, false, 2);
        }
    }

    private void performWedgeClean(Molecule mol) {
        mol.stereoClean();
    }

    private void performConvertWedgeInterpretation(Molecule mol) {
        mol.useOnlyFirstAtomInStereoCalculation(false);
        int[] parities = new int[mol.getAtomCount()];
        for (int i = 0; i < parities.length; ++i) {
            parities[i] = mol.getParity(i);
        }
        mol.useOnlyFirstAtomInStereoCalculation(true);
        mol.setParity(parities, false);
    }

    private void performConvertDoubleBonds(Molecule mol, int act) {
        if (mol.getDim() == 0) {
            mol.clean(2, null);
        }
        switch (act) {
            case 1: {
                CleanUtil.setCTWigglyBond(mol);
                break;
            }
            case 2: {
                CleanUtil.setCTCrossedBond(mol);
            }
        }
    }

    private void performRemoveStereoCareBox(Molecule mol) {
        MolBond[] bonds;
        for (MolBond bond : bonds = mol.getBondArray()) {
            bond.setFlags(bond.getFlags() & 0xFFFFFDFF);
        }
    }

    private void performReactionExpand(RxnMolecule rxmol, String field) throws StandardizerException {
        int i;
        Molecule parent = (Molecule)rxmol.getParent();
        DataSgroup[] dgroups = Standardizer.getDataSgroups(rxmol, field);
        if (dgroups.length == 0) {
            return;
        }
        if (this.numberUtil == null) {
            this.numberUtil = new NumberUtil();
        }
        int[][] coefficients = new int[rxmol.getReactantCount() + rxmol.getProductCount() + rxmol.getAgentCount()][];
        int k = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = rxmol.getComponentCount(i2) - 1; j >= 0; --j) {
                Molecule structure = rxmol.getComponent(i2, j);
                for (int t = 0; t < dgroups.length; ++t) {
                    if (!Standardizer.outerDataSgroup(dgroups[t], structure)) continue;
                    coefficients[k] = this.findFraction(dgroups[t].getData());
                    parent.ungroupSgroup(dgroups[t]);
                    break;
                }
                int[] factor = this.performExpand(structure, field);
                if (coefficients[k] != null) {
                    int[] nArray = coefficients[k];
                    nArray[0] = nArray[0] * factor[1];
                    int[] nArray2 = coefficients[k];
                    nArray2[1] = nArray2[1] * factor[0];
                } else {
                    coefficients[k] = new int[]{factor[1], factor[0]};
                }
                ++k;
            }
        }
        int[] multiplicities = new int[coefficients.length];
        this.calcMultiplicities(multiplicities, coefficients);
        boolean allOnes = true;
        for (i = 0; i < multiplicities.length; ++i) {
            if (multiplicities[i] == 1) continue;
            allOnes = false;
            break;
        }
        if (allOnes) {
            return;
        }
        k = 0;
        for (i = 0; i < 3; ++i) {
            for (int j = rxmol.getComponentCount(i) - 1; j >= 0; --j) {
                Molecule structure = rxmol.getComponent(i, j);
                int multiplicity = multiplicities[k++];
                while (--multiplicity > 0) {
                    rxmol.addComponent((Molecule)structure.clone(), i);
                }
            }
        }
        rxmol.rebuildStructures();
        if (this.changedAtomSet != null) {
            this.changedAtomSet.addAll(Arrays.asList(rxmol.getAtomArray()));
        }
    }

    private void performMapReaction(RxnMolecule rxnmol) throws StandardizerException {
        if (this.autoMapper == null) {
            this.autoMapper = new AutoMapper();
        }
        this.autoMapper.setMappingStyle(2);
        try {
            this.autoMapper.map(rxnmol);
        }
        catch (AutoMapperException e) {
            throw new StandardizerException("Unable to map reaction: " + rxnmol.toFormat("smiles"), e);
        }
    }

    private void performMap(Molecule mol) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            mol.getAtom(i).setAtomMap(i + 1);
        }
    }

    private void performUnmapAtoms(Molecule mol) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            mol.getAtom(i).setAtomMap(0);
        }
    }

    private static boolean outerDataSgroup(DataSgroup dgroup, Molecule mol) {
        if (dgroup.getAtomCount() != mol.getAtomCount()) {
            return false;
        }
        for (int i = dgroup.getAtomCount() - 1; i >= 0; --i) {
            if (dgroup.getAtom(i).getParent() == mol) continue;
            return false;
        }
        return true;
    }

    private int[] performExpand(Molecule mol, String field) throws StandardizerException {
        int i;
        SelectionMolecule[] parts;
        DataSgroup[] dgroups = Standardizer.getDataSgroups(mol, field);
        if (dgroups.length == 0) {
            return new int[]{1, 1};
        }
        if (this.numberUtil == null) {
            this.numberUtil = new NumberUtil();
        }
        int mcount = (parts = Standardizer.findParts(mol, dgroups))[dgroups.length].isEmpty() ? dgroups.length : dgroups.length + 1;
        int[][] coefficients = new int[mcount][];
        for (int i2 = 0; i2 < dgroups.length; ++i2) {
            coefficients[i2] = this.findFraction(dgroups[i2].getData());
        }
        if (mcount == dgroups.length + 1) {
            coefficients[dgroups.length] = new int[]{1, 1};
        }
        int[] multiplicities = new int[mcount];
        int[] factor = this.calcMultiplicities(multiplicities, coefficients);
        MoleculeGraph newpart = mol.newInstance();
        for (i = 0; i < multiplicities.length; ++i) {
            int multiplicity = multiplicities[i];
            while (--multiplicity > 0) {
                newpart.fuse((MoleculeGraph)parts[i].clone());
            }
        }
        for (i = 0; i < dgroups.length; ++i) {
            mol.ungroupSgroup(dgroups[i]);
        }
        mol.fuse(newpart);
        if (this.changedAtomSet != null) {
            this.changedAtomSet.addAll(Arrays.asList(newpart.getAtomArray()));
        }
        return factor;
    }

    private static DataSgroup[] getDataSgroups(Molecule mol, String field) {
        int count = mol.getSgroupCount();
        ArrayList<Sgroup> dgroupList = new ArrayList<Sgroup>(count);
        for (int i = 0; i < count; ++i) {
            Sgroup sgroup = mol.getSgroup(i);
            if (sgroup.getType() != 10 || field != null && !field.equals(((DataSgroup)sgroup).getFieldName())) continue;
            dgroupList.add(sgroup);
        }
        DataSgroup[] dgroups = new DataSgroup[dgroupList.size()];
        dgroupList.toArray(dgroups);
        return dgroups;
    }

    private static SelectionMolecule[] findParts(Molecule mol, DataSgroup[] dgroups) {
        int dcount = dgroups.length;
        int[] fragids = mol.getFragIds();
        int[] fragid2dgroup = new int[fragids.length];
        Arrays.fill(fragid2dgroup, dcount);
        SelectionMolecule[] parts = new SelectionMolecule[dcount + 1];
        for (int i = 0; i < dcount; ++i) {
            parts[i] = new SelectionMolecule();
            DataSgroup dgroup = dgroups[i];
            for (int j = dgroup.getAtomCount() - 1; j >= 0; --j) {
                MolAtom atom = dgroup.getAtom(j);
                int index = mol.indexOf(atom);
                int fragid = fragids[index];
                if (fragid2dgroup[fragid] == i) continue;
                mol.findFrag(index, parts[i]);
                fragid2dgroup[fragid] = i;
            }
        }
        parts[dcount] = new SelectionMolecule();
        for (int fragid = 0; fragid < fragid2dgroup.length; ++fragid) {
            if (fragid2dgroup[fragid] != dcount) continue;
            mol.findFragById(fragid, parts[dcount]);
        }
        return parts;
    }

    private int[] findFraction(String data) throws StandardizerException {
        if (data == null) {
            return new int[]{1, 1};
        }
        try {
            int k = data.indexOf("/");
            if (k != -1) {
                int a = Integer.parseInt(data.substring(0, k).trim());
                int b = Integer.parseInt(data.substring(k + 1).trim());
                if (b == 0) {
                    throw new StandardizerException("Expand: attached data format error: " + data);
                }
                return new int[]{a, b};
            }
            double m = Double.parseDouble(data.trim());
            return this.numberUtil.findFraction(m);
        }
        catch (NumberFormatException e) {
            throw new StandardizerException("Expand: attached data format error: " + data, e);
        }
    }

    private int[] calcMultiplicities(int[] multiplicities, int[][] coefficients) {
        int i;
        int denominator = 1;
        for (i = 0; i < coefficients.length; ++i) {
            denominator *= coefficients[i][1];
        }
        for (i = 0; i < coefficients.length; ++i) {
            multiplicities[i] = coefficients[i][0] * denominator / coefficients[i][1];
        }
        int gcd = NumberUtil.findGreatestCommonDivisor(multiplicities);
        int i2 = 0;
        while (i2 < coefficients.length) {
            int n = i2++;
            multiplicities[n] = multiplicities[n] / gcd;
        }
        return new int[]{denominator, gcd};
    }

    private void performTautomerize(Molecule mol) throws StandardizerException {
        if (this.tautomerizationPlugin == null) {
            this.tautomerizationPlugin = new TautomerizationPlugin();
            this.tautomerizationPlugin.setTakeStandardForm(true);
            this.tautomerizationPlugin.setCleanResultStructures(true);
        }
        boolean inputMoleculeRefused = false;
        try {
            this.tautomerizationPlugin.checkMolecule(mol);
        }
        catch (PluginException e) {
            inputMoleculeRefused = true;
        }
        if (!inputMoleculeRefused) {
            try {
                this.tautomerizationPlugin.setMolecule(mol);
                if (this.tautomerizationPlugin.run()) {
                    mol.removeAll();
                    mol.fuse(this.tautomerizationPlugin.getStructure(0));
                }
            }
            catch (PluginException e) {
                throw new StandardizerException(e);
            }
        }
        mol.dearomatize();
    }

    private void performMesomerize(Molecule mol) throws StandardizerException {
        if (this.resonancePlugin == null) {
            this.resonancePlugin = new ResonancePlugin();
            this.resonancePlugin.setTakeCanonicalForm(true);
        }
        boolean inputMoleculeRefused = false;
        try {
            this.resonancePlugin.checkMolecule(mol);
        }
        catch (PluginException e) {
            inputMoleculeRefused = true;
        }
        if (!inputMoleculeRefused) {
            try {
                this.resonancePlugin.setMolecule(mol);
                if (this.resonancePlugin.run()) {
                    mol.removeAll();
                    mol.fuse(this.resonancePlugin.getStructure(0));
                }
            }
            catch (PluginException e) {
                throw new StandardizerException(e);
            }
        }
        mol.dearomatize();
    }

    private void performFinalStereoFix(Molecule mol) {
        if (mol.getDim() == 2) {
            StereoCorrector.removeInvalidWedges(mol);
            StereoCorrector.removeInvalidEnhancedStereo(mol);
        }
    }

    private void performCreateGroup(Molecule mol, GroupList groupList) throws StandardizerException {
        int i;
        int[] usedIndexes = new int[]{};
        Sgroup[] sGroups = mol.getSgroupArray();
        mol.expandSgroups();
        for (i = 0; i < sGroups.length; ++i) {
            int[] atomIndexes = new int[sGroups[i].getAtomCount()];
            for (int j = 0; j < atomIndexes.length; ++j) {
                atomIndexes[j] = mol.indexOf(sGroups[i].getAtom(j));
            }
            usedIndexes = this.concat(usedIndexes, atomIndexes);
        }
        for (i = 0; i < groupList.getGroups().size(); ++i) {
            List<GroupDefinition> targetList = groupList.getGroups().get(i);
            for (GroupDefinition groupPattern : targetList) {
                StandardizedMolSearch search = new StandardizedMolSearch();
                MolSearchOptions options = new MolSearchOptions(2);
                options.setImplicitHMatching(1);
                options.setOrderSensitiveSearch(false);
                search.setTarget(mol, usedIndexes);
                search.setSearchOptions(options);
                search.setQuery(groupPattern.getGroup());
                try {
                    int[] hit;
                    SuperatomSgroup group = null;
                    while ((hit = search.findNext()) != null) {
                        group = new SuperatomSgroup(mol);
                        group.setSubscript(groupPattern.getAbbreviation());
                        for (int k = 0; k < hit.length; ++k) {
                            mol.setSgroupParent(mol.getAtom(hit[k]), group, true);
                        }
                        usedIndexes = this.concat(usedIndexes, hit);
                        search.setTarget(mol, usedIndexes);
                    }
                }
                catch (SearchException e) {
                    e.printStackTrace();
                }
            }
        }
        mol.contractSgroups();
        mol.setGUIContracted(true);
        mol.clean(2, null);
    }

    int[] concat(int[] first, int[] second) {
        int[] result = new int[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private void performReaction(Molecule mol, ReactionPerformer performer) throws StandardizerException {
        performer.setChangedAtomSet(this.changedAtomSet);
        if (performer.getSearchOptions().isSubgraphSearch() && performer.getSearchOptions().getSearchType() != 7) {
            this.processReaction(mol, performer);
        } else if (!mol.isEmpty()) {
            int i;
            Molecule cmol = performer.getProductCount() == 0 ? (Molecule)mol.clone() : null;
            Molecule[] frags = mol.convertToFrags();
            int emptyFragCount = 0;
            for (i = 0; i < frags.length; ++i) {
                this.processReaction(frags[i], performer);
                if (cmol == null || !frags[i].isEmpty()) continue;
                ++emptyFragCount;
            }
            if (emptyFragCount < frags.length) {
                mol.removeAll();
                for (i = 0; i < frags.length; ++i) {
                    mol.fuse(frags[i]);
                }
            } else {
                cmol.findFrag(0, frags[0]);
                mol.removeAll();
                mol.fuse(frags[0]);
                if (this.changedAtomSet != null) {
                    this.changedAtomSet.clear();
                    this.changedAtomSet.addAll(Arrays.asList(mol.getAtomArray()));
                }
            }
        }
    }

    private void processReaction(Molecule mol, ReactionPerformer performer) throws StandardizerException {
        try {
            performer.setReactant(mol);
            performer.react();
        }
        catch (ReactionException e) {
            throw new StandardizerException(e);
        }
    }

    private void standardizeReaction(RxnMolecule rxmol, int type) throws SearchException, LicenseException {
        for (int i = 0; i < this.stdata.length; ++i) {
            if (this.stdata[i].type != type || !this.isActiveTask(this.stdata[i])) continue;
            long grinvCC = rxmol.getGrinvCC();
            if (this.stdata[i].type == 11 || this.stdata[i].type == 12) {
                this.checkLicense(this.stdata[i].type);
                this.performMapReaction(rxmol);
            } else if (this.stdata[i].type == 8) {
                this.checkLicense(this.stdata[i].type);
                this.performReactionExpand(rxmol, this.stdata[i].datafield);
            }
            if (grinvCC == rxmol.getGrinvCC()) continue;
            this.appliedTask[i] = true;
        }
    }

    private void standardizeRgMolecule(RgMolecule rgmol, int type) throws SearchException, LicenseException {
        for (int i = 0; i < this.stdata.length; ++i) {
            if (this.stdata[i].type != type || !this.isActiveTask(this.stdata[i])) continue;
            long grinvCC = rgmol.getGrinvCC();
            if (this.stdata[i].type == 21 || this.stdata[i].type == 2 && this.stdata[i].rmethod == 5) {
                this.checkLicense(this.stdata[i].type);
                this.performKeepRoot(rgmol);
            }
            if (grinvCC == rgmol.getGrinvCC()) continue;
            this.appliedTask[i] = true;
        }
    }

    private void standardizeComponent(Molecule mol) throws SearchException, LicenseException {
        for (int i = 0; i < this.stdata.length; ++i) {
            if (!this.isActiveTask(this.stdata[i])) continue;
            long grinvCC = mol.getGrinvCC();
            this.checkLicense(this.stdata[i].type);
            if (this.stdata[i].performer == null) {
                if (this.stdata[i].type == 1) {
                    this.performAction(mol, this.stdata[i].data);
                } else if (this.stdata[i].type == 2) {
                    this.performRemoval(mol, this.stdata[i].rmethod, this.stdata[i].rmeasure);
                } else if (this.stdata[i].type == 3) {
                    this.performClean(mol, this.stdata[i].dim, this.stdata[i].cleantype, this.stdata[i].getTBCleaner());
                } else if (this.stdata[i].type == 4) {
                    this.performImplH(mol, this.stdata[i].flags);
                } else if (this.stdata[i].type == 5) {
                    this.performSgroups(mol, this.stdata[i].flags, this.stdata[i].sgroups);
                } else if (this.stdata[i].type == 6) {
                    this.performClearStereo(mol, this.stdata[i].flags);
                } else if (this.stdata[i].type == 7) {
                    this.performAbsoluteStereo(mol, this.stdata[i].flags);
                } else if (this.stdata[i].type == 8) {
                    this.performExpand(mol, this.stdata[i].datafield);
                } else if (this.stdata[i].type == 9) {
                    this.performTautomerize(mol);
                } else if (this.stdata[i].type == 10) {
                    this.performMesomerize(mol);
                } else if (this.stdata[i].type == 12) {
                    this.performMap(mol);
                } else if (this.stdata[i].type == 13) {
                    this.performUnmapAtoms(mol);
                } else if (this.stdata[i].type == 14) {
                    this.performConvertDoubleBonds(mol, this.stdata[i].flags);
                } else if (this.stdata[i].type == 15) {
                    this.performWedgeClean(mol);
                } else if (this.stdata[i].type == 16) {
                    this.performConvertWedgeInterpretation(mol);
                } else if (this.stdata[i].type == 17) {
                    if (!this.isReaction) {
                        this.performNeutralize(mol);
                    }
                } else if (this.stdata[i].type == 18) {
                    this.performClearIsotopes(mol);
                } else if (this.stdata[i].type == 19) {
                    this.performAliasToGroup(mol);
                } else if (this.stdata[i].type == 20) {
                    this.performAliasToAtom(mol);
                } else if (this.stdata[i].type == 22) {
                    this.performConvertToEnhancedStereo(mol, this.stdata[i].flags);
                } else if (this.stdata[i].type == 23) {
                    this.performRemoveAtomValues(mol);
                } else if (this.stdata[i].type == 24) {
                    this.performRemoveAttachedData(mol);
                } else if (this.stdata[i].type == 25) {
                    this.performRemoveStereoCareBox(mol);
                } else if (this.stdata[i].type == 26) {
                    this.performCreateGroup(mol, this.stdata[i].getGroupList());
                }
            } else {
                this.performReaction(mol, this.stdata[i].performer);
            }
            if (grinvCC == mol.getGrinvCC()) continue;
            this.appliedTask[i] = true;
        }
        if (this.cldata != null) {
            long grinvCC = mol.getGrinvCC();
            this.performClean(mol, this.cldata.dim, this.cldata.cleantype, this.cldata.getTBCleaner());
            if (grinvCC != mol.getGrinvCC()) {
                this.appliedTask[this.stdata.length] = true;
            }
        }
        if (this.finalStereoFix) {
            this.performFinalStereoFix(mol);
        }
    }

    private void checkLicense(int type) {
        if (type != 1 && type != 4 && type != 15 && type != 16) {
            try {
                this.checkLicense();
            }
            catch (LicenseException e) {
                throw new LicenseException(e.getMessage() + lineSep + lineSep + LICENSE_MSG);
            }
        }
    }

    @Override
    public Molecule standardize(Molecule mol) throws SearchException, LicenseException {
        int i;
        RgMolecule rgmol;
        RxnMolecule rxmol;
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Molecule: " + ReactionUtil.toFormat(mol, new String[]{"smiles", "cxsmiles", "mrv"}));
        }
        MolAtom[] oldAtoms = this.atomIndexQuery ? mol.getAtomArray() : null;
        Arrays.fill(this.appliedTask, false);
        if (this.partialClean) {
            this.initPartialClean();
        }
        this.isReaction = (rxmol = RxnMolecule.getReaction(mol)) != null;
        RgMolecule rgMolecule = rgmol = mol instanceof RgMolecule && ((RgMolecule)mol).getRgroupCount() > 0 ? (RgMolecule)mol : null;
        if (rgmol != null) {
            this.standardizeRgMolecule(rgmol, 2);
            this.standardizeRgMolecule(rgmol, 21);
            this.standardize(rgmol.getRoot());
            for (i = rgmol.getRgroupCount() - 1; i >= 0; --i) {
                for (int j = rgmol.getRgroupMemberCount(i) - 1; j >= 0; --j) {
                    this.standardizeComponent(rgmol.getRgroupMember(i, j));
                }
            }
        } else if (rxmol != null) {
            this.standardizeReaction(rxmol, 8);
            for (i = rxmol.getProductCount() - 1; i >= 0; --i) {
                this.standardizeComponent(rxmol.getProduct(i));
            }
            for (i = rxmol.getAgentCount() - 1; i >= 0; --i) {
                this.standardizeComponent(rxmol.getAgent(i));
            }
            for (i = rxmol.getReactantCount() - 1; i >= 0; --i) {
                this.standardizeComponent(rxmol.getReactant(i));
            }
            this.standardizeReaction(rxmol, 11);
            this.standardizeReaction(rxmol, 12);
        } else {
            this.standardizeComponent(mol);
        }
        boolean modified = false;
        for (int i2 = 0; i2 < this.appliedTask.length; ++i2) {
            modified |= this.appliedTask[i2];
        }
        if (modified && (rxmol != null || rgmol != null) && (this.cldata != null || this.isLastTaskClean())) {
            CleanUtil.arrangeComponents(mol);
        }
        this.changedAtomSet = null;
        if (this.atomIndexQuery) {
            this.setAtomIndexData(mol, oldAtoms);
        }
        return mol;
    }

    public void standardize(Molecule[] mols) throws SearchException, LicenseException {
        if (this.atomIndexQuery && mols.length > 1) {
            throw new StandardizerException("Atom index query is only available for a single molecule at a time.");
        }
        for (int i = 0; i < mols.length; ++i) {
            this.standardize(mols[i]);
        }
    }

    public int[] getAppliedTaskIndexes() {
        int count = 0;
        for (int i = 0; i < this.appliedTask.length; ++i) {
            if (!this.appliedTask[i]) continue;
            ++count;
        }
        int[] indexes = new int[count];
        count = 0;
        for (int i = 0; i < this.appliedTask.length; ++i) {
            if (!this.appliedTask[i]) continue;
            indexes[count++] = i;
        }
        return indexes;
    }

    public String[] getAppliedTaskIDs() {
        int[] indexes = this.getAppliedTaskIndexes();
        String[] ids = new String[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            ids[i] = indexes[i] < this.stdata.length ? this.stdata[indexes[i]].id : this.cldata.id;
        }
        return ids;
    }

    public boolean isLastTaskClean() {
        return this.stdata.length == 0 || this.stdata[this.stdata.length - 1].type == 3;
    }

    StandardizerData[] getTaskList() {
        return this.stdata;
    }

    public static void main(String[] args) throws Exception {
        ConcurrentStandardizerProcessor.main(args);
    }

    static {
        SET_TARGET = new HashSet();
        SET_TARGET.add(GROUP_TARGET);
        lineSep = System.getProperty("line.separator");
        LICENSE_MSG = "Action tasks:" + lineSep + "Aromatize, Dearomatize, AddExplicitH, RemoveExplicitH, WedgeClean, " + lineSep + "ConvertWedgeInterpretation do not require a license key." + lineSep + "Remove non-Action elements from Standardizer XML configuration and run again.";
        logger = Logger.getLogger(Standardizer.class.getName());
    }
}

