/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.reaction.GroupList;
import chemaxon.reaction.ReactionPerformer;
import chemaxon.reaction.StandardizerException;
import chemaxon.sss.search.TemplateBasedClean;
import chemaxon.struc.Molecule;
import java.io.Serializable;
import java.util.HashSet;

class StandardizerData
implements Serializable {
    public static final int REACTION = 0;
    public static final int ACTION = 1;
    public static final int REMOVAL = 2;
    public static final int CLEAN = 3;
    public static final int IMPLH = 4;
    public static final int SGROUPS = 5;
    public static final int CLEARSTEREO = 6;
    public static final int ABSOLUTESTEREO = 7;
    public static final int EXPAND = 8;
    public static final int TAUTOMERIZE = 9;
    public static final int MESOMERIZE = 10;
    public static final int MAPREACTION = 11;
    public static final int MAP = 12;
    public static final int UNMAPATOMS = 13;
    public static final int CONVERTDOUBLEBONDS = 14;
    public static final int WEDGECLEAN = 15;
    public static final int CONVERTWEDGEINTERPRETATION = 16;
    public static final int NEUTRALIZE = 17;
    public static final int CLEARISOTOPES = 18;
    public static final int ALIASTOGROUP = 19;
    public static final int ALIASTOATOM = 20;
    public static final int REMOVERGROUPDEFINITIONS = 21;
    public static final int ENHANCEDSTEREO = 22;
    public static final int REMOVEATOMVALUES = 23;
    public static final int REMOVEATTACHEDDATA = 24;
    public static final int REMOVESTEREOCAREBOX = 25;
    public static final int CREATEGROUP = 26;
    public static final int ACT_AROMATIZE_BASIC = 1;
    public static final int ACT_AROMATIZE_GENERAL = 2;
    public static final int ACT_AROMATIZE_LOOSE = 3;
    public static final int ACT_DEAROMATIZE = 4;
    public static final int ACT_HYDROGENIZE = 5;
    public static final int RMETHOD_REMOVE_SMALLEST = 1;
    public static final int RMETHOD_KEEP_LARGEST = 2;
    public static final int RMETHOD_REMOVE_LARGEST = 3;
    public static final int RMETHOD_KEEP_SMALLEST = 4;
    public static final int RMETHOD_RGROUPS = 5;
    public static final int RMEASURE_ATOM_COUNT = 1;
    public static final int RMEASURE_MOL_MASS = 2;
    public static final int SGROUPS_CONTRACT = 1;
    public static final int SGROUPS_EXPAND = 2;
    public static final int SGROUPS_UNGROUP = 3;
    public static final int CLEARSTEREO_CHIRALITY = 1;
    public static final int CLEARSTEREO_DOUBLEBOND = 2;
    public static final int CLEARSTEREO_SINGLE_UP_OR_DOWN_BOND = 4;
    public static final int ABSOLUTESTEREO_CLEAR = 1;
    public static final int ABSOLUTESTEREO_SET = 2;
    public static final int ENHANCEDSTEREO_ABS = 1;
    public static final int ENHANCEDSTEREO_AND = 2;
    public static final int ENHANCEDSTEREO_OR = 4;
    public static final int CLEAN_PARTIAL = 1;
    public static final int CLEAN_FULL = 2;
    public static final int CLEAN_TEMPLATE_BASED = 3;
    public static final int CLEAN_REMOVE_Z_COORDINATE = 4;
    public static final int CONVERTDOUBLEBONDS_WIGGLY = 1;
    public static final int CONVERTDOUBLEBONDS_CROSSED = 2;
    int type = -1;
    String id = null;
    int data = -1;
    ReactionPerformer performer = null;
    int rmethod = -1;
    int rmeasure = -1;
    int dim = -1;
    int cleantype = 1;
    int flags = 0;
    private transient TemplateBasedClean tbCleaner = null;
    private Molecule[] cleanTemplates = null;
    String datafield = null;
    HashSet sgroups = null;
    HashSet groups = null;
    private GroupList groupList;

    StandardizerData(int type, String id, HashSet groups) {
        this.type = type;
        this.id = id;
        this.groups = groups;
    }

    StandardizerData(int type, String id, String datastr, HashSet groups) throws StandardizerException {
        this(type, id, groups);
        if (type == 8) {
            this.datafield = datastr;
        } else if (datastr != null) {
            if ((datastr = datastr.toLowerCase()).startsWith("aromatize:b") || datastr.equals("aromatize:1")) {
                this.data = 1;
            } else if (datastr.startsWith("aromatize:l")) {
                this.data = 3;
            } else if (datastr.startsWith("aromatize")) {
                this.data = 2;
            } else if (datastr.equals("dearomatize")) {
                this.data = 4;
            } else if (datastr.equals("hydrogenize") || datastr.equals("addexplicith")) {
                this.data = 5;
            } else {
                throw new StandardizerException("Standardizer action \"" + datastr + "\" is not implemented.");
            }
        }
    }

    StandardizerData(int type, String id, ReactionPerformer performer, HashSet groups) throws StandardizerException {
        this(type, id, groups);
        this.performer = performer;
    }

    StandardizerData(int type, String id, int rmethod, int rmeasure, HashSet groups) {
        this(type, id, groups);
        this.rmethod = rmethod;
        this.rmeasure = rmeasure;
    }

    StandardizerData(int type, String id, int dim, int cleantype, Molecule[] cleanTemplates, HashSet groups) throws StandardizerException {
        this(type, id, groups);
        this.dim = dim;
        this.cleantype = cleantype;
        this.cleanTemplates = cleanTemplates;
    }

    StandardizerData(int type, String id, int flags, HashSet groups) throws StandardizerException {
        this(type, id, groups);
        this.flags = flags;
    }

    StandardizerData(int type, String id, int flags, HashSet sgroups, HashSet groups) throws StandardizerException {
        this(type, id, groups);
        this.flags = flags;
        this.sgroups = sgroups;
    }

    public StandardizerData(int type, GroupList groupList) {
        this.type = type;
        this.groupList = groupList;
    }

    TemplateBasedClean getTBCleaner() {
        if (this.tbCleaner != null) {
            return this.tbCleaner;
        }
        if (this.cleanTemplates != null) {
            this.tbCleaner = new TemplateBasedClean(this.cleanTemplates);
            return this.tbCleaner;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StandardizerData) {
            StandardizerData other = (StandardizerData)obj;
            if (this.type == other.type && this.data == other.data) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.type;
        hash = 31 * hash + this.data;
        return hash;
    }

    public String toString() {
        String stype = "-";
        switch (this.type) {
            case 0: {
                stype = "REACTION";
                break;
            }
            case 1: {
                stype = "ACTION";
                break;
            }
            case 2: {
                stype = "REMOVAL";
                break;
            }
            case 3: {
                stype = "CLEAN";
                break;
            }
            case 4: {
                stype = "IMPLH";
                break;
            }
            case 5: {
                stype = "SGROUPS";
                break;
            }
            case 6: {
                stype = "CLEARSTEREO";
                break;
            }
            case 7: {
                stype = "ABSOLUTESTEREO";
                break;
            }
            case 8: {
                stype = "EXPAND";
                break;
            }
            case 9: {
                stype = "TAUTOMERIZE";
                break;
            }
            case 10: {
                stype = "MESOMERIZE";
                break;
            }
            case 11: {
                stype = "MAPREACTION";
                break;
            }
            case 12: {
                stype = "MAP";
                break;
            }
            case 13: {
                stype = "UNMAPATOMS";
                break;
            }
            case 14: {
                stype = "CONVERTDOUBLEBONDS";
                break;
            }
            case 15: {
                stype = "WEDGECLEAN";
                break;
            }
            case 16: {
                stype = "CONVERTWEDGEINTERPRETATION";
                break;
            }
            case 17: {
                stype = "NEUTRALIZE";
                break;
            }
            case 18: {
                stype = "CLEARISOTOPES";
                break;
            }
            case 19: {
                stype = "ALIASTOGROUP";
                break;
            }
            case 20: {
                stype = "ALIASTOATOM";
                break;
            }
            case 21: {
                stype = "REMOVERGROUPDEFINITIONS";
                break;
            }
            case 22: {
                stype = "ENHANCEDSTEREO";
                break;
            }
            case 23: {
                stype = "REMOVEATOMVALUES";
                break;
            }
            case 24: {
                stype = "REMOVEATTACHEDDATA";
                break;
            }
            case 26: {
                stype = "CREATEGROUP";
            }
        }
        return stype + " - " + this.id + " - " + this.data;
    }

    public GroupList getGroupList() {
        return this.groupList;
    }
}

