/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction;

import chemaxon.reaction.Reaction;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.ReactionPerformer;
import chemaxon.reaction.ReactionUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.util.ArrayList;
import java.util.HashSet;

public class Transformer
implements chemaxon.util.reaction.ReactionPerformer {
    private ReactionPerformer performer;

    @Override
    public boolean setReaction(Molecule mol) {
        RxnMolecule rxn = RxnMolecule.getReaction(mol);
        if (rxn != null) {
            try {
                this.performer = new ReactionPerformer(new Reaction(ReactionUtil.fuseReactionMolecule(rxn)));
                this.performer.setTransform(true);
                this.performer.setDuplicateFiltering(0);
                return true;
            }
            catch (ReactionException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public Molecule performReaction(Molecule mol) {
        if (this.performer.getReaction() == null) {
            return mol;
        }
        HashSet<MolAtom> changedAtomSet = new HashSet<MolAtom>();
        this.performer.setChangedAtomSet(changedAtomSet);
        try {
            this.performer.setReactant(mol);
            this.performer.react();
            if (mol.getDim() == 2) {
                mol.partialClean(2, Transformer.getFixedComponent(mol, changedAtomSet), null);
            }
        }
        catch (ReactionException e) {
            throw new RuntimeException(e);
        }
        return mol;
    }

    private static int[] getFixedComponent(Molecule mol, HashSet<MolAtom> changedAtomSet) {
        ArrayList<MolAtom> fixedAtomList = new ArrayList<MolAtom>();
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = mol.getAtom(i);
            if (changedAtomSet == null || changedAtomSet.contains(atom)) continue;
            fixedAtomList.add(atom);
        }
        int[] fixed = new int[fixedAtomList.size()];
        for (int i = 0; i < fixed.length; ++i) {
            MolAtom atom = (MolAtom)fixedAtomList.get(i);
            fixed[i] = mol.indexOf(atom);
        }
        fixedAtomList.clear();
        int[] ids = mol.findComponentIds(fixed);
        boolean onecomp = true;
        for (int i = 1; i < ids.length; ++i) {
            if (ids[i - 1] == ids[i]) continue;
            onecomp = false;
            break;
        }
        if (onecomp) {
            return fixed;
        }
        int[] counts = new int[mol.getAtomCount()];
        for (int i = 0; i < ids.length; ++i) {
            int n = ids[i];
            counts[n] = counts[n] + 1;
        }
        int m = -1;
        int id = -1;
        for (int i = 0; i < ids.length; ++i) {
            if (counts[ids[i]] <= m) continue;
            m = counts[ids[i]];
            id = ids[i];
        }
        int j = 0;
        int[] compfixed = new int[m];
        for (int i = 0; i < fixed.length; ++i) {
            if (ids[i] != id) continue;
            compfixed[j++] = fixed[i];
        }
        return compfixed;
    }
}

