/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction.tester;

import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;

public class ExampleCounter {
    private int count = 0;

    public static void main(String[] args) {
        HashSet<String> switchs = new HashSet<String>();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-") || !ExampleCounter.isSwitchCorrect(args[i])) continue;
            switchs.add(args[i]);
        }
        if (!ExampleCounter.containsAllNeededSwitch(switchs)) {
            ExampleCounter.printHelp();
            return;
        }
        InputStream inputStream = System.in;
        OutputStream outputStream = System.out;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h") || args[i].equals("--help")) {
                ExampleCounter.printHelp();
                return;
            }
            if (args[i].equals("-o")) {
                try {
                    outputStream = new FileOutputStream(args[++i]);
                }
                catch (FileNotFoundException e) {
                    System.err.println("Could not open output file. Exiting");
                    e.printStackTrace();
                    System.exit(1);
                }
                continue;
            }
            try {
                inputStream = new FileInputStream(args[i]);
                continue;
            }
            catch (FileNotFoundException e) {
                System.err.println("Could not open input file. Exiting");
                e.printStackTrace();
                System.exit(1);
            }
        }
        ExampleCounter counter = new ExampleCounter();
        try {
            counter.countExamples(inputStream, outputStream);
            inputStream.close();
            ((OutputStream)outputStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void countExamples(InputStream inputStream, OutputStream outputStream) throws Exception {
        Molecule molecule;
        MolImporter importer = new MolImporter(inputStream);
        PrintWriter writer = new PrintWriter(outputStream);
        while ((molecule = importer.read()) != null) {
            writer.println(this.getName(molecule) + ": " + this.getExampleCount(molecule));
            writer.flush();
        }
        importer.close();
        writer.close();
    }

    private int getExampleCount(Molecule molecule) throws Exception {
        int count = 0;
        String examples = molecule.getProperty("EXAMPLE");
        if (examples != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(examples.getBytes());
            MolImporter importer = new MolImporter(inputStream);
            while (importer.read() != null) {
                ++count;
            }
            importer.close();
        }
        return count;
    }

    private String getName(Molecule molecule) {
        String name = molecule.getProperty("NAME");
        if (name == null) {
            return "Reaction" + ++this.count;
        }
        return name;
    }

    private static boolean isSwitchCorrect(String switchString) {
        return switchString.equals("-o");
    }

    private static boolean containsAllNeededSwitch(Set set) {
        return true;
    }

    private static void printHelp() {
        System.out.println("ExampleCounter");
        System.out.println("Usage:");
        System.out.println("exampleCount [<inputfile>] [-o outputfile]");
    }
}

