/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction.tester;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.reaction.EqualableMolecule;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.ReactionUtil;
import chemaxon.reaction.Reactor;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.util.iterator.MoleculeIterator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class ReactionExampleTester {
    public static final String EXAMPLE_PROPERTY_NAME = "EXAMPLE";
    private static final String DEFAULT_REACTION_NAME = "Unnamed reaction";
    private static final String[] FORMATS = new String[]{"cxsmiles", "cxsmarts", "mrv"};
    private static final String TEST_REPORT_SEPARATOR = "\n\n==========\n\n";

    public static String testReactionExamples(MoleculeIterator iterator) {
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            String testReport = null;
            try {
                testReport = ReactionExampleTester.testReactionExamples(iterator.next());
            }
            catch (NoSuchElementException e) {
                testReport = "Cannot read reaction.";
            }
            if (testReport == null) continue;
            sb.append(testReport);
            sb.append(TEST_REPORT_SEPARATOR);
        }
        return sb.length() != 0 ? sb.delete(sb.lastIndexOf(TEST_REPORT_SEPARATOR), sb.length()).toString() : "All tests completed successfully.";
    }

    public static String testReactionExamples(Molecule reaction) {
        return ReactionExampleTester.testReactionExamples(reaction, EXAMPLE_PROPERTY_NAME, true, false);
    }

    public static String testReactionExamples(Molecule reaction, boolean reportAlways) {
        return ReactionExampleTester.testReactionExamples(reaction, EXAMPLE_PROPERTY_NAME, true, reportAlways);
    }

    public static String testReactionExamples(Molecule reaction, boolean errorOnMissingExamples, boolean reportAlways) {
        return ReactionExampleTester.testReactionExamples(reaction, EXAMPLE_PROPERTY_NAME, errorOnMissingExamples, reportAlways);
    }

    public static String testReactionExamples(Molecule reaction, String examplePropertyName, boolean errorOnMissingExamples, boolean reportAlways) {
        String reactionName = reaction.getProperty("NAME") == null ? DEFAULT_REACTION_NAME : reaction.getProperty("NAME");
        List<RxnMolecule> exampleReactions = null;
        try {
            exampleReactions = ReactionExampleTester.getExampleReactions(reaction, examplePropertyName);
        }
        catch (MolFormatException e) {
            return reactionName + ": example reaction is in a format that cannot be read.";
        }
        catch (IOException e) {
            return reactionName + ": I/O error occured while reading example reactions.";
        }
        return ReactionExampleTester.testReactionExamples(reaction, exampleReactions, errorOnMissingExamples, reportAlways);
    }

    public static String testReactionExamples(Molecule reaction, List<RxnMolecule> exampleReactions, boolean errorOnMissingExamples, boolean reportAlways) {
        String reactionName;
        String string = reactionName = reaction.getProperty("NAME") == null ? DEFAULT_REACTION_NAME : reaction.getProperty("NAME");
        if (!reaction.isReaction()) {
            return reactionName + ": not a reaction.";
        }
        if (exampleReactions.size() == 0) {
            return errorOnMissingExamples ? reactionName + ": reaction has no examples." : null;
        }
        Reactor reactor = new Reactor();
        reactor.setResultType(4);
        reactor.setShowUnsuccessfulReactions(true);
        try {
            reactor.setReaction(reaction);
        }
        catch (ReactionException e) {
            return reactionName + ": " + (e.getMessage().length() > 0 ? e.getMessage() : "error occured while setting the reaction.");
        }
        StringBuilder sb = new StringBuilder();
        boolean ok = true;
        int count = 0;
        for (RxnMolecule exampleReaction : exampleReactions) {
            ++count;
            if (exampleReaction == null) {
                ok = false;
                sb.append("Error while testing reaction '" + reactionName + "': cannot read example, or not a reaction " + count + "/" + exampleReactions.size() + "\n");
                continue;
            }
            if (exampleReaction.getProperty("enabled") != null && !exampleReaction.getProperty("enabled").equalsIgnoreCase("true")) continue;
            EqualedMoleculeList exampleProducts = new EqualedMoleculeList(exampleReaction.getProducts());
            try {
                reactor.setReactants(exampleReaction.getReactants());
                Molecule[] result = reactor.react();
                RxnMolecule fusedReaction = (RxnMolecule)result[0];
                EqualedMoleculeList products = new EqualedMoleculeList(fusedReaction.getProducts());
                if (exampleProducts == null && products == null) {
                    ok = true;
                    continue;
                }
                if (exampleProducts != null && products != null) {
                    if (exampleProducts.equals(products) || products.equals(exampleProducts)) continue;
                    ok = false;
                    sb.append("Error while testing reaction '" + reactionName + "' example " + count + "/" + exampleReactions.size() + "\nExpected:\n" + ReactionUtil.toFormat(exampleReaction, FORMATS) + "\nCalculated:\n" + ReactionUtil.toFormat(fusedReaction, FORMATS) + "\n\n");
                    continue;
                }
                ok = false;
                sb.append("Error while testing reaction '" + reactionName + "' example " + count + "/" + exampleReactions.size() + "\nExpected:\n" + ReactionUtil.toFormat(exampleReaction, FORMATS) + "\nCalculated:\n" + ReactionUtil.toFormat(fusedReaction, FORMATS) + "\n\n");
            }
            catch (ReactionException e) {
                ok = false;
                sb.append("Error while testing reaction '" + reactionName + "': testing of example " + count + "/" + exampleReactions.size() + " failed. " + e.getMessage() + "\n");
            }
        }
        return ok ? (reportAlways ? reactionName + ": test completed successfully." : null) : sb.toString().trim();
    }

    private static List<RxnMolecule> getExampleReactions(Molecule mol, String examplePropertyName) throws MolFormatException, IOException {
        String examples = mol.getProperty(examplePropertyName);
        ArrayList<RxnMolecule> reactionList = new ArrayList<RxnMolecule>();
        if (examples == null || examples.equals("")) {
            return reactionList;
        }
        MolImporter importer = new MolImporter(new ByteArrayInputStream(examples.getBytes()));
        Molecule examplerxn = null;
        try {
            while ((examplerxn = importer.read()) != null) {
                RxnMolecule rxn = RxnMolecule.getReaction(examplerxn);
                if (rxn != null) {
                    reactionList.add(rxn);
                    continue;
                }
                reactionList.add(null);
            }
        }
        catch (IOException e) {
            reactionList.add(null);
        }
        return reactionList;
    }

    private static class EqualedMoleculeList {
        private Set<EqualedMolecule> productGroupSet = new HashSet<EqualedMolecule>();

        public EqualedMoleculeList(Molecule[] products) {
            List<Molecule> productList = Arrays.asList(products);
            for (Molecule product : productList) {
                this.productGroupSet.add(new EqualedMolecule(product));
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof EqualedMoleculeList)) {
                return false;
            }
            EqualedMoleculeList other = (EqualedMoleculeList)obj;
            return ((Object)this.productGroupSet).equals(other.productGroupSet);
        }

        public String toString() {
            return this.productGroupSet.toString();
        }
    }

    private static class EqualedMolecule
    extends EqualableMolecule {
        public EqualedMolecule(Molecule mol) {
            super(mol);
        }

        @Override
        public int hashCode() {
            return 1;
        }
    }
}

