/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.reaction.util;

import chemaxon.struc.Molecule;
import chemaxon.util.iterator.MoleculeIterator;

public final class PropertyInjectorMoleculeIterator
implements MoleculeIterator {
    private final MoleculeIterator iterator;
    private final String propertyName;
    private final String propertyValue;
    private long counter = 1L;
    private boolean addCountToPropertyValue;

    public PropertyInjectorMoleculeIterator(MoleculeIterator iterator, String propertyName, String propertyValue, boolean addCountToPropertyValue) {
        this.iterator = iterator;
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.addCountToPropertyValue = addCountToPropertyValue;
    }

    @Override
    public Molecule next() {
        Molecule mol = this.iterator.next();
        if (mol != null) {
            mol.setProperty(this.propertyName, this.propertyValue + (this.addCountToPropertyValue ? String.valueOf(this.counter++) : ""));
        }
        return mol;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    @Deprecated
    public Throwable getThrowable() {
        return this.iterator.getThrowable();
    }

    @Override
    public double estimateProgress() {
        return this.iterator.estimateProgress();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

