/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.formula;

import chemaxon.sss.formula.FormulaComponent;
import chemaxon.sss.formula.FormulaMatchable;
import java.util.ArrayList;

class FormulaDescriptor
extends FormulaMatchable {
    private ArrayList<FormulaComponent> components = new ArrayList();
    private int type;
    private FormulaDescriptor targetDescriptor;

    public int getComponentCount() {
        return this.components.size();
    }

    public FormulaComponent getComponent(int i) {
        return this.components.get(i);
    }

    public void addComponent(FormulaComponent component) {
        this.components.add(component);
    }

    public boolean isValid() {
        if (this.components.size() == 0) {
            return false;
        }
        for (int compIndex = this.components.size() - 1; compIndex >= 0; --compIndex) {
            if (this.components.get(compIndex).isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean isMatching(FormulaDescriptor target, int type) {
        int index;
        if (type == 0) {
            return true;
        }
        assert (target != null);
        this.type = type;
        this.targetDescriptor = target;
        this.queryCount = this.components.size();
        this.targetCount = target.getComponentCount();
        if (this.queryCount > this.targetCount) {
            return false;
        }
        if (type == 1 && this.queryCount != this.targetCount) {
            return false;
        }
        this.queryPair = new int[this.queryCount];
        this.targetPair = new int[this.targetCount];
        this.isCalculated = new boolean[this.queryCount][];
        this.isMatching = new boolean[this.queryCount][];
        for (index = 0; index < this.queryCount; ++index) {
            this.queryPair[index] = -1;
            this.isCalculated[index] = new boolean[this.targetCount];
            this.isMatching[index] = new boolean[this.targetCount];
        }
        for (index = 0; index < this.targetCount; ++index) {
            this.targetPair[index] = -1;
        }
        int queryPaired = this.getQueriesPaired();
        return queryPaired == this.queryCount;
    }

    @Override
    protected void calculateMatch(int qIndex, int tIndex) {
        assert (!this.isCalculated[qIndex][tIndex]);
        switch (this.type) {
            case 1: {
                this.isCalculated[qIndex][tIndex] = true;
                this.isMatching[qIndex][tIndex] = this.components.get(qIndex).isExactMatch(this.targetDescriptor.getComponent(tIndex));
                break;
            }
            case 2: {
                this.isCalculated[qIndex][tIndex] = true;
                this.isMatching[qIndex][tIndex] = this.components.get(qIndex).isExactSubformulaMatch(this.targetDescriptor.getComponent(tIndex));
                break;
            }
            case 3: {
                this.isCalculated[qIndex][tIndex] = true;
                this.isMatching[qIndex][tIndex] = this.components.get(qIndex).isSubformulaMatch(this.targetDescriptor.getComponent(tIndex));
                break;
            }
            default: {
                this.isCalculated[qIndex][tIndex] = true;
                this.isMatching[qIndex][tIndex] = true;
            }
        }
    }
}

