/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.formula;

import java.util.ArrayList;
import java.util.LinkedList;

public abstract class FormulaMatchable {
    protected int queryCount;
    protected int targetCount;
    protected boolean[][] isCalculated;
    protected boolean[][] isMatching;
    protected int[] queryPair;
    protected int[] targetPair;

    protected abstract void calculateMatch(int var1, int var2);

    protected int getQueriesPaired() {
        boolean found = true;
        int queryPaired = 0;
        while (found && queryPaired < this.queryCount) {
            found = false;
            ArrayList<Integer> path = this.findNewPath();
            int size = path.size();
            if (size <= 0) continue;
            found = true;
            ++queryPaired;
            int t = 0;
            int q = 0;
            int index = 0;
            while (index < size) {
                t = path.get(index++);
                q = path.get(index++);
                this.queryPair[q] = t;
                this.targetPair[t] = q;
            }
        }
        return queryPaired;
    }

    private ArrayList<Integer> findNewPath() {
        int qIndex;
        ArrayList<Integer> path = new ArrayList<Integer>();
        boolean[] visitedQ = new boolean[this.queryCount];
        int[] parentQ = new int[this.queryCount];
        boolean[] visitedT = new boolean[this.targetCount];
        int[] parentT = new int[this.targetCount];
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (qIndex = 0; qIndex < this.queryCount; ++qIndex) {
            if (this.queryPair[qIndex] != -1) continue;
            list.add(qIndex);
            visitedQ[qIndex] = true;
            parentQ[qIndex] = -1;
        }
        boolean found = false;
        while (!list.isEmpty() && !found) {
            int tIndex;
            qIndex = (Integer)list.removeFirst();
            if (qIndex < this.queryCount) {
                for (tIndex = 0; tIndex < this.targetCount && !found; ++tIndex) {
                    if (visitedT[tIndex] || this.queryPair[qIndex] == tIndex) continue;
                    if (!this.isCalculated[qIndex][tIndex]) {
                        this.calculateMatch(qIndex, tIndex);
                    }
                    if (!this.isMatching[qIndex][tIndex]) continue;
                    visitedT[tIndex] = true;
                    parentT[tIndex] = qIndex;
                    if (this.targetPair[tIndex] != -1) {
                        list.add(this.queryCount + tIndex);
                        continue;
                    }
                    list.add(tIndex);
                    found = true;
                }
                continue;
            }
            tIndex = qIndex - this.queryCount;
            if (visitedQ[qIndex = this.targetPair[tIndex]]) continue;
            visitedQ[qIndex] = true;
            parentQ[qIndex] = tIndex;
            list.add(qIndex);
        }
        if (found) {
            int index = (Integer)list.removeLast();
            int parity = 1;
            int parent = index;
            while (parent != -1) {
                path.add(parent);
                parent = parity == 1 ? parentT[parent] : parentQ[parent];
                parity = 1 - parity;
            }
        }
        return path;
    }
}

