/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen;

import chemaxon.core.calculations.FindAllRings;
import chemaxon.descriptors.MDGeneratorException;
import chemaxon.descriptors.RFParameters;
import chemaxon.descriptors.ReactionFingerprint;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.enumeration.supergraph.SupergraphFindAllRings;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.jchem.db.FingerprintHandler;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jep.FingerprintGenerator;
import chemaxon.marvin.util.MulticenterTransform;
import chemaxon.reaction.Standardizer;
import chemaxon.sss.screen.ScreenMol;
import chemaxon.sss.screen.StrucFPConfig;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchUtil;
import chemaxon.sss.search.bracket.PolymerMatcher;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.util.BinaryDataUtil;
import chemaxon.util.MolHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CombinedFingerprint
implements FingerprintGenerator {
    private int numberOfInts = 0;
    private int numberOfBits = 0;
    private int numberOfKeys = 0;
    private int[] cfp = null;
    private int[] cfp_noRings = null;
    private boolean ringInfoIncomplete = false;
    private boolean reactionMappingIncomplete = false;
    private final List<StructuralKeyData> structKeyData = new ArrayList<StructuralKeyData>();
    private int cFPInts = 0;
    private int cFPPath = 0;
    private int cFPBits = 0;
    private boolean queryIsKey;
    private boolean smartsMode;
    private boolean reactionFP = false;
    private static final Logger logger = Logger.getLogger(CombinedFingerprint.class.getName());

    public CombinedFingerprint(int numberOfInts, String config, Standardizer std, int cFPInts, int cFPPath, int cFPBits) throws IOException {
        StrucFPConfig sc = new StrucFPConfig();
        sc.parseConfig(config);
        this.init(numberOfInts, sc, std, cFPInts, cFPPath, cFPBits);
    }

    public CombinedFingerprint(int numberOfInts, String config, Standardizer std, int cFPInts, int cFPPath, int cFPBits, boolean reactionFP) throws IOException {
        StrucFPConfig sc = new StrucFPConfig();
        sc.parseConfig(config);
        this.reactionFP = reactionFP;
        this.init(numberOfInts, sc, std, cFPInts, cFPPath, cFPBits);
    }

    public CombinedFingerprint(int numberOfInts, InputStream structures, Standardizer std, int cFPInts, int cFPPath, int cFPBits, boolean smartsMode) throws IOException {
        StrucFPConfig sc = new StrucFPConfig();
        sc.readMolecules(structures, smartsMode);
        this.init(numberOfInts, sc, std, cFPInts, cFPPath, cFPBits);
    }

    private void init(int numberOfInts, StrucFPConfig sc, Standardizer std, int cFPInts, int cFPPath, int cFPBits) {
        this.numberOfInts = numberOfInts;
        this.numberOfBits = BinaryDataUtil.translateIntCountToBitCount(numberOfInts);
        this.cFPInts = cFPInts;
        this.cFPPath = cFPPath;
        this.cFPBits = cFPBits;
        this.structKeyData.clear();
        this.numberOfKeys = sc.getNumberOfKeys();
        this.smartsMode = sc.getSmartsMode();
        List<Molecule> molecules = sc.getMolecules();
        List<String> molStrings = sc.getMolStrings();
        for (int keyIndex = 0; keyIndex < this.numberOfKeys; ++keyIndex) {
            Molecule mol = molecules.get(keyIndex);
            String keyString = molStrings.get(keyIndex);
            TableInfo.standardize(mol, std, false);
            int[][] fingerprint = this.getFingerprints(mol, true);
            MolSearch ms = new MolSearch();
            ms.setQuery(mol);
            this.structKeyData.add(new StructuralKeyData(mol, keyString, fingerprint, ms));
        }
    }

    public int[][] getBlackFingerprints() {
        int[][] res = new int[2][this.cFPInts];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < this.cFPInts; ++j) {
                res[i][j] = -1;
            }
        }
        return res;
    }

    private int[][] getFingerprints(Molecule mol, boolean calcWithRings) {
        boolean calcWithRingsCorrected = calcWithRings;
        if (mol instanceof Supergraph) {
            calcWithRingsCorrected = false;
            if (SearchUtil.hasMarkushQueryAtom(mol)) {
                return this.getBlackFingerprints();
            }
        }
        MulticenterTransform mct = new MulticenterTransform();
        mct.transformMulticenters(mol);
        ScreenMol screen = new ScreenMol(mol, this.cFPInts * 4);
        if (calcWithRingsCorrected) {
            SupergraphFindAllRings allRingsSearcher = new SupergraphFindAllRings();
            ((FindAllRings)allRingsSearcher).setGraph(mol);
            allRingsSearcher.startRingSearch(14, false, 0, 50);
            int[][][] r = allRingsSearcher.getAromaticAndAliphaticRings();
            this.ringInfoIncomplete = allRingsSearcher.timeoutReached();
            screen.setRings(r[1], r[0]);
        } else {
            this.ringInfoIncomplete = true;
        }
        byte[][] fingerprints = screen.getFingerprints(this.cFPPath, this.cFPBits);
        mct.restoreMulticenters(mol);
        int[][] result = new int[][]{CombinedFingerprint.convertBytesToInts(fingerprints[0]), CombinedFingerprint.convertBytesToInts(fingerprints[1])};
        return result;
    }

    public static int[] convertBytesToInts(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int intCount = bytes.length / 4;
        int[] ints = new int[intCount];
        for (int i = 0; i < intCount; ++i) {
            ints[i] = BinaryDataUtil.getFingerprintInInt(bytes, i);
        }
        return ints;
    }

    public boolean queryIsKey() {
        return this.queryIsKey;
    }

    public int[] getStructuralKeys(Molecule mol, String molString, boolean isSmarts, boolean queryMode) {
        this.queryIsKey = false;
        int[] strucFP = new int[this.numberOfInts];
        int[] targetFP = null;
        if (this.reactionFP) {
            targetFP = new int[this.numberOfInts];
            targetFP = ReactionFingerprint.getChemicalHashedFingerprint(this.cfp, this.cfp.length);
        } else {
            targetFP = this.ringInfoIncomplete ? this.cfp_noRings : this.cfp;
        }
        for (int x = 0; x < this.numberOfKeys; ++x) {
            boolean hit;
            block14: {
                int[] keyFP;
                int[][] keyFPs = this.structKeyData.get((int)x).fingerprint;
                int[] nArray = keyFP = this.ringInfoIncomplete ? keyFPs[0] : keyFPs[1];
                if (logger.isLoggable(Level.FINE)) {
                    if (keyFP == null) {
                        logger.fine("keyFP is null ");
                    }
                    if (targetFP == null) {
                        logger.fine("targetFP is null ");
                    }
                }
                if (keyFP != null && targetFP != null && !FingerprintHandler.targetContainsQuery(keyFP, targetFP)) continue;
                hit = false;
                if (molString != null && isSmarts == this.smartsMode && molString.trim().equals(this.structKeyData.get((int)x).structuralKeyString.trim())) {
                    hit = true;
                    this.queryIsKey = true;
                } else {
                    MolSearch ms = this.structKeyData.get((int)x).searcher;
                    try {
                        ms.getSearchOptions().setImplicitHMatching(queryMode ? 2 : 1);
                        if (mol.isQuery()) {
                            ms.getSearchOptions().setExactQueryAtomMatching(true);
                            ms.getSearchOptions().setExactBondMatching(true);
                        } else {
                            ms.getSearchOptions().setExactQueryAtomMatching(false);
                            ms.getSearchOptions().setExactBondMatching(false);
                        }
                        ms.setTarget(mol);
                        hit = ms.isMatching();
                        if (queryMode && hit && !this.queryIsKey) {
                            ms.setSearchOptions(new MolSearchOptions(5));
                            ms.getSearchOptions().setImplicitHMatching(2);
                            if (ms.isMatching()) {
                                this.queryIsKey = true;
                            }
                            ms.setSearchOptions(new MolSearchOptions(2));
                        }
                    }
                    catch (SearchException e) {
                        if (!logger.isLoggable(Level.SEVERE)) break block14;
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            if (!hit) continue;
            int bitToSet = x % this.numberOfBits;
            int intToSet = bitToSet / 32;
            int bitIndex = bitToSet % 32;
            int theInt = strucFP[intToSet];
            strucFP[intToSet] = theInt |= 1 << bitIndex;
        }
        return strucFP;
    }

    @Override
    public int[] getFingerprint(Molecule mol) {
        return this.getCombinedFingerprint(mol, null, false, true, true);
    }

    public int[] getCombinedFingerprint(MolHandler mh, String molString, boolean isSmarts, boolean queryMode) {
        return this.getCombinedFingerprint(mh.getMolecule(), molString, isSmarts, queryMode, true);
    }

    public int[] getCombinedFingerprint(Molecule mol, String molString, boolean isSmarts, boolean queryMode, boolean withBranchCalculation) {
        return this.getCombinedFingerprints(mol, molString, isSmarts, queryMode, true, withBranchCalculation)[1];
    }

    public int[][] getCombinedFingerprints(Molecule mol, String molString, boolean isSmarts, boolean queryMode, boolean withRings, boolean withBranchCalculation) {
        int[][] fingerprints = null;
        this.reactionMappingIncomplete = false;
        Molecule transformedMol = PolymerMatcher.getGeneralRepresentation(mol);
        fingerprints = this.reactionFP ? this.getReactionFingeprints(transformedMol) : this.getFingerprints(transformedMol, withRings);
        this.cfp = fingerprints[1];
        this.cfp_noRings = fingerprints[0];
        if (this.numberOfInts < 1) {
            this.queryIsKey = false;
            return fingerprints;
        }
        int[] strucFP = this.getStructuralKeys(transformedMol, molString, isSmarts, queryMode);
        int[] result0 = new int[this.cfp_noRings.length + strucFP.length];
        System.arraycopy(this.cfp_noRings, 0, result0, 0, this.cfp_noRings.length);
        System.arraycopy(strucFP, 0, result0, this.cfp_noRings.length, strucFP.length);
        int[] result1 = new int[this.cfp.length + strucFP.length];
        System.arraycopy(this.cfp, 0, result1, 0, this.cfp.length);
        System.arraycopy(strucFP, 0, result1, this.cfp.length, strucFP.length);
        int[][] result = new int[][]{result0, result1};
        return result;
    }

    private int[][] getReactionFingeprints(Molecule mol) {
        ReactionFingerprint rfp = new ReactionFingerprint();
        RFParameters rfParam = new RFParameters();
        rfParam.setBitCount(this.cFPBits);
        rfParam.setBondCount(this.cFPPath);
        rfParam.setLength(this.cFPInts * 32);
        rfp.setParameters(rfParam);
        try {
            rfp.generate(mol);
        }
        catch (MDGeneratorException e) {
            throw new UnsupportedOperationException(e);
        }
        this.reactionMappingIncomplete = rfp.isReactionMappingIncomplete();
        byte[] fpByte = rfp.toData();
        int[] fp = CombinedFingerprint.convertBytesToInts(fpByte);
        return new int[][]{fp, fp};
    }

    public boolean isRingInfoIncomplete() {
        return this.ringInfoIncomplete;
    }

    public boolean isReactionMappingIncomplete() {
        return this.reactionMappingIncomplete;
    }

    private static void printFP(int[] fp) {
        for (int x = 0; x < fp.length * 32; ++x) {
            int idx = x / 32;
            int bitIdx = x % 32;
            int bit = (fp[idx] & 1 << 31 - bitIdx) > 0 ? 1 : 0;
            System.err.print(bit);
        }
        System.err.println("");
    }

    public static void main(String[] args) throws Exception {
        RgMolecule mol;
        String keysFile = args[0];
        String molsFile = args[1];
        CombinedFingerprint sk = new CombinedFingerprint(1, new FileInputStream(keysFile), null, 16, 6, 2, true);
        MolInputStream mis = new MolInputStream(new FileInputStream(molsFile));
        MolImporter molimp = new MolImporter(mis);
        while (molimp.read(mol = new RgMolecule())) {
            TableInfo.standardize(mol, null, true);
            int[] fp = sk.getCombinedFingerprint(new MolHandler(mol), null, false, true);
            CombinedFingerprint.printFP(fp);
        }
    }

    private static class StructuralKeyData {
        public Molecule structuralKey;
        public String structuralKeyString;
        public int[][] fingerprint;
        public MolSearch searcher;

        public StructuralKeyData(Molecule molecule, String string, int[][] fingerprint, MolSearch ms) {
            this.structuralKey = molecule;
            this.structuralKeyString = string;
            this.fingerprint = fingerprint;
            this.searcher = ms;
        }
    }
}

