/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen;

import chemaxon.sss.screen.MarkushScreenOptions;
import chemaxon.sss.screen.MarkushScreenSearchType;
import chemaxon.sss.search.SearchOptions;
import chemaxon.sss.search.options.HomologyTranslationOption;

public class DefaultMarkushScreenOptions
implements MarkushScreenOptions,
Cloneable {
    protected final MarkushScreenSearchType searchType;
    protected HomologyTranslationOption broadTranslation;
    protected HomologyTranslationOption narrowTranslation;
    protected boolean completeHG;

    public DefaultMarkushScreenOptions(SearchOptions searchOptions) throws IllegalArgumentException {
        this.searchType = MarkushScreenSearchType.getValue(searchOptions.getSearchType());
        this.broadTranslation = searchOptions.getHomologyBroadTranslation();
        this.narrowTranslation = searchOptions.getHomologyNarrowTranslation();
        this.completeHG = searchOptions.getCompleteHG();
    }

    public DefaultMarkushScreenOptions(MarkushScreenOptions other) {
        this.searchType = other.getSearchType();
        this.broadTranslation = other.getHomologyBroadTranslation();
        this.narrowTranslation = other.getHomologyNarrowTranslation();
        this.completeHG = other.isCompleteHG();
    }

    public DefaultMarkushScreenOptions(MarkushScreenSearchType searchType) throws IllegalArgumentException {
        this(new SearchOptions(searchType.getSearchTypeConstant()));
    }

    @Override
    public final MarkushScreenSearchType getSearchType() {
        return this.searchType;
    }

    @Override
    public final HomologyTranslationOption getHomologyBroadTranslation() {
        return this.broadTranslation;
    }

    public void setHomologyBroadTranslation(HomologyTranslationOption opt) {
        this.broadTranslation = opt;
    }

    @Override
    public final HomologyTranslationOption getHomologyNarrowTranslation() {
        return this.narrowTranslation;
    }

    public void setHomologyNarrowTranslation(HomologyTranslationOption opt) {
        this.narrowTranslation = opt;
    }

    @Override
    public final boolean isCompleteHG() {
        return this.completeHG;
    }

    public void setCompleteHG(boolean opt) {
        this.completeHG = opt;
    }

    public String toString() {
        return "Screen Options:\n  searchType = " + (Object)((Object)this.searchType) + "\n" + "  broadTranslation = " + (Object)((Object)this.broadTranslation) + "\n" + "  narrowTranslation = " + (Object)((Object)this.narrowTranslation) + "\n" + "  completeHG = " + this.completeHG;
    }
}

