/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.sss.screen;

import chemaxon.sss.screen.MarkushScreenHandler;
import chemaxon.sss.screen.MarkushScreenHandlerFactory;
import chemaxon.sss.screen.MarkushScreenOptions;
import chemaxon.sss.screen.MarkushScreenStorage;
import chemaxon.struc.Molecule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MarkushScreenHandlerFactoryDummyImpl
implements MarkushScreenHandlerFactory {
    Log log = LogFactory.getLog(MarkushScreenHandlerFactoryDummyImpl.class);
    public static final String ACCEPT_ALL_TYPE = "Accept all";
    public static final String DECLINE_ALL_TYPE = "Decline all";

    @Override
    public MarkushScreenHandler constructScreenHandler(String type, String config) throws IllegalArgumentException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("construct handler. Type: " + type + ", config: " + config));
        }
        if (type.equalsIgnoreCase(ACCEPT_ALL_TYPE)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Construct 'accept all' handler");
            }
            return new HandlerImpl(true);
        }
        if (type.equalsIgnoreCase(DECLINE_ALL_TYPE)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Construct 'decline all' handler");
            }
            return new HandlerImpl(false);
        }
        throw new IllegalArgumentException("Invalid component type: " + type);
    }

    private static class SimpleStorage
    implements MarkushScreenStorage {
        private SimpleStorage() {
        }

        @Override
        public byte[] toRawData() {
            return new byte[]{0, 1, 2, 3, 4, 5};
        }

        @Override
        public int getRawDataSize() {
            return 6;
        }
    }

    private static class HandlerImpl
    implements MarkushScreenHandler {
        private boolean acceptAll;

        private HandlerImpl(boolean acceptAll) {
            this.acceptAll = acceptAll;
        }

        @Override
        public MarkushScreenOptions convertScreenOptions(MarkushScreenOptions screenOptions, Molecule queryMol) {
            return screenOptions;
        }

        @Override
        public SimpleStorage generateQueryDescriptor(Molecule mol, MarkushScreenOptions screenOptions) throws IllegalArgumentException {
            return new SimpleStorage();
        }

        @Override
        public SimpleStorage generateTargetDescriptor(Molecule mol) {
            return new SimpleStorage();
        }

        @Override
        public boolean accept(MarkushScreenStorage queryDescr, MarkushScreenStorage targetDescr, MarkushScreenOptions screenOptions) {
            SimpleStorage qd = (SimpleStorage)queryDescr;
            SimpleStorage td = (SimpleStorage)targetDescr;
            if (qd == null || td == null) {
                throw new NullPointerException();
            }
            return this.acceptAll;
        }

        @Override
        public SimpleStorage fromRawData(byte[] data) {
            return new SimpleStorage();
        }
    }
}

